/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifdef __linux__

#include <stdint.h>
#include <sys/types.h>

#ifdef __cplusplus
extern "C" {
#endif

/** Interface to <sys/mman.h>::mmap() that assists with page offset math
 *  normally used to map hw register blocks into application space.
 *  fd < 0 create temporary file descriptor, fd >= 0 reuse given filedescriptor to /dev/mem
 */
void *mapMem(size_t phys_addr, size_t length, void **map_base, int fd);

/** free a single region assuming you held the map_base
 */
int unMapMem(void *map_base, size_t length);

/** free all mapMem regions in the application.
 */
void mapMem_destructor( void );

#ifdef __cplusplus
}
#endif


#else // !linux

// threadx hwaddr and virtual address assumed to be the same
#define mapMem( addr, len, base, fd ) (void*)addr
#define unMapMem( base, len )
#define mapMem_destructor( )

#endif // linux


