/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifdef __linux__

#include "map_mem.h"
#include <unistd.h>   // getpagesize(), usleep()
#include <sys/mman.h> // mmap(), munmap()
#include <fcntl.h> // open
#include "lassert.h"


#define G_MAX_MAPPED 10000
static int g_i = 0;
static void *g_map_base[G_MAX_MAPPED] = {0};
static uint32_t g_map_length[G_MAX_MAPPED] = {0};
static pthread_mutex_t the_mutex;
static pthread_mutex_t *mutex = NULL;

void mapMem_destructor( )
{
    int i = 0;
    if (mutex == NULL) {
                mutex = &the_mutex;
                posix_mutex_init( mutex );
        }

    pthread_mutex_lock( mutex );
    for ( i = 0; i < G_MAX_MAPPED; i++ )
    {
	if ( g_map_base[i] )
	{
	    unMapMem(g_map_base[i], g_map_length[i]);
	    g_map_base[i] = 0;
	}
    }
    g_i = 0;
    pthread_mutex_unlock( mutex );
}


void *mapMem(size_t phys_addr, size_t length, void **map_base, int fd)
{
    uint32_t page_size = getpagesize();
    int have_fd;
    int i;
    size_t orig_length = length;

    have_fd = (fd >= 0);
    // printf ( "have %d\n", have_fd );

    if ( !have_fd )
    {
	if((fd = open("/dev/mem", (O_RDWR | O_SYNC | O_CLOEXEC))) < 0)
	{
	    perror("mapMem()  open('dev/mem') failed ");
        printf("mapMem()  open('dev/mem') failed ");
	    ASSERT(fd == 0);
        return(NULL);
	}
    }

    //length += phys_addr & (off_t)(page_size - 1);
    if( 0 != ( phys_addr % page_size ) )
    {
        length += page_size;
    }
    if((*map_base = mmap(NULL, length, PROT_READ | PROT_WRITE, MAP_SHARED, fd,
                         (size_t)phys_addr & ~(size_t)(page_size - 1))) == MAP_FAILED)
    {
        printf("!!!! %s mmap failed\n",__func__);
        close(fd);
        return(NULL);
    }
    else
    {
#if 0
	    if (mutex == NULL) {
		    mutex = &the_mutex;
		    posix_mutex_init( mutex );
	    }
	    pthread_mutex_lock( mutex );


        for ( i = 0; i < G_MAX_MAPPED; i++ ) {
            if ( g_map_base[i] == *map_base ) {

                if( g_map_length[i] != length )
                {
                    printf("!! Length does not match map_base: %p g_map_length: %d length: %d orig_length: %d i: %d phys_addr: %#lx offset: %#lx page_size: %d\n", *map_base , g_map_length[i], length, orig_length, i, phys_addr, phys_addr & (off_t)(page_size - 1), page_size );
                }
                break;
            }
        }


	    if ( g_i + 1 < G_MAX_MAPPED ) {
		    for ( i = g_i + 1; i < G_MAX_MAPPED; i++ ) {
			    if ( g_map_base[i] == 0 ) {
				    g_i = i;
				    g_map_base[g_i] = (*map_base + (phys_addr & (page_size - 1)));
				    g_map_length[g_i] = length;
				    break;
			    }
		    }
	    } else {
		    for ( i = 0; i < G_MAX_MAPPED; i++ ) {
			    if ( g_map_base[i] == 0 ) {
				    g_i = i;
				    g_map_base[g_i] = (*map_base + (phys_addr & (page_size - 1)));
				    g_map_length[g_i] = length;
				    break;
			    }
		    }
		    ASSERT( i < /* compile time constant too small */ G_MAX_MAPPED );
	    }
	    pthread_mutex_unlock( mutex );
#endif

	    if (!have_fd)
		    close(fd);

               // printf("%s map_base: %p v_addr: %p g_map_length: %d length: %d orig_length: %d i: %d phys_addr: %#lx page_size: %d\n",__func__, *map_base, (void *)(*map_base + (phys_addr & (page_size - 1))) , g_map_length[g_i], length, orig_length, g_i,phys_addr, page_size );
                if (*map_base)
                {
                    if ((void *)(*map_base + (phys_addr & (page_size - 1))) == NULL)
                    {
                         printf("!!!! %s:%d mmap failed\n",__func__,__LINE__ );
                    }
                    return ((void *)(*map_base + (phys_addr & (page_size - 1))));
                }

    }
    return NULL;
}

int unMapMem(void *map_base, size_t length)
{
    size_t page_size = getpagesize();
    int i;
    int error = 0;

    if (map_base == NULL)
    {
        printf("!!!!!!!!!!!!! map_base: 0\n");
        return(-1);
    }

    //length += (off_t)map_base & (page_size - 1);

    //printf("%s map_base: %p page: %ld length: %ld %p\n",__func__, map_base, page_size, length, (void*) ((size_t)map_base & ~(page_size - 1)) );

    if( 0 != ( (size_t)map_base % page_size ) )
    {
        length += page_size;
    }
    error = munmap((void*) ((size_t)map_base & ~(page_size - 1)), length);
    if(error)
    {
        printf("%s failed %d\n",__func__ , error);
        return(-1);
    }

#if 0
    if (mutex == NULL) {
                mutex = &the_mutex;
                posix_mutex_init( mutex );
        }

    pthread_mutex_lock( mutex );
    for ( i = 0; i < G_MAX_MAPPED; i++ )
    {
        if ( map_base == g_map_base[i] )
        {
            if (length != g_map_length[i])
            {
                printf("!!!!! %s i: %d map_base: %p map_length: %ld length:%ld\n",__func__, i, map_base, g_map_length[i], length);

            }
           // printf(" %s clearing g_map_base i: %d map_base: %p map_length: %ld length:%ld\n",__func__, i, map_base, g_map_length[i], length);
            g_map_base[i] = 0;
            break;
        }
    }
    if ( i == G_MAX_MAPPED)
    {
        printf("!!!!! %s map_base: %p not found\n",__func__, map_base);
    }
    pthread_mutex_unlock(mutex);
#endif

    return( 0 );

}

#endif // linux


