/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2009-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef ERROR_TYPES_H
#define ERROR_TYPES_H

#include <stdint.h>

/**
 * \file error_types.h
 *
 * \brief Define the error_types_t type so that all modules may return 
 * the same kind of error variable.
 *
 * error_type_t is a global error return variable.  All modules that use this 
 * all handled through the event reporting module so this type is a prototype for
 * doing subsystem errors. All modules that use error_type_t
 * shall extend this with their own errors using the following guidelines.
 *
 * -# Use the defined returns of SYS_OK and SYS_FAIL 
 * -# Reserve 0 through -10 for the system
 * -# Error numbers are locally defined.  Should not span subsystems
 * -# Errors are all negative numbers of < -10
 * -# Positive numbers may be used however the module decides
 * -# Subsystems should consider a consistent error numbering scheme.
 * -# Subsystems should put a unique prefix on their errors for easy identification.
 * For example, SPI_OUT_OF_MEMORY or USB_DEVICE_DISCONNECTED
*/

// \typedef Error type define
typedef int32_t error_type_t;

#define SYS_OK 0    ///< Unique in the system
#define SYS_FAIL -1 ///< Unique in the system

// *** DEPRECATED - DO NOT USE ***
// OK and FAIL are too generic and collide with various third-party sources (e.g. FAIL is defined as 0)
#ifndef OK
#define OK 0    ///< Unique in the system
#endif
#ifndef FAIL
#define FAIL -1 ///< Unique in the system
#endif

#endif
