/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/





#include <stdint.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include "debug.h"


void hex_dump_named(void *start_addr, int size, char *region)
{

    int i;
    unsigned char line[80];
    unsigned char *ascii, *hex;
    unsigned char *endptr, *ptr = (unsigned char *)start_addr;
    intptr_t offset = (intptr_t)ptr;
    static char hex_ascii[] =
    {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    endptr = ptr + size;
    memset(line, ' ', 80);
    line[69] = 0;

    if (region)
    {
        printf("\n%s:\n", region);
    }

    while(ptr != endptr) {
        hex = &line[2];
        ascii = &line[52];

        for(i = 0 ; i < 16 ; i++) {
            if(isprint(*ptr))
                *ascii++ = *ptr;
            else
                *ascii++ = '.';

            *hex++ = hex_ascii[*ptr >> 4];
            *hex++ = hex_ascii[*ptr & 0x0F];
            *hex++ = ' ';

            // clean out whatever is left from the last line...
            if(++ptr == endptr) {
                memset(hex, ' ', (15 - i) * 3);
                memset(ascii, ' ', 15 - i);
                break;
            }
        }

        printf("0x%08x %s\n", offset, line);
        offset += 16;
    }

    printf("\n");
}

void reg32_dump_named(void *start_addr, int size, char *region)
{
    uint32_t ashex;
    void* offset;
    char asbinary[33];
    uint32_t bit;
    uint32_t i;
    
    //DBG_ASSERT( start_addr );
    //DBG_ASSERT( (((uint32_t)start_addr) & 0x03) == 0 );
    //DBG_ASSERT( size % 4 == 0 && size < 40000 && size > 0 );

    if (region) {
        printf("\n%s:\n", region);
    }

    for ( offset = start_addr; offset < start_addr + size; offset += 4 ) {
	ashex = *(uint32_t *)offset; 
	for ( i = 0, bit = 1; i < 32; i++ )
	    asbinary[31-i] = ashex & (bit << i) ? '1' : '0';  
	asbinary[32] = 0;
	printf("0x%08x  0x%08x  %s\n", offset, ashex, asbinary);
    }
}

char* reg32_as_binary(char *buf, int bufsize, uint32_t reg_val) 
{
    int i;
    uint32_t bit;

    for ( i = 0, bit = 1; i < 32; i++ )
	buf[31-i] = reg_val & (bit << i) ? '1' : '0';  
    buf[32] = 0;

    return buf;
}
 
char* reg32_hexonly(char *buf, int bufsize, uint32_t reg_val) 
{
    int cnt = 0;

    cnt += snprintf( &buf[cnt], bufsize-cnt, "%s ", ":hex" );
    return buf;
}

void reg32_dump_named_arr(void *start_addr, int num_registers, 
			  char *region, 
			  char* (*reg_func_array[])(char *buf, int bufsize, uint32_t reg_val))
{
    uint32_t ashex;
    void* offset;
    char buf[256] = " ";
    uint32_t n;
    char *output;
    
    if (region) {
        printf("\n%s:\n", region);
    }

    for ( offset = start_addr, n = 0; n < num_registers; n++, offset += 4 ) {
	ashex = *(uint32_t *)offset; 
	if ( reg_func_array[n] ) {
	    output = reg_func_array[n]( buf, 256, ashex );
	    printf("0x%08x  0x%08x  %s\n", offset, ashex, output);
	}
    }
}

_assert(char *str, char *file, int line)
{
    printf("assert %s %s %d\n", str, file, line);
}


