#
# Copyright (C) 2012-2018 Red Hat, Inc. All rights reserved.
#
# This file is part of LVM2.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 2.1 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from distutils.core import setup, Extension

liblvm = Extension('lvm',
                    sources = ['liblvm_python.c'],
                    libraries= ['lvm2app', 'devmapper'],
                    library_dirs= ['../liblvm', '../libdm'],
                    include_dirs= ['../include'])

setup (name='lvm',
       version="2.02.180(2) (2018-07-19)",
       description='Python bindings for liblvm2',
       license="LGPLv2+",
       maintainer='LVM2 maintainers',
       maintainer_email='linux-lvm@redhat.com',
       url='http://sourceware.org/lvm2/',
       ext_modules=[liblvm],
)
