/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2010-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifdef __cplusplus
#ifndef MEM_API_NEW_H
#define MEM_API_NEW_H


#include <cstring>  // sizeof 

/** global heap both new and sysLimiter_new use this.
 *  limiter_new looks for the variable: limiter 
 *   in the current scope
 */
extern "C" mlimiter_t *sysLimiter; 

/** global heap new use this instead of "new"
 *  variable "sysLimiter" is in global scope.
 */
#define sysLimiter_new new ( sysLimiter, __FILE__, __LINE__ )

/** allocation from limiter instead of global heap use this instead of "new"
 * variable "limiter" must be in scope. 
 * mlimiter_t *limiter = limiter_by_name("network"); // get non-owned reference to limiter
 * char * p = limiter_new char[3000]; // variable must be named "limiter"
 *
 */
#define limiter_new new ( limiter, __FILE__, __LINE__ )



/** overload operator new used with limiter and sysLimiter macros above. 
 */
void *operator new (size_t size,  mlimiter_t *mlimiter, const char *file, int line);

/** new array operator overload 
*/
void *operator new[] (size_t size, mlimiter_t *mlimiter, const char *file, int line);

/** overload operator new, same as sysLimiter_new except the file and line logging is missing 
 * not recommended but its there.
 */
void *operator new (size_t size);

/** overload [] new to use memAPI.c global heap sysLimiter, with poor file and line logging.
 */
void *operator new[] (size_t size);

/** overload delete to use memAPI.c::memFree().
 */
void operator delete (void *p);

#endif  // MEM_API_NEW_H
#endif  // __cplusplus

