/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2010-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#include "key_table.h"
#include "string.h"
#include "lassert.h"

// linear searches, prevent sparse arrays, and discourage large arrays.
//


const char *key_table_name_by_index( unsigned index, const char *table[] )
{
    unsigned i;
    
    DBG_ASSERT(table);

    for (i = 0; table[i]; i++)
        if ( i == index )
            return table[i];

    return 0;
}

void *key_table_obj_by_index( unsigned index, void** table)
{
    unsigned i;

    DBG_ASSERT(table);

    for (i = 0; table[i]; i++)
        if ( i == index )
            return (void*)table[i];
    return 0;
}

unsigned key_table_index_by_name( const char *name, const char *table[] )
{
    unsigned i;

    DBG_ASSERT(table);

    for (i = 0; table[i]; i++)
    {
        if ( 0 == strcasecmp( name, table[i] ))
        {
            return i;
        }
    }
    return -1;
} 

const char * key_table_name_by_objectptr( void *obj, const char *stab[], void** otab)
{
    unsigned i;
    
    DBG_ASSERT(stab);
    DBG_ASSERT(otab);

    for (i = 0; otab[i]; i++)
        if ( obj == otab[i] )
            return stab[i];
    return 0;
}

