/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2010-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



/**
 * \file mrvl_jbig_config.h
 *
 * \brief JBIG device info
 *
 **/

#ifndef MRVL_JBIG_CONFIG_H
#define MRVL_JBIG_CONFIG_H

#include <stdint.h>
#include <dmaalloc-app/error_types.h>
#include "jbig_api.h"
#include <assp/88pa6270/c0/JBIG_SA_regheaders.h>
#include <dmaalloc-app/uio_lib_api.h>


#define NUM_JBIG_BLOCKS 4      ///< number of JBIG blocks supported for this ASIC

#define JBIG_REGS_t JBIG_CODEC_0_CORE_REGS_t
#define JBIG_CODEC_IDMA_REGS_t JBIG_CODEC_0_IDMA_REGS_t
#define JBIG_CODEC_ODMA_REGS_t JBIG_CODEC_0_ODMA_JBIG_ODMA_UDMA_REGS_t
#define JBIG_CODEC_ODMA_CORE_REGS_t  JBIG_CODEC_0_ODMA_JBIG_ODMA_CORE_REGS_t

typedef struct jbig_block_config_s
{
    jbig_block_t jbig_block_type; // encode or decode
    JBIG_REGS_t* jbig_regs;
    JBIG_CODEC_IDMA_REGS_t* jbig_idma_regs;
    JBIG_CODEC_ODMA_REGS_t* jbig_odma_regs;
    JBIG_CODEC_ODMA_CORE_REGS_t* jbig_odma_core_regs;
    uio_dev_t* dev_jbig;
    uio_dev_t* dev_idma;
    uio_dev_t* dev_odma;
    uio_dev_t* dev_odma_core;
}jbig_block_config_t;

const jbig_block_config_t* jbig_platform_get_config();

#define JBIG_CODEC_IDMA_STATUS_DMA_BUSY_MASK              JBIG_CODEC_0_IDMA_STATUS_DMA_BUSY_MASK
#define JBIG_CODEC_IDMA_CFG_REPLICATE_REPLACE_VAL         JBIG_CODEC_0_IDMA_CFG_REPLICATE_REPLACE_VAL
#define JBIG_CODEC_IDMA_CFG_OUT_WIDTH_REPLACE_VAL         JBIG_CODEC_0_IDMA_CFG_OUT_WIDTH_REPLACE_VAL
#define JBIG_CODEC_IDMA_CFG_BURST_LEN_REPLACE_VAL         JBIG_CODEC_0_IDMA_CFG_BURST_LEN_REPLACE_VAL
#define JBIG_CODEC_IDMA_CFG_ENABLE_REPLACE_VAL            JBIG_CODEC_0_IDMA_CFG_ENABLE_REPLACE_VAL
#define JBIG_CODEC_IDMA_LINE_WIDTH_LINE_WIDTH_REPLACE_VAL JBIG_CODEC_0_IDMA_LINE_WIDTH_LINE_WIDTH_REPLACE_VAL

#define JBIG_CODEC_IDMA_INT_ST_WHO_INT_ST_MASK            JBIG_CODEC_0_IDMA_INT_ST_WHO_INT_ST_MASK
#define JBIG_CODEC_IDMA_INT_ST_FIN_INT_ST_MASK            JBIG_CODEC_0_IDMA_INT_ST_FIN_INT_ST_MASK
#define JBIG_CODEC_IDMA_INT_ST_EOI_INT_ST_MASK            JBIG_CODEC_0_IDMA_INT_ST_EOI_INT_ST_MASK
#define JBIG_CODEC_IDMA_INT_ST_RST_INT_ST_MASK            JBIG_CODEC_0_IDMA_INT_ST_RST_INT_ST_MASK
#define JBIG_CODEC_IDMA_RESET_SOFT_RESET_REPLACE_VAL      JBIG_CODEC_0_IDMA_RESET_SOFT_RESET_REPLACE_VAL

#define JBIG_CODEC_JSTAT_E_MASK     JBIG_CODEC_0_CORE_JSTAT_E_MASK
#define JBIG_CODEC_JSTAT_DD_MASK    JBIG_CODEC_0_CORE_JSTAT_DD_MASK
#define JBIG_CODEC_JSTAT_ED_MASK    JBIG_CODEC_0_CORE_JSTAT_ED_MASK
#define JBIG_CODEC_JSTAT_I_MASK     JBIG_CODEC_0_CORE_JSTAT_I_MASK
#define JBIG_CODEC_JSTAT_D_MASK     JBIG_CODEC_0_CORE_JSTAT_D_MASK

#define JBIG_CODEC_JBIG_EN_E_REPLACE_VAL JBIG_CODEC_0_CORE_JBIG_EN_E_REPLACE_VAL
#define JBIG_CODEC_JBIG_EN_S_REPLACE_VAL JBIG_CODEC_0_CORE_JBIG_EN_S_REPLACE_VAL
// #define JBIG_CODEC_JBIG_EN_D_REPLACE_VAL JBIG_CODEC_0_CORE_JBIG_EN_D_REPLACE_VAL

#define JBIG_CODEC_JCTL_T_REPLACE_VAL   JBIG_CODEC_0_CORE_JCTL_T_REPLACE_VAL
#define JBIG_CODEC_JCTL_A_REPLACE_VAL   JBIG_CODEC_0_CORE_JCTL_A_REPLACE_VAL
#define JBIG_CODEC_JCTL_B_REPLACE_VAL   JBIG_CODEC_0_CORE_JCTL_B_REPLACE_VAL
#define JBIG_CODEC_JCTL_BE_REPLACE_VAL  JBIG_CODEC_0_CORE_JCTL_BE_REPLACE_VAL
#define JBIG_CODEC_JCTL_C_REPLACE_VAL   JBIG_CODEC_0_CORE_JCTL_C_REPLACE_VAL
#define JBIG_CODEC_JCTL_D_REPLACE_VAL   JBIG_CODEC_0_CORE_JCTL_D_REPLACE_VAL
#define JBIG_CODEC_JCTL_E_REPLACE_VAL   JBIG_CODEC_0_CORE_JCTL_E_REPLACE_VAL
#define JBIG_CODEC_JCTL_L_REPLACE_VAL   JBIG_CODEC_0_CORE_JCTL_L_REPLACE_VAL
#define JBIG_CODEC_JCTL_M_REPLACE_VAL   JBIG_CODEC_0_CORE_JCTL_M_REPLACE_VAL

#endif
