/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2010-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



/** 
 * \file mrvl_jbig_config.c
 * 
 * \brief JBIG device info.
 * 
 **/
#include <stdint.h>
#include <stdio.h>
#include "jbig_api.h"
#include "mrvl_jbig_config.h"
#include <uio_lib_api.h>
#include <lassert.h>


static bool jbig_config_initialized = false;
jbig_block_config_t jbig_block_config_array[NUM_JBIG_BLOCKS];

/** 
 * \brief Get the platform configuration.
 * 
 * \param config Return configuration to the address of this
 * location.
 * 
 * \return OK if successful, FAIL if not.
 **/
const jbig_block_config_t* jbig_platform_get_config()
{
    uio_map_t *map = NULL; 

    if(!jbig_config_initialized)
    {
        // JBIG Codec 0
        printf("\n%s codec 0\n", __func__);
        jbig_block_config_array[0].jbig_block_type = JBIG_CODEC_BLOCK;

        jbig_block_config_array[0].dev_jbig = uio_open_dev("jbig-codec-core-uio0");
        printf("dev_jbig %p ", jbig_block_config_array[0].dev_jbig);
        map = uio_get_map(jbig_block_config_array[0].dev_jbig, 0);
        printf("map: %p, map->virt_addr %p\n", map, map->virt_addr);
        ASSERT(map != NULL);
        jbig_block_config_array[0].jbig_regs = map->virt_addr;

        jbig_block_config_array[0].dev_idma = uio_open_dev("jbig-codec-idma-uio0");
        printf("dev_idma %p ", jbig_block_config_array[0].dev_idma);
        map = uio_get_map(jbig_block_config_array[0].dev_idma, 0);
        printf("map: %p, map->virt_addr %p\n", map, map->virt_addr);
        ASSERT(map != NULL);
        jbig_block_config_array[0].jbig_idma_regs = map->virt_addr;

        jbig_block_config_array[0].dev_odma = uio_open_dev("jbig-codec-odma-uio0");
        printf("dev_odma %p ", jbig_block_config_array[0].dev_odma);
        map = uio_get_map(jbig_block_config_array[0].dev_odma, 0);
        ASSERT(map != NULL);
        printf("map: %p, map->virt_addr %p\n", map, map->virt_addr);
        jbig_block_config_array[0].jbig_odma_regs = map->virt_addr;

        jbig_block_config_array[0].dev_odma_core = uio_open_dev("jbig-codec-odma-core-uio0");
        printf("dev_odma_core %p ", jbig_block_config_array[0].dev_odma_core);
        map = uio_get_map(jbig_block_config_array[0].dev_odma_core, 0);
        ASSERT(map != NULL);

	map->virt_addr = (void *)((char *)jbig_block_config_array[0].jbig_odma_regs + 0x800);
        printf("map: %p, map->virt_addr %p\n", map, map->virt_addr);
        jbig_block_config_array[0].jbig_odma_core_regs = map->virt_addr;


        // JBIG Codec 1
        printf("\ncodec 1\n");
        jbig_block_config_array[1].jbig_block_type = JBIG_CODEC_BLOCK;
        jbig_block_config_array[1].dev_jbig = uio_open_dev("jbig-codec-core-uio1");
     //   printf("dev_jbig %p\n", jbig_block_config_array[1].dev_jbig);
        map = uio_get_map(jbig_block_config_array[1].dev_jbig, 0);
        ASSERT(map != NULL);
     //    printf("map: %p, map->virt_addr %p\n", map, map->virt_addr);
        jbig_block_config_array[1].jbig_regs = map->virt_addr;

        jbig_block_config_array[1].dev_idma = uio_open_dev("jbig-codec-idma-uio1");
        map = uio_get_map(jbig_block_config_array[1].dev_idma, 0);
        ASSERT(map != NULL);
     //    printf("map: %p, map->virt_addr %p\n", map, map->virt_addr);
        jbig_block_config_array[1].jbig_idma_regs = map->virt_addr;

        jbig_block_config_array[1].dev_odma = uio_open_dev("jbig-codec-odma-uio1");
        map = uio_get_map(jbig_block_config_array[1].dev_odma, 0);
        ASSERT(map != NULL);
    //     printf("map: %p, map->virt_addr %p\n", map, map->virt_addr);
        jbig_block_config_array[1].jbig_odma_regs = map->virt_addr;

        jbig_block_config_array[1].dev_odma_core = uio_open_dev("jbig-codec-odma-core-uio1");
        printf("dev_odma_core %p ", jbig_block_config_array[1].dev_odma_core);
        map = uio_get_map(jbig_block_config_array[1].dev_odma_core, 0);
        ASSERT(map != NULL);

	map->virt_addr = (void *)((char *)jbig_block_config_array[1].jbig_odma_regs + 0x800);
        printf("map: %p, map->virt_addr %p\n", map, map->virt_addr);
        jbig_block_config_array[1].jbig_odma_core_regs = map->virt_addr;


        // JBIG Codec 2
        printf("\ncodec 2\n");
        jbig_block_config_array[2].jbig_block_type = JBIG_CODEC_BLOCK;
        jbig_block_config_array[2].dev_jbig = uio_open_dev("jbig-codec-core-uio2");
        map = uio_get_map(jbig_block_config_array[2].dev_jbig, 0);
    //    printf("map: %p, map->virt_addr %p\n", map, map->virt_addr);
        ASSERT(map != NULL);
        jbig_block_config_array[2].jbig_regs = map->virt_addr;

        jbig_block_config_array[2].dev_idma = uio_open_dev("jbig-codec-idma-uio2");
        map = uio_get_map(jbig_block_config_array[2].dev_idma, 0);
        ASSERT(map != NULL);
        jbig_block_config_array[2].jbig_idma_regs = map->virt_addr;

        jbig_block_config_array[2].dev_odma = uio_open_dev("jbig-codec-odma-uio2");
        map = uio_get_map(jbig_block_config_array[2].dev_odma, 0);
        ASSERT(map != NULL);
        jbig_block_config_array[2].jbig_odma_regs = map->virt_addr;

        jbig_block_config_array[2].dev_odma_core = uio_open_dev("jbig-codec-odma-core-uio2");
        printf("dev_odma_core %p ", jbig_block_config_array[2].dev_odma_core);
        map = uio_get_map(jbig_block_config_array[2].dev_odma_core, 0);
        ASSERT(map != NULL);

	map->virt_addr = (void *)((char *)jbig_block_config_array[2].jbig_odma_regs + 0x800);

        printf("map: %p, map->virt_addr %p\n", map, map->virt_addr);
        jbig_block_config_array[2].jbig_odma_core_regs = map->virt_addr;



        // JBIG Codec 3
        printf("\ncodec 3\n");
        jbig_block_config_array[3].jbig_block_type = JBIG_CODEC_BLOCK;
        jbig_block_config_array[3].dev_jbig = uio_open_dev("jbig-codec-core-uio3");
     //   printf("dev_jbig %p\n", jbig_block_config_array[3].dev_jbig);
        map = uio_get_map(jbig_block_config_array[3].dev_jbig, 0);
    //    printf("map: %p, map->virt_addr %p\n", map, map->virt_addr);
        ASSERT(map != NULL);
        jbig_block_config_array[3].jbig_regs = map->virt_addr;

        jbig_block_config_array[3].dev_idma = uio_open_dev("jbig-codec-idma-uio3");
        map = uio_get_map(jbig_block_config_array[3].dev_idma, 0);
        ASSERT(map != NULL);
        jbig_block_config_array[3].jbig_idma_regs = map->virt_addr;

        jbig_block_config_array[3].dev_odma = uio_open_dev("jbig-codec-odma-uio3");
        map = uio_get_map(jbig_block_config_array[3].dev_odma, 0);
        ASSERT(map != NULL);
        jbig_block_config_array[3].jbig_odma_regs = map->virt_addr;

        jbig_block_config_array[3].dev_odma_core = uio_open_dev("jbig-codec-odma-core-uio3");
        printf("dev_odma_core %p ", jbig_block_config_array[3].dev_odma_core);
        map = uio_get_map(jbig_block_config_array[3].dev_odma_core, 0);
        ASSERT(map != NULL);

	map->virt_addr = (void *)((char *)jbig_block_config_array[3].jbig_odma_regs + 0x800);

        printf("map: %p, map->virt_addr %p\n", map, map->virt_addr);
        jbig_block_config_array[3].jbig_odma_core_regs = map->virt_addr;


        jbig_config_initialized = true;
    }

    return jbig_block_config_array;
}

