/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2008-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



//-jrs#include "asic.h"
#include "jbig.h"
#include "jbig_api.h"
#include "mrvl_jbig_config.h"
#include <dmaalloc-app/dma_alloc_api.h>

#define LOGGER_JBIG_UTILS 0x40000000    // pick a bit for this file.
#define LOGGER_JBIG_API   0x20000000    // pick a bit for this file.
#define LOGGER_JBIG_TEST  0x80000000    // pick a bit for this file.


#define REG_SET_BITS(addr, val) *(addr) |= (val);
#define REG_CLEAR_BITS(addr, val) *(addr) &= ~(val);
#define REG_CLEAR(addr) *(addr) = 0x0;

#define JBIG_IDMA_REGS_t JBIG_DECODE_IDMA_REGS_t
#define JBIG_ODMA_REGS_t JBIG_DECODE_ODMA_REGS_t
#define JBIG_CONTROL_REGS_t JBIG_DECODE_REGS_t

// JBIG descriptor configuration bit definitions
#define JBIG_ODMA_DESCRIPTOR_COMPLETE    (1<<25)
#define JBIG_ODMA_DESCRIPTOR_OWNERSHIP    (1<<24)
#define JBIG_ODMA_DESC_INT_ON_COMPLETION  (1<<1)
#define JBIG_ODMA_DESC_STOP_ON_COMPLETION (1<<0)

// Read DMA
#define JBIG_DESCRIPTOR_OWNERSHIP      (1<<16)
#define JBIG_DESCRIPTOR_END_OF_IMAGE   (1<<7)
#define JBIG_DESCRIPTOR_START_OF_IMAGE (1<<6)
#define JBIG_DESCRIPTOR_INTERRUPT_ON_COMPLETION (1<<1)
#define JBIG_DESCRIPTOR_STOP (1<<0)


typedef enum
{
   JBIG_MSG_FREE_MEMORY = 0x5,
   JBIG_MSG_IDMA_COMPLETE,          // input dma complete
   JBIG_MSG_ODMA_COMPLETE,          // output dma complete
   JBIG_MSG_OPERATION_COMPLETE,
   JBIG_MSG_ODMA_EOI,
   JBIG_MSG_STOP_THREAD
} JBIGMSG;


typedef struct 
{
    unsigned int            : 16;
    unsigned int enAtmov    : 1; 
    unsigned int line3      : 1;   
    unsigned int typLineDet : 1; 
    unsigned int            : 1;    
    unsigned int encode     : 1;
    unsigned int decode     : 1;
    unsigned int            : 2;
    unsigned int streaming  : 1;
    unsigned int atmov      : 7;
} tJBIGControlRegDef;

typedef union 
{
    uint32_t shadow;
    tJBIGControlRegDef JBIGControlReg;
} tJBIGControlShadow;

/**
 * \brief This structure defines the layout of the video DMA descriptor. DMA
 *  descriptors reside in memory, and must NOT be cached. Descriptors are
 *  "chained", and the DMA hardware "follows the chain", as long as the next
 *  descriptor in the chain is marked as ready.
 **/
typedef struct jbig_idma_descriptor_s
{
    volatile uint32_t control;
    volatile uint32_t dataBuffer;
    volatile uint32_t length;
//    volatile struct jbigDescriptor * next_desc_phys_addr;
//    struct jbigDescriptor * next_desc_virt_addr;
//    void * context;            ///< context pointer to allow recovery of callback and dma tracking info
//    void* hw_addr;             ///< physical HW address of this descriptor; 
//                               ///needed to free with MEM_FREE_UNCACHED and needed when starting DMA
} __attribute__ ((__packed__)) jbig_idma_descriptor_t;

typedef struct jbig_odma_descriptor_s
{
    volatile uint32_t control;
    volatile uint32_t length;
    volatile uint32_t dataBuffer;
//    volatile struct jbig_odma_descriptor_s* next_desc_phys_addr;
//    struct jbig_odma_descriptor_s* next_desc_virt_addr;
//    void* context;             ///< context pointer to allow recovery of callback and dma tracking info
//    void* hw_addr;             ///< physical HW address of this descriptor; 
//                               ///needed to free with MEM_FREE_UNCACHED and needed when starting DMA

} __attribute__ ((__packed__))  jbig_odma_descriptor_t;

typedef struct jbig_descriptor_s
{
    // The following union contains the three words of either the idma
    // or odma descriptor.
    union
    {
        jbig_idma_descriptor_t idma;
        jbig_odma_descriptor_t odma;
    };

    volatile uint32_t next_desc_phys_addr;		// The field also belongs to hardware [IO]DMA descriptor

    struct jbig_descriptor_s* next_desc_virt_addr;
    void* context;             ///< context pointer to allow recovery of callback and dma tracking info
    void* hw_addr;             ///< physical HW address of this descriptor; 
                               ///needed to free with MEM_FREE_UNCACHED and needed when starting DMA
} __attribute__ ((aligned (32))) jbig_descriptor_t;

typedef struct jbig_dma_context_s
{
//    dma_alloc_t* dma_alloc;
    BigBuffer_t* buf;
    uint32_t len;
    void* user_callback_data;
}jbig_dma_context_t;

typedef struct
{
    JBIGMSG msgType;
    jbig_descriptor_t * descriptor;
    jbig_handle_t * handle;
}JBIG_MESSAGE;


// Generic JBIG descriptor List structure
typedef struct jbigDescriptorList
{
    jbig_descriptor_t * ListHead;
    jbig_descriptor_t * ListTail;
} tJBIGDescriptorList;


struct jbig_handle_s
{
    uint32_t    channel;
    jbig_config_t config;
    uint8_t		inUse;
    uint8_t     dirty;
    uint32_t    lastError;
    uint8_t		started;
    bool        complete;
    bool        odma_complete;
    uint32_t    linesRemaining;

    uint32_t    bytes_output;       ///< number of bytes output by ODMA during last transaction

    pthread_mutex_t lock;
    sem_t open_sem;             ///< block is in use
    sem_t completion_sem;       ///< completion semaphore used by blocking encode/decode apis
    sem_t user_sem;             ///< semaphore available for use application to use

    // linked list of pending descriptors
    tJBIGDescriptorList  pendingReadDescriptorList;
    tJBIGDescriptorList  currentReadDescriptorList;
    
    // These counters are used to track how many descriptors we
    // have in flight at once. If we exceed the number of messages
    // we can handle then they will be lost.
    uint32_t    numPendingMessages;
    uint32_t    maxNumMessages;

    // The pending list is used to build a linked
    // list of descriptors the current list is the 
    // list that is being worked on by the JBIG block
    tJBIGDescriptorList  pendingWriteDescriptorList;
    tJBIGDescriptorList  currentWriteDescriptorList;
    
    // pointer to JBIG event callback given by user
    jbig_callback_t  jbigCallback;
    void* jbig_callback_context;
    uint32_t control_status;

    jbig_dma_callback_t odma_callback;
    jbig_dma_callback_t idma_callback;
    jbig_dma_callback_with_byte_count_t odma_byte_count_callback;
        
    // JBIG block data including block type, register interface pointers, and int nums.
    const jbig_block_config_t* jbig_block_interface;

    // store last input byte to compare when adding "pad line" for jbig bug work around
    uint8_t     last_input_byte;

    int32_t bytes_until_pad;



};



void jbigResetHardware( jbig_handle_t * handle );
error_type_t jbigAddWriteDMABuffer(jbig_handle_t * handle, BigBuffer_t* buf, uint32_t size, void * userData );
error_type_t jbigAddReadDMABuffer( jbig_handle_t * handle, BigBuffer_t* buf, uint32_t size, void * userData );

void jbigSetCallback( jbig_handle_t * inHandle, jbig_callback_t callback );
void jbigClearCallback( jbig_handle_t * inHandle );

void jbigStartReadDMA( jbig_handle_t * inHandle );
void jbigStartWriteDMA( jbig_handle_t * inHandle );

error_type_t  jbig_add_pad_read_strip( jbig_handle_t * handle );
error_type_t  jbig_add_pad_write_strip( jbig_handle_t * handle, tJBIGDescriptorList* inList );

/**
 * 
 * \brief Initialize realtime OS related items; e.g. attach interrupts, create 
 *        threads.
 * 
 * @param jbig_block_config 
 */
void jbig_init_rtos(const jbig_block_config_t * jbig_block_config);

void jbigResetReadDMA(  jbig_handle_t * handle );
void jbigResetWriteDMA( jbig_handle_t * handle );
void jbigStart( jbig_handle_t * handle );
void jbigStop( jbig_handle_t * handle );
error_type_t jbigCommitConfig( jbig_handle_t *handle );
void jbigInitDescriptors( jbig_handle_t *handle );
void jbigFreeMemory( jbig_handle_t * handle );
jbig_handle_t * jbigAssignHandle( jbig_block_t block );
void jbigSetCurrentTransaction( jbig_handle_t * inHandle );
jbig_handle_t * jbigGetCurrentTransaction( jbig_block_t inBlock);
void jbigClearCurrentTransaction( jbig_handle_t * inHandle );
error_type_t jbigStartThread( void );
error_type_t jbigStopThread( void );

// Debug functions
void jbig_dump_control_regs(jbig_handle_t *handle);
void jbig_dump_odma_regs(jbig_handle_t *handle);
void jbig_dump_idma_regs(jbig_handle_t *handle);
void jbig_dump_all_regs(jbig_handle_t * handle);

void jbigFreeHandleDescriptors( jbig_handle_t * handle );

extern tJBIGControlShadow JBIGControlShadow;

