#!/usr/bin/perl -w
#
# Copyright (c) 2007-2018, Marvell International Ltd.
#

use strict;
use POSIX;



my $debug=0;

#
# extract the change number from the string that is passed.
# the 2nd field of the string is the number.  So look for
# a space and then the 2nd space and return that value.
#
sub extractCommitTag
{
    #
    # now extract the change number from the string.
    my $val=shift(@_);
    my $start = index($val, ' ')+1;  # Find the first space in the string
    my $commit = substr($val, $start, 7);   # get the string from first space on.
    return $commit;  # return that number.
}

#
# Find the change list number and return it.
#
sub getCommitFromWorkspace
{
    # find the change number for our code.
    #
    my $temp1 = 'git log --abbrev-commit'; # the command to execute
    my $git_log_data =`$temp1`;  # Execute the command.
    my $first = extractCommitTag($git_log_data);  # get the commit tag
    # return it.
    return $first;

}

#
# $Header
#
my $header='
/******************************************************************************
 *
 * ============================================================================
 * (C) Copyright %d Marvell International Ltd.
 * ============================================================================
 *
 * Description: This file is _Generated_ by perl on every build.  Do NOT edit.
 *
 *****************************************************************************/


const unsigned int FIRMWARE_VERSION[] __attribute__ ((section (".fwrevision")))={%s};
const char BUILD_INFO[] __attribute__ ((section (".fwrevision")))="%s";
';

my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
                                                    localtime();
# +1900 because year starts at 100; +1 because month starts at 0
my $fwversion = sprintf( "(%d<<12) | %d,(%d<<21) | (%d<<17) | (%d<<12) | %d",shift @ARGV, shift @ARGV, $year, $mon+1, $mday, shift @ARGV );
print "$fwversion\n" if $debug;

print "$wday\n" if $debug;

my $build_info_string="";
# build a  string like:
# "TIME=Mon Mar 19 13:16:40 2007 dangerousradish -- PROD=<Product> CFG=GCC_DEBUG"
#

my $time_str = POSIX::strftime( "%a %b %d %H:%M:%S %Y", $sec, $min, $hour, $mday, $mon, $year );
$build_info_string .= "TIME=$time_str";
$build_info_string .= ";COMMIT=";
$build_info_string .= getCommitFromWorkspace;

#
# now do the final output
#
my $output = sprintf( $header, $year + 1900, $fwversion, $build_info_string);
print $output if $debug;

open( FH, ">source/main/fwVersion.c" ) || die "could not open source/main/fwVersion.c for writing: $!";
print FH "$output\n";
close( FH );


