#
# ============================================================================
# (C) Copyright 2013-2014   Marvell International Ltd.
# ============================================================================
#
TOP    = $(realpath $(CURDIR))
toprel = $(subst $(realpath $(TOP))/,,$(abspath $(1)))

DERIVED_DIRS = $(OBJDIR) $(DEPDIR) $(BINDIR)
INC_DIRS = include/cheader

ELFPRGMFILES = $(foreach elf, $(PRGMFILES), $(elf).elf)

# Define toolchain names
CC      := $(CROSS_COMPILE)gcc
HOSTCC  := gcc
CPP     := $(CROSS_COMPILE)g++
HOSTCPP := g++
AS      := $(CROSS_COMPILE)gcc
LD      := $(CROSS_COMPILE)ld
OBJCOPY := $(CROSS_COMPILE)objcopy
OBJDUMP := $(CROSS_COMPILE)objdump
SIZE    := $(CROSS_COMPILE)size
NM      := $(CROSS_COMPILE)nm
STRIP   := $(CROSS_COMPILE)strip
#OVRLY_TRANS := $(TOP)/tools/overlay_tool/overlayize.py

# Sources
SRCDIR ?= $(TOP)/source

allasrc = 
allcsrc = 

to_lower =$(subst A,a,$(subst B,b,$(subst C,c,$(subst D,d,$(subst E,e,$(subst F,f,$(subst G,g,$(subst H,h,$(subst I,i,$(subst J,j,$(subst K,k,$(subst L,l,$(subst M,m,$(subst N,n,$(subst O,o,$(subst P,p,$(subst Q,q,$(subst R,r,$(subst S,s,$(subst T,t,$(subst U,u,$(subst V,v,$(subst W,w,$(subst X,x,$(subst Y,y,$(subst Z,z,$1))))))))))))))))))))))))))

define MODULE_INC_MAKE_MACRO
  asrc =
  csrc =

  $(eval include $(SRCDIR)/$(1)/Makefile)

  # List of all .c & .S source files.
  $(foreach i, asrc, $(eval allasrc+=$(addprefix $(SRCDIR)/$(1)/,$($(i)))))
  $(foreach i, csrc, $(eval allcsrc+=$(addprefix $(SRCDIR)/$(1)/,$($(i)))))

  # List of all source files without directory and file-extension.
  $(foreach i, csrc_overlay asrc csrc, \
  		$(eval ALLOBJ+=$(addprefix $(OBJDIR)/,$(addsuffix .o, $(basename $($(i)))))))
endef

$(foreach module, $(MODULES), $(eval  $(call MODULE_INC_MAKE_MACRO,$(module))))

ALLASRC = $(sort $(allasrc))
ALLCSRC = $(sort $(allcsrc))

# Determine the compiler version. Use this information to determine the 
# correct path for the libraries.
CC_VERSION := $(shell $(CC) -v 2>&1 | grep "gcc version" | cut -d' ' -f3)

# Get the path to the C Compiler in a variable
CC_EXE_PATH := $(shell dirname `which $(CC)`)

# One dir (bin) up from the CC is the base of the Tools package
TOOLS_BASE := $(CC_EXE_PATH)/..

# Libraries are always found in this path relative to the tools base
TOOL_PREFIX := $(patsubst %-,%,$(CROSS_COMPILE))
LIB_BASE 	:= $(TOOLS_BASE)/lib/gcc/$(TOOL_PREFIX)/$(CC_VERSION)

# Set a Libs search var for the CC line
LIBPATH	:= $(LIB_BASE)
#LIBPATH := \
 /usr/local/carlson-minot/crosscompilers/lib/gcc/arm-none-eabi/4.7.3 \
 /usr/local/carlson-minot/crosscompilers/lib/gcc/arm-none-eabi/4.7.3/../../../../arm-none-eabi/lib \
 /usr/local/carlson-minot/crosscompilers/arm-none-eabi/lib

# use the bare metal (eabi) compiler and include files for all UPC builds!
CC_INCPATH = $(TOOLS_BASE)/$(TOOL_PREFIX)/include

CDEFS			= -DCPU_FREQ=52 -DUART -DNUM_OVERLAY_SLOTS=4 \
					-DDEBUGPRINT -DUPC_BUILD -DDESTINY
ifeq ($(CONFIG_TPM),yes)
CDEFS	+= -DCONFIG_TPM
ifeq ($(CONFIG_TPM_PHYSICAL_INIT),yes)
CDEFS	+= -DCONFIG_TPM_PHYSICAL_INIT
endif
endif

BT := $(call to_lower,$(BUILD_TYPE))
ifeq "$(BT)" "initial"
 CDEFS          += -DINITIAL_TURN_ON
else
  ifeq "$(BT)" "second"
    CDEFS          += -DSECOND_STAGE_TURN_ON
  endif
endif

gccincdir := $(shell $(CC) -print-file-name=include)

IDEFS			= 
INCFLAGS		= -I$(CC_INCPATH) -I$(TOP)/include $(foreach dir, $(INC_DIRS), -I$(TOP)/$(dir)) -I.
UC_FLAGS		=  -march=armv7-r -mcpu=cortex-r4
CROSS_CMN_FLAGS	= $(UC_FLAGS) -g -mlittle-endian
CFLAGS			= -g -Wall $(CDEFS) $(INCFLAGS) 
#CROSS_CFLAGS	= $(CROSS_CMN_FLAGS) -Os -Wall $(CDEFS) $(INCFLAGS) -mthumb
CROSS_CFLAGS	= $(CROSS_CMN_FLAGS) -O1 -Wall $(CDEFS) $(INCFLAGS) -mthumb
#CROSS_CFLAGS	= $(CROSS_CMN_FLAGS) -O3 -Wall $(CDEFS) $(INCFLAGS)
CROSS_CFLAGS	+= -ffunction-sections -fdata-sections
CROSS_CFLAGS	+= -ffreestanding -nostdinc -isystem $(gccincdir) -fno-builtin -msoft-float
CROSS_ASFLAGS	= $(CROSS_CMN_FLAGS) $(CDEFS) $(INCFLAGS)
EXTRA_CFLAGS	=
# Compiler flags to generate dependency files:
CFLAGS 			+= -MD -MP -MF $(DEPDIR)/$(@F).d
CROSS_CFLAGS	+= -MD -MP -MF $(DEPDIR)/$(@F).d
OVLY_CROSS_CFLAGS	= -xc -finstrument-functions
CFLOW_FLAGS		:= --format=posix 

# Note -Map needs to be at the end!
#LDFLAGS			= -L$(LIBPATH) -L$(LIBEXTRA) -lc -EL -Map $$(basename $$@).map
LDFLAGS			= $(foreach lib,$(LIBPATH), -L$(lib)) -EL -Map $$(basename $$@).map
LDFLAGS			+= --gc-sections
#LIBS			= --start-group -lgcc -lc --end-group
LIBS			= 

strip_list = .comment .bss .debug_line .debug_info \
             .debug_abbrev .debug_aranges .debug_ranges .debug_str \
			 .debug_frame .debug_loc .shstrtab .symtab .strtab

ifdef BUILDBSPI
strip_list += .lcm .lcm.data .lcm.minprintf .codetable
endif
ifdef BUILDROM
strip_list += .lcm .lcm.data .lcm.minprintf .codetable
endif

STRIPFLAGS = -S --strip-unneeded $(foreach x, $(strip_list), -R$(x))

quote   = '
# magic to close the quote above '

MSG_HOST_LD     := ${quote} HOST-LD   ${quote}
MSG_LD          := ${quote} LD        ${quote}
MSG_STRIP       := ${quote} STRIP     ${quote}
MSG_OBJDUMP     := ${quote} OBJDUMP   ${quote}
MSG_OBJCPY      := ${quote} OBJCPY    ${quote}
MSG_HOST_CC     := ${quote} HOST-CC   ${quote}
MSG_CC          := ${quote} CC        ${quote}
MSG_HOST_CPP    := ${quote} HOST-CXX  ${quote}
MSG_CPP         := ${quote} CXX       ${quote}
MSG_HOST_AS     := ${quote} HOST-AS   ${quote}
MSG_OVR         := ${quote} OVERLAY   ${quote}
MSG_AS          := ${quote} AS        ${quote}
MSG_CLEAN       := ${quote} CLEANing  ${quote}
MSG_CF          := ${quote} CFLOW     ${quote}

# Decide on a verbosity level based on the V= parameter
export AT := @

ifndef V
export V0    :=
export V1    := $(AT)
else ifeq ($(V), 0)
export V0    := $(AT)
export V1    := $(AT)
else ifeq ($(V), 1)
endif

# Compile: create .o's from C source files. Host Compiler
define COMPILE_HOST_C_MACRO
$(OBJDIR)/$(notdir $(basename $(1))).o : $(1)
	@echo $(MSG_HOST_CC) $$(call toprel, $$<)
	$(V1) $(HOSTCC) -c -mthumb $$(CFLAGS) $$(CONLYFLAGS) $$< -o $$@
endef

# Cross Compile: create .o's from C source files.
define COMPILE_CROSS_CC_MACRO
$(OBJDIR)/$(notdir $(basename $(1))).o : $(1)
	@echo $(MSG_CC) $$(call toprel, $$<)
	$(V1) $(CC) -c $$(CROSS_CFLAGS) $$(CONLYFLAGS) $$< -o $$@
endef

## Cross Compile: create .i's from C source files.
#define COMPILE_OVRLY_I_MACRO
#$(OBJDIR)/$(notdir $(basename $(1))).i : $(1)
#	@echo $(MSG_OVR) $$(call toprel, $$<)
#ifdef V1
#	$(V1) $(OVRLY_TRANS) $$< > $$@ 
#else
#	$(V1) $(OVRLY_TRANS) -v 3 $$< > $$@ 
#endif
#endef

## Cross Compile: create .o's from translated .i type C source files.
#define COMPILE_OVRLY_CROSS_CC_MACRO
#$(OBJDIR)/$(notdir $(basename $(1))).o : $(OBJDIR)/$(notdir $(basename $(1))).i
#	@echo $(MSG_CC) $$(call toprel, $$<)
#	$(V1) $(CC) -c $$(OVLY_CROSS_CFLAGS) $$(CROSS_CFLAGS) $$(CONLYFLAGS) $$< -o $$@
#endef
#
## Compile: create .o's from C++ source files. Host Compiler
#define COMPILE_HOST_CPP_MACRO
#$(OBJDIR)/$(notdir $(basename $(1))).o : $(1)
#	@echo $(MSG_HOST_CPP) $$(call toprel, $$<)
#	$(V1) $(HOSTCPP) -c -mthumb $$(CFLAGS) $$(CPPFLAGS) $$< -o $$@
#endef

# Assemble: create .o's from asm source files. .S-only .s will not work with GCC
define ASSEMBLY_CROSS_MACRO
$(OBJDIR)/$(notdir $(basename $(1))).o : $(1) 
	@echo $(MSG_AS) $$(call toprel, $$<)
	$(V1) $(AS) -c $$(CROSS_ASFLAGS) $$< -o $$@
endef

# Link .o's into an ELF object file
#$(BINDIR)/$(1).elf: $(TOOLSDIR)/$(strip $(1)).ld $($(subst xxxx,$(strip $(1)),ALLxxxxOBJ))
define ELF_PRGM_MACRO
$(BINDIR)/$(1).elf: $(TOOLSDIR)/$(strip $(1)).ld $(ALLOBJ)
	@echo $(MSG_LD) $$(call toprel, $$@)
	$(V1) $(LD) $(LDFLAGS) --script $$^ $(LIBS) -o $$@
endef

# Strip extra cruft from an ELF object file to make stripped.elf
define STRIPPED_ELF_MACRO
$(BINDIR)/$(1).stripped.elf: $(BINDIR)/$(1).elf
	@echo $(MSG_STRIP) $$(call toprel, $$@)
ifdef V1
	$(V1) $(STRIP) $(STRIPFLAGS) -o $$@ $$^ 2> /dev/null
else
	$(V1) $(STRIP) $(STRIPFLAGS) -o $$@ $$^
endif
endef

# Create a diagnostic dump file
define OBJDUMP_MACRO
$(BINDIR)/$(1).dump: $(BINDIR)/$(1).elf
	@echo $(MSG_OBJDUMP) $$(call toprel, $$@)
	$(V1) $(OBJDUMP) -S $$^ --source > $$@
endef

# Copy/translate a stripped.elf into a .bin file.
define OBJCPY_MACRO
$(BINDIR)/$(1).bin: $(BINDIR)/$(1).stripped.elf
	@echo $(MSG_OBJCPY) $$(call toprel, $$@)
	$(V1) $(OBJCOPY) -O binary $$^ $$@
endef

define DIR_CHECK_MACRO
$(1):
	$(V1)mkdir -p $(1)
endef

# Check our created dirs exist
$(foreach directory, $(DERIVED_DIRS), $(eval $(call DIR_CHECK_MACRO, $(directory))))

# Compile C source files
$(foreach src, $(ALLCSRC), $(eval $(call COMPILE_CROSS_CC_MACRO,$(src))))

# Assemble .S source files
$(foreach src, $(ALLASRC), $(eval $(call ASSEMBLY_CROSS_MACRO,$(src))))

# Link source files to .elf
$(foreach elf, $(PRGMTARGETS), $(eval $(call ELF_PRGM_MACRO,$(elf))))

# Create OBJ dump files from .elf
$(foreach dump, $(PRGMTARGETS), $(eval $(call OBJDUMP_MACRO,$(dump))))

# Create Stripped .elf files
$(foreach stripped_elf, $(PRGMTARGETS), $(eval $(call STRIPPED_ELF_MACRO,$(stripped_elf))))

# Convert Stripped .elf files to Obj Binaries
$(foreach bin, $(PRGMTARGETS), $(eval $(call OBJCPY_MACRO,$(bin))))

$(BINDIR)/$(PRGMTARGETS).cflow: $(ALLCSRC)
	@echo $(MSG_CF) $(call toprel, $@)
ifdef V1
	$(V1) cflow -o$@ $(CFLOW_FLAGS) $(CDEFS) $(INCFLAGS) $^ 2> /dev/null
else
	$(V1) cflow -o$@ $(CFLOW_FLAGS) $(CDEFS) $(INCFLAGS) $^
endif

$(BINDIR)/$(PRGMTARGETS).cflow_r: $(ALLCSRC)
	@echo $(MSG_CF) $(call toprel, $@)
ifdef V1
	$(V1) cflow -o$@ $(CFLOW_FLAGS) --reverse --brief $(CDEFS) $(INCFLAGS) $^ 2> /dev/null
else
	$(V1) cflow -o$@ $(CFLOW_FLAGS) --reverse --brief $(CDEFS) $(INCFLAGS) $^ 
endif

cflow: $(BINDIR) $(BINDIR)/$(PRGMTARGETS).cflow $(BINDIR)/$(PRGMTARGETS).cflow_r

test_vars:
	@echo _$(BT)_ _$(BUILD_TYPE)_
	@echo makefile_list: $(MAKEFILE_LIST)
	@echo TOP: $(TOP)
	@echo CC: $(CC)
	@echo cc_version: $(CC_VERSION) cc_exe_path: $(CC_EXE_PATH) 
	@echo tools_base: $(TOOLS_BASE) incpath: $(INCPATH)
	@echo libpath: $(LIBPATH)
	@echo cc: $(CC) cpp: $(CPP) hostcc: $(HOSTCC)
	@echo srctargets: $(srctargets)
	@echo
	@echo allasrc:  $(allasrc)
	@echo ALLASRC:  $(ALLASRC)
	@echo
	@echo allcsrc:  $(allcsrc)
	@echo ALLCSRC:  $(ALLCSRC)
	@echo
	@echo _$(foreach x, $(PRGMTARGETS), $(ALLOBJ))_
#	@echo 2_$(foreach x, $(PRGMTARGETS), $($(subst xxxx,$(x),ALLxxxxOBJ)))_

#/* Used by vim and some versions of vi: set tabstop=4 shiftwidth=4: */
