#!/usr/bin/env python

# Dump a THX linked universal binary (multiple THeradX images for multiple
# architectures linked into one single file).
#
#   20-Nov-2014

# support python2 but be as python3 as possible
from __future__ import print_function
from __future__ import unicode_literals

import sys
import os
import struct

from thxlink import entry_fmt, package_fmt, TRDX_MAGIC_KEY, calc_cksum

field_names = ("chip_id", "chip_rev", "flags", "cksum", "offset_bytes",
                "size_bytes" )

def dump_thx_universal( infilename ) : 
    infile = open(infilename,'rb')

    header_buf = infile.read(struct.calcsize(package_fmt))
    magic, num_entries = struct.unpack( package_fmt, header_buf )
    print("magic={0:#010x} num_entries={1}".format(magic, num_entries))

    entry_list = []
    for i in range(num_entries) : 
        # read the entry header
        entry_buf = infile.read(struct.calcsize(entry_fmt))
        # unpack into a python dict
        entry_tup = struct.unpack(entry_fmt,entry_buf)
        entry = dict(zip(field_names,entry_tup))

        entry_list.append( entry )
        # detach the ref
        del entry

    for idx,entry in enumerate(entry_list) : 
        infile.seek(entry["offset_bytes"],os.SEEK_SET)
        entry["data"] = infile.read( entry["size_bytes"] )
            
        cksum = calc_cksum(entry["data"])
        if cksum != entry["cksum"] :
            print("Error! checksum mismatch on entry={0}".format(idx),
                    file=sys.stderr)

        print("chip_id={0} chip_rev={1} flags={2:#04x} cksum={3} offset_bytes={4} size_bytes={5}".format(
                entry["chip_id"],entry["chip_rev"],entry["flags"],
                entry["cksum"], entry["offset_bytes"], entry["size_bytes"] ) )

    infile.close()

def usage():
    print("TODO.",file=sys.stderr)

if __name__=='__main__':
    if len(sys.argv) != 2 : 
        usage()
        sys.exit(1)
    infilename = sys.argv[1]
    dump_thx_universal( infilename )

