/***********************************************************************
* (C) Copyright 2007-2014 Marvell International Ltd.                   *
************************************************************************/

/***********************************************************************
* File: MiniLoader.ld                                                  *
*                                                                      *
* Load file for Gnu toolchain link                                     *
************************************************************************/


ENTRY(entry)
MEMORY
{
/* R4 processor ROM */
  rom(rx)			: ORIGIN = 0xFFE00000, LENGTH = 128k

/* R4 processor RAM */
                      /* Offset 32K in in case RevB, another 2K to leave TIM room */
  lcm (wx)			: ORIGIN = 0xd0f00000 + (32K +2K), LENGTH = 96K - (32K +2K)
}

/* lcm is 96k long, but we ignore parts */

SECTIONS
{

  .lcm : {
           *(.entrypoint);
           *(.lcm.data);/* make sure these values are in lcm.*/
           __boot_memory__ = .;
           . = ALIGN(32);
         } > lcm

  /* we put vectors as the first thing in LCM so they are at the beginning */
  .vectors	: {
                *(.vectors);
                __boot_vectors = .;
                /* mfg rev placeholder at a known location */
                mfg_rev_space = .;
                . = . + 8;
                *(.fwrevision);
                *(.post_vectors);
              } > lcm

  .text		: { *(.text)		} > lcm
  .init		: { *(.init)		} > lcm

  __code_end__ = .;

  .rodata	: { *(.rodata)		} > lcm
  .rodata.str1.4 : {*(.rodata.str1.4)} > lcm
  .glue_7	: { *(.glue_7)		} > lcm
  .glue_7t	: { *(.glue_7t)		} > lcm
  .fini		: { *(.fini)} > lcm

 /* . = ALIGN(8);   align 8 for safety */

  __ROMvars_end__ = .;

  .bss BLOCK(32) : {                 /* our BSS init is efficient -- assumes 32 byte alignments... */
                *(.bss);
              } > lcm
  __bss_start__ = ADDR(.bss);	/* Variable holding start of bss section */
  __bss_end__ = .;	/* Variable holding end of bss section */

  .data BLOCK(32): {                       /* our DATA init is efficient -- assumes 32 byte alignments... */
                *(.data);
        } > lcm
    . = ALIGN(8);
  __datavars_start__ = ADDR(.data); /* Variable holding start of bss section */
  __datavars_end__ = .;


  . = ALIGN(8); /* always need to align 8 for a stack */
  __Initial_IRQ__ = . + 0x200;
  __Initial_FIQ__ = . + 0x280;
  __Initial_Exception__ = . + 0x2C0;  /* should have stack for exception handling */
  . = __Initial_Exception__;
  __Initial_SP__ = . + 8K;
  . = __Initial_SP__;
  __SRAM_SCRATCH__ = . ;
  __start_of_free_DDR__ = 0;
  end = .;  /* end of everything */


  /* DEBUG SECTIONS */
/*
  .stab 0 : { *(.stab) }
  .stabstr 0 : { *(.stabstr) }
  .stab.excl 0 : { *(.stab.excl) }
  .stab.exclstr 0 : { *(.stab.exclstr) }
  .stab.index 0 : { *(.stab.index) }
  .stab.indexstr 0 : { *(.stab.indexstr) }
  .comment 0 : { *(.comment) }
*/
/*  /DISCARD/ : {
        *(.comment)
        *(.debug_line)
        *(.debug_info)
        *(.debug_abbrev)
        *(.debug_aranges)
        *(.debug_frame)
        *(.debug_pubnames)
        *(.debug_str)
        *(.debug_ranges)
         } */
/*romStartAtVectors = 0xffff0000;*/
}

/* Used by vim and some versions of vi: set tabstop=4 shiftwidth=4: */
