/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the G
General Public License Version 2, and any use shall comply with the term
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOS
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details a
this warranty disclaimer.
*/

#include "asmCmptLayer.h"
#include "regAddrs.h"


    .balign 16
    .section .entrypoint, #execinstr

#define LCM_SIZE 0x00018000
#define CHIPID_REG  AP_CIU_BASE
#define CHIP_GR2 0x6270
#define CHIP_GE2 0x6220
#define DFT_ISLD_REV_ID_REG     0xD401D800
#define DFT_ISLD_GR2_REVA_VAL   0x00010000



EXPORT entry
EXPORT _Entry

LABEL(entry)
LABEL(_Entry)
    ldr sp,=IPS_LCM_BASE + LCM_SIZE - 1024
    ldr r1,=DFT_ISLD_REV_ID_REG
    ldr r0,[r1]
    mov r1,#DFT_ISLD_GR2_REVA_VAL   ;# Is it Gr2 RevA?
    cmp r0, r1
    beq _SPloaded
    ldr r1,=CHIPID_REG
    ldr r0,[r1]                     ;# Read the ChipID reg
    lsl r0, r0, #16
    lsr r0, r0, #16
    ldr r1,=CHIP_GE2                ;# Is it Ge2?
    cmp r0, r1
    ldreq sp,=IPS_LCM_BASE_GE2 + LCM_SIZE - 1024

LABEL(_SPloaded)


;# Debugger foo.  Kill this later!!  Hold here for a bit so XDB can get its breakpoints re-init'ed.
#if 0
    mov r0, #0x100000
1:  nop
    nop
    nop
    nop
    nop
    subs r0,r0,#1
    bne  1b
#endif
    nop
    bl  _set_up_bss_vars
    ;# call the code to authenticate this
    blx main_entry
    ;# should never return from this.
LABEL(_hello)
    b _hello

/* bss & datavars labels are defined in the .ld file */
.LC1:           .word   __bss_start__
.LC2:           .word   __bss_end__
DATA_START:     .word __datavars_start__
DATA_END:       .word __datavars_end__
DATA_SOURCE:    .word __ROMvars_end__


.arm

;#*******************************************************************
;# MemsetBSS(UINT8 *destination, UINT8 fillValue, int length
;# same with ASSUMPTION everything is aligned, save simulation cycles
;#*******************************************************************
;#thumb.thumb_func
;#    .global MemsetBSS
MemsetBSS:
    ADD  R3, R0, R2         ;#Calculate Final Address + 1
    CMP  R2, #0
    BEQ  MemsetDoneBSS      ;# if there are 0 values to set, we are done
    MOV  R2, R0
MemsetLoopBSS:
    STR  R1, [R0], #4       ;#Store a 4byte at offset
    STR  R1, [R0], #4       ;#Store a 4byte at offset
    STR  R1, [R0], #4       ;#Store a 4byte at offset
    STR  R1, [R0], #4       ;#Store a 4byte at offset
    STR  R1, [R0], #4       ;#Store a 4byte at offset
    STR  R1, [R0], #4       ;#Store a 4byte at offset
    STR  R1, [R0], #4       ;#Store a 4byte at offset
    STR  R1, [R0], #4       ;#Store a 4byte at offset
    CMP  R0, R3             ;#See if we are done copying
    BLT  MemsetLoopBSS
    MOV  R0, R2             ;# return orig dest address
MemsetDoneBSS:
    BX   LR
.arm

;#*******************************************************************
;# Blockcpy
;# Purpose - Provide a version of memcpy that does not require the
;#    whole C Runtime Library to be pulled into boot code
;# R0 - Destination   (Input)
;# R1 - Source      (Input)
;# R2 - Number of Bytes to Copy (Input)
;#        original destination (internal)
;#*******************************************************************
;#    .global Blockcpy
Blockcpy:
    stmdb   sp!, {r0-r12}   ;# save current regs
    add     R2, R1, R2      ;#-Load address of last word
BlockcpyLoop:
    ldmia   R1!, {r3-r10}   ;#-Load 8 words from source
    stmia   R0!, {r3-r10}   ;#-Store 8 words to dest
    cmp     R1, R2          ;#-Repeat until dest full
    blo     BlockcpyLoop
    ldmia   sp!, {r0-r12}   ;# restore regs
    BX      LR              ;#Return to Caller

;#    .global Blockcpy16
Blockcpy16:
    stmdb   sp!, {r0-r6}    ;# save current regs
    add     R2, R1, R2      ;#-Load address of last word
BlockcpyLoop16:
    ldmia   R1!, {r3-r6}    ;#-Load 4 words from source
    stmia   R0!, {r3-r6}    ;#-Store 4 words to dest
    cmp     R1, R2          ;#-Repeat until dest full
    blo     BlockcpyLoop16
    ldmia   sp!, {r0-r6}    ;# restore regs
    BX      LR              ;#Return to Caller


_set_up_bss_vars:
    STMDB SP!, {r0-r5,r14}

    /* Zero the memory in the .bss section.  */
    mov   a2, #0            /* Second arg: fill value */

    ldr a1, .LC1            /* First arg: start of memory block */
    ldr a3, .LC2
    sub a3, a3, a1          /* Third arg: length of block */


    bl  FUNCTION (MemsetBSS)
    /* Copy the initializer data in the .data section from ROM to RAM.  */
    LDR r0, DATA_START      ;# Pickup data vars start pointer, first arg
    LDR r5, DATA_END        ;# Pickup data vars end pointer
    sub   r2, r5, r0        ;# calc length and place in 3rd
    ldr   r1, DATA_SOURCE   ;# Get the source of the data

    mov fp, #0              /* Null frame pointer */

    bl  FUNCTION (Blockcpy)

    LDMIA   SP!, {r0-r5,r14}
    blx r14
