/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2007-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

#ifndef __CODE_IMAGES_H__
#define __CODE_IMAGES_H__

#include <stdint.h>
#include <stdbool.h>
#include "error_types.h"
#include "rom_types.h"

#define SWAP32(x) ((((x) & 0xff)<<24) | (((x) & 0xff00) << 8) | (((x) & 0xff0000)>>8) | (((x)>>24) & 0xff))

#define VINITHI_SET_LOW_VEC    (1<<0)
#define AARCH32_MODE           (1<<27)

bool recovery_boot(void);

#ifdef CONFIG_TPM	/* RICOH change */
struct image_info {
	uint32_t flash_addr;
	uint32_t dest_addr;
	uint32_t load_size;
};
error_type_t load_code_images(rom_types_e rom_type,
	struct image_info *APinfo, struct image_info *R4info);
error_type_t check_code_images(struct image_info *APinfo, struct image_info *R4info);
error_type_t locate_USB_code_images(struct image_info *APinfo, struct image_info *R4info);
#else /* CONFIG_TPM */
error_type_t load_code_images(rom_types_e rom_type, uint32_t *AP_loaded_code_launch_addr, uint32_t *R4_loaded_code_launch_addr);

error_type_t check_code_images(uint32_t *AP_loaded_code_launch_addr, uint32_t *R4_loaded_code_launch_addr);

error_type_t locate_USB_code_images( uint32_t *AP_loaded_code_launch_addr, uint32_t *R4_loaded_code_launch_addr );
#endif /* CONFIG_TPM */

void launch_code_images( rom_types_e rom_type, board_types_e board_type, uint32_t AP_loaded_code_launch_addr, uint32_t R4_loaded_code_launch_addr );

#endif //ifndef __CODE_IMAGES_H__
