/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2007-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

typedef struct R4_mp_entries_s
{
    uint16_t        chip_id;        // Matches to CIU::CHIP_ID [15:0]
    uint8_t         chip_rev;       // Matches to CIU::CHIP_ID [23:16]
    uint8_t         flags;
    uint32_t        CRC32_val;
    uint32_t        image_offset_address;        
    uint32_t        size;        
} R4_mp_entries_t;

typedef struct R4_multi_package_s
{
    uint32_t        magic_key;
    uint32_t        entries_count;
    R4_mp_entries_t  entries[]; 
} R4_multi_package_t;

#define R4_MP_MAGIC_KEY  (0x54524458)    // "TRDX" in ASCII
#define R4_MP_SI_FLAG    (0x02)
#define R4_MP_FPGA_FLAG  (0x01)
