#ifndef __TPM_TIS_H__
#define __TPM_TIS_H__

#include "tpm_device.h"

struct tis_device {
	struct tpm_device tpm;
	int locality;
	long timeout_a;
	long timeout_b;
	long timeout_c;
	long timeout_d;
};

#define TPM_TIMEOUT_MS			5 /* msec */
#define TIS_SHORT_TIMEOUT_MS		750 /* msec */
#define TIS_LONG_TIMEOUT_MS		2000 /* 2 sec */

/* TPM_ACCESS_x bit fields */
#define TPM_ACCESS_VALID		0x80
#define TPM_ACCESS_ACTIVE_LOCALITY	0x20
#define TPM_ACCESS_REQUEST_PENDING	0x04
#define TPM_ACCESS_REQUEST_USE		0x02

/* TPM_STS_x bit fields */
#define TPM_STS_VALID			0x80
#define TPM_STS_COMMAND_READY		0x40
#define TPM_STS_GO			0x20
#define TPM_STS_DATA_AVAIL		0x10
#define TPM_STS_DATA_EXPECT		0x08

#endif /*__TPM_TIS_H__*/
