#ifndef __TPM_DEVICE_H__
#define __TPM_DEVICE_H__

#include "tpm_api.h"

struct tpm_device {
	void (*remove)(struct tpm_device *tpm, int keep_pmu);
	int  (*open)(struct tpm_device *tpm);
	void (*close)(struct tpm_device *tpm);
	int  (*send)(struct tpm_device *tpm, const void *buf, int size);
	int  (*recv)(struct tpm_device *tpm, void *buf, int size);
	int  (*xfer)(struct tpm_device *tpm, const void *txbuf, int txlen,
		void *rxbuf, int *rxlen);
};

extern struct tpm_device *tpm_alloc_device(tpm_device_type_t type,
	int bus, int cs);
extern void tpm_free_device(struct tpm_device *tpm, int keep_pmu);

extern int tpm_execute(struct tpm_device *tpm,
	const void *command, u32 cmdlen, void *response, u32 *preslen);

#endif /*__TPM_DEVICE_H__*/
