#include <stdint.h>
#include <string.h>
#include "cpu_api.h"
#include "regAddrs.h"
#include "minPrintf.h"
#include "tpm_device.h"

/* GPIO Output Direction Set Register */
#define AP_AP_APB_GPIO_GPIO5_SDR	(AP_AP_APB_GPIO_GPIO5_BASE + 0x1c)
/* GPIO Pin Output Set Register */
#define AP_AP_APB_GPIO_GPIO5_PSR	(AP_AP_APB_GPIO_GPIO5_BASE + 0x08)
/* GPIO Pin Output Clear Register */
#define AP_AP_APB_GPIO_GPIO5_PCR	(AP_AP_APB_GPIO_GPIO5_BASE + 0x0c)

#define out32(reg,val)		*((volatile u32 *)(reg)) = (val)
#define udelay(usec)		cpu_spin_delay(usec)
#define mdelay(msec)		cpu_spin_delay(msec * 1000)

void tpm_device_init(void)
{
	const u32 mask = 1U << 6;	/* GPIOF[6] */

	/* Set GPIOF[6] Direction to output */
	out32(AP_AP_APB_GPIO_GPIO5_SDR, mask);
	/* deassert the TPM reset signal thru GPIOF[6] */
	out32(AP_AP_APB_GPIO_GPIO5_PSR, mask);
	udelay(100);
	out32(AP_AP_APB_GPIO_GPIO5_PCR, mask);
	udelay(10);
	out32(AP_AP_APB_GPIO_GPIO5_PSR, mask);
	udelay(500);
}

extern struct tpm_device *tpm_tis_spi_probe(int bus, int cs);

struct tpm_device *tpm_alloc_device(tpm_device_type_t type, int bus, int cs)
{
	struct tpm_device *tpm = NULL;

	switch (type) {
	case TPM_DEVICE_SPI:
		tpm = tpm_tis_spi_probe(bus, cs);
		if (!tpm) {
			minPrintf("#ERROR:%s(): %s(%d, %d) failed.\n",
				__func__, "tpm_tis_spi_device_probe", bus, cs);
		}
		break;
	case TPM_DEVICE_I2C:
		minPrintf("#ERROR:%s(): %s: unsupported device type.\n",
			__func__, "I2C");
		break;
	default:
		minPrintf("#ERROR:%s(): %d: invalid device type.\n",
			__func__, type);
		break;
	}
	return tpm;
}

void tpm_free_device(struct tpm_device *tpm, int keep_pmu)
{
	tpm->remove(tpm, keep_pmu);
}
