#ifndef __PEGMATITE_SPI_H__
#define __PEGMATITE_SPI_H__

/* SSP Register offsets */
#define SSP_SSCR0	0x00
#define SSP_SSCR1	0x04
#define SSP_SSSR	0x08
#define SSP_SSITR	0x0c
#define SSP_SSDR	0x10
#define SSP_SSTO	0x28
#define SSP_SSPSP	0x2c
#define SSP_SSTSA	0x30
#define SSP_SSRSA	0x34
#define SSP_SSTSS	0x38
#define SSP_SSACD	0x3c
#define SSP_SSACDD	0x40

/* SSCR0 bits */
#define SSCR0_DSS_DataSize(x)	(((x) - 1) & 0xf)
#define SSCR0_FRF_Motorola	(0x0U << 4)
#define SSCR0_FRF_TI		(0x1U << 4)
#define SSCR0_FRF_National	(0x2U << 4)
#define SSCR0_SSE		(0x1U << 7)
#define SSCR0_EDSS		(0x1U << 20)
#define SSCR0_RIM		(0x1U << 22)
#define SSCR0_TIM		(0x1U << 23)
#define SSCR0_FRDC(x)		(((x) & 0x7) << 24)
#define SSCR0_FCTRL		(0x1U << 28)
#define SSCR0_MOD		(0x1U << 31)
/* SSCR1 bits */
#define SSCR1_RIE		(0x1U << 0)
#define SSCR1_TIE		(0x1U << 1)
#define SSCR1_LBM		(0x1U << 2)
#define SSCR1_SPO		(0x1U << 3)
#define SSCR1_SPH		(0x1U << 4)
#define SSCR1_MWDS		(0x1U << 5)
#define SSCR1_TFT_TxThresh(x)	((((x) - 1) & 0xf) << 6)
#define SSCR1_RFT_RxThresh(x)	((((x) - 1) & 0xf) << 10)
#define SSCR1_EFWR		(0x1U << 14)
#define SSCR1_STRF		(0x1U << 15)
#define SSCR1_IFS		(0x1U << 16)
#define SSCR1_FEN		(0x1U << 17)
#define SSCR1_PINTE		(0x1U << 18)
#define SSCR1_TINTE		(0x1U << 19)
#define SSCR1_RSRE		(0x1U << 20)
#define SSCR1_TSRE		(0x1U << 21)
#define SSCR1_TRAIL		(0x1U << 22)
#define SSCR1_RWOT		(0x1U << 23)
#define SSCR1_SFRMDIR		(0x1U << 24)
#define SSCR1_SCLKDIR		(0x1U << 25)
#define SSCR1_ECRB		(0x1U << 26)
#define SSCR1_ECRA		(0x1U << 27)
#define SSCR1_SCFR		(0x1U << 28)
#define SSCR1_EBCEI		(0x1U << 29)
#define SSCR1_TTE		(0x1U << 30)
#define SSCR1_TTELP		(0x1U << 31)
/* SSSR bits */
#define SSSR_OSS		(0x1U << 31)
#define SSSR_TX_OSS		(0x1U << 30)
#define SSSR_BCE		(0x1U << 23)
#define SSSR_CSS		(0x1U << 22)
#define SSSR_TUR		(0x1U << 21)
#define SSSR_EOC		(0x1U << 20)
#define SSSR_TINT		(0x1U << 19)
#define SSSR_PINT		(0x1U << 18)
#define SSSR_RFL(x)		(((x) >> 12) & 0xf)
#define SSSR_TFL(x)		(((x) >> 8) & 0xf)
#define SSSR_ROR		(0x1U << 7)
#define SSSR_RFS		(0x1U << 6)
#define SSSR_TFS		(0x1U << 5)
#define SSSR_BSY		(0x1U << 4)
#define SSSR_RNE		(0x1U << 3)
#define SSSR_TNF		(0x1U << 2)
/* SSSR write 1 to clear bits */
#define SSSR_BITS_W1C		( SSSR_BCE | SSSR_TUR | SSSR_EOC | SSSR_TINT \
				| SSSR_PINT | SSSR_ROR )

#define RX_THRESH_DEFAULT	8
#define TX_THRESH_DEFAULT	8

#endif /*__PEGMATITE_SPI_H__*/
