/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

#ifndef __PMU_INTERNAL_H__
#define __PMU_INTERNAL_H__

#include "minPrintf.h"

#include "UH_PMU_Dividers.h"
#include "UH_PMU_Dividers_Config.h"
#include "UH_PMU_Device.h"

#define ENABLE 		true
#define DISABLE		false

#define APMU_ASSERT     assert
#ifdef DEBUG
#define APMU_PRINTF(...)     minPrintf(__VA_ARGS__)
#else
#define APMU_PRINTF(...)
#endif


#define UTF_spin_delay(x)  cpu_spin_delay(x)
#define APMU_DELAY_US(x)   cpu_spin_delay(x)

typedef enum
{
    apmu_pi_device_core0=0,
    apmu_pi_device_core1=1,
    apmu_pi_device_core2=2,
    apmu_pi_device_core3=3,
    apmu_pi_device_l2,
    apmu_pi_device_other,
    apmu_pi_device_gpu,
} apmu_pi_device_t;

bool apmu_power_island(apmu_pi_device_t device, bool power_on);



#endif // ifndef __PMU_INTERNAL_H__
