/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/
/**
 *
 * \file UH_PMU_Dividers_Config.h
 *
 **/

#ifndef __UH_PMU_DIVIDERS_CONFIG_H
#define __UH_PMU_DIVIDERS_CONFIG_H


#define TURN_ON_CORE_BYPASS_CONFIG                                                                                        \
{                                                                                                                         \
    /* APMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {APMU_DIV_DOMAIN, AP_CPU_CLK_DIV,        CORE_PLL,       1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, DDR_CLK2X_DIV,         DDR_PLL,        1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, DDR_CLK_DIV,           DDR_PLL,        4,         0,        1,         1},                          \
                                                                                                                          \
    /* IPMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {IPMU_DIV_DOMAIN, XCPU_CLK_DIV,          DDR_PLL,        2,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, XIO_CLK_DIV,           DDR_PLL,        3,         0,        1,         1}                           \
}


#define TURN_ON_CONFIG                                                                                                    \
{                                                                                                                         \
    /* MPMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {MPMU_DIV_DOMAIN, MFPI_DEGLITCH_CLK_DIV, REF_CLK,        6,         0,        1,         1},    /* CORE_PLL ??? */    \
    {MPMU_DIV_DOMAIN, HIPWM_CLK_DIV,         HIPS_CORE_CLK,  1,         0,        1,         1},    /* SYSTEM_PLL ??? */  \
                                                                                                                          \
    /* APMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {APMU_DIV_DOMAIN, CPU_DBG_CLK_DIV,       CORE_PLL,       3,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, TPIU_CLK_DIV,          CORE_PLL,       10,        0,        1,         1},                          \
    {APMU_DIV_DOMAIN, AP_BUS_CLK_DIV,        CORE_PLL,       6,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, I2C_CLK1_DIV,          CORE_PLL,       8,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, SSP_CLK1_DIV,          CORE_PLL,       6,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, SMMU_CLK_DIV,          CORE_PLL,       3,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, BCM_CPU_CLK_DIV,       CORE_PLL,       3,         0,        1,         1},                          \
    /* Run the A53s at 400MHz */                                                                                          \
    {APMU_DIV_DOMAIN, AP_CPU_CLK_DIV,        CORE_PLL,       3,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, GPU_BUS_CLK_DIV,       CORE_PLL,       3,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, GPU_CLK_DIV,           CORE_PLL,       2,         0,        1,         1},                          \
    /* Run SDMMC at 100MHz */                                                                                             \
    {APMU_DIV_DOMAIN, SDMMC_CLK_DIV,         CORE_PLL,       6,         1,        1,         1},                          \
    {APMU_DIV_DOMAIN, LCDX_CLK_DIV,          CORE_PLL,       12,        0,        1,         1},                          \
    /* Keep the UARTs on the 25MHz refclk */                                                                              \
    {APMU_DIV_DOMAIN, LAN_MAC_CLK2X_DIV,     SYSTEM_PLL,     1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, LAN_MAC_CLK_DIV,       LAN_RX_CLK_PHY, 1,         0,        1,         1},                          \
    /* DDR at 400MHz */                                                                                                   \
    {APMU_DIV_DOMAIN, DDR_CLK2X_DIV,         DDR_PLL,        1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, DDR_CLK_DIV,           DDR_PLL,        4,         0,        1,         1},                          \
                                                                                                                          \
    /* IPMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {IPMU_DIV_DOMAIN, IPS_BUS_CLK_DIV,       CORE_PLL,       6,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, AUDIO_CLK_PRE_DIV,     SYSTEM_PLL,     15,        1,        1,         1},                          \
    {IPMU_DIV_DOMAIN, AUDIO_CLK_DIV,         SYSTEM_PLL,     59,        0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, ADC_TSEN_CLK_DIV,      SYSTEM_PLL,     20,        0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, FAST_NSS_CLK_DIV,      SYSTEM_PLL,     3,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, NSS_CLK_DIV,           SYSTEM_PLL,     10,        0,        1,         1},                          \
    /* VCF_CLK_DIV??? */                                                                                                  \
    {IPMU_DIV_DOMAIN, XCPU_CLK_DIV,          DDR_PLL,        2,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, XIO_CLK_DIV,           DDR_PLL,        3,         0,        1,         1},                          \
                                                                                                                          \
    /* Set the QSPI/bSPI divider last. This minimizes the time window at which                                            \
     * we run slow before the core PLL is set up. */                                                                      \
    /* Run QSPI at 50MHz */                                                                                               \
    {APMU_DIV_DOMAIN, QSPI_CLK_DIV,          DDR_PLL,        32,         0,        1,         1}                          \
}


#define R4_400_AP_1200_DDR_400_CONFIG                                                                                     \
{                                                                                                                         \
    /* MPMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {MPMU_DIV_DOMAIN, MFPI_DEGLITCH_CLK_DIV, REF_CLK,        6,         0,        1,         1},    /* CORE_PLL ??? */    \
    {MPMU_DIV_DOMAIN, HIPWM_CLK_DIV,         HIPS_CORE_CLK,  1,         0,        1,         1},    /* SYSTEM_PLL ??? */  \
                                                                                                                          \
    /* APMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {APMU_DIV_DOMAIN, CPU_DBG_CLK_DIV,       CORE_PLL,       3,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, TPIU_CLK_DIV,          CORE_PLL,       10,        0,        1,         1},                          \
    {APMU_DIV_DOMAIN, AP_BUS_CLK_DIV,        CORE_PLL,       6,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, I2C_CLK1_DIV,          CORE_PLL,       8,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, SSP_CLK1_DIV,          CORE_PLL,       6,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, SMMU_CLK_DIV,          CORE_PLL,       3,         0,        1,         1},                          \
    /* Run the R4 at 400MHz */                                                                                            \
    {APMU_DIV_DOMAIN, BCM_CPU_CLK_DIV,       CORE_PLL,       3,         0,        1,         1},                          \
    /* Run the A53s at 1200MHz */                                                                                         \
    {APMU_DIV_DOMAIN, AP_CPU_CLK_DIV,        CORE_PLL,       1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, GPU_BUS_CLK_DIV,       CORE_PLL,       3,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, GPU_CLK_DIV,           CORE_PLL,       2,         0,        1,         1},                          \
    /* Run SDMMC at 100MHz */                                                                                             \
    {APMU_DIV_DOMAIN, SDMMC_CLK_DIV,         DDR_PLL,         2,        1,        1,         1},                          \
    {APMU_DIV_DOMAIN, LCDX_CLK_DIV,          CORE_PLL,       12,        0,        1,         1},                          \
    /* Keep the UARTs on the 25MHz refclk */                                                                              \
    {APMU_DIV_DOMAIN, LAN_MAC_CLK2X_DIV,     SYSTEM_PLL,     1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, LAN_MAC_CLK_DIV,       LAN_RX_CLK_PHY, 1,         0,        1,         1},                          \
    /* DDR at 400MHz */                                                                                                   \
    {APMU_DIV_DOMAIN, DDR_CLK2X_DIV,         DDR_PLL,        1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, DDR_CLK_DIV,           DDR_PLL,        4,         0,        1,         1},                          \
                                                                                                                          \
    /* IPMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {IPMU_DIV_DOMAIN, IPS_BUS_CLK_DIV,       CORE_PLL,       6,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, AUDIO_CLK_PRE_DIV,     SYSTEM_PLL,     15,        1,        1,         1},                          \
    {IPMU_DIV_DOMAIN, AUDIO_CLK_DIV,         SYSTEM_PLL,     59,        0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, ADC_TSEN_CLK_DIV,      SYSTEM_PLL,     20,        0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, FAST_NSS_CLK_DIV,      SYSTEM_PLL,     3,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, NSS_CLK_DIV,           SYSTEM_PLL,     10,        0,        1,         1},                          \
    /* VCF_CLK_DIV??? */                                                                                                  \
    {IPMU_DIV_DOMAIN, XCPU_CLK_DIV,          DDR_PLL,        2,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, XIO_CLK_DIV,           DDR_PLL,        3,         0,        1,         1},                          \
                                                                                                                          \
    /* Set the QSPI/bSPI divider last. This minimizes the time window at which                                            \
     * we run slow before the core PLL is set up. */                                                                      \
    /* Run QSPI at 50MHz */                                                                                               \
    {APMU_DIV_DOMAIN, QSPI_CLK_DIV,          DDR_PLL,        32,         0,        1,         1}                          \
}


#define R4_400_AP_800_DDR_400_CONFIG /*RICOH add*/								                                          \
{                                                                                                                         \
    /* MPMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {MPMU_DIV_DOMAIN, MFPI_DEGLITCH_CLK_DIV, REF_CLK,        6,         0,        1,         1},    /* CORE_PLL ??? */    \
    {MPMU_DIV_DOMAIN, HIPWM_CLK_DIV,         HIPS_CORE_CLK,  1,         0,        1,         1},    /* SYSTEM_PLL ??? */  \
                                                                                                                          \
    /* APMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {APMU_DIV_DOMAIN, CPU_DBG_CLK_DIV,       CORE_PLL,       3,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, TPIU_CLK_DIV,          CORE_PLL,       10,        0,        1,         1},                          \
    {APMU_DIV_DOMAIN, AP_BUS_CLK_DIV,        CORE_PLL,       6,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, I2C_CLK1_DIV,          CORE_PLL,       8,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, SSP_CLK1_DIV,          CORE_PLL,       6,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, SMMU_CLK_DIV,          CORE_PLL,       3,         0,        1,         1},                          \
    /* Run the R4 at 400MHz */                                                                                            \
    {APMU_DIV_DOMAIN, BCM_CPU_CLK_DIV,       CORE_PLL,       2,         0,        1,         1},                          \
    /* Run the A53s at 800MHz */                                                                                          \
    {APMU_DIV_DOMAIN, AP_CPU_CLK_DIV,        CORE_PLL,       1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, GPU_BUS_CLK_DIV,       CORE_PLL,       4,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, GPU_CLK_DIV,           CORE_PLL,       4,         0,        1,         1},                          \
    /* Run SDMMC at 200MHz */                                                                                             \
    {APMU_DIV_DOMAIN, SDMMC_CLK_DIV,         DDR_PLL,        4,         1,        1,         1},                          \
    {APMU_DIV_DOMAIN, LCDX_CLK_DIV,          CORE_PLL,       12,        0,        1,         1},                          \
    /* Keep the UARTs on the 25MHz refclk */                                                                              \
    {APMU_DIV_DOMAIN, LAN_MAC_CLK2X_DIV,     SYSTEM_PLL,     1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, LAN_MAC_CLK_DIV,       LAN_RX_CLK_PHY, 1,         0,        1,         1},                          \
    /* DDR at 400MHz */                                                                                                   \
    {APMU_DIV_DOMAIN, DDR_CLK2X_DIV,         DDR_PLL,        1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, DDR_CLK_DIV,           DDR_PLL,        4,         0,        1,         1},                          \
                                                                                                                          \
    /* IPMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {IPMU_DIV_DOMAIN, IPS_BUS_CLK_DIV,       CORE_PLL,       6,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, AUDIO_CLK_PRE_DIV,     SYSTEM_PLL,     15,        1,        1,         1},                          \
    {IPMU_DIV_DOMAIN, AUDIO_CLK_DIV,         SYSTEM_PLL,     59,        0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, ADC_TSEN_CLK_DIV,      SYSTEM_PLL,     20,        0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, FAST_NSS_CLK_DIV,      SYSTEM_PLL,     3,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, NSS_CLK_DIV,           SYSTEM_PLL,     10,        0,        1,         1},                          \
    /* VCF_CLK_DIV??? */                                                                                                  \
    {IPMU_DIV_DOMAIN, XCPU_CLK_DIV,          DDR_PLL,        2,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, XIO_CLK_DIV,           DDR_PLL,        3,         0,        1,         1},                          \
                                                                                                                          \
    /* Set the QSPI/bSPI divider last. This minimizes the time window at which                                            \
     * we run slow before the core PLL is set up. */                                                                      \
    /* Run QSPI at 50MHz */                                                                                               \
    {APMU_DIV_DOMAIN, QSPI_CLK_DIV,          DDR_PLL,        32,         0,        1,         1}                          \
}


#define R4_400_AP_1200_DDR_800_CONFIG /*RICOH add*/								                                          \
{                                                                                                                         \
    /* MPMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {MPMU_DIV_DOMAIN, MFPI_DEGLITCH_CLK_DIV, REF_CLK,        6,         0,        1,         1},                          \
    {MPMU_DIV_DOMAIN, HIPWM_CLK_DIV,         HIPS_CORE_CLK,  1,         0,        1,         1},                          \
                                                                                                                          \
    /* APMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {APMU_DIV_DOMAIN, CPU_DBG_CLK_DIV,       CORE_PLL,       4,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, TPIU_CLK_DIV,          CORE_PLL,       10,        0,        1,         1},                          \
    {APMU_DIV_DOMAIN, AP_BUS_CLK_DIV,        DDR_PLL,        8,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, I2C_CLK1_DIV,          DDR_PLL,        8,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, SSP_CLK1_DIV,          REF_CLK,        22,        0,        1,         1},                          \
    {APMU_DIV_DOMAIN, SSP_CLK2_DIV,          REF_CLK,        10,        0,        1,         1},                          \
    {APMU_DIV_DOMAIN, SSP_CLK3_DIV,          REF_CLK,        10,        0,        1,         1},                          \
    {APMU_DIV_DOMAIN, SMMU_CLK_DIV,          CORE_PLL,       4,         0,        1,         1},                          \
    /* Run the R4 at 400MHz */                                                                                            \
    {APMU_DIV_DOMAIN, BCM_CPU_CLK_DIV,       CORE_PLL,       3,         0,        1,         1},                          \
    /* Run the A53s at 1200MHz */                                                                                         \
    {APMU_DIV_DOMAIN, AP_CPU_CLK_DIV,        CORE_PLL,       1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, GPU_BUS_CLK_DIV,       DDR_PLL,        4,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, GPU_CLK_DIV,           DDR_PLL,        4,         0,        1,         1},                          \
    /* Run SDMMC at 100MHz */                                                                                             \
    {APMU_DIV_DOMAIN, SDMMC_CLK_DIV,         DDR_PLL,        4,         1,        1,         1},                          \
    {APMU_DIV_DOMAIN, LCDX_CLK_DIV,          CORE_PLL,       30,        0,        1,         1},                          \
    /* Keep the UARTs on the 25MHz refclk */                                                                              \
    {APMU_DIV_DOMAIN, LAN_MAC_CLK2X_DIV,     SYSTEM_PLL,     1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, LAN_MAC_CLK_DIV,       LAN_RX_CLK_PHY, 1,         0,        1,         1},                          \
    /* DDR at 400MHz */                                                                                                   \
    {APMU_DIV_DOMAIN, DDR_CLK2X_DIV,         DDR_PLL,        1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, DDR_CLK_DIV,           DDR_PLL,        4,         0,        1,         1},                          \
                                                                                                                          \
    /* IPMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {IPMU_DIV_DOMAIN, IPS_BUS_CLK_DIV,       CORE_PLL,       6,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, AUDIO_CLK_PRE_DIV,     REF_CLK,        18,        1,        1,         1},                          \
    {IPMU_DIV_DOMAIN, AUDIO_CLK_DIV,         SYSTEM_PLL,     1,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, ADC_TSEN_CLK_DIV,      SYSTEM_PLL,     20,        0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, FAST_NSS_CLK_DIV,      SYSTEM_PLL,     3,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, NSS_CLK_DIV,           SYSTEM_PLL,     10,        0,        1,         1},                          \
    /* VCF_CLK_DIV??? */                                                                                                  \
    {IPMU_DIV_DOMAIN, XCPU_CLK_DIV,          DDR_PLL,        3,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, XIO_CLK_DIV,           DDR_PLL,        4,         0,        1,         1},                          \
                                                                                                                          \
    /* Set the QSPI/bSPI divider last. This minimizes the time window at which                                            \
     * we run slow before the core PLL is set up. */                                                                      \
    /* Run QSPI at 50MHz */                                                                                               \
    {APMU_DIV_DOMAIN, QSPI_CLK_DIV,          DDR_PLL,        62,         0,        1,         1}                          \
}


#define TURN_ON_CONFIG_DDR_800_AP_1200                                                                                    \
{                                                                                                                         \
    /* MPMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {MPMU_DIV_DOMAIN, MFPI_DEGLITCH_CLK_DIV, REF_CLK,        6,         0,        1,         1},    /* CORE_PLL ??? */    \
    {MPMU_DIV_DOMAIN, HIPWM_CLK_DIV,         HIPS_CORE_CLK,  1,         0,        1,         1},    /* SYSTEM_PLL ??? */  \
                                                                                                                          \
    /* APMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {APMU_DIV_DOMAIN, CPU_DBG_CLK_DIV,       CORE_PLL,       3,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, TPIU_CLK_DIV,          CORE_PLL,       10,        0,        1,         1},                          \
    {APMU_DIV_DOMAIN, AP_BUS_CLK_DIV,        CORE_PLL,       6,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, I2C_CLK1_DIV,          CORE_PLL,       8,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, SSP_CLK1_DIV,          CORE_PLL,       6,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, SMMU_CLK_DIV,          CORE_PLL,       3,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, BCM_CPU_CLK_DIV,       CORE_PLL,       3,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, AP_CPU_CLK_DIV,        CORE_PLL,       1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, GPU_BUS_CLK_DIV,       CORE_PLL,       3,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, GPU_CLK_DIV,           CORE_PLL,       2,         0,        1,         1},                          \
    /* Run SDMMC at 100MHz */                                                                                             \
    {APMU_DIV_DOMAIN, SDMMC_CLK_DIV,         CORE_PLL,       6,         1,        1,         1},                          \
    {APMU_DIV_DOMAIN, LCDX_CLK_DIV,          CORE_PLL,       12,        0,        1,         1},                          \
    /* Keep the UARTs on the 25MHz refclk */                                                                              \
    {APMU_DIV_DOMAIN, LAN_MAC_CLK2X_DIV,     SYSTEM_PLL,     1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, LAN_MAC_CLK_DIV,       LAN_RX_CLK_PHY, 1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, DDR_CLK2X_DIV,         DDR_PLL,        1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, DDR_CLK_DIV,           DDR_PLL,        4,         0,        1,         1},                          \
                                                                                                                          \
    /* IPMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {IPMU_DIV_DOMAIN, IPS_BUS_CLK_DIV,       CORE_PLL,       6,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, AUDIO_CLK_PRE_DIV,     SYSTEM_PLL,     15,        1,        1,         1},                          \
    {IPMU_DIV_DOMAIN, AUDIO_CLK_DIV,         SYSTEM_PLL,     59,        0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, ADC_TSEN_CLK_DIV,      SYSTEM_PLL,     20,        0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, FAST_NSS_CLK_DIV,      SYSTEM_PLL,     3,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, NSS_CLK_DIV,           SYSTEM_PLL,     10,        0,        1,         1},                          \
    /* VCF_CLK_DIV??? */                                                                                                  \
    {IPMU_DIV_DOMAIN, XCPU_CLK_DIV,          DDR_PLL,        4,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, XIO_CLK_DIV,           DDR_PLL,        6,         0,        1,         1},                          \
                                                                                                                          \
    /* Set the QSPI/bSPI divider last. This minimizes the time window at which                                            \
     * we run slow before the core PLL is set up. */                                                                      \
    /* Run QSPI at 50MHz */                                                                                               \
    {APMU_DIV_DOMAIN, QSPI_CLK_DIV,          CORE_PLL,       32,         0,        1,         1}                          \
}


#define GR2_TOP_CLASS_REF_CONFIG                                                                                          \
{                                                                                                                         \
    /* MPMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {MPMU_DIV_DOMAIN, MFPI_DEGLITCH_CLK_DIV, REF_CLK,        6,         0,        1,         1},    /* CORE_PLL ??? */    \
    {MPMU_DIV_DOMAIN, HIPWM_CLK_DIV,         HIPS_CORE_CLK,  1,         0,        1,         1},    /* SYSTEM_PLL ??? */  \
                                                                                                                          \
    /* APMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {APMU_DIV_DOMAIN, CPU_DBG_CLK_DIV,       CORE_PLL,       3,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, TPIU_CLK_DIV,          CORE_PLL,       10,        0,        1,         1},                          \
    {APMU_DIV_DOMAIN, AP_BUS_CLK_DIV,        CORE_PLL,       6,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, I2C_CLK1_DIV,          CORE_PLL,       8,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, SSP_CLK1_DIV,          CORE_PLL,       6,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, SMMU_CLK_DIV,          CORE_PLL,       3,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, BCM_CPU_CLK_DIV,       CORE_PLL,       3,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, AP_CPU_CLK_DIV,        CORE_PLL,       1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, GPU_BUS_CLK_DIV,       CORE_PLL,       3,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, GPU_CLK_DIV,           CORE_PLL,       2,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, SDMMC_CLK_DIV,         CORE_PLL,       3,         1,        1,         1},                          \
    {APMU_DIV_DOMAIN, LCDX_CLK_DIV,          CORE_PLL,       12,        0,        1,         1},                          \
    {APMU_DIV_DOMAIN, UART0_CLK_DIV,         SYSTEM_PLL,     3,         1,        16276,     1152},                       \
    {APMU_DIV_DOMAIN, UART1_CLK_DIV,         SYSTEM_PLL,     3,         1,        16276,     1152},                       \
    {APMU_DIV_DOMAIN, UART2_CLK_DIV,         SYSTEM_PLL,     3,         1,        16276,     1152},                       \
    {APMU_DIV_DOMAIN, UART3_CLK_DIV,         SYSTEM_PLL,     3,         1,        16276,     1152},                       \
    {APMU_DIV_DOMAIN, LAN_MAC_CLK2X_DIV,     SYSTEM_PLL,     1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, LAN_MAC_CLK_DIV,       LAN_RX_CLK_PHY, 1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, DDR_CLK2X_DIV,         DDR_PLL,        1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, DDR_CLK_DIV,           DDR_PLL,        4,         0,        1,         1},                          \
                                                                                                                          \
    /* IPMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {IPMU_DIV_DOMAIN, IPS_BUS_CLK_DIV,       CORE_PLL,       6,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, AUDIO_CLK_PRE_DIV,     SYSTEM_PLL,     15,        1,        1,         1},                          \
    {IPMU_DIV_DOMAIN, AUDIO_CLK_DIV,         SYSTEM_PLL,     59,        0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, ADC_TSEN_CLK_DIV,      SYSTEM_PLL,     20,        0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, FAST_NSS_CLK_DIV,      SYSTEM_PLL,     3,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, NSS_CLK_DIV,           SYSTEM_PLL,     10,        0,        1,         1},                          \
    /* VCF_CLK_DIV??? */                                                                                                  \
    {IPMU_DIV_DOMAIN, XCPU_CLK_DIV,          DDR_PLL,        4,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, XIO_CLK_DIV,           DDR_PLL,        6,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, LVDS_AFE_REF_CLK_DIV,  SCAN_PLL,       2,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, SCAN_CLK_DIV,          SCAN_PLL,       6,         0,        1,         1},                          \
                                                                                                                          \
    /* Set the QSPI/bSPI divider last. This minimizes the time window at which                                            \
     * we run slow before the core PLL is set up. */                                                                      \
    {APMU_DIV_DOMAIN, QSPI_CLK_DIV,          CORE_PLL,       6,         0,        1,         1}                           \
}

#define TURN_ON_CONFIG_DDR_400_AP_1000                                                                                    \
{                                                                                                                         \
    /* MPMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {MPMU_DIV_DOMAIN, MFPI_DEGLITCH_CLK_DIV, REF_CLK,        6,         0,        1,         1},    /* CORE_PLL ??? */    \
    {MPMU_DIV_DOMAIN, HIPWM_CLK_DIV,         HIPS_CORE_CLK,  1,         0,        1,         1},    /* SYSTEM_PLL ??? */  \
                                                                                                                          \
    /* APMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {APMU_DIV_DOMAIN, CPU_DBG_CLK_DIV,       CORE_PLL,       5,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, TPIU_CLK_DIV,          CORE_PLL,       16,        0,        1,         1},                          \
    {APMU_DIV_DOMAIN, AP_BUS_CLK_DIV,        CORE_PLL,       10,        0,        1,         1},                          \
    {APMU_DIV_DOMAIN, I2C_CLK1_DIV,          CORE_PLL,       10,        0,        1,         1},                          \
    {APMU_DIV_DOMAIN, SSP_CLK1_DIV,          CORE_PLL,       10,        0,        1,         1},                          \
    {APMU_DIV_DOMAIN, BCM_CPU_CLK_DIV,       CORE_PLL,       5,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, AP_CPU_CLK_DIV,        CORE_PLL,       2,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, GPU_BUS_CLK_DIV,       CORE_PLL,       5,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, GPU_CLK_DIV,           CORE_PLL,       4,         0,        1,         1},                          \
    /* Run SDMMC at 200MHz. NOTE: This divider does not exist in RevB, so don't change it. */                             \
    {APMU_DIV_DOMAIN, SDMMC_CLK_DIV,         CORE_PLL,       10,        0,        1,         1},                          \
    {APMU_DIV_DOMAIN, LCDX_CLK_DIV,          CORE_PLL,       20,        0,        1,         1},                          \
    /* Keep the UARTs on the 25MHz refclk */                                                                              \
    {APMU_DIV_DOMAIN, LAN_MAC_CLK2X_DIV,     SYSTEM_PLL,     1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, LAN_MAC_CLK_DIV,       LAN_RX_CLK_PHY, 1,         0,        1,         1},                          \
    /* NOTE: DDRClk2x does not exist in RevB, so don't change it (should be 1) */                                         \
    {APMU_DIV_DOMAIN, DDR_CLK2X_DIV,         DDR_PLL,        1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, DDR_CLK_DIV,           DDR_PLL,        4,         0,        1,         1},                          \
                                                                                                                          \
    /* IPMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {IPMU_DIV_DOMAIN, IPS_BUS_CLK_DIV,       CORE_PLL,       10,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, AUDIO_CLK_PRE_DIV,     SYSTEM_PLL,     15,        1,        1,         1},                          \
    {IPMU_DIV_DOMAIN, AUDIO_CLK_DIV,         SYSTEM_PLL,     59,        0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, ADC_TSEN_CLK_DIV,      SYSTEM_PLL,     20,        0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, FAST_NSS_CLK_DIV,      SYSTEM_PLL,     3,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, NSS_CLK_DIV,           SYSTEM_PLL,     10,        0,        1,         1},                          \
    /* VCF_CLK_DIV??? */                                                                                                  \
    {IPMU_DIV_DOMAIN, XCPU_CLK_DIV,          DDR_PLL,        4,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, XIO_CLK_DIV,           DDR_PLL,        6,         0,        1,         1},                          \
                                                                                                                          \
    /* Set the QSPI/bSPI divider last. This minimizes the time window at which                                            \
     * we run slow before the core PLL is set up. */                                                                      \
    /* Run QSPI at 62.5MHz */                                                                                               \
    {APMU_DIV_DOMAIN, QSPI_CLK_DIV,          CORE_PLL,       32,        0,        1,         1}                           \
}

#define TURN_ON_CONFIG_DDR_600_AP_1000                                                                                    \
{                                                                                                                         \
    /* MPMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {MPMU_DIV_DOMAIN, MFPI_DEGLITCH_CLK_DIV, REF_CLK,        6,         0,        1,         1},    /* CORE_PLL ??? */    \
    {MPMU_DIV_DOMAIN, HIPWM_CLK_DIV,         HIPS_CORE_CLK,  1,         0,        1,         1},    /* SYSTEM_PLL ??? */  \
                                                                                                                          \
    /* APMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {APMU_DIV_DOMAIN, CPU_DBG_CLK_DIV,       CORE_PLL,       5,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, TPIU_CLK_DIV,          CORE_PLL,       16,        0,        1,         1},                          \
    {APMU_DIV_DOMAIN, AP_BUS_CLK_DIV,        CORE_PLL,       10,         0,        1,         1},                         \
    {APMU_DIV_DOMAIN, I2C_CLK1_DIV,          CORE_PLL,       10,         0,        1,         1},                         \
    {APMU_DIV_DOMAIN, SSP_CLK1_DIV,          CORE_PLL,       10,         0,        1,         1},                         \
    {APMU_DIV_DOMAIN, BCM_CPU_CLK_DIV,       CORE_PLL,       5,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, AP_CPU_CLK_DIV,        CORE_PLL,       1,         0,        1,         1},  /* CPU src clk = CORE_PLL/2 */  \
    {APMU_DIV_DOMAIN, GPU_BUS_CLK_DIV,       CORE_PLL,       5,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, GPU_CLK_DIV,           CORE_PLL,       4,         0,        1,         1},                          \
    /* Run SDMMC at 200MHz. NOTE: This divider does not exist in RevB, so don't change it. */                             \
    {APMU_DIV_DOMAIN, SDMMC_CLK_DIV,         CORE_PLL,       10,         0,        1,         1},                         \
    {APMU_DIV_DOMAIN, LCDX_CLK_DIV,          CORE_PLL,       20,        0,        1,         1},                          \
    /* Keep the UARTs on the 25MHz refclk */                                                                              \
    {APMU_DIV_DOMAIN, LAN_MAC_CLK2X_DIV,     SYSTEM_PLL,     1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, LAN_MAC_CLK_DIV,       LAN_RX_CLK_PHY, 1,         0,        1,         1},                          \
    /* NOTE: DDRClk2x does not exist in RevB, so don't change it (should be 1) */                                         \
    {APMU_DIV_DOMAIN, DDR_CLK2X_DIV,         DDR_PLL,        1,         0,        1,         1},                          \
    {APMU_DIV_DOMAIN, DDR_CLK_DIV,           DDR_PLL,        4,         0,        1,         1},                          \
                                                                                                                          \
    /* IPMU Div: */                                                                                                       \
    /* pmu_div_domain, clk_div,              clk_src,        div_value, prediven, fract_num, fract_denom */               \
    {IPMU_DIV_DOMAIN, IPS_BUS_CLK_DIV,       CORE_PLL,       10,         0,        1,         1},                         \
    {IPMU_DIV_DOMAIN, AUDIO_CLK_PRE_DIV,     SYSTEM_PLL,     15,        1,        1,         1},                          \
    {IPMU_DIV_DOMAIN, AUDIO_CLK_DIV,         SYSTEM_PLL,     59,        0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, ADC_TSEN_CLK_DIV,      SYSTEM_PLL,     20,        0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, FAST_NSS_CLK_DIV,      SYSTEM_PLL,     3,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, NSS_CLK_DIV,           SYSTEM_PLL,     10,        0,        1,         1},                          \
    /* VCF_CLK_DIV??? */                                                                                                  \
    {IPMU_DIV_DOMAIN, XCPU_CLK_DIV,          DDR_PLL,        3,         0,        1,         1},                          \
    {IPMU_DIV_DOMAIN, XIO_CLK_DIV,           DDR_PLL,        3,         0,        1,         1},                          \
                                                                                                                          \
    /* Set the QSPI/bSPI divider last. This minimizes the time window at which                                            \
     * we run slow before the core PLL is set up. */                                                                      \
    /* Run QSPI at 62.5MHz */                                                                                               \
    {APMU_DIV_DOMAIN, QSPI_CLK_DIV,          CORE_PLL,       32,         0,        1,         1}                          \
}


#endif  // __UH_PMU_DIVIDERS_CONFIG_H

