/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

/**
 *
 * \brief This header file contains PMU specific defines.
 *
 *  Code is from
 *
 *      //unity/firmware/modules/common/asic/88pa6270/lowpower/lpp_v1_0/os/src/lpp_apmu.h
 *
 *  and modified for UTF.
 *
 **/

#ifndef UH_PMU_DEVICE_H
#define UH_PMU_DEVICE_H

#include "regAddrs.h"
#include "APMU_regheaders.h"
#include "IPMU_regheaders.h"
#include "MPMU_regheaders.h"
#include "MC_regheaders.h"
#include "LAN_regheaders.h"
//#include "UTF_Timers.h"
//#include "UTF_MessageHandler.h"
#include "minPrintf.h"
#include "cpu_api.h"
#include "assert.h"

#ifdef DESTINY_PLATFORM
#define EMULATION
#endif

#ifdef DEBUG
#define PMU_DEVICE_PRINTF(...)    minPrintf(__VA_ARGS__)
#else
#define PMU_DEVICE_PRINTF(...)
#endif

#define PMU_DEVICE_US(x)    cpu_spin_delay(x)

#define PMU_DEVICE_ASSERT(x)      ASSERT(x)
// note power Island are handled in seperat file
typedef enum
{
    APMU_DEVICE_LCD       = 0,// SRAM, Clock, done
    APMU_DEVICE_AP_APB    ,// SRAM, Clock, Done? Note: that AP_APB was turned on with UART, SPI and I2C in simulations
    APMU_DEVICE_UART      ,// clock, done.   Dependent on APMU_DEVICE_AP_APB needed
    APMU_DEVICE_SPI       ,// clock, done.   Dependent on APMU_DEVICE_AP_APB needed
    APMU_DEVICE_SPI2      ,// clock, done.   Dependent on APMU_DEVICE_AP_APB needed
    APMU_DEVICE_SPI3      ,// clock, done.   Dependent on APMU_DEVICE_AP_APB needed
    APMU_DEVICE_I2C       ,// clock, done.   Dependent on APMU_DEVICE_AP_APB needed
    APMU_DEVICE_SATA      ,// SRAM, clock, done.  Dependent on APMU_DEVICE_IO_WRAP needed
    APMU_DEVICE_PCIe_dm2  ,// SRAM, clock, done.  Dependent on APMU_DEVICE_IO_WRAP needed
    APMU_DEVICE_PCIe_dm4  ,// SRAM, clock, done.  Dependent on APMU_DEVICE_IO_WRAP needed
    APMU_DEVICE_SDMMC     ,// SRAM, clock, done.  Dependent on APMU_DEVICE_IO_WRAP needed 
    APMU_DEVICE_NDSMC     ,// SRAM, clock, done.  Dependent on APMU_DEVICE_IO_WRAP needed
    APMU_DEVICE_USB2      ,// SRAM, clock, done.  Dependent on APMU_DEVICE_IO_WRAP needed
    APMU_DEVICE_USB3      ,// SRAM, clock, done.  Dependent on APMU_DEVICE_IO_WRAP needed
    APMU_DEVICE_LAN       ,// SRAM, clock, done.  Dependent on APMU_DEVICE_IO_WRAP needed
    APMU_DEVICE_IO_WRAP   ,// SRAM, Clock, Done.  has multipl dependents need ot check for turn off
    APMU_DEVICE_CDMA      ,
    PMU_DEVICE_SMMU       ,// SRAM, Clock, Done.   Not sure about checks
    IPMU_DEVICE_DEC       ,// Clock, Done,
    IPMU_DEVICE_MVDO      ,// Clock, Done,
    IPMU_DEVICE_IPS_APB   ,// SRAM, Clock, Done.
    IPMU_DEVICE_MC5       ,// SRAM, clock, done
    IPMU_DEVICE_CDMA      ,

}pmu_device_t;


bool pmu_power_device(pmu_device_t device, bool power_on);

#endif // UH_PMU_DEVICE_H

