/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

#ifndef __PLL_INTERNAL_H__
#define __PLL_INTERNAL_H__

#include <stdint.h>
#include "minPrintf.h"
#include "cpu_api.h"
#include "error_types.h"
#include "assert.h"
#include "pll_api.h"
#include "SSPLL3P0G_cfg.h"

#define STATUS 0
#ifdef DEBUG
#define mrvl_msg(x,y,...) minPrintf(__VA_ARGS__)
#else
#define mrvl_msg(x,y, ...) while(0)
#endif
#define mrvl_regread32(addr) (*addr)
#define mrvl_regwrite32(addr, val)  (*addr = val)
#define mrvl_sysAlloc(...) ml_sysAlloc(__VA_ARGS__)
#define mrvl_wait_for_us(...) cpu_spin_delay(__VA_ARGS__)

typedef uint32_t*  addr_p;


// gr2_cfgs.c Declarations
SSPLL3P0G_cfg_p mrvl_index_get_cfg_ptr_SSPLL3P0G( SSPLL3P0G_cfg_entry_t  index );

#endif // ifndef __PLL_INTERNAL_H__
