/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/
//TSMC SSPLL_3P0G PLL Configuration
//Spread Sheet Version:  Rev. 0.2
// Date:	8/9/2013
// REFCLK = 25MHz
// VCO = 2400000000

#include <stdint.h>
#include "pll_internal.h"
#include "SSPLL3P0G_cfg.h"
#include "minPrintf.h"

static const SSPLL3P0G_cfg_t cfg_2400MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN = {

  .RESET = 		0,
  .RESET_PI = 		0,
  .RESET_SSC = 		0,
  .AVDD1815_SEL =	0x1,	//
  .BYPASS_EN = 		0x1,	//
  .PU = 		0x1,	//
  .KVCO = 		0xE,	//
  .ICP = 		0x03,	//Reposit at 2017/01/26
  .VDDM = 		0x1,	//
  .VDDL = 		0x4,	//
  .CTUNE = 		0x1,	//
  .PLL_BW_SEL = 	0x0,	//
  .FBCLK_EXT_SEL =	0x0,	//
  .FBCDLY =		0x0,	//
  .REFDIV = 		0x03,	//Reposit at 2017/01/26
  .FBDIV = 		0x48,	//Reposit at 2017/01/26
  .CLKOUT_SE_GATING_EN =0x0,	//
  .CLKOUT_SOURCE_SEL = 	0x1,	//
  .CLKOUT_SE_DIV_SEL =	0x1,	//
  .CLKOUT_DIFF_EN =	0x0,	//
  .CLKOUT_DIFF_DIV_SEL =0x1,	//
  .PI_EN = 		0x1,	//
  .PI_LOOP_MODE = 	0x1,	//
  .INTPI = 		0x6,	//
  .INTPR = 		0x4,	//
  .CLK_DET_EN =		0x1,	//
  .FD = 		0x4,	//
  .FREQ_OFFSET_EN = 	0x0,	//
  .FREQ_OFFSET = 	0x0000,	//
  .FREQ_OFFSET_MODE_SELECTION =	0x1,	//
  .FREQ_OFFSET_VALID = 	0x0,	//
  .SSC_CLK_EN = 	0x0,	//
  .SSC_MODE = 		0x0,	//
  .SSC_FREQ_DIV = 	0x0,	//
  .SSC_RNGE = 		0x000,	//
  .RESERVE_IN = 	0x0,	//
  .TEST_ANA = 		0x0,	//
  .PLL_LOCK = 		0x0		//
};

//TSMC SSPLL_3P0G PLL Configuration
//Spread Sheet Version:  Rev. 0.2
// Date:	8/9/2013
// REFCLK = 25MHz
// VCO = 3000000000


static const SSPLL3P0G_cfg_t cfg_3000MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN = {
  /*****************************************************************/
  /* 0xd0623000 RST_PREDIV = 0x00000003                            */
  .RESET_PI = 0,					/* RST_PREDIV[18]              */
  .RESET_SSC = 0,					/* RST_PREDIV[17]              */
  .RESET = 0,						/* RST_PREDIV[16]              */
  .REFDIV = 0x3,					/* RST_PREDIV[8:0]             */
  /*****************************************************************/
  /* 0xd0623004 MULT_POSTDIV = 0x005a0001                          */
  .FBDIV = 0x5a,					/* MULT_POSTDIV[24:16]         */
  .CLKOUT_DIFF_DIV_SEL = 0x0,		/* MULT_POSTDIV[10:8]          */
  .CLKOUT_SE_DIV_SEL = 0x1,			/* MULT_POSTDIV[2:0]           */
  /*****************************************************************/
  /* 0xd0623008 KVCO = 0x0000000f                                  */
  .KVCO =  0xf,						/* KVCO[3:0]                   */
  /*****************************************************************/
  /* 0xd062300c MISC = 0x0000306c                                  */
  .PLL_BW_SEL = 0x0,				/* MISC[15]                    */
  .CTUNE = 0x1,						/* MISC[14:13]                 */
  .INTPI = 0x8,						/* MISC[12:9]                  */
  .ICP = 0x3,						/* MISC[8:5]                   */
  .VDDM = 0x1,						/* MISC[4:3]                   */
  .VDDL = 0x4,						/* MISC[2:0]                   */
  /*****************************************************************/
  /* 0xd0623010 FEEDBACK_MODE_DESKEW = 0x00000000                  */
  .FBCDLY = 0x0,					/* FEEDBACK_MODE_DESKEW[22:17] */
  .FBCLK_EXT_SEL = 0x0,				/* FEEDBACK_MODE_DESKEW[16]    */
  /*****************************************************************/
  /* 0xd0623014 OFFSET_MODE = 0x04900005                           */
  .INTPR = 0x4,						/* OFFSET_MODE[26:24]          */
  .FD = 0x4,						/* OFFSET_MODE[23:21]          */
  .PI_LOOP_MODE = 0x1,				/* OFFSET_MODE[20]             */
  .FREQ_OFFSET = 0x0000,			/* OFFSET_MODE[19:3]           */
  .FREQ_OFFSET_MODE_SELECTION = 0x1,/* OFFSET_MODE[2]              */
  .FREQ_OFFSET_VALID = 0x0,			/* OFFSET_MODE[1]              */
  .FREQ_OFFSET_EN = 0x1,			/* OFFSET_MODE[0]              */
  /*****************************************************************/
  /* 0xd0623018 FIXED_MODE_SSC_MODE = 0x000b0006                   */
  .AVDD1815_SEL = 0x1,				/* FIXED_MODE_SSC_MODE[19]     */
  .CLKOUT_SE_GATING_EN = 0x0,		/* FIXED_MODE_SSC_MODE[18]     */
  .PU = 0x1,						/* FIXED_MODE_SSC_MODE[17]     */
  .BYPASS_EN = 0x1,					/* FIXED_MODE_SSC_MODE[16]     */
  .SSC_MODE = 0x0,					/* FIXED_MODE_SSC_MODE[3]      */
  .CLK_DET_EN = 0x1,				/* FIXED_MODE_SSC_MODE[2]      */
  .PI_EN = 0x1,						/* FIXED_MODE_SSC_MODE[1]      */
  .SSC_CLK_EN = 0x0,				/* FIXED_MODE_SSC_MODE[0]      */
  /*****************************************************************/
  /* 0xd062301c SSC_FREQ_SSC_RANGE = 0x00000000                    */
  .SSC_FREQ_DIV = 0x0,				/* SSC_FREQ_SSC_RANGE[31:16]   */
  .SSC_RNGE = 0x000,				/* SSC_FREQ_SSC_RANGE[10:0]    */
  /*****************************************************************/
  /* 0xd0623020 CLK_CTRL_MARVELL_TEST = 0x00010000                 */
  .CLKOUT_DIFF_EN = 0x0,			/* CLK_CTRL_MARVELL_TEST[17]   */
  .CLKOUT_SOURCE_SEL = 0x1,			/* CLK_CTRL_MARVELL_TEST[16]   */
  .RESERVE_IN = 0x0,				/* CLK_CTRL_MARVELL_TEST[11:4] */
  .TEST_ANA = 0x0,					/* CLK_CTRL_MARVELL_TEST[3:0]  */
  /*****************************************************************/
  /* 0xd0623024 LOCK_STATUS = 0x00000000                           */
  .PLL_LOCK = 0x0					/* LOCK_STATUS[0]              */
};

static const SSPLL3P0G_cfg_t cfg_1500MHz_8_25MHz_SSC_30KHz_0_CENTER_OFFSET_0_DOWN = {/* For RICOH's SCANPLL setting */
  /*****************************************************************/
  /* 0xd0623000 RST_PREDIV = 0x00000001                            */
  .RESET_PI = 0,					/* RST_PREDIV[18]              */
  .RESET_SSC = 0,					/* RST_PREDIV[17]              */
  .RESET = 0,						/* RST_PREDIV[16]              */
  .REFDIV = 0x1,					/* RST_PREDIV[8:0]             */
  /*****************************************************************/
  /* 0xd0623004 MULT_POSTDIV = 0x000f0000                          */
  .FBDIV = 0xf,						/* MULT_POSTDIV[24:16]         */
  .CLKOUT_DIFF_DIV_SEL = 0x0,		/* MULT_POSTDIV[10:8]          */
  .CLKOUT_SE_DIV_SEL = 0x0,			/* MULT_POSTDIV[2:0]           */
  /*****************************************************************/
  /* 0xd0623008 KVCO = 0x0000000a                                  */
  .KVCO =  0xa,						/* KVCO[3:0]                   */
  /*****************************************************************/
  /* 0xd062300c MISC = 0x0000acac                                  */
  .PLL_BW_SEL = 0x1,				/* MISC[15]                    */
  .CTUNE = 0x1,						/* MISC[14:13]                 */
  .INTPI = 0x6,						/* MISC[12:9]                  */
  .ICP = 0x5,						/* MISC[8:5]                   */
  .VDDM = 0x1,						/* MISC[4:3]                   */
  .VDDL = 0x4,						/* MISC[2:0]                   */
  /*****************************************************************/
  /* 0xd0623010 FEEDBACK_MODE_DESKEW = 0x00000000                  */
  .FBCDLY = 0x0,					/* FEEDBACK_MODE_DESKEW[22:17] */
  .FBCLK_EXT_SEL = 0x0,				/* FEEDBACK_MODE_DESKEW[16]    */
  /*****************************************************************/
  /* 0xd0623014 OFFSET_MODE = 0x04900004                           */
  .INTPR = 0x4,						/* OFFSET_MODE[26:24]          */
  .FD = 0x4,						/* OFFSET_MODE[23:21]          */
  .PI_LOOP_MODE = 0x1,				/* OFFSET_MODE[20]             */
  .FREQ_OFFSET = 0x0000,			/* OFFSET_MODE[19:3]           */
  .FREQ_OFFSET_MODE_SELECTION = 0x1,/* OFFSET_MODE[2]              */
  .FREQ_OFFSET_VALID = 0x0,			/* OFFSET_MODE[1]              */
  .FREQ_OFFSET_EN = 0x0,			/* OFFSET_MODE[0]              */
  /*****************************************************************/
  /* 0xd0623018 FIXED_MODE_SSC_MODE = 0x000a000f                   */
  .AVDD1815_SEL = 0x1,				/* FIXED_MODE_SSC_MODE[19]     */
  .CLKOUT_SE_GATING_EN = 0x0,		/* FIXED_MODE_SSC_MODE[18]     */
  .PU = 0x1,						/* FIXED_MODE_SSC_MODE[17]     */
  .BYPASS_EN = 0x0,					/* FIXED_MODE_SSC_MODE[16]     */
  .SSC_MODE = 0x1,					/* FIXED_MODE_SSC_MODE[3]      */
  .CLK_DET_EN = 0x1,				/* FIXED_MODE_SSC_MODE[2]      */
  .PI_EN = 0x1,						/* FIXED_MODE_SSC_MODE[1]      */
  .SSC_CLK_EN = 0x1,				/* FIXED_MODE_SSC_MODE[0]      */
  /*****************************************************************/
  /* 0xd062301c SSC_FREQ_SSC_RANGE = 0x186a006b                    */
  .SSC_FREQ_DIV = 0x186a,			/* SSC_FREQ_SSC_RANGE[31:16]   */
  .SSC_RNGE = 0x06b,				/* SSC_FREQ_SSC_RANGE[10:0]    */
  /*****************************************************************/
  /* 0xd0623020 CLK_CTRL_MARVELL_TEST = 0x00010000                 */
  .CLKOUT_DIFF_EN = 0x0,			/* CLK_CTRL_MARVELL_TEST[17]   */
  .CLKOUT_SOURCE_SEL = 0x1,			/* CLK_CTRL_MARVELL_TEST[16]   */
  .RESERVE_IN = 0x0,				/* CLK_CTRL_MARVELL_TEST[11:4] */
  .TEST_ANA = 0x0,					/* CLK_CTRL_MARVELL_TEST[3:0]  */
  /*****************************************************************/
  /* 0xd0623024 LOCK_STATUS = 0x00000000                           */
  .PLL_LOCK = 0x0					/* LOCK_STATUS[0]              */
};

//TSMC SSPLL_3P0G PLL Configuration
//Spread Sheet Version:  Rev. 0.2
// Date:	8/9/2013
// REFCLK = 25MHz
// VCO = 1600000000


static const SSPLL3P0G_cfg_t cfg_1600MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN = {
  .RESET = 		0,
  .RESET_PI = 		0,
  .RESET_SSC = 		0,
  .AVDD1815_SEL = 	0x1,	//
  .BYPASS_EN = 		0x1,	//
  .PU = 		0x1,	//
  .KVCO = 		0xA,	//
  .ICP = 		0x03,	//Reposit at 2017/01/26
  .VDDM = 		0x1,	//
  .VDDL = 		0x4,	//
  .CTUNE = 		0x1,	//
  .PLL_BW_SEL = 	0x0,	//
  .FBCLK_EXT_SEL =	0x0,	//
  .FBCDLY =		0x0,	//
  .REFDIV = 		0x03,	//Reposit at 2017/01/26
  .FBDIV = 		0x30,	//Reposit at 2017/01/26
  .CLKOUT_SE_GATING_EN =0x0,	//
  .CLKOUT_SOURCE_SEL = 	0x1,	//
  .CLKOUT_SE_DIV_SEL =	0x0,	//
  .CLKOUT_DIFF_EN =	0x0,	//
  .CLKOUT_DIFF_DIV_SEL =0x0,	//
  .PI_EN = 		0x1,	//
  .PI_LOOP_MODE = 	0x1,	//
  .INTPI = 		0x5,	//
  .INTPR = 		0x4,	//
  .CLK_DET_EN =		0x1,	//
  .FD = 		0x4,	//
  .FREQ_OFFSET_EN = 	0x0,	//
  .FREQ_OFFSET = 	0x0000,	//
  .FREQ_OFFSET_MODE_SELECTION =	0x1,	//
  .FREQ_OFFSET_VALID = 	0x0,	//
  .SSC_CLK_EN = 	0x0,	//
  .SSC_MODE = 		0x0,	//
  .SSC_FREQ_DIV = 	0x0,	//
  .SSC_RNGE = 		0x0,	//
  .RESERVE_IN = 	0x0,	//
  .TEST_ANA = 		0x0,	//
  .PLL_LOCK = 		0x0		//
};

//TSMC SSPLL_3P0G PLL Configuration
//Spread Sheet Version:  Rev. 0.2
// Date:	8/9/2013
// REFCLK = 25MHz
// VCO = 1600000000
// enable sscg (n.sai 17/02/21)

static const SSPLL3P0G_cfg_t cfg_1600MHz_8_25MHz_SSCON_0KHz_0_CENTER_OFFSET_0_DOWN = {
  .RESET = 		0,
  .RESET_PI = 		0,
  .RESET_SSC = 		0,
  .AVDD1815_SEL = 	0x1,	//
  .BYPASS_EN = 		0x1,	//
  .PU = 		0x1,	//
  .KVCO = 		0xA,	//
  .ICP = 		0x03,	//Reposit at 2017/01/26
  .VDDM = 		0x1,	//
  .VDDL = 		0x4,	//
  .CTUNE = 		0x1,	//
  .PLL_BW_SEL = 	0x0,	//
  .FBCLK_EXT_SEL =	0x0,	//
  .FBCDLY =		0x0,	//
  .REFDIV = 		0x03,	//Reposit at 2017/01/26
  .FBDIV = 		0x30,	//Reposit at 2017/01/26
  .CLKOUT_SE_GATING_EN =0x0,	//
  .CLKOUT_SOURCE_SEL = 	0x1,	//
  .CLKOUT_SE_DIV_SEL =	0x0,	//
  .CLKOUT_DIFF_EN =	0x0,	//
  .CLKOUT_DIFF_DIV_SEL =0x0,	//
  .PI_EN = 		0x1,	//
  .PI_LOOP_MODE = 	0x1,	//
  .INTPI = 		0x5,	//
  .INTPR = 		0x4,	//
  .CLK_DET_EN =		0x1,	//
  .FD = 		0x4,	//
  .FREQ_OFFSET_EN = 	0x0,	//
  .FREQ_OFFSET = 	0x0000,	//
  .FREQ_OFFSET_MODE_SELECTION =	0x1,	//
  .FREQ_OFFSET_VALID = 	0x0,	//
  .SSC_CLK_EN = 	0x0,	// 2017/03/02 TEMP set 0(0x01)
  .SSC_MODE = 		0x0,	// 2017/03/02 TEMP set 0(0x01)
  .SSC_FREQ_DIV = 	0x0,	// 2017/03/02 TEMP set 0(0x1a0b)
  .SSC_RNGE = 		0x0,	// 2017/03/02 TEMP set 0(0x032)
  .RESERVE_IN = 	0x0,	//
  .TEST_ANA = 		0x0,	//
  .PLL_LOCK = 		0x0		//
};

//TSMC SSPLL_3P0G PLL Configuration
// Leveraged from above config
// Date:	8/9/2013
// REFCLK = 25MHz
// VCO = 1600000000


static const SSPLL3P0G_cfg_t cfg_800MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN = {

  .RESET = 		0,
  .RESET_PI = 		0,
  .RESET_SSC = 		0,
  .AVDD1815_SEL = 	0x1,	//
  .BYPASS_EN = 		0x1,	//
  .PU = 		0x1,	//
  .KVCO = 		0xA,	//
  .ICP = 		0x3,	//
  .VDDM = 		0x1,	//
  .VDDL = 		0x4,	//
  .CTUNE = 		0x1,	//
  .PLL_BW_SEL = 	0x0,	//
  .FBCLK_EXT_SEL =	0x0,	//
  .FBCDLY =		0x0,	//
  .REFDIV = 		0x3,	//
  .FBDIV = 		0x30,	//
  .CLKOUT_SE_GATING_EN =0x0,	//
  .CLKOUT_SOURCE_SEL = 	0x1,	//
  .CLKOUT_SE_DIV_SEL =	0x1,	//
  .CLKOUT_DIFF_EN =	0x0,	//
  .CLKOUT_DIFF_DIV_SEL =0x1,	//
  .PI_EN = 		0x1,	//
  .PI_LOOP_MODE = 	0x1,	//
  .INTPI = 		0x5,	//
  .INTPR = 		0x4,	//
  .CLK_DET_EN =		0x1,	//
  .FD = 		0x4,	//
  .FREQ_OFFSET_EN = 	0x0,	//
  .FREQ_OFFSET = 	0x0000,	//
  .FREQ_OFFSET_MODE_SELECTION =	0x1,	//
  .FREQ_OFFSET_VALID = 	0x0,	//
  .SSC_CLK_EN = 	0x0,	//
  .SSC_MODE = 		0x0,	//
  .SSC_FREQ_DIV = 	0x0,	//
  .SSC_RNGE = 		0x000,	//
  .RESERVE_IN = 	0x0,	//
  .TEST_ANA = 		0x0,	//
  .PLL_LOCK = 		0x0		//
};

//TSMC SSPLL_3P0G PLL Configuration
// Leveraged from above config
// Date:	8/9/2013
// REFCLK = 25MHz
// VCO = 1600000000
// enable sscg (n.sai 17/02/21)

static const SSPLL3P0G_cfg_t cfg_800MHz_8_25MHz_SSCON_0KHz_0_CENTER_OFFSET_0_DOWN = {

  .RESET = 		0,
  .RESET_PI = 		0,
  .RESET_SSC = 		0,
  .AVDD1815_SEL = 	0x1,	//
  .BYPASS_EN = 		0x0,	//
  .PU = 		0x1,	//
  .KVCO = 		0xA,	//
  .ICP = 		0x3,	//
  .VDDM = 		0x1,	//
  .VDDL = 		0x4,	//
  .CTUNE = 		0x1,	//
  .PLL_BW_SEL = 	0x0,	//
  .FBCLK_EXT_SEL =	0x0,	//
  .FBCDLY =		0x0,	//
  .REFDIV = 		0x3,	//
  .FBDIV = 		0x30,	//
  .CLKOUT_SE_GATING_EN =0x0,	//
  .CLKOUT_SOURCE_SEL = 	0x1,	//
  .CLKOUT_SE_DIV_SEL =	0x1,	//
  .CLKOUT_DIFF_EN =	0x0,	//
  .CLKOUT_DIFF_DIV_SEL =0x1,	//
  .PI_EN = 		0x1,	//
  .PI_LOOP_MODE = 	0x1,	//
  .INTPI = 		0x5,	//
  .INTPR = 		0x4,	//
  .CLK_DET_EN =		0x1,	//
  .FD = 		0x4,	//
  .FREQ_OFFSET_EN = 	0x0,	//
  .FREQ_OFFSET = 	0x0000,	//
  .FREQ_OFFSET_MODE_SELECTION =	0x1,	//
  .FREQ_OFFSET_VALID = 	0x0,	//
  .SSC_CLK_EN = 	0x1,	//
  .SSC_MODE = 		0x1,	//
  .SSC_FREQ_DIV = 	0x0d05,	//
  .SSC_RNGE = 		0x032,	//
  .RESERVE_IN = 	0x0,	//
  .TEST_ANA = 		0x0,	//
  .PLL_LOCK = 		0x0		//
};

//TSMC SSPLL_3P0G PLL Configuration
//Spread Sheet Version:  Rev. 0.2
// Date:	8/9/2013
// REFCLK = 25MHz
// VCO = 2000000000


static const SSPLL3P0G_cfg_t cfg_2000MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN = {

  .RESET = 		0,
  .RESET_PI = 		0,
  .RESET_SSC = 		0,
  .AVDD1815_SEL = 	0x1,	//
  .BYPASS_EN = 		0x1,	//
  .PU = 		0x1,	//
  .KVCO = 		0xC,	//
  .ICP = 		0x3,	//
  .VDDM = 		0x1,	//
  .VDDL = 		0x4,	//
  .CTUNE = 		0x1,	//
  .PLL_BW_SEL = 	0x0,	//
  .FBCLK_EXT_SEL =	0x0,	//
  .FBCDLY =		0x0,	//
  .REFDIV = 		0x3,	//
  .FBDIV = 		0x3C,	//
  .CLKOUT_SE_GATING_EN =0x0,	//
  .CLKOUT_SOURCE_SEL = 	0x1,	//
  .CLKOUT_SE_DIV_SEL =	0x0,	//
  .CLKOUT_DIFF_EN =	0x0,	//
  .CLKOUT_DIFF_DIV_SEL =0x0,	//
  .PI_EN = 		0x1,	//
  .PI_LOOP_MODE = 	0x1,	//
  .INTPI = 		0x6,	//
  .INTPR = 		0x4,	//
  .CLK_DET_EN =		0x1,	//
  .FD = 		0x4,	//
  .FREQ_OFFSET_EN = 	0x1,	//
  .FREQ_OFFSET = 	0x0000,	//
  .FREQ_OFFSET_MODE_SELECTION =	0x1,	//
  .FREQ_OFFSET_VALID = 	0x0,	//
  .SSC_CLK_EN = 	0x0,	//
  .SSC_MODE = 		0x0,	//
  .SSC_FREQ_DIV = 	0x0,	//
  .SSC_RNGE = 		0x000,	//
  .RESERVE_IN = 	0x0,	//
  .TEST_ANA = 		0x0,	//
  .PLL_LOCK = 		0x0		//
};

//TSMC SSPLL_3P0G PLL Configuration
//Spread Sheet Version:  Rev. 0.2
// Date:	8/9/2013
// REFCLK = 25MHz
// VCO = 2133333333.33333


static const SSPLL3P0G_cfg_t cfg_2133MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN = {

  .RESET = 		0,
  .RESET_PI = 		0,
  .RESET_SSC = 		0,
  .AVDD1815_SEL = 	0x1,	//
  .BYPASS_EN = 		0x1,	//
  .PU = 		0x1,	//
  .KVCO = 		0xC,	//
  .ICP = 		0x3,	//
  .VDDM = 		0x1,	//
  .VDDL = 		0x4,	//
  .CTUNE = 		0x1,	//
  .PLL_BW_SEL = 	0x0,	//
  .FBCLK_EXT_SEL =	0x0,	//
  .FBCDLY =		0x0,	//
  .REFDIV = 		0x3,	//
  .FBDIV = 		0x40,	//
  .CLKOUT_SE_GATING_EN =0x0,	//
  .CLKOUT_SOURCE_SEL = 	0x1,	//
  .CLKOUT_SE_DIV_SEL =	0x0,	//
  .CLKOUT_DIFF_EN =	0x0,	//
  .CLKOUT_DIFF_DIV_SEL =0x0,	//
  .PI_EN = 		0x1,	//
  .PI_LOOP_MODE = 	0x1,	//
  .INTPI = 		0x6,	//
  .INTPR = 		0x4,	//
  .CLK_DET_EN =		0x1,	//
  .FD = 		0x4,	//
  .FREQ_OFFSET_EN = 	0x1,	//
  .FREQ_OFFSET = 	0x0000,	//
  .FREQ_OFFSET_MODE_SELECTION =	0x1,	//
  .FREQ_OFFSET_VALID = 	0x0,	//
  .SSC_CLK_EN = 	0x0,	//
  .SSC_MODE = 		0x0,	//
  .SSC_FREQ_DIV = 	0x0,	//
  .SSC_RNGE = 		0x000,	//
  .RESERVE_IN = 	0x0,	//
  .TEST_ANA = 		0x0,	//
  .PLL_LOCK = 		0x0		//
};

//TSMC SSPLL_3P0G PLL Configuration
//Spread Sheet Version:  Rev. 0.2
// Date:	8/9/2013
// REFCLK = 25MHz
// VCO = 2100000000


static const SSPLL3P0G_cfg_t cfg_2100MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN = {

  .RESET = 		0,
  .RESET_PI = 		0,
  .RESET_SSC = 		0,
  .AVDD1815_SEL = 	0x1,	//
  .BYPASS_EN = 		0x1,	//
  .PU = 		0x1,	//
  .KVCO = 		0xC,	//
  .ICP = 		0x3,	//
  .VDDM = 		0x1,	//
  .VDDL = 		0x4,	//
  .CTUNE = 		0x1,	//
  .PLL_BW_SEL = 	0x0,	//
  .FBCLK_EXT_SEL =	0x0,	//
  .FBCDLY =		0x0,	//
  .REFDIV = 		0x3,	//
  .FBDIV = 		0x3F,	//
  .CLKOUT_SE_GATING_EN =0x0,	//
  .CLKOUT_SOURCE_SEL = 	0x1,	//
  .CLKOUT_SE_DIV_SEL =	0x0,	//
  .CLKOUT_DIFF_EN =	0x0,	//
  .CLKOUT_DIFF_DIV_SEL =0x0,	//
  .PI_EN = 		0x1,	//
  .PI_LOOP_MODE = 	0x1,	//
  .INTPI = 		0x6,	//
  .INTPR = 		0x4,	//
  .CLK_DET_EN =		0x1,	//
  .FD = 		0x4,	//
  .FREQ_OFFSET_EN = 		0x1,	//
  .FREQ_OFFSET = 		0x0000,	//
  .FREQ_OFFSET_MODE_SELECTION =	0x1,	//
  .FREQ_OFFSET_VALID = 		0x0,	//
  .SSC_CLK_EN = 	0x0,	//
  .SSC_MODE = 		0x0,	//
  .SSC_FREQ_DIV = 	0x0,	//
  .SSC_RNGE = 		0x000,	//
  .RESERVE_IN = 	0x0,	//
  .TEST_ANA = 		0x0,	//
  .PLL_LOCK = 		0x0 	//
};

//TSMC SSPLL_3P0G PLL Configuration
// Leveraged from above 2100 configuration
// Date:	8/9/2013
// REFCLK = 25MHz
// VCO = 2100000000


static const SSPLL3P0G_cfg_t cfg_1050MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN = {

  .RESET = 		0,
  .RESET_PI = 		0,
  .RESET_SSC = 		0,
  .AVDD1815_SEL = 	0x1,	//
  .BYPASS_EN = 		0x1,	//
  .PU = 		0x1,	//
  .KVCO = 		0xC,	//
  .ICP = 		0x3,	//
  .VDDM = 		0x1,	//
  .VDDL = 		0x4,	//
  .CTUNE = 		0x1,	//
  .PLL_BW_SEL = 	0x0,	//
  .FBCLK_EXT_SEL =	0x0,	//
  .FBCDLY =		0x0,	//
  .REFDIV = 		0x3,	//
  .FBDIV = 		0x3F,	//
  .CLKOUT_SE_GATING_EN =0x0,	//
  .CLKOUT_SOURCE_SEL = 	0x1,	//
  .CLKOUT_SE_DIV_SEL =	0x1,	//
  .CLKOUT_DIFF_EN =	0x0,	//
  .CLKOUT_DIFF_DIV_SEL =0x1,	//
  .PI_EN = 		0x1,	//
  .PI_LOOP_MODE = 	0x1,	//
  .INTPI = 		0x6,	//
  .INTPR = 		0x4,	//
  .CLK_DET_EN =		0x1,	//
  .FD = 		0x4,	//
  .FREQ_OFFSET_EN = 		0x1,	//
  .FREQ_OFFSET = 		0x0000,	//
  .FREQ_OFFSET_MODE_SELECTION =	0x1,	//
  .FREQ_OFFSET_VALID = 		0x0,	//
  .SSC_CLK_EN = 	0x0,	//
  .SSC_MODE = 		0x0,	//
  .SSC_FREQ_DIV = 	0x0,	//
  .SSC_RNGE = 		0x000,	//
  .RESERVE_IN = 	0x0,	//
  .TEST_ANA = 		0x0,	//
  .PLL_LOCK = 		0x0 	//
};

//TSMC SSPLL_3P0G PLL Configuration
//Spread Sheet Version:  Rev. 0.2
// Date:	8/9/2013
// REFCLK = 25MHz
// VCO = 2500000000


static const SSPLL3P0G_cfg_t cfg_2500MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN = {

  .RESET = 		0,
  .RESET_PI = 		0,
  .RESET_SSC = 		0,
  .AVDD1815_SEL = 	0x1,	//
  .BYPASS_EN = 		0x1,	//
  .PU = 		0x1,	//
  .KVCO = 		0xE,	//
  .ICP = 		0x3,	//
  .VDDM = 		0x1,	//
  .VDDL = 		0x4,	//
  .CTUNE = 		0x1,	//
  .PLL_BW_SEL = 	0x0,	//
  .FBCLK_EXT_SEL =	0x0,	//
  .FBCDLY =		0x0,	//
  .REFDIV = 		0x3,	//
  .FBDIV = 		0x4B,	//
  .CLKOUT_SE_GATING_EN =0x0,	//
  .CLKOUT_SOURCE_SEL = 	0x1,	//
  .CLKOUT_SE_DIV_SEL =	0x0,	//
  .CLKOUT_DIFF_EN =	0x0,	//
  .CLKOUT_DIFF_DIV_SEL =0x0,	//
  .PI_EN = 		0x1,	//
  .PI_LOOP_MODE = 	0x1,	//
  .INTPI = 		0x8,	//
  .INTPR = 		0x4,	//
  .CLK_DET_EN =		0x1,	//
  .FD = 		0x4,	//
  .FREQ_OFFSET_EN = 	0x1,	//
  .FREQ_OFFSET = 	0x0000,	//
  .FREQ_OFFSET_MODE_SELECTION = 0x1,	//
  .FREQ_OFFSET_VALID = 	0x0,	//
  .SSC_CLK_EN = 	0x0,	//
  .SSC_MODE = 		0x0,	//
  .SSC_FREQ_DIV = 	0x0,	//
  .SSC_RNGE = 		0x000,	//
  .RESERVE_IN = 	0x0,	//
  .TEST_ANA = 		0x0,	//
  .PLL_LOCK = 		0x0		//
};

static const SSPLL3P0G_cfg_t cfg_LVDSAFE0_PLL_100MHzRefClk_700MHzOut = {

  .RESET = 		0,
  .RESET_PI = 		0,
  .RESET_SSC = 		0,
  .AVDD1815_SEL =	0x1,	//
  .BYPASS_EN = 		0x1,	//
  .PU = 		0x1,	//
  .KVCO = 		0xF,	//
  .ICP = 		0x5,	//  (PLL_BW_SEL=1, REFCLK/M = 22-26MHz, ICP=x5)
  .VDDM = 		0x1,	//
  .VDDL = 		0x4,	//
  .CTUNE = 		0x1,	//
  .PLL_BW_SEL = 	0x1,	//
  .FBCLK_EXT_SEL =	0x0,	//
  .FBCDLY =		0x0,	//
  .REFDIV = 		0x4,	//
  .FBDIV = 		0x1C,	//   x1C=28
  .CLKOUT_SE_GATING_EN =0x0,	//
  .CLKOUT_SOURCE_SEL = 	0x1,	//   0=Select differential clk out (only option for LVDSAFE)
  .CLKOUT_SE_DIV_SEL =	0x0,	//
  .CLKOUT_DIFF_EN =	0x1,	//
  .CLKOUT_DIFF_DIV_SEL =0x2,	//
  .PI_EN = 		0x0,	//
  .PI_LOOP_MODE = 	0x0,	//
  .INTPI = 		0x6,	//
  .INTPR = 		0x4,	//
  .CLK_DET_EN =		0x1,	//
  .FD = 		0x4,	//
  .FREQ_OFFSET_EN = 	0x0,	//
  .FREQ_OFFSET = 	0x0000,	//
  .FREQ_OFFSET_MODE_SELECTION =	0x1,	//
  .FREQ_OFFSET_VALID = 	0x0,	//
  .SSC_CLK_EN = 	0x0,	//
  .SSC_MODE = 		0x0,	//
  .SSC_FREQ_DIV = 	0x0,	//
  .SSC_RNGE = 		0x000,	//
  .RESERVE_IN = 	0x0,	//
  .TEST_ANA = 		0x0,	//
  .PLL_LOCK = 		0x0		//
};

static const SSPLL3P0G_cfg_t cfg_LVDSAFE1_PLL_100MHzRefClk_700MHzOut = {

  .RESET = 		0,
  .RESET_PI = 		0,
  .RESET_SSC = 		0,
  .AVDD1815_SEL =	0x1,	//
  .BYPASS_EN = 		0x1,	//
  .PU = 		0x1,	//
  .KVCO = 		0xF,	//
  .ICP = 		0x5,	//  (PLL_BW_SEL=1, REFCLK/M = 22-26MHz, ICP=x5)
  .VDDM = 		0x1,	//
  .VDDL = 		0x4,	//
  .CTUNE = 		0x1,	//
  .PLL_BW_SEL = 	0x1,	//
  .FBCLK_EXT_SEL =	0x0,	//
  .FBCDLY =		0x0,	//
  .REFDIV = 		0x4,	//
  .FBDIV = 		0x1C,	//
  .CLKOUT_SE_GATING_EN =0x0,	//
  .CLKOUT_SOURCE_SEL = 	0x1,	//   0=Select differential clk out
  .CLKOUT_SE_DIV_SEL =	0x0,	//
  .CLKOUT_DIFF_EN =	0x1,	//
  .CLKOUT_DIFF_DIV_SEL =0x2,	//
  .PI_EN = 		0x0,	//
  .PI_LOOP_MODE = 	0x0,	//
  .INTPI = 		0x6,	//
  .INTPR = 		0x4,	//
  .CLK_DET_EN =		0x1,	//
  .FD = 		0x4,	//
  .FREQ_OFFSET_EN = 	0x0,	//
  .FREQ_OFFSET = 	0x0000,	//
  .FREQ_OFFSET_MODE_SELECTION =	0x1,	//
  .FREQ_OFFSET_VALID = 	0x0,	//
  .SSC_CLK_EN = 	0x0,	//
  .SSC_MODE = 		0x0,	//
  .SSC_FREQ_DIV = 	0x0,	//
  .SSC_RNGE = 		0x000,	//
  .RESERVE_IN = 	0x0,	//
  .TEST_ANA = 		0x0,	//
  .PLL_LOCK = 		0x0		//
};

//TSMC SSPLL_3P0G PLL Configuration
//Spread Sheet Version:  Rev. 0.2
// Date:	5/1/2014
// REFCLK = 25MHz
// VCO = 1566666666.66667
// CLKOUT = 196608049.833333
// CLKOUTP/N = OFF


static const SSPLL3P0G_cfg_t cfg_1567MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_1549433_UP = {

  .RESET = 	0,
  .RESET_PI = 	0,
  .RESET_SSC = 	0,
  .AVDD1815_SEL =0x1,		//
  .BYPASS_EN = 	0x1,		//
  .PU = 	0x1,		//
  .KVCO = 	0xA,		// 1010
  .ICP = 	0x3,		// 5.25uA, target is 5.4uA
  .VDDM = 	0x1,		//
  .VDDL = 	0x4,		//
  .CTUNE = 	0x1,		//
  .PLL_BW_SEL = 0x0,		// AUTO
  .FBCLK_EXT_SEL =0x0,		//
  .FBCDLY =	0x0,		//
  .REFDIV = 	0x3,		// 3
  .FBDIV = 	0x2F,		//  47
  .CLKOUT_SE_GATING_EN =0x0,	//
  .CLKOUT_SOURCE_SEL = 	0x1,	//
  .CLKOUT_SE_DIV_SEL =	0x3,	//  8
  .CLKOUT_DIFF_EN =	0x0,	//  OFF
  .CLKOUT_DIFF_DIV_SEL =0x3,	// 8
  .PI_EN = 	0x1,		//
  .PI_LOOP_MODE = 	0x1,	//
  .INTPI = 	0x5,		// 0101
  .INTPR = 	0x4,		//  100
  .CLK_DET_EN =	0x1,		//
  .FD = 	0x4,		// 100
  .FREQ_OFFSET_EN = 	0x1,	// ON Direction UP
  .FREQ_OFFSET = 	0x11033,//  1549433Hz, if model correct
  .FREQ_OFFSET_MODE_SELECTION =	0x1,	// CK_DIV64_OUT
  .FREQ_OFFSET_VALID = 	0,	//
  .SSC_CLK_EN = 	0x0,	//  OFF
  .SSC_MODE = 	0x0,		// CENTER
  .SSC_FREQ_DIV = 	0x0,	// 0KHz
  .SSC_RNGE = 	0x000,		//  0%
  .RESERVE_IN = 	0,	//
  .TEST_ANA = 	0,		//
  .PLL_LOCK = 	0		//
};

//TSMC SSPLL_3P0G PLL Configuration
//Spread Sheet Version:  Rev. 0.2
// Date:	5/15/2014
// REFCLK = 25MHz
// VCO = 2666666666.66667
// CLKOUT = 666666666.666667
// CLKOUTP/N = OFF

static const SSPLL3P0G_cfg_t cfg_667MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_UP = {
  .RESET = 	0,
  .RESET_PI = 	0,
  .RESET_SSC = 	0,
  .AVDD1815_SEL = 	0x1,		//
  .BYPASS_EN = 	0x0,	        	//
  .PU = 	0x1,			//
  .KVCO = 	0xF,			// 1111
  .ICP = 	0x3,			// 5.25uA, target is 5.4uA
  .VDDM = 	0x1,			//
  .VDDL = 	0x4,			//
  .CTUNE = 	0x1,			//
  .PLL_BW_SEL = 	0x0,		// AUTO
  .FBCLK_EXT_SEL =	0x0,		//
  .FBCDLY =	0x0,			//
  .REFDIV = 	0x3,			// 3
  .FBDIV = 	0x50,			//  80
  .CLKOUT_SE_GATING_EN =	0x0,	//
  .CLKOUT_SOURCE_SEL = 	0x1,		//
  .CLKOUT_SE_DIV_SEL =	0x2,		//  4
  .CLKOUT_DIFF_EN =	0x0,		//  OFF
  .CLKOUT_DIFF_DIV_SEL =	0x2,	// 4
  .PI_EN = 	0x1,			//
  .PI_LOOP_MODE = 	0x1,		//
  .INTPI = 	0x8,			// 1000
  .INTPR = 	0x4,			//  100
  .CLK_DET_EN =	0x1,			//
  .FD = 	0x4,			// 100
  .FREQ_OFFSET_EN = 	0x0,		// OFF Direction UP
  .FREQ_OFFSET = 	0x0,		//  0Hz
  .FREQ_OFFSET_MODE_SELECTION = 	0x1,	// CK_DIV64_OUT
  .FREQ_OFFSET_VALID = 	0,		//
  .SSC_CLK_EN = 	0x0,		//  OFF
  .SSC_MODE = 	0x0,			// CENTER
  .SSC_FREQ_DIV = 	0x0,		// 0KHz
  .SSC_RNGE = 	0x000,			//  0%
  .RESERVE_IN = 	0,		//
  .TEST_ANA = 	0,			//
  .PLL_LOCK = 	0			//
};

//TSMC SSPLL_3P0G PLL Configuration
//Spread Sheet Version:  Rev. 0.2
// Date:	5/15/2014
// REFCLK = 25MHz
// VCO = 2666666666.66667
// CLKOUT = 333333333.333333
// CLKOUTP/N = OFF

static const SSPLL3P0G_cfg_t cfg_334MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_UP = {
  .RESET = 	0,
  .RESET_PI = 	0,
  .RESET_SSC = 	0,
  .AVDD1815_SEL = 	0x1,		//
  .BYPASS_EN = 	0x0,	        	//
  .PU = 	0x1,			//
  .KVCO = 	0xF,			// 1111
  .ICP = 	0x3,			// 5.25uA, target is 5.4uA
  .VDDM = 	0x1,			//
  .VDDL = 	0x4,			//
  .CTUNE = 	0x1,			//
  .PLL_BW_SEL = 	0x0,		// AUTO
  .FBCLK_EXT_SEL =	0x0,		//
  .FBCDLY =	0x0,			//
  .REFDIV = 	0x3,			// 3
  .FBDIV = 	0x50,			//  80
  .CLKOUT_SE_GATING_EN =	0x0,	//
  .CLKOUT_SOURCE_SEL = 	0x1,		//
  .CLKOUT_SE_DIV_SEL =	0x3,		//  8
  .CLKOUT_DIFF_EN =	0x0,		//  OFF
  .CLKOUT_DIFF_DIV_SEL =	0x3,	// 8
  .PI_EN = 	0x1,			//
  .PI_LOOP_MODE = 	0x1,		//
  .INTPI = 	0x8,			// 1000
  .INTPR = 	0x4,			//  100
  .CLK_DET_EN =	0x1,			//
  .FD = 	0x4,			// 100
  .FREQ_OFFSET_EN = 	0x0,		// OFF Direction UP
  .FREQ_OFFSET = 	0x0,		//  0Hz
  .FREQ_OFFSET_MODE_SELECTION = 	0x1,	// CK_DIV64_OUT
  .FREQ_OFFSET_VALID = 	0,		//
  .SSC_CLK_EN = 	0x0,		//  OFF
  .SSC_MODE = 	0x0,			// CENTER
  .SSC_FREQ_DIV = 	0x0,		// 0KHz
  .SSC_RNGE = 	0x000,			//  0%
  .RESERVE_IN = 	0,		//
  .TEST_ANA = 	0,			//
  .PLL_LOCK = 	0			//
};

//TSMC SSPLL_3P0G PLL Configuration
//Spread Sheet Version:  Manually copied from 666.66MHz
// Date:	10/19/2015
// REFCLK = 25MHz
// VCO = 2666666666.66667
// CLKOUT = 1333333333.33333
// CLKOUTP/N = OFF

static const SSPLL3P0G_cfg_t cfg_1333MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_UP = {
  .RESET = 	0,
  .RESET_PI = 	0,
  .RESET_SSC = 	0,
  .AVDD1815_SEL = 	0x1,		//
  .BYPASS_EN = 	0x0,	        	//
  .PU = 	0x1,			//
  .KVCO = 	0xF,			// 1111
  .ICP = 	0x3,			// 5.25uA, target is 5.4uA
  .VDDM = 	0x1,			//
  .VDDL = 	0x5,			//
  .CTUNE = 	0x1,			//
  .PLL_BW_SEL = 	0x0,		// AUTO
  .FBCLK_EXT_SEL =	0x0,		//
  .FBCDLY =	0x0,			//
  .REFDIV = 	0x3,			// 3
  .FBDIV = 	0x50,			//  80
  .CLKOUT_SE_GATING_EN =	0x0,	//
  .CLKOUT_SOURCE_SEL = 	0x1,		//
  .CLKOUT_SE_DIV_SEL =	0x1,		//  2
  .CLKOUT_DIFF_EN =	0x0,		//  OFF
  .CLKOUT_DIFF_DIV_SEL =	0x2,	// 4
  .PI_EN = 	0x1,			//
  .PI_LOOP_MODE = 	0x1,		//
  .INTPI = 	0x8,			// 1000
  .INTPR = 	0x4,			//  100
  .CLK_DET_EN =	0x1,			//
  .FD = 	0x4,			// 100
  .FREQ_OFFSET_EN = 	0x0,		// OFF Direction UP
  .FREQ_OFFSET = 	0x0,		//  0Hz
  .FREQ_OFFSET_MODE_SELECTION = 	0x1,	// CK_DIV64_OUT
  .FREQ_OFFSET_VALID = 	0,		//
  .SSC_CLK_EN = 	0x0,		//  OFF
  .SSC_MODE = 	0x0,			// CENTER
  .SSC_FREQ_DIV = 	0x0,		// 0KHz
  .SSC_RNGE = 	0x000,			//  0%
  .RESERVE_IN = 	0,		//
  .TEST_ANA = 	0,			//
  .PLL_LOCK = 	0			//
};



/* Note: The entries in this array correspond to enum values in SSPLL3P0G_cfg_entry_t. */
static const SSPLL3P0G_cfg_t *cfgs_array[SSPLL3P0G_NUM_CFGS] =
{
    [SSPLL3P0G_CFG_2400MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN] = &cfg_2400MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN, // Core PLL Config 1200 MHz (post div 2), bypass OK
    [SSPLL3P0G_CFG_2000MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN] = &cfg_2000MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN, // Core PLL Config, bypass OK
    [SSPLL3P0G_CFG_3000MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN] = &cfg_3000MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN, // Scan PLL Config, bypass OK
    [SSPLL3P0G_CFG_2133MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN] = &cfg_2133MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN, // DDR PLL Config 1, bypass OK, but model still gives error
    [SSPLL3P0G_CFG_1600MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN] = &cfg_1600MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN, // DDR PLL Config 2, bypass OK
    [SSPLL3P0G_CFG_1600MHZ_8_25MHZ_SSCON_0KHZ_0_CENTER_OFFSET_0_DOWN] = &cfg_1600MHz_8_25MHz_SSCON_0KHz_0_CENTER_OFFSET_0_DOWN, // DDR PLL Config 2, bypass OK
    [SSPLL3P0G_CFG_2100MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN] = &cfg_2100MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN, // Alt config for DDR PLL (will avoid model errors), bypass OK
    [SSPLL3P0G_CFG_2500MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN] = &cfg_2500MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN, // SysPLL Config, don't use bypass
    [SSPLL3P0G_CFG_LVDSAFE0_PLL_100MHZREFCLK_700MHZOUT] = &cfg_LVDSAFE0_PLL_100MHzRefClk_700MHzOut,
    [SSPLL3P0G_CFG_LVDSAFE1_PLL_100MHZREFCLK_700MHZOUT] = &cfg_LVDSAFE1_PLL_100MHzRefClk_700MHzOut,
    [SSPLL3P0G_CFG_1567MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_1549433_UP] = &cfg_1567MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_1549433_UP, // SiLabs PLL setup
    [SSPLL3P0G_CFG_1500MHZ_8_25MHZ_SSC_30KHZ_0_CENTER_OFFSET_0_DOWN] = &cfg_1500MHz_8_25MHz_SSC_30KHz_0_CENTER_OFFSET_0_DOWN, // For RICOH's SCANPLL setting SSC on
    [SSPLL3P0G_CFG_1333MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_UP] = &cfg_1333MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_UP, 	// DDR PLL Config 8, bypass OK
    [SSPLL3P0G_CFG_1050MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN] = &cfg_1050MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN,     // DDR PLL Config 3 for bring-up, bypass OK
    [SSPLL3P0G_CFG_800MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN] = &cfg_800MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_DOWN,      // DDR PLL Config 4 for bring-up, bypass OK
    [SSPLL3P0G_CFG_800MHZ_8_25MHZ_SSCON_0KHZ_0_CENTER_OFFSET_0_DOWN] = &cfg_800MHz_8_25MHz_SSCON_0KHz_0_CENTER_OFFSET_0_DOWN,      // DDR PLL Config 4 for bring-up, bypass OK
    [SSPLL3P0G_CFG_667MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_UP] = &cfg_667MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_UP,        // DDR PLL Config 5 for bring-up, bypass OK
    [SSPLL3P0G_CFG_334MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_UP] = &cfg_334MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_UP         // DDR PLL Config 6 for bring-up, bypass OK
};


/*
 *----------------------------------------------------------------------
 * function mrvl_index_get_cfg_ptr_SSPLL3P0G()
 *----------------------------------------------------------------------
 *
 * Creates a instance of the SSPLL3P0G_cfg_p structure and returns a pointer
 * of the created instance.
 *
 * Inputs: null
 * Outputs:returns a SSPLL3P0G_cfg_p pointer
 *         returns the requested index, return NULL is out-of-index
 * Usage: my_pll_cfg_ptr = mrvl_get_cfg_ptr_SSPLL3P0G
 *
 */
SSPLL3P0G_cfg_p mrvl_index_get_cfg_ptr_SSPLL3P0G( SSPLL3P0G_cfg_entry_t  index )
{
  /*
   * I could return a void * here to be like the
   * get_isr_chandle_<BLOCK>() and get_regs_chandle() functions.
   * However, this function (and get_regs_chandle_<SUPERBLOCK>()) are
   * the only "get_chandle" funtions that are called in C, so go ahead
   * and type cast it here.
   */

  mrvl_msg(STATUS, "SSPLL3P0G", "index_get: Returning chandle (pointer) for SSPLL3P0G_cfg_t structure index %d\n", index);

  if (index < SSPLL3P0G_NUM_CFGS ) {
    return (SSPLL3P0G_cfg_p) cfgs_array[index];
  } else {
    return NULL;
  }
}

