/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

#ifndef _SSPLL3P0G_CFG_H_
#define _SSPLL3P0G_CFG_H_

#include <stdint.h>

typedef struct SSPLL3P0G_cfg_s
{
  /* random configuration */
  /* PLL Reset & REFDIV */
  uint8_t RESET;
  uint8_t RESET_PI;
  uint8_t RESET_SSC;
  uint8_t REFDIV;
  /* PLL Feedback Multiplier */
  uint16_t FBDIV;
  uint8_t CLKOUT_DIFF_DIV_SEL;
  uint8_t CLKOUT_SE_DIV_SEL;
  /* PLL gain control */
  uint8_t KVCO;
  /* PLL misc control */
  uint8_t PLL_BW_SEL;
  uint8_t CTUNE;
  uint8_t INTPI;
  uint8_t ICP;
  uint8_t VDDM;
  uint8_t VDDL;
  /*  PLL PFD input select and de-skew application */
  uint8_t FBCDLY;
  uint8_t FBCLK_EXT_SEL;
  /* PLL Offset Frequency Control */
  uint8_t INTPR;
  uint8_t FD;
  uint8_t PI_LOOP_MODE;
  uint32_t FREQ_OFFSET;
  uint8_t FREQ_OFFSET_MODE_SELECTION;
  uint8_t FREQ_OFFSET_VALID;
  uint8_t FREQ_OFFSET_EN;
  /* PLL Enable */
  uint8_t AVDD1815_SEL;
  uint8_t CLKOUT_SE_GATING_EN;
  uint8_t PU;
  uint8_t BYPASS_EN;
  uint8_t SSC_MODE;
  uint8_t CLK_DET_EN;
  uint8_t PI_EN;
  uint8_t SSC_CLK_EN;
  /* PLL Modulation Frequency */
  uint16_t SSC_FREQ_DIV;
  uint16_t SSC_RNGE;
  /* PLL Output Clock Control */
  uint8_t CLKOUT_DIFF_EN;
  uint8_t CLKOUT_SOURCE_SEL;
  uint8_t RESERVE_IN;
  uint8_t TEST_ANA;
  /* PLL Lock Status */
  uint8_t PLL_LOCK;
  /* PLL Reserve and Status Out */
  uint8_t PU18_REG;
  uint8_t RESERVE_OUT;
  uint8_t PROGRAM_IN_BYPASS;
} SSPLL3P0G_cfg_t, *SSPLL3P0G_cfg_p;

/* Note: These enum values correspond to entries in cfgs_array[]. */
typedef enum
{
    SSPLL3P0G_CFG_2400MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN=0,
    SSPLL3P0G_CFG_2000MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN,
    SSPLL3P0G_CFG_3000MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN,
    SSPLL3P0G_CFG_2133MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN,
    SSPLL3P0G_CFG_1600MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN,
    SSPLL3P0G_CFG_1600MHZ_8_25MHZ_SSCON_0KHZ_0_CENTER_OFFSET_0_DOWN,
    SSPLL3P0G_CFG_2100MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN,
    SSPLL3P0G_CFG_2500MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN,
    SSPLL3P0G_CFG_LVDSAFE0_PLL_100MHZREFCLK_700MHZOUT,
    SSPLL3P0G_CFG_LVDSAFE1_PLL_100MHZREFCLK_700MHZOUT,
    SSPLL3P0G_CFG_1567MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_1549433_UP,
    SSPLL3P0G_CFG_1500MHZ_8_25MHZ_SSC_30KHZ_0_CENTER_OFFSET_0_DOWN,/*RICOH add for SCANPLL*/
    SSPLL3P0G_CFG_1333MHz_8_25MHz_SSC_0KHz_0_CENTER_OFFSET_0_UP,
    SSPLL3P0G_CFG_1050MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN,
    SSPLL3P0G_CFG_800MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_DOWN,
    SSPLL3P0G_CFG_800MHZ_8_25MHZ_SSCON_0KHZ_0_CENTER_OFFSET_0_DOWN,
    SSPLL3P0G_CFG_667MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_UP,
    SSPLL3P0G_CFG_334MHZ_8_25MHZ_SSC_0KHZ_0_CENTER_OFFSET_0_UP,
    SSPLL3P0G_NUM_CFGS
} SSPLL3P0G_cfg_entry_t;


/*------------------------------------------------------------------------
                        Function Prototypes
------------------------------------------------------------------------*/
SSPLL3P0G_cfg_p mrvl_get_cfg_ptr_SSPLL3P0G();
SSPLL3P0G_cfg_p mrvl_index_get_cfg_ptr_SSPLL3P0G(SSPLL3P0G_cfg_entry_t index);

#endif
