/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

/**
 *
 * \file SSPLL3P0G_api.h
 *
 * \brief This header file implements the SSPLL3P0G API.
 *
 **/

#ifndef SSPLL3P0G_API_H
#define SSPLL3P0G_API_H

#include "SSPLL3P0G_regheaders.h"
#include "SSPLL3P0G_cfg.h"

/*------------------------------------------------------------------------
                        Function Prototypes
------------------------------------------------------------------------*/
uint32_t mrvl_prg_bypass_SSPLL3P0G(SSPLL3P0G_cfg_p cfg,
                                   SSPLL3P0G_REGS_t *regs,
                                   void (*callback)(uint32_t, void *),
                                   void *cb_data);
uint32_t mrvl_prg_SSPLL3P0G(SSPLL3P0G_cfg_p cfg,
                            SSPLL3P0G_REGS_t *regs,
                            void (*callback)(uint32_t, void *),
                            void *cb_data);
uint32_t mrvl_ssc_enable_SSPLL3P0G(SSPLL3P0G_REGS_t *regs,
                                   void (*callback)(uint32_t, void *),
                                   void *cb_data);
uint32_t mrvl_ssc_disable_SSPLL3P0G(SSPLL3P0G_REGS_t *regs,
                                    void (*callback)(uint32_t, void *),
                                    void *cb_data);
uint32_t mrvl_dump_cfg_SSPLL3P0G(SSPLL3P0G_cfg_p cfg);
uint32_t mrvl_query_cfg_SSPLL3P0G(SSPLL3P0G_cfg_p cfg,
                                  SSPLL3P0G_REGS_t *regs,
                                  void (*callback)(uint32_t, void *),
                                  void *cb_data);
uint32_t ricoh_ssc_enable(SSPLL3P0G_REGS_t *regs, void (*callback)(uint32_t, void *), void *cb_data);

#endif // SSPLL3P0G_API_H
