/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

/**
 *
 * \file UTF_PinConfig_TurnOnPCA.h
 *
 * \brief This header file contains UTF Pin config for the GR2 Turn-On
 * PCA.
 *
 **/

#ifndef UTF_PINCONFIG_TURNONPCA_H_
#define UTF_PINCONFIG_TURNONPCA_H_

/* The pin functions are based on the GR2 Turn-on PCA. The pins are grouped
 * per IO group. If the IO group doesn't have any pins to be configured, define it as
 * an empty array (ex. #define SERIAL_1_PIN_CONFIG {} )*/

/* Miscellaneous pins ( LED's, buttons, etc ) */
#define MISC_PIN_CONFIG                                                 \
{                                                                       \
        { IO_PAD72, FUNC_SEL_0 },   /* nPWR LED (GPIO)*/                \
}
#define MISC_PIN_CONFIG_GE2                                             \
{                                                                       \
        { IO_PAD55, FUNC_SEL_0 },   /* nPWR LED (GPIO)*/                \
}

/* SERIAL 1 -> J12, Debug Ser1 */
#define SERIAL_1_PIN_CONFIG                                             \
{                                                                       \
        { IO_PAD6, FUNC_SEL_1 },    /* SER1_RXD */                      \
        { IO_PAD7, FUNC_SEL_1 },    /* SER1_TXD */                      \
}
#define SERIAL_1_PIN_CONFIG_GE2                                         \
{                                                                       \
        { IO_PAD9, FUNC_SEL_1 },    /* SER1_RXD */                      \
        { IO_PAD10, FUNC_SEL_1 },    /* SER1_TXD */                     \
}

#define SERIAL_3_PIN_CONFIG						\
{									\
	{ IO_PAD155, FUNC_SEL_3 },    /* SER3_RXD */			\
	{ IO_PAD154, FUNC_SEL_3 },    /* SER3_TXD */			\
}

#define SERIAL_4_PIN_CONFIG						\
{									\
	{ IO_PAD40, FUNC_SEL_3 },    /* SER4_RXD */			\
	{ IO_PAD41, FUNC_SEL_3 },    /* SER4_TXD */			\
}

/* bSPI */
#define BSPI_PIN_CONFIG                                                 \
{                                                                       \
        { IO_PAD14, FUNC_SEL_1 /* Def */ },     /* bSPi_nCS1 */         \
        { IO_PAD16, FUNC_SEL_1 /* Def */ },     /* bSPi_nWP_IO2 */      \
        { IO_PAD17, FUNC_SEL_1 /* Def */ },     /* bSPi_nHLD_IO3 */     \
        /* These pins are shared with SPi1 */                           \
        { IO_PAD10, FUNC_SEL_1 /* Def */ },     /* bSPi_CLK */          \
        { IO_PAD11, FUNC_SEL_1 /* Def */ },     /* bSPi_MOSI_IO0 */     \
        { IO_PAD12, FUNC_SEL_1 /* Def */ },     /* bSPi_MISO_IO1 */     \
        { IO_PAD13, FUNC_SEL_1 /* Def */ },     /* bSPi_nCS0 */         \
}
#define BSPI_PIN_CONFIG_GE2                                             \
{                                                                       \
        { IO_PAD17, FUNC_SEL_1 /* Def */ },     /* bSPi_nCS1 */         \
        { IO_PAD19, FUNC_SEL_1 /* Def */ },     /* bSPi_nWP_IO2 */      \
        { IO_PAD20, FUNC_SEL_1 /* Def */ },     /* bSPi_nHLD_IO3 */     \
        /* These pins are shared with SPi1 */                           \
        { IO_PAD13, FUNC_SEL_1 /* Def */ },     /* bSPi_CLK */          \
        { IO_PAD14, FUNC_SEL_1 /* Def */ },     /* bSPi_MOSI_IO0 */     \
        { IO_PAD15, FUNC_SEL_1 /* Def */ },     /* bSPi_MISO_IO1 */     \
        { IO_PAD16, FUNC_SEL_1 /* Def */ },     /* bSPi_nCS0 */         \
}

/* SERIAL 2 - ( J25 Debug Ser2, J26 Alt Debug Ser2, or P24 HDR ) */
#define SERIAL_2_PIN_CONFIG                                             \
{                                                                       \
        { IO_PAD193, FUNC_SEL_3 },  /* SER2_RXD */                      \
        { IO_PAD194, FUNC_SEL_3 },  /* SER2_TXD */                      \
}
#define SERIAL_2_PIN_CONFIG_GE2                                         \
{                                                                       \
        { IO_PAD127, FUNC_SEL_1 },  /* SER2_RXD */                      \
        { IO_PAD128, FUNC_SEL_1 },  /* SER2_TXD */                      \
}

/* SD MMC 0 (on board eMMC (U8) or eMMC Header J23) */
#define SD_MMC_0_PIN_CONFIG                                             \
{                                                                       \
        { IO_PAD126, FUNC_SEL_1 },  /* SD_MMC0_CLK */                   \
        { IO_PAD127, FUNC_SEL_1 },  /* SD_MMC0_CMD */                   \
        { IO_PAD128, FUNC_SEL_1 },  /* SD_MMC0_DATA[0] */               \
        { IO_PAD129, FUNC_SEL_1 },  /* SD_MMC0_DATA[1] */               \
        { IO_PAD130, FUNC_SEL_1 },  /* SD_MMC0_DATA[2] */               \
        { IO_PAD131, FUNC_SEL_1 },  /* SD_MMC0_DATA[3] */               \
        { IO_PAD132, FUNC_SEL_1 },  /* SD_MMC0_DATA[4] */               \
        { IO_PAD133, FUNC_SEL_1 },  /* SD_MMC0_DATA[5] */               \
        { IO_PAD134, FUNC_SEL_1 },  /* SD_MMC0_DATA[6] */               \
        { IO_PAD135, FUNC_SEL_1 },  /* SD_MMC0_DATA[7] */               \
        { IO_PAD136, FUNC_SEL_1 },  /* SD_MMC0_nCD */                   \
        { IO_PAD137, FUNC_SEL_1 },  /* SD_MMC0_nWP */                   \
        { IO_PAD138, FUNC_SEL_0 },  /* #SD_MMC0_nPWR (GPIO) */          \
        { IO_PAD139, FUNC_SEL_0 },  /* #SD_MMC0nVDD1P8_SEL (GPIO)*/     \
}
#define SD_MMC_0_PIN_CONFIG_GE2                                         \
{                                                                       \
        { IO_PAD103, FUNC_SEL_1 },  /* SD_MMC0_CLK */                   \
        { IO_PAD104, FUNC_SEL_1 },  /* SD_MMC0_CMD */                   \
        { IO_PAD105, FUNC_SEL_1 },  /* SD_MMC0_DATA[0] */               \
        { IO_PAD106, FUNC_SEL_1 },  /* SD_MMC0_DATA[1] */               \
        { IO_PAD107, FUNC_SEL_1 },  /* SD_MMC0_DATA[2] */               \
        { IO_PAD108, FUNC_SEL_1 },  /* SD_MMC0_DATA[3] */               \
        { IO_PAD109, FUNC_SEL_1 },  /* SD_MMC0_DATA[4] */               \
        { IO_PAD110, FUNC_SEL_1 },  /* SD_MMC0_DATA[5] */               \
        { IO_PAD111, FUNC_SEL_1 },  /* SD_MMC0_DATA[6] */               \
        { IO_PAD112, FUNC_SEL_1 },  /* SD_MMC0_DATA[7] */               \
        { IO_PAD113, FUNC_SEL_1 },  /* SD_MMC0_nCD */                   \
        { IO_PAD114, FUNC_SEL_1 },  /* SD_MMC0_nWP */                   \
        { IO_PAD115, FUNC_SEL_0 },  /* #SD_MMC0_nPWR (GPIO) */          \
        { IO_PAD116, FUNC_SEL_0 },  /* #SD_MMC0nVDD1P8_SEL (GPIO)*/     \
}

/* SD_MMC2_A */
#define SD_MMC2_PIN_CONFIG                                              \
{                                                                       \
        { IO_PAD140, FUNC_SEL_1 },  /* SD_MMC2_CLK */                   \
        { IO_PAD141, FUNC_SEL_1 },  /* SD_MMC2_CMD */                   \
        { IO_PAD142, FUNC_SEL_1 },  /* SD_MMC2_CMD[0] */                \
        { IO_PAD143, FUNC_SEL_1 },  /* SD_MMC2_CMD[1] */                \
        { IO_PAD144, FUNC_SEL_1 },  /* SD_MMC2_CMD[2] */                \
        { IO_PAD145, FUNC_SEL_1 },  /* SD_MMC2_CMD[3] */                \
}
/* SD MMC 1(uSD J16) */
#define SD_MMC_1_PIN_CONFIG_GE2                                         \
{                                                                       \
        { IO_PAD90, FUNC_SEL_2},  /* SD_MMC1_CLK */                     \
		{ IO_PAD91, FUNC_SEL_2},  /* SD_MMC1_CMD */                     \
		{ IO_PAD95, FUNC_SEL_2},  /* SD_MMC1_DATA[0] */                 \
		{ IO_PAD96, FUNC_SEL_2},  /* SD_MMC1_DATA[1] */                 \
		{ IO_PAD97, FUNC_SEL_2},  /* SD_MMC1_DATA[2] */                 \
		{ IO_PAD98, FUNC_SEL_2},  /* SD_MMC1_DATA[3] */                 \
}


/* USB3X0 */
#define USB3X0_PIN_CFG                                                  \
{                                                                       \
        { IO_PAD0, FUNC_SEL_1 },    /* USB3X0_VB_nOC_1P8 */             \
        { IO_PAD2, FUNC_SEL_1 },    /* USB3X0_nPWR_EN */                \
}                                                                       \

/* USB2X1 */
#define USB2X1_PIN_CFG                                                  \
{                                                                       \
        { IO_PAD1, FUNC_SEL_1 },    /* USB2X1_VB_nOC_1P8 */             \
        { IO_PAD3, FUNC_SEL_1 },    /* USB2X1_nPWR_EN */                \
}

/* USB2H2 */
#define USB2H2_PIN_CFG                                                  \
{                                                                       \
        { IO_PAD4, FUNC_SEL_1 },    /* USB2H2_nOC */                    \
        { IO_PAD5, FUNC_SEL_1 },    /* USB2H2_nPWR_EN */                \
}

/* I2C1 - EEPROM and Power rails chip (U38)*/
#define I2C1_PIN_CFG                                                    \
{                                                                       \
        { IO_PAD8, FUNC_SEL_1 },    /* I2C1_SCLK */                     \
        { IO_PAD9, FUNC_SEL_1 },    /* I2C1_SDA */                      \
}

/* I2C1 - EEPROM and Power rails chip (U46)*/
#define I2C1_PIN_CFG_GE2                                                \
{                                                                       \
        { IO_PAD11, FUNC_SEL_1 },    /* I2C1_SCLK */                    \
        { IO_PAD12, FUNC_SEL_1 },    /* I2C1_SDA */                     \
}

/* I2C2 - EEPROM and Power rails chip */
#define I2C2_PIN_CFG                                                    \
{                                                                       \
        { IO_PAD16, FUNC_SEL_2 },    /* I2C2_SDA  */                    \
        { IO_PAD17, FUNC_SEL_2 },    /* I2C2_SCLK*/                     \
}

/* SPi1 */
#define SPI_1_PIN_CFG                                                   \
{                                                                       \
        { IO_PAD15, FUNC_SEL_2 },   /* SPi1_nCS */                      \
        /* These SPi1 pins are shared with bSPI. */                     \
        { IO_PAD10, FUNC_SEL_2 },   /* SPi1_CLK */                      \
        { IO_PAD11, FUNC_SEL_2 },   /* SPi1_MOSI */                     \
        { IO_PAD12, FUNC_SEL_2 },   /* SPi1_MISO */                     \
}

/* PCIe */
#define PEX_PIN_CFG                                                     \
{                                                                       \
        /* These pins are shared with SATA LEDs. */                     \
        { IO_PAD18, FUNC_SEL_1  },   /* PEX_nCLKREQ[0] */               \
        { IO_PAD19, FUNC_SEL_1  },   /* PEX_nCLKREQ[1] */               \
}

/* SATA */
#define SATA_PIN_CFG                                                    \
{                                                                       \
        /* These pins are shared with PCIe */                           \
        { IO_PAD18, FUNC_SEL_2  },   /* SATA_ST_ACTIVE_LED */           \
        { IO_PAD19, FUNC_SEL_2  },   /* SATA_PHY_RDY_LED */             \
}

/* Ethernet */
#define ENET_PIN_CFG                                                    \
{                                                                       \
        { IO_PAD20, FUNC_SEL_1  },   /* ENET_RX_CLK */                  \
        { IO_PAD21, FUNC_SEL_1  },   /* ENET_RX_CTRL */                 \
        { IO_PAD22, FUNC_SEL_1  },   /* ENET_RX_D0 */                   \
        { IO_PAD23, FUNC_SEL_1  },   /* ENET_RX_D1 */                   \
        { IO_PAD24, FUNC_SEL_1  },   /* ENET_RX_D2 */                   \
        { IO_PAD25, FUNC_SEL_1  },   /* ENET_RX_D3 */                   \
        { IO_PAD26, FUNC_SEL_1  },   /* ENET_TX_D0 */                   \
        { IO_PAD27, FUNC_SEL_1  },   /* ENET_TX_D1 */                   \
        { IO_PAD28, FUNC_SEL_1  },   /* ENET_TX_D2 */                   \
        { IO_PAD29, FUNC_SEL_1  },   /* ENET_TX_D3 */                   \
        { IO_PAD30, FUNC_SEL_1  },   /* ENET_TX_CTRL */                 \
        { IO_PAD31, FUNC_SEL_1  },   /* ENET_TX_CLK */                  \
        { IO_PAD32, FUNC_SEL_1  },   /* ENET_MDC */                     \
        { IO_PAD33, FUNC_SEL_1  },   /* ENET_MDIO */                    \
        { IO_PAD34, FUNC_SEL_0  },   /* nLanPhyReset (GPIO) */          \
        { IO_PAD35, FUNC_SEL_1  },   /* ENET_25MHZ_CLK */               \
};

/* DCMTR2_A */
#define DCMTR_2_PIN_CFG                                                 \
{                                                                       \
        { IO_PAD36, FUNC_SEL_1  },   /* DCMTR2_P[0] */                  \
        { IO_PAD37, FUNC_SEL_1  },   /* DCMTR2_P[1] */                  \
        { IO_PAD38, FUNC_SEL_1  },   /* DCMTR2_P[2] */                  \
        { IO_PAD39, FUNC_SEL_1  },   /* DCMTR2_P[3] */                  \
        { IO_PAD40, FUNC_SEL_1  },   /* DCMTR2_P[4] */                  \
        { IO_PAD41, FUNC_SEL_1  },   /* DCMTR2_P[5] */                  \
}

/* DCMTR3_A */
#define DCMTR_3_PIN_CFG                                                 \
{                                                                       \
        { IO_PAD42, FUNC_SEL_1  },   /* DCMTR3_P[0] */                  \
        { IO_PAD43, FUNC_SEL_1  },   /* DCMTR3_P[1] */                  \
        { IO_PAD44, FUNC_SEL_1  },   /* DCMTR3_P[2] */                  \
        { IO_PAD45, FUNC_SEL_1  },   /* DCMTR3_P[3] */                  \
        { IO_PAD46, FUNC_SEL_1  },   /* DCMTR3_P[4] */                  \
        { IO_PAD47, FUNC_SEL_1  },   /* DCMTR3_P[5] */                  \
}

/* DCMTR4_A */
#define DCMTR_4_PIN_CFG                                                 \
{                                                                       \
        { IO_PAD48, FUNC_SEL_1  },   /* DCMTR4_P[0] */                  \
        { IO_PAD49, FUNC_SEL_1  },   /* DCMTR4_P[1] */                  \
        { IO_PAD50, FUNC_SEL_1  },   /* DCMTR4_P[2] */                  \
        { IO_PAD51, FUNC_SEL_1  },   /* DCMTR4_P[3] */                  \
        { IO_PAD52, FUNC_SEL_1  },   /* DCMTR4_P[4] */                  \
        { IO_PAD53, FUNC_SEL_1  },   /* DCMTR4_P[5] */                  \
}

/* DCMTR5_A */
#define DCMTR_5_PIN_CFG                                                 \
{                                                                       \
        { IO_PAD54, FUNC_SEL_1  },   /* DCMTR5_P[0] */                  \
        { IO_PAD55, FUNC_SEL_1  },   /* DCMTR5_P[1] */                  \
        { IO_PAD56, FUNC_SEL_1  },   /* DCMTR5_P[2] */                  \
        { IO_PAD57, FUNC_SEL_1  },   /* DCMTR5_P[3] */                  \
        { IO_PAD58, FUNC_SEL_1  },   /* DCMTR5_P[4] */                  \
        { IO_PAD59, FUNC_SEL_1  },   /* DCMTR5_P[5] */                  \
}

/* DCMTR6_A */
#define DCMTR_6_PIN_CFG                                                 \
{                                                                       \
        { IO_PAD60, FUNC_SEL_1  },   /* DCMTR6_P[0] */                  \
        { IO_PAD61, FUNC_SEL_1  },   /* DCMTR6_P[1] */                  \
        { IO_PAD62, FUNC_SEL_1  },   /* DCMTR6_P[2] */                  \
        { IO_PAD63, FUNC_SEL_1  },   /* DCMTR6_P[3] */                  \
}

/* Fuser, P7 */
#define FUSER_PIN_CFG                                                   \
{                                                                       \
        { IO_PAD64, FUNC_SEL_1  },   /* Fuser_Ctrl[0] */                \
        { IO_PAD65, FUNC_SEL_1  },   /* Fuser_Ctrl[1] */                \
        { IO_PAD66, FUNC_SEL_1  },   /* Fuser_Ctrl[2] */                \
        { IO_PAD67, FUNC_SEL_1  },   /* Fuser_Ctrl[3] */                \
        { IO_PAD73, FUNC_SEL_1  },   /* FuserOverTemp */                \
        /* These pins are shared with GPIO */                           \
        { IO_PAD72, FUNC_SEL_1  },   /* ZeroCrossingDetect */           \
}

/* HSync (P12 or distributed to P8, P9, P10, P11) */
#define HSYNC_PIN_CFG                                                   \
{                                                                       \
        { IO_PAD68, FUNC_SEL_1  },   /* LS_nHsync[0] */                 \
        { IO_PAD69, FUNC_SEL_1  },   /* LS_nHsync[1] */                 \
        { IO_PAD70, FUNC_SEL_1  },   /* LS_nHsync[2] */                 \
        { IO_PAD71, FUNC_SEL_1  },   /* LS_nHsync[3] */                 \
}

/* LS */
#define LS_PIN_CFG                                                      \
{                                                                       \
        { IO_PAD74, FUNC_SEL_1  },   /* LS_ClkAccP[0] */                \
        { IO_PAD75, FUNC_SEL_1  },   /* LS_StartDecN[0] */              \
        { IO_PAD76, FUNC_SEL_1  },   /* LS_LockDet[0] */                \
        { IO_PAD81, FUNC_SEL_1  },   /* LS_ClkAccP[1] */                \
        { IO_PAD82, FUNC_SEL_1  },   /* LS_StartDecN[1] */              \
        { IO_PAD83, FUNC_SEL_1  },   /* LS_LockDet[1] */                \
}

/* LD (P12, P9, P10) */
#define LD_PIN_CFG                                                      \
{                                                                       \
        { IO_PAD77, FUNC_SEL_1  },   /* LD_Ctrl[0] */                   \
        { IO_PAD78, FUNC_SEL_1  },   /* LD_Ctrl[1] */                   \
        { IO_PAD79, FUNC_SEL_1  },   /* LD_Ctrl[2] */                   \
        { IO_PAD80, FUNC_SEL_1  },   /* LP_DACOUT0 */                   \
        { IO_PAD84, FUNC_SEL_1  },   /* LD_Ctrl[3] */                   \
        { IO_PAD85, FUNC_SEL_1  },   /* LD_Ctrl[4] */                   \
        { IO_PAD86, FUNC_SEL_1  },   /* LD_Ctrl[5] */                   \
        { IO_PAD87, FUNC_SEL_1  },   /* LP_DACOUT1 */                   \
        { IO_PAD88, FUNC_SEL_1  },   /* LD_Ctrl[6] */                   \
        { IO_PAD89, FUNC_SEL_1  },   /* LD_Ctrl[7] */                   \
        /* These pins are shared with I2C4 (J19&J27, LCD) */            \
        { IO_PAD90, FUNC_SEL_1  },   /* LD_Ctrl[8] */                   \
        { IO_PAD91, FUNC_SEL_1  },   /* LP_DACOUT2 */                   \
        /* These pins are shared with GPIO (J19, LCD) */                \
        { IO_PAD92, FUNC_SEL_1  },   /* LD_Ctrl[9] */                   \
        { IO_PAD93, FUNC_SEL_1  },   /* LD_Ctrl[10] */                  \
        /* These pins are shared with GPIO (WiFi) */                    \
        { IO_PAD94, FUNC_SEL_1  },   /* LD_Ctrl[11] */                  \
        { IO_PAD95, FUNC_SEL_1  },   /* LP_DACOUT3 */                   \
}

/* I2C4 J19 & J27 LCD */
#define I2C4_PIN_CFG                                                    \
{                                                                       \
    /* These pins are shared with LD (P10) */                           \
    { IO_PAD90, FUNC_SEL_1  },   /* LD_Ctrl[8] */                       \
    { IO_PAD91, FUNC_SEL_1  },   /* LP_DACOUT2 */                       \
}

/* DPWM_A_B */
#define DPWM_PIN_CFG                                                    \
{                                                                       \
        { IO_PAD96, FUNC_SEL_1  },   /* DPWM[8] */                      \
        { IO_PAD97, FUNC_SEL_1  },   /* DPWM[9] */                      \
        { IO_PAD98, FUNC_SEL_1  },   /* DPWM[10] */                     \
        { IO_PAD106, FUNC_SEL_1  },   /* DPWM[4] */                     \
        { IO_PAD107, FUNC_SEL_1  },   /* DPWM[5] */                     \
        { IO_PAD108, FUNC_SEL_1  },   /* DPWM[6] */                     \
        { IO_PAD109, FUNC_SEL_1  },   /* DPWM[7] */                     \
}

/* NAND (U7 or J17) */
#define NAND_PIN_CFG                                                    \
{                                                                       \
        { IO_PAD110, FUNC_SEL_1  },   /* NAND_nCE1 */                   \
        { IO_PAD111, FUNC_SEL_0  },   /* NAND_nWP */                    \
        { IO_PAD112, FUNC_SEL_1  },   /* NAND_nWE */                    \
        { IO_PAD113, FUNC_SEL_1  },   /* NAND_ALE */                    \
        { IO_PAD114, FUNC_SEL_1  },   /* NAND_CLE */                    \
        { IO_PAD115, FUNC_SEL_1  },   /* NAND_nCE0 */                   \
        { IO_PAD116, FUNC_SEL_1  },   /* NAND_nRE */                    \
        { IO_PAD117, FUNC_SEL_1  },   /* NAND_RnB */                    \
        { IO_PAD118, FUNC_SEL_1  },   /* NAND_DATA[0] */                \
        { IO_PAD119, FUNC_SEL_1  },   /* NAND_DATA[1] */                \
        { IO_PAD120, FUNC_SEL_1  },   /* NAND_DATA[2] */                \
        { IO_PAD121, FUNC_SEL_1  },   /* NAND_DATA[3] */                \
        { IO_PAD122, FUNC_SEL_1  },   /* NAND_DATA[4] */                \
        { IO_PAD123, FUNC_SEL_1  },   /* NAND_DATA[5] */                \
        { IO_PAD124, FUNC_SEL_1  },   /* NAND_DATA[6] */                \
        { IO_PAD125, FUNC_SEL_1  },   /* NAND_DATA[7] */                \
}

/* SPi2_A */
#define SPI_2_PIN_CFG                                                   \
{                                                                       \
        { IO_PAD146, FUNC_SEL_1 },    /* SPi2_CLK */                    \
        { IO_PAD147, FUNC_SEL_1 },    /* SPi2_MISO */                   \
        { IO_PAD148, FUNC_SEL_1 },    /* SPi2_MOSI */                   \
        { IO_PAD149, FUNC_SEL_1 },    /* SPi2_nCS */                    \
}

/* SPi3_A (P24 or J27 serLCD )*/
#define SPI_3_PIN_CFG                                                   \
{                                                                       \
        { IO_PAD152, FUNC_SEL_1 },    /* SPi3_CLK */                    \
        { IO_PAD153, FUNC_SEL_1 },    /* SPi3_nCS */                    \
        { IO_PAD154, FUNC_SEL_1 },    /* SPi3_MOSI */                   \
        { IO_PAD155, FUNC_SEL_1 },    /* SPi3_MISO */                   \
}

/* SPi2 ( P22 HDR ) */
#define SPI2_PIN_CFG                                                    \
{                                                                       \
        { IO_PAD156, FUNC_SEL_2 },    /* SPi2_CLK */                    \
        { IO_PAD157, FUNC_SEL_2 },    /* SPi2_nCS */                    \
        { IO_PAD158, FUNC_SEL_2 },    /* SPi2_MISO */                   \
        { IO_PAD159, FUNC_SEL_2 },    /* SPi2_MOSI*/                    \
}

/* SERIAL 4 */
#define SERIAL_4_PIN_CFG                                                \
{                                                                       \
        { IO_PAD160, FUNC_SEL_2 },    /* SER4_RXD */                    \
        { IO_PAD161, FUNC_SEL_2 },    /* SER4_TXD */                    \
}

/* DCMTR0 (P13) */
#define DCMOTOR_0_PIN_CFG                                                \
{                                                                        \
        /* These pins are shared with the Stepper Motor controller 0 */  \
        { IO_PAD162, FUNC_SEL_1 },    /* DCMTR0_P[0] */                  \
        { IO_PAD163, FUNC_SEL_1 },    /* DCMTR0_P[1] */                  \
        { IO_PAD164, FUNC_SEL_1 },    /* DCMTR0_P[2] */                  \
        { IO_PAD165, FUNC_SEL_1 },    /* DCMTR0_P[3] */                  \
        { IO_PAD166, FUNC_SEL_1 },    /* DCMTR0_P[4] */                  \
        { IO_PAD167, FUNC_SEL_1 },    /* DCMTR0_P[5] */                  \
}

/* STMTR 0 (P13) */
#define STMOTOR_0_PIN_CFG                                                \
{                                                                        \
        /* These pins are shared with DCMTR0 */  \
        { IO_PAD162, FUNC_SEL_2 },    /* STMTR0_P[0] */                  \
        { IO_PAD163, FUNC_SEL_2 },    /* STMTR0_P[1] */                  \
        { IO_PAD164, FUNC_SEL_2 },    /* STMTR0_P[2] */                  \
        { IO_PAD165, FUNC_SEL_2 },    /* STMTR0_P[3] */                  \
        { IO_PAD166, FUNC_SEL_2 },    /* STMTR0_P[4] */                  \
        { IO_PAD167, FUNC_SEL_2 },    /* STMTR0_P[5] */                  \
}

/* DCMTR1 (P14) */
#define DCMOTOR_1_PIN_CFG                                                \
{                                                                        \
        /* These pins are shared with STMTR1 */                          \
        { IO_PAD168, FUNC_SEL_1 },    /* DCMTR1_P[0] */                  \
        { IO_PAD169, FUNC_SEL_1 },    /* DCMTR1_P[1] */                  \
        { IO_PAD170, FUNC_SEL_1 },    /* DCMTR1_P[2] */                  \
        { IO_PAD171, FUNC_SEL_1 },    /* DCMTR1_P[3] */                  \
        { IO_PAD172, FUNC_SEL_1 },    /* DCMTR1_P[4] */                  \
        { IO_PAD173, FUNC_SEL_1 },    /* DCMTR1_P[5] */                  \
}

/* STMTR1 (P14) */
#define STMOTOR_1_PIN_CFG                                                \
{                                                                        \
        /* These pins are shared with DCMTR1 */                          \
        { IO_PAD168, FUNC_SEL_2 },    /* STMTR1_P[0] */                  \
        { IO_PAD169, FUNC_SEL_2 },    /* STMTR1_P[1] */                  \
        { IO_PAD170, FUNC_SEL_2 },    /* STMTR1_P[2] */                  \
        { IO_PAD171, FUNC_SEL_2 },    /* STMTR1_P[3] */                  \
        { IO_PAD172, FUNC_SEL_2 },    /* STMTR1_P[4] */                  \
        { IO_PAD173, FUNC_SEL_2 },    /* STMTR1_P[5] */                  \
}

/* SCCP0 (P16, AFE) */
#define SCCP_0_PIN_CFG                                                   \
{                                                                        \
        { IO_PAD174, FUNC_SEL_1 },    /* SCCP0_D[0] */                   \
        { IO_PAD183, FUNC_SEL_1 },    /* SCCP0_D[4] */                   \
        { IO_PAD184, FUNC_SEL_1 },    /* SCCP0_D[1] */                   \
        { IO_PAD185, FUNC_SEL_1 },    /* SCCP0_D[5] */                   \
        { IO_PAD186, FUNC_SEL_1 },    /* SCCP0_D[2] */                   \
        { IO_PAD187, FUNC_SEL_1 },    /* SCCP0_D[3] */                   \
}

/* I2S Audio - P21 */
#define I2S_PIN_CONFIG                                                  \
{                                                                       \
        { IO_PAD189, FUNC_SEL_6 },    /* I2S_MCLK */                    \
        /* Shared with U38, 88PG870D VSEL (GPIO) */                     \
        { IO_PAD188, FUNC_SEL_6 },    /* 32KHzCLKOUT */                 \
        /* Shared with P2, Event_Timers */                              \
        { IO_PAD190, FUNC_SEL_6 },    /* I2S_TXD */                     \
        { IO_PAD191, FUNC_SEL_6 },    /* I2S_SCLK */                    \
        { IO_PAD192, FUNC_SEL_6 },    /* I2S_WS */                      \
}

/* CCD0 */
#define CCD_0_PIN_CFG                                                    \
{                                                                        \
        { IO_PAD175, FUNC_SEL_1 },    /* CCD_Transfer_SP[0] */           \
        { IO_PAD176, FUNC_SEL_1 },    /* CCD_LEDR[0] */                  \
        { IO_PAD177, FUNC_SEL_1 },    /* CCD_BulbGate_LEDG[0] */         \
        { IO_PAD178, FUNC_SEL_1 },    /* CCD_BulbPWM_LEDB[0] */          \
}

/* CCD1 */
#define CCD_1_PIN_CFG                                                    \
{                                                                        \
        { IO_PAD179, FUNC_SEL_1 },    /* CCD_Transfer_SP[1] */           \
        { IO_PAD180, FUNC_SEL_1 },    /* CCD_LEDR[1] */                  \
        { IO_PAD181, FUNC_SEL_1 },    /* CCD_BulbGate_LEDG[1] */         \
        { IO_PAD182, FUNC_SEL_1 },    /* CCD_BulbPWM_LEDB[1] */          \
}

/* Sensor */
#define SENSOR_PIN_CFG                                                      \
{                                                                           \
        { IO_PAD99, FUNC_SEL_1  },   /* Sensor[0] */                        \
        { IO_PAD100, FUNC_SEL_1  },   /* Sensor[1] */                       \
        { IO_PAD101, FUNC_SEL_1  },   /* Sensor[2] */                       \
}

/* Event Timer */
#define EVENT_TIMER_A_PIN_CFG                                               \
{                                                                           \
        /* EVENT_A */                                                       \
        { IO_PAD190, FUNC_SEL_1 },    /* Event_Timer5 */                    \
        { IO_PAD191, FUNC_SEL_1 },    /* Event_Timer6 */                    \
        { IO_PAD192, FUNC_SEL_2 },    /* Event_Timer2 */                    \
}

/* Event Timer B */
#define EVENT_TIMER_B_PIN_CFG                                               \
{                                                                           \
        /* Event_B */                                                       \
        { IO_PAD223, FUNC_SEL_2 },    /* Event_Timer5 */                    \
        { IO_PAD224, FUNC_SEL_2 },    /* Event_Timer6 */                    \
        /* These pins are shared with GPIO (TPS51200, U28) */               \
        { IO_PAD225, FUNC_SEL_2 },    /* Event_Timer7 */                    \
}

/* LCD_A ( LCD, P20 HDR ) */
#define LCD_PIN_CFG                                                         \
{                                                                           \
        { IO_PAD193, FUNC_SEL_2 },    /* LCD_DCLK */                        \
        { IO_PAD194, FUNC_SEL_2 },    /* LCD_HS */                          \
        { IO_PAD195, FUNC_SEL_2 },    /* LCD_VS */                          \
        { IO_PAD196, FUNC_SEL_2 },    /* LCD_VALID */                       \
        { IO_PAD197, FUNC_SEL_2 },    /* LCD_BIAS */                        \
        { IO_PAD198, FUNC_SEL_2 },    /* LCD_DATA[0] */                     \
        { IO_PAD199, FUNC_SEL_2 },    /* LCD_DATA[1] */                     \
        { IO_PAD200, FUNC_SEL_2 },    /* LCD_DATA[2] */                     \
        { IO_PAD201, FUNC_SEL_2 },    /* LCD_DATA[3] */                     \
        { IO_PAD202, FUNC_SEL_2 },    /* LCD_DATA[4] */                     \
        { IO_PAD203, FUNC_SEL_2 },    /* LCD_DATA[5] */                     \
        { IO_PAD204, FUNC_SEL_2 },    /* LCD_DATA[6] */                     \
        { IO_PAD205, FUNC_SEL_2 },    /* LCD_DATA[7] */                     \
        /* These pins are shared with the AFE, P16 */                       \
        { IO_PAD206, FUNC_SEL_2 },    /* LCD_DATA[8] */                     \
        { IO_PAD207, FUNC_SEL_2 },    /* LCD_DATA[9] */                     \
        { IO_PAD208, FUNC_SEL_2 },    /* LCD_DATA[10] */                    \
        { IO_PAD209, FUNC_SEL_2 },    /* LCD_DATA[11] */                    \
        { IO_PAD210, FUNC_SEL_2 },    /* LCD_DATA[12] */                    \
        { IO_PAD211, FUNC_SEL_2 },    /* LCD_DATA[13] */                    \
        { IO_PAD212, FUNC_SEL_2 },    /* LCD_DATA[14] */                    \
        { IO_PAD213, FUNC_SEL_2 },    /* LCD_DATA[15] */                    \
        { IO_PAD214, FUNC_SEL_2 },    /* LCD_DATA[16] */                    \
        { IO_PAD215, FUNC_SEL_2 },    /* LCD_DATA[17] */                    \
        { IO_PAD216, FUNC_SEL_2 },    /* LCD_DATA[18] */                    \
        { IO_PAD217, FUNC_SEL_2 },    /* LCD_DATA[19] */                    \
        /* These pins are shared with the CCD ( CIS_2x8 HDR, P15  ) */      \
        { IO_PAD218, FUNC_SEL_2 },    /* LCD_DATA[20] */                    \
        { IO_PAD219, FUNC_SEL_2 },    /* LCD_DATA[21] */                    \
        { IO_PAD220, FUNC_SEL_2 },    /* LCD_DATA[22] */                    \
        { IO_PAD221, FUNC_SEL_2 },    /* LCD_DATA[23] */                    \
}

/* AFE ( AFE, P16 )*/
#define AFE_PIN_CFG                                                         \
{                                                                           \
        /* These pins are shared with the LCD */                            \
        { IO_PAD206, FUNC_SEL_1 },    /* AFE_DATA[0] */                     \
        { IO_PAD207, FUNC_SEL_1 },    /* AFE_DATA[1] */                     \
        { IO_PAD208, FUNC_SEL_1 },    /* AFE_DATA[2] */                     \
        { IO_PAD209, FUNC_SEL_1 },    /* AFE_DATA[3] */                     \
        { IO_PAD210, FUNC_SEL_1 },    /* AFE_DATA[4] */                     \
        { IO_PAD211, FUNC_SEL_1 },    /* AFE_DATA[5] */                     \
        { IO_PAD212, FUNC_SEL_1 },    /* AFE_DATA[6] */                     \
        { IO_PAD213, FUNC_SEL_1 },    /* AFE_DATA[7] */                     \
        { IO_PAD214, FUNC_SEL_1 },    /* AFE_CDSCLK2_VSMP */                \
        { IO_PAD215, FUNC_SEL_1 },    /* AFE_CDSCLK1_CLMP */                \
        { IO_PAD216, FUNC_SEL_1 },    /* AFE_LCLMP */                       \
        { IO_PAD217, FUNC_SEL_1 },    /* AFE_ADCCLK_MCLK */                 \
}

/* CCD */
#define CCD_PIN_CFG                                                         \
{                                                                           \
        /* These pins are shared with the LCD */                            \
        { IO_PAD218, FUNC_SEL_1 },    /* CCD_RS */                          \
        { IO_PAD219, FUNC_SEL_1 },    /* CCD_ClkPh1_CLK */                  \
        { IO_PAD220, FUNC_SEL_1 },    /* CCD_ClkPh1_CLK */                  \
        { IO_PAD221, FUNC_SEL_1 },    /* CCD_SENSOR_SEL */                  \
        /* These pins are shared with MTONE ( LCD, P20 ) */                 \
        { IO_PAD222, FUNC_SEL_1 },    /* CCD_CLAMP */                       \
}

/* MTONE_B */
#define MTONE_PIN_CFG                                                       \
{                                                                           \
        /* These pins are shared with CCD */                                \
        { IO_PAD222, FUNC_SEL_2 },    /* MTONE */                           \
}

/* VID_LVDS */
#define VID_LVDS                                                            \
{                                                                           \
        { VID_LVDSO_D0, FUNC_SEL_1  },                                      \
        { VID_LVDSO_D1, FUNC_SEL_1  },                                      \
        { VID_LVDSO_D2, FUNC_SEL_1  },                                      \
        { VID_LVDSO_D3, FUNC_SEL_1  },                                      \
        { VID_LVDSO_D4, FUNC_SEL_1  },                                      \
        { VID_LVDSO_D5, FUNC_SEL_1  },                                      \
        { VID_LVDSO_D6, FUNC_SEL_1  },                                      \
        { VID_LVDSO_D7, FUNC_SEL_1  },                                      \
}

/* CLK_OBS_LVDS */
#define CLK_OBS_LVDS                                                        \
{                                                                           \
        { VID_LVDSO_D0, FUNC_SEL_3  },  /* System PLL, P8 11,12 */          \
        { VID_LVDSO_D3, FUNC_SEL_3  },  /* LVDS Safe Clock, 0 P9 13,14 */   \
        { VID_LVDSO_D4, FUNC_SEL_3  },  /* LVDS Safe Clock, 1 P10 11,12 */  \
        { VID_LVDSO_D5, FUNC_SEL_3  },  /* Core PLL, P10 13,14 */           \
        { VID_LVDSO_D6, FUNC_SEL_3  },  /* DDR PLL, P11 11,12 */            \
        { VID_LVDSO_D7, FUNC_SEL_3  },  /* Scan PLL, P11 13,14 */           \
}

/* SCIFO_LVDS */
#define SCIFO_LVDS                                                          \
{                                                                           \
        { SCIF0_LVDSO_CLK, FUNC_SEL_1  },                                   \
        { SCIF0_LVDSI_CLK, FUNC_SEL_1  },                                   \
        { SCIF0_LVDSI_D0,  FUNC_SEL_1  },                                   \
        { SCIF0_LVDSI_D1,  FUNC_SEL_1  },                                   \
        { SCIF0_LVDSI_D2,  FUNC_SEL_1  },                                   \
        { SCIF1_LVDSO_CLK, FUNC_SEL_1  },                                   \
        { SCIF1_LVDSI_CLK, FUNC_SEL_1  },                                   \
        { SCIF1_LVDSI_D0,  FUNC_SEL_1  },                                   \
        { SCIF1_LVDSI_D1,  FUNC_SEL_1  },                                   \
        { SCIF1_LVDSI_D2,  FUNC_SEL_1  },                                   \
}

#endif /* UTF_PINCONFIG_TURNONPCA_H_ */


