/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

/**
 *
 * \file UTF_PinConfig.h
 *
 * \brief This header file contains UTF Pin Config routines
 *
 **/

#ifndef UTF_PINCONFIG_H_
#define UTF_PINCONFIG_H_

#include "board_types.h"
#include "UTF_PinConfig_TurnOnPCA.h"

typedef enum
{
    IO_PAD0,    /* GPIOA[0] */
    IO_PAD1,    /* GPIOA[1] */
    IO_PAD2,    /* GPIOA[2] */
    IO_PAD3,    /* GPIOA[3] */
    IO_PAD4,    /* GPIOA[4] */
    IO_PAD5,    /* GPIOA[5] */
    IO_PAD6,    /* GPIOA[6] */
    IO_PAD7,    /* GPIOA[7] */
    IO_PAD8,    /* GPIOA[8] */
    IO_PAD9,    /* GPIOA[9] */
    IO_PAD10,    /* GPIOA[10] */
    IO_PAD11,    /* GPIOA[11] */
    IO_PAD12,    /* GPIOA[12] */
    IO_PAD13,    /* GPIOA[13] */
    IO_PAD14,    /* GPIOA[14] */
    IO_PAD15,    /* GPIOA[15] */
    IO_PAD16,    /* GPIOA[16] */
    IO_PAD17,    /* GPIOA[17] */
    IO_PAD18,    /* GPIOA[18] */
    IO_PAD19,    /* GPIOA[19] */
    IO_PAD20,    /* GPIOA[20] */
    IO_PAD21,    /* GPIOA[21] */
    IO_PAD22,    /* GPIOA[22] */
    IO_PAD23,    /* GPIOA[23] */
    IO_PAD24,    /* GPIOA[24] */
    IO_PAD25,    /* GPIOA[25] */
    IO_PAD26,    /* GPIOA[26] */
    IO_PAD27,    /* GPIOA[27] */
    IO_PAD28,    /* GPIOA[28] */
    IO_PAD29,    /* GPIOA[29] */
    IO_PAD30,    /* GPIOA[30] */
    IO_PAD31,    /* GPIOA[31] */
    IO_PAD32,    /* GPIOB[0] */
    IO_PAD33,    /* GPIOB[1] */
    IO_PAD34,    /* GPIOB[2] */
    IO_PAD35,    /* GPIOB[3] */
    IO_PAD36,    /* GPIOB[4] */
    IO_PAD37,    /* GPIOB[5] */
    IO_PAD38,    /* GPIOB[6] */
    IO_PAD39,    /* GPIOB[7] */
    IO_PAD40,    /* GPIOB[8] */
    IO_PAD41,    /* GPIOB[9] */
    IO_PAD42,    /* GPIOB[10] */
    IO_PAD43,    /* GPIOB[11] */
    IO_PAD44,    /* GPIOB[12] */
    IO_PAD45,    /* GPIOB[13] */
    IO_PAD46,    /* GPIOB[14] */
    IO_PAD47,    /* GPIOB[15] */
    IO_PAD48,    /* GPIOB[16] */
    IO_PAD49,    /* GPIOB[17] */
    IO_PAD50,    /* GPIOB[18] */
    IO_PAD51,    /* GPIOB[19] */
    IO_PAD52,    /* GPIOB[20] */
    IO_PAD53,    /* GPIOB[21] */
    IO_PAD54,    /* GPIOB[22] */
    IO_PAD55,    /* GPIOB[23] */
    IO_PAD56,    /* GPIOB[24] */
    IO_PAD57,    /* GPIOB[25] */
    IO_PAD58,    /* GPIOB[26] */
    IO_PAD59,    /* GPIOB[27] */
    IO_PAD60,    /* GPIOB[28] */
    IO_PAD61,    /* GPIOB[29] */
    IO_PAD62,    /* GPIOB[30] */
    IO_PAD63,    /* GPIOB[31] */
    IO_PAD64,    /* GPI_C[0] */
    IO_PAD65,    /* GPI_C[1] */
    IO_PAD66,    /* GPI_C[2] */
    IO_PAD67,    /* GPI_C[3] */
    IO_PAD68,    /* GPIOC[4] */
    IO_PAD69,    /* GPIOC[5] */
    IO_PAD70,    /* GPIOC[6] */
    IO_PAD71,    /* GPIOC[7] */
    IO_PAD72,    /* GPIOC[8] */
    IO_PAD73,    /* GPIOC[9] */
    IO_PAD74,    /* GPIOC[10] */
    IO_PAD75,    /* GPIOC[11] */
    IO_PAD76,    /* GPIOC[12] */
    IO_PAD77,    /* GPIOC[13] */
    IO_PAD78,    /* GPIOC[14] */
    IO_PAD79,    /* GPIOC[15] */
    IO_PAD80,    /* GPIOC[16] */
    IO_PAD81,    /* GPIOC[17] */
    IO_PAD82,    /* GPIOC[18] */
    IO_PAD83,    /* GPIOC[19] */
    IO_PAD84,    /* GPIOC[20] */
    IO_PAD85,    /* GPIOC[21] */
    IO_PAD86,    /* GPIOC[22] */
    IO_PAD87,    /* GPIOC[23] */
    IO_PAD88,    /* GPIOC[24] */
    IO_PAD89,    /* GPIOC[25] */
    IO_PAD90,    /* GPIOC[26] */
    IO_PAD91,    /* GPIOC[27] */
    IO_PAD92,    /* GPIOC[28] */
    IO_PAD93,    /* GPIOC[29] */
    IO_PAD94,    /* GPIOC[30] */
    IO_PAD95,    /* GPIOC[31] */
    IO_PAD96,    /* GPIOD[0] */
    IO_PAD97,    /* GPIOD[1] */
    IO_PAD98,    /* GPIOD[2] */
    IO_PAD99,    /* GPIOD[3] */
    IO_PAD100,    /* GPIOD[4] */
    IO_PAD101,    /* GPIOD[5] */
    IO_PAD102,    /* GPIOD[6] */
    IO_PAD103,    /* GPIOD[7] */
    IO_PAD104,    /* GPIOD[8] */
    IO_PAD105,    /* GPIOD[9] */
    IO_PAD106,    /* GPIOD[10] */
    IO_PAD107,    /* GPIOD[11] */
    IO_PAD108,    /* GPIOD[12] */
    IO_PAD109,    /* GPIOD[13] */
    IO_PAD110,    /* GPIOD[14] */
    IO_PAD111,    /* GPIOD[15] */
    IO_PAD112,    /* GPIOD[16] */
    IO_PAD113,    /* GPIOD[17] */
    IO_PAD114,    /* GPIOD[18] */
    IO_PAD115,    /* GPIOD[19] */
    IO_PAD116,    /* GPIOD[20] */
    IO_PAD117,    /* GPIOD[21] */
    IO_PAD118,    /* GPIOD[22] */
    IO_PAD119,    /* GPIOD[23] */
    IO_PAD120,    /* GPIOD[24] */
    IO_PAD121,    /* GPIOD[25] */
    IO_PAD122,    /* GPIOD[26] */
    IO_PAD123,    /* GPIOD[27] */
    IO_PAD124,    /* GPIOD[28] */
    IO_PAD125,    /* GPIOD[29] */
    IO_PAD126,    /* GPIOD[30] */
    IO_PAD127,    /* GPIOD[31] */
    IO_PAD128,    /* GPIOE[0] */
    IO_PAD129,    /* GPIOE[1] */
    IO_PAD130,    /* GPIOE[2] */
    IO_PAD131,    /* GPIOE[3] */
    IO_PAD132,    /* GPIOE[4] */
    IO_PAD133,    /* GPIOE[5] */
    IO_PAD134,    /* GPIOE[6] */
    IO_PAD135,    /* GPIOE[7] */
    IO_PAD136,    /* GPIOE[8] */
    IO_PAD137,    /* GPIOE[9] */
    IO_PAD138,    /* GPIOE[10] */
    IO_PAD139,    /* GPIOE[11] */
    IO_PAD140,    /* GPIOE[12] */
    IO_PAD141,    /* GPIOE[13] */
    IO_PAD142,    /* GPIOE[14] */
    IO_PAD143,    /* GPIOE[15] */
    IO_PAD144,    /* GPIOE[16] */
    IO_PAD145,    /* GPIOE[17] */
    IO_PAD146,    /* GPIOE[18] */
    IO_PAD147,    /* GPIOE[19] */
    IO_PAD148,    /* GPIOE[20] */
    IO_PAD149,    /* GPIOE[21] */
    IO_PAD150,    /* GPIOE[22] */
    IO_PAD151,    /* GPIOE[23] */
    IO_PAD152,    /* GPIOE[24] */
    IO_PAD153,    /* GPIOE[25] */
    IO_PAD154,    /* GPIOE[26] */
    IO_PAD155,    /* GPIOE[27] */
    IO_PAD156,    /* GPIOE[28] */
    IO_PAD157,    /* GPIOE[29] */
    IO_PAD158,    /* GPIOE[30] */
    IO_PAD159,    /* GPIOE[31] */
    IO_PAD160,    /* GPIOF[0] */
    IO_PAD161,    /* GPIOF[1] */
    IO_PAD162,    /* GPIOF[2] */
    IO_PAD163,    /* GPIOF[3] */
    IO_PAD164,    /* GPIOF[4] */
    IO_PAD165,    /* GPIOF[5] */
    IO_PAD166,    /* GPIOF[6] */
    IO_PAD167,    /* GPIOF[7] */
    IO_PAD168,    /* GPIOF[8] */
    IO_PAD169,    /* GPIOF[9] */
    IO_PAD170,    /* GPIOF[10] */
    IO_PAD171,    /* GPIOF[11] */
    IO_PAD172,    /* GPIOF[12] */
    IO_PAD173,    /* GPIOF[13] */
    IO_PAD174,    /* GPIOF[14] */
    IO_PAD175,    /* GPIOF[15] */
    IO_PAD176,    /* GPIOF[16] */
    IO_PAD177,    /* GPIOF[17] */
    IO_PAD178,    /* GPIOF[18] */
    IO_PAD179,    /* GPIOF[19] */
    IO_PAD180,    /* GPIOF[20] */
    IO_PAD181,    /* GPIOF[21] */
    IO_PAD182,    /* GPIOF[22] */
    IO_PAD183,    /* GPIOF[23] */
    IO_PAD184,    /* GPIOF[24] */
    IO_PAD185,    /* GPIOF[25] */
    IO_PAD186,    /* GPIOF[26] */
    IO_PAD187,    /* GPIOF[27] */
    IO_PAD188,    /* GPIOF[28] */
    IO_PAD189,    /* GPIOF[29] */
    IO_PAD190,    /* GPIOF[30] */
    IO_PAD191,    /* GPIOF[31] */
    IO_PAD192,    /* GPIOG[0] */
    IO_PAD193,    /* GPIOG[1] */
    IO_PAD194,    /* GPIOG[2] */
    IO_PAD195,    /* GPIOG[3] */
    IO_PAD196,    /* GPIOG[4] */
    IO_PAD197,    /* GPIOG[5] */
    IO_PAD198,    /* GPIOG[6] */
    IO_PAD199,    /* GPIOG[7] */
    IO_PAD200,    /* GPIOG[8] */
    IO_PAD201,    /* GPIOG[9] */
    IO_PAD202,    /* GPIOG[10] */
    IO_PAD203,    /* GPIOG[11] */
    IO_PAD204,    /* GPIOG[12] */
    IO_PAD205,    /* GPIOG[13] */
    IO_PAD206,    /* GPIOG[14] */
    IO_PAD207,    /* GPIOG[15] */
    IO_PAD208,    /* GPIOG[16] */
    IO_PAD209,    /* GPIOG[17] */
    IO_PAD210,    /* GPIOG[18] */
    IO_PAD211,    /* GPIOG[19] */
    IO_PAD212,    /* GPIOG[20] */
    IO_PAD213,    /* GPIOG[21] */
    IO_PAD214,    /* GPIOG[22] */
    IO_PAD215,    /* GPIOG[23] */
    IO_PAD216,    /* GPIOG[24] */
    IO_PAD217,    /* GPIOG[25] */
    IO_PAD218,    /* GPIOG[26] */
    IO_PAD219,    /* GPIOG[27] */
    IO_PAD220,    /* GPIOG[28] */
    IO_PAD221,    /* GPIOG[29] */
    IO_PAD222,    /* GPIOG[30] */
    IO_PAD223,    /* GPIOG[31] */
    IO_PAD224,    /* GPIOH[0] */
    IO_PAD225,    /* GPIOH[1] */
} signal_name_t;

typedef enum
{
    FUNC_SEL_0,
    FUNC_SEL_1,
    FUNC_SEL_2,
    FUNC_SEL_3,
    FUNC_SEL_4,
    FUNC_SEL_5,
    FUNC_SEL_6,
    FUNC_SEL_7
} function_t;

typedef struct pin_config_s
{
    signal_name_t pad;
    function_t function;

    /* Add other pin config here if necessary
     * (e.g., pullup, slew, etc)
     */
} pin_config_t;

static void setPinConfig( const pin_config_t * config );
static void setPinConfigIOGroup( const pin_config_t * io_grp_pin_cfg, int num_pins );

#define SET_PIN_CONFIG_IO_GRP( config_array ) { setPinConfigIOGroup( config_array, sizeof( config_array )/sizeof( pin_config_t ) ); }

#endif /* UTF_PINCONFIG_H_ */
