/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

/*------------------------------------------------------------------------
            Include Files
------------------------------------------------------------------------*/
//#include "UTF.h"
#include <stddef.h>
#include "UTF_PinConfig.h"
#include "regAddrs.h"
#include "board_types.h"
#include "minPrintf.h"
//#include "UTF_MessageHandler.h"
#include "6270_Padring_regheaders.h"
#include "ID_utils.h"
#include "assert.h"

#include "UTF_PinConfig.h"

/*------------------------------------------------------------------------
             Defines
------------------------------------------------------------------------*/
#define UTF_SOURCE_NAME __FILE__

/*------------------------------------------------------------------------
                        Globals
-------------------------------------------------------------------------*/

static const pin_config_t misc_pin_cfg[] = MISC_PIN_CONFIG;
static const pin_config_t serial_1_pin_cfg[] = SERIAL_1_PIN_CONFIG;
static const pin_config_t bspi_pin_cfg[] = BSPI_PIN_CONFIG;
static const pin_config_t serial_2_pin_cfg[] = SERIAL_2_PIN_CONFIG;
static const pin_config_t serial_3_pin_cfg[] = SERIAL_3_PIN_CONFIG;
static const pin_config_t serial_4_pin_cfg[] = SERIAL_4_PIN_CONFIG;
static const pin_config_t sd_mmc_0_pin_cfg[] = SD_MMC_0_PIN_CONFIG;
static const pin_config_t sd_mmc_2_pin_cfg[] = SD_MMC2_PIN_CONFIG;
static const pin_config_t i2c_1_pin_cfg[] = I2C1_PIN_CFG;
static const pin_config_t i2c_2_pin_cfg[] = I2C2_PIN_CFG;

static const pin_config_t misc_pin_cfg_ge2[] = MISC_PIN_CONFIG_GE2;
static const pin_config_t serial_1_pin_cfg_ge2[] = SERIAL_1_PIN_CONFIG_GE2;
static const pin_config_t bspi_pin_cfg_ge2[] = BSPI_PIN_CONFIG_GE2;
static const pin_config_t serial_2_pin_cfg_ge2[] = SERIAL_2_PIN_CONFIG_GE2;
static const pin_config_t sd_mmc_0_pin_cfg_ge2[] = SD_MMC_0_PIN_CONFIG_GE2;
static const pin_config_t sd_mmc_1_pin_cfg_ge2[] = SD_MMC_1_PIN_CONFIG_GE2;
static const pin_config_t i2c_1_pin_cfg_ge2[] = I2C1_PIN_CFG_GE2;
//static const pin_config_t i2c_2_pin_cfg[] = I2C2_PIN_CFG;

/* IOs configured in main UTF, not in bootcode. */
#ifndef BOOTCODE

//static const pin_config_t usb3x0_pin_cfg[] = USB3X0_PIN_CFG;
//static const pin_config_t usb2x1_pin_cfg[] = USB2X1_PIN_CFG;
//static const pin_config_t usb2h2_pin_cfg[] = USB2H2_PIN_CFG;
//static const pin_config_t i2c1_pin_cfg[] = I2C1_PIN_CFG;
//static const pin_config_t spi_1_pin_cfg[] = SPI_1_PIN_CFG;
//static const pin_config_t pex_pin_cfg[] = PEX_PIN_CFG;
//static const pin_config_t enet_pin_cfg[] = ENET_PIN_CFG;
//static const pin_config_t dcmtr_2_pin_cfg[] = DCMTR_2_PIN_CFG;
//static const pin_config_t dcmtr_3_pin_cfg[] = DCMTR_3_PIN_CFG;
//static const pin_config_t dcmtr_4_pin_cfg[] = DCMTR_4_PIN_CFG;
//static const pin_config_t dcmtr_5_pin_cfg[] = DCMTR_5_PIN_CFG;
//static const pin_config_t dcmtr_6_pin_cfg[] = DCMTR_6_PIN_CFG;
//static const pin_config_t fuser_pin_cfg[] = FUSER_PIN_CFG;
//static const pin_config_t hsync_pin_cfg[] = HSYNC_PIN_CFG;
//static const pin_config_t ls_pin_cfg[] = LS_PIN_CFG;
//static const pin_config_t ld_pin_cfg[] = LD_PIN_CFG;
//static const pin_config_t dpwm_pin_cfg[] = DPWM_PIN_CFG;
//static const pin_config_t nand_pin_cfg[] = NAND_PIN_CFG;
//static const pin_config_t spi_2_pin_cfg[] = SPI_2_PIN_CFG;
//static const pin_config_t spi_3_pin_cfg[] = SPI_3_PIN_CFG;
//static const pin_config_t serial_4_pin_cfg[] = SERIAL_4_PIN_CFG;
//static const pin_config_t dcmotor_0_pin_cfg[] = DCMOTOR_0_PIN_CFG;
//static const pin_config_t dcmotor_1_pin_cfg[] = DCMOTOR_1_PIN_CFG;
//static const pin_config_t sccp_0_pin_cfg[] = SCCP_0_PIN_CFG;
//static const pin_config_t ccd_0_pin_cfg[] = CCD_0_PIN_CFG;
//static const pin_config_t ccd_1_pin_cfg[] = CCD_1_PIN_CFG;
//static const pin_config_t sensor_pin_cfg[] = SENSOR_PIN_CFG;
//static const pin_config_t event_timer_a_pin_cfg[] = EVENT_TIMER_A_PIN_CFG;
//static const pin_config_t event_timer_b_pin_cfg[] = EVENT_TIMER_B_PIN_CFG;
//static const pin_config_t lcd_pin_cfg[] = LCD_PIN_CFG;
//static const pin_config_t afe_pin_cfg[] = AFE_PIN_CFG;
//static const pin_config_t ccd_pin_cfg[] = CCD_PIN_CFG;
//static const pin_config_t mtone_pin_cfg[] = MTONE_PIN_CFG;

#endif


/*------------------------------------------------------------------------
        initPinConfig
------------------------------------------------------------------------*/
/**
 *
 * \brief Initializes the pin/pad configuration at startup
 *
 * \param  void (no input)
 * \return void (no return value)
 *
 */
void initPinConfig( board_types_e board_type )
{
	if (is_FPGA())
	{
		return;
	}

    /* Common IOs to setup for both bootcode and main UTF */
    if ((board_type == eBringUp_Brd_Ge2_RevA) ||  (board_type == eBringUp_Brd_Ge2_RevB))
    {
        SET_PIN_CONFIG_IO_GRP( serial_1_pin_cfg_ge2); //Serial debug port1
        SET_PIN_CONFIG_IO_GRP( serial_2_pin_cfg_ge2); //Serial debug port2
        SET_PIN_CONFIG_IO_GRP( misc_pin_cfg_ge2); //power LED, etc.
        SET_PIN_CONFIG_IO_GRP( bspi_pin_cfg_ge2); //BootSPI
        SET_PIN_CONFIG_IO_GRP( sd_mmc_0_pin_cfg_ge2); //EMMC
        SET_PIN_CONFIG_IO_GRP( sd_mmc_1_pin_cfg_ge2); //microSD
        SET_PIN_CONFIG_IO_GRP( i2c_1_pin_cfg_ge2); //I2C 1 (for SPD, etc)
        //SET_PIN_CONFIG_IO_GRP( i2c_2_pin_cfg ); //I2C 2 (for SPD, etc)
    }
    else
    {
        SET_PIN_CONFIG_IO_GRP( serial_1_pin_cfg ); //Serial debug port1
        SET_PIN_CONFIG_IO_GRP( serial_2_pin_cfg ); //Serial debug port2
        SET_PIN_CONFIG_IO_GRP( serial_3_pin_cfg ); //Serial debug port3
        SET_PIN_CONFIG_IO_GRP( serial_4_pin_cfg ); //Serial debug port4
        SET_PIN_CONFIG_IO_GRP( misc_pin_cfg ); //power LED, etc.
        SET_PIN_CONFIG_IO_GRP( bspi_pin_cfg ); //BootSPI
        SET_PIN_CONFIG_IO_GRP( sd_mmc_0_pin_cfg ); //EMMC
        SET_PIN_CONFIG_IO_GRP( sd_mmc_2_pin_cfg ); //microSD
        SET_PIN_CONFIG_IO_GRP( i2c_1_pin_cfg ); //I2C 1 (for SPD, etc)
        SET_PIN_CONFIG_IO_GRP( i2c_2_pin_cfg ); //I2C 2 (for SPD, etc)
    }

    /* IOs configured in main UTF. Uncomment if ready to be configured at startup */
#ifndef BOOTCODE

//    SET_PIN_CONFIG_IO_GRP( i2c1_pin_cfg ); //EEPROM, power supply chip (power rails)
//    SET_PIN_CONFIG_IO_GRP( usb3x0_pin_cfg ); // USB to Wifi module
//    SET_PIN_CONFIG_IO_GRP( usb2x1_pin_cfg ); // USB Host
//    SET_PIN_CONFIG_IO_GRP( usb2h2_pin_cfg ); // microUSB
//    SET_PIN_CONFIG_IO_GRP( enet_pin_cfg ); // Ethernet

    /*
     * These IOs go to either a header or a slot. Uncomment to enable at startup.
     * Or call SET_PIN_CONFIG_IO_GRP(<config>) in unit test to enable.
     */
//    SET_PIN_CONFIG_IO_GRP( nand_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( pex_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( dcmtr_2_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( dcmtr_3_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( dcmtr_4_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( dcmtr_5_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( dcmtr_6_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( spi_1_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( fuser_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( hsync_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( ls_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( ld_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( dpwm_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( spi_2_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( spi_3_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( serial_4_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( dcmotor_0_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( dcmotor_1_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( sccp_0_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( ccd_0_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( ccd_1_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( sensor_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( event_timer_a_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( event_timer_b_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( lcd_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( afe_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( ccd_pin_cfg );
//    SET_PIN_CONFIG_IO_GRP( mtone_pin_cfg );
#endif
}

/*------------------------------------------------------------------------
        setPinConfigIOGroup
------------------------------------------------------------------------*/
/**
 *
 * \brief Configures the pin(s) for the specified IO group
 *
 * \param  io_grp_pin_cfg[in] - pin config array for IO group
 *         num_pins[in] - num of pins in the IO group
 *
 * \return void (no return value)
 *
 */
void setPinConfigIOGroup( const pin_config_t * io_grp_pin_cfg, int num_pins )
{
    int i;

    if ( ( io_grp_pin_cfg == NULL ) || ( num_pins == 0 ) )
    {
        return;
    }

    for ( i = 0; i < num_pins; i++, io_grp_pin_cfg++ )
    {
        setPinConfig( io_grp_pin_cfg );
    }
}

/*------------------------------------------------------------------------
        setPinConfig
------------------------------------------------------------------------*/
/**
 *
 * \brief Configures the pin to the specified pin configuration
 *
 * \param  void (no input)
 * \return void (no return value)
 *
 */
static void setPinConfig( const pin_config_t * config )
{
    volatile uint32_t * pio_cfg_reg;
    uint32_t *base_addr = (uint32_t *) AP_AP_APB_PADRING_IO_PAD0_BASE;
    uint32_t reg_val;

    if ( config == NULL )
    {
        return;
    }

    if (is_Gr2())
    {
        /* The pin config (padring) registers are arranged in memory as follows:
         *
         * Pin   0 - 109 : +0x000 -> +0x1B4
         * Pin 110 - 192 : +0x1D8 -> +0x320
         * Pin 193 - 225 : +0x34C -> +0x3CC
         *
         */
        if ( config->pad >= IO_PAD193 )
        {
            if (is_NOT_Gr2_RevA()) // Not Gr2 RevA
                // Gr2 RevA had extra registers between 192 & 193, so subtrack 0x10 to line back up for other Revs
                pio_cfg_reg = ( uint32_t * ) ( AP_AP_APB_PADRING_IO_PAD193_BASE + ( ( config->pad - IO_PAD193 ) * sizeof ( uint32_t ) ) - 0x10 );
            else // RevA
                pio_cfg_reg = ( uint32_t * ) ( AP_AP_APB_PADRING_IO_PAD193_BASE + ( ( config->pad - IO_PAD193 ) * sizeof ( uint32_t ) ) );
        }
        else if ( config->pad >= IO_PAD110 )
        {
            pio_cfg_reg = ( uint32_t * ) ( AP_AP_APB_PADRING_IO_PAD110_BASE + ( ( config->pad - IO_PAD110 ) * sizeof ( uint32_t ) ) );
        }
        else
        {
            pio_cfg_reg = ( uint32_t * ) ( AP_AP_APB_PADRING_IO_PAD0_BASE + ( config->pad * sizeof ( uint32_t ) ) );
        }
    }
    else if (is_Ge2())
    {
        if ( config->pad >= IO_PAD159 )
        {
            pio_cfg_reg = ( uint32_t * ) ( AP_AP_APB_PADRING_IO_PAD159_BASE + ( ( config->pad - IO_PAD159 ) * sizeof ( uint32_t ) ) );
        }
        else if ( config->pad >= IO_PAD87 )
        {
            pio_cfg_reg = ( uint32_t * ) ( AP_AP_APB_PADRING_IO_PAD87_BASE + ( ( config->pad - IO_PAD87 ) * sizeof ( uint32_t ) ) );
        }
        else {
        	// TODO Fill this in to handle the Gaps unique to Ge2
        	pio_cfg_reg = ( uint32_t * ) ( AP_AP_APB_PADRING_IO_PAD0_BASE + ( config->pad * sizeof ( uint32_t ) ) );
        }
    }
    else
        return;

    //msg( MSG_DEBUG, UTF_SOURCE_NAME,"(0x%08x) Pin #%d = func 0x%x \r\n", pio_cfg_reg, config->pad, config->function );
    //minPrintf( "(0x%08x) Pin #%d = func 0x%x \r\n", pio_cfg_reg, config->pad, config->function );
    // Ge2 has an issue where the pin config registers must be written in a certain order for it to work correctly.
    // Since it doesn't matter to gr2 do the same for both to fix the bug.  For read must read base address 
    // then the config address twice.  For a write, read base, read config, write config twice.
    //
    reg_val = *base_addr;
    reg_val = *pio_cfg_reg;
    reg_val = *pio_cfg_reg;
    reg_val = IO_PAD0_PIOCFG_FUNC_SEL_REPLACE_VAL( reg_val, config->function );
    *pio_cfg_reg = reg_val;
    *pio_cfg_reg = reg_val;

}

