/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/
#ifndef __FLASH_INTERNAL_H__
#define __FLASH_INTERNAL_H__

#include <stdint.h>
#include <assert.h>
#include "minPrintf.h"

typedef enum
{
	PORT_DEV	= 1,
	FLASH_DEV,
	STREAMING_DEV
} DeviceType_T;


typedef uint32_t (*MRead_F)		(uint32_t, uint32_t, uint32_t, uint32_t);
typedef uint32_t (*MWrite_F) 	(uint32_t, uint32_t, uint32_t, uint32_t);
typedef uint32_t (*MErase_F) 	(uint32_t, uint32_t);
typedef uint32_t (*MFinalize_F)	();
typedef uint32_t (*MReset_F) 	();
typedef uint32_t (*MWipe_F)  	();
typedef void     (*MSetPartition_F)     (uint32_t PartitionNum);
typedef uint32_t (*MCheckPortReady_F)	(uint32_t);

typedef struct
{
	uint32_t	 	    valid;
	uint32_t		    MediaNum;
	DeviceType_T		DeviceType;

	MRead_F				Read;
	MWrite_F			Write;
	MErase_F			Erase;
	MReset_F			Reset;
	MWipe_F				Wipe;
	MFinalize_F			Finalize;
	MSetPartition_F		SetPartition;
	MCheckPortReady_F	CheckPortReady;
} MEDIA_T, *P_MEDIA_T;


typedef uint32_t (*pConfigure_Flashes_F) (P_MEDIA_T, uint8_t);
typedef uint32_t (*pReadFlash_F) (uint32_t FlashOffset, uint32_t LocalBuffer, uint32_t Size, uint32_t dummy);

struct flash_ops {
    pConfigure_Flashes_F configure_flashes;
    pReadFlash_F ReadFlash;
} flash_ops_t;

#endif // ifndef __FLASH_INTERNAL_H__
