/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

#ifndef __SPD_ROM_H__
#define __SPD_ROM_H__

#include "error_types.h"
#include "board_types.h"
#include "pll_api.h"
#include "stdbool.h"

typedef struct spd_rom_info_s {
    uint32_t i2c_bus;
    uint32_t i2c_addr;
} spd_rom_info_t;

typedef struct spd_record_s {
	uint8_t crc_size_used;      		// Byte 0
	uint8_t revision;           		// Byte 1
	uint8_t basic_mem_type;     		// Byte 2
	uint8_t module_type;        		// Byte 3
	uint8_t bank_addr_bpc;      		// Byte 4
	uint8_t ras_cas;            		// Byte 5
	uint8_t voltage;            		// Byte 6
	uint8_t module_org;         		// Byte 7
	uint8_t ecc_width;          		// Byte 8
	uint8_t fine_time_base;     		// Byte 9
	uint8_t mtb_dividend;       		// Byte 10
	uint8_t mtb_divisor;        		// Byte 11
	uint8_t min_cycle_time;     		// Byte 12
	uint8_t reserved_b13;       		// Byte 13
	uint8_t cas_latency_14;     		// Byte 14
	uint8_t cas_latency_15;     		// Byte 15
	uint8_t min_cas;            		// Byte 16
	uint8_t min_write_recov;    		// Byte 17
	uint8_t min_t_rcd;          		// Byte 18
	uint8_t min_t_rrd;          		// Byte 19
	uint8_t min_t_rp;           		// Byte 20
	uint8_t min_t_rc_t_ras;     		// Byte 21
	uint8_t min_t_ras;          		// Byte 22
	uint8_t min_t_rc;           		// Byte 23
	uint8_t min_t_rfc_l;        		// Byte 24
	uint8_t min_t_rfc_u;        		// Byte 25
	uint8_t min_t_wtr;          		// Byte 26
	uint8_t min_t_rtp;          		// Byte 27
	uint8_t min_t_faw;          		// Byte 28
	uint8_t min_four_t_faw;          	// Byte 29
	uint8_t optional_features;  		// Byte 30
	uint8_t therm_ref_options;  		// Byte 31
	uint8_t temp_sensor_avail;  		// Byte 32
	uint8_t nonstd_dev_type;    		// Byte 33
	int8_t t_ck_min_correction; 		// Byte 34
	int8_t t_aa_min_correction; 		// Byte 35
	int8_t t_rcd_min_correction;		// Byte 36
	int8_t t_rp_min_correction; 		// Byte 37
	int8_t t_rc_min_correction;     	// Byte 38
	uint8_t reserved_b39_b59[21];   	// Byte 39 to 59
	uint8_t module_nominal_height;  	// Byte 60
	uint8_t module_nominal_thick;   	// Byte 61
	uint8_t JEDEC_ref_design;       	// Byte 62
	uint8_t module_specific[54];    	// Byte 63 to 116
	uint8_t module_manufacturer_low;	// Byte 117
	uint8_t module_manufacturer_hi; 	// Byte 118
	uint8_t module_manufacturer_loc;	// Byte 119
	uint8_t manufactured_dec_year;  	// Byte 120
	uint8_t manufactured_10w_weeks; 	// Byte 121
	uint8_t module_sernum[4];       	// Byte 122 to 125
	uint8_t crc16[2];               	// Byte 126 to 127
	uint8_t module_part_num[18];    	// Byte 128 to 145
	uint8_t module_revision_code[2];	// Byte 146 to 147
	uint8_t manufacturer_id[2];         // Byte 148 to 149
	uint8_t manufacturur_spec_data[26]; // Byte 150 to 175
    uint8_t undefined[80];              // Byte 176 to 255
} spd_record_t;

#define SPD_ROM_SIZE        (sizeof(struct spd_record_s))

error_type_t read_SPD_memory_config( board_types_e board_type, DDR_config_t **DDR_config_record, uint32_t *mem_width, pll_freq_t *ddr_pll_settings, bool *ddr4_memory );

#endif // ifndef __SPD_ROM_H__
