/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

//#define DEBUG

//#include "ddr_internal.h"
#include "error_types.h"
#include "board_types.h"
//#include "GR2/UTF_DDR_Config.h"
//#include "GS2/UTF_DDR_GS2_Config.h"
#include "MC_regheaders.h"
#include "ddr_utils.h"
#include "ddr_config.h"
#include "spd_rom.h"
#include "i2c_api.h"
#include "pll_api.h"
#include "minPrintf.h"
#include "string.h"
#include "hex_dump.h"
#include "ID_utils.h"

uint8_t spd_buffer[SPD_ROM_SIZE];
//static DDR_config_t TOC_MCConfig        = mt41k1G8_125_mt41k1G8_125_800_x32_INIT_DATA; // mt41j256m16_93_800_x32_INIT_DATA;
extern DDR_config_t TOC_MCConfig;
extern DDR_config_t TOC_MCConfig_Ge2;
 
extern DDR_config_t FFC_r1_MCConfig;
extern DDR_config_t GLD_4_MCConfig;
extern DDR_config_t TWNDIE_4_MCConfig;
extern DDR_config_t Default_MCConfig_DDR4_Ge2;
#if 0
static DDR_config_t Customer_Board_XX_MCConfig   = Customer_800_x32_INIT_DATA;
#endif

#define board_is(board) ( 0 == memcmp(spd_data->module_part_num, board, sizeof(board)-1))

// This is an example of reading the SPD EEPROM data.  In this example, the data
// in the EEPROM is just the SPD header values (byte 0-2), and the module part num
// holding the board type ID string.  Based on the board type, the appropriate mem
// configuration is setup.
error_type_t parse_i2c_SPD_data(const void *buffer, DDR_config_t **DDR_config_record, uint32_t *mem_width, pll_freq_t *DDR_PLL_settings, bool *ddr4_memory)
{
	const spd_record_t *spd_data = buffer;
#ifdef DEBUG
	minPrintf("\n\n");
	hex_dump(buffer, SPD_ROM_SIZE);
	minPrintf("\n\nmodule_part_number: |%s|\n",spd_data->module_part_num);
#endif

	// Check if we got data that seems right.  Look for DDR3 SPD keys.
	if (!((spd_data->crc_size_used == 0x92) ||
		  (spd_data->crc_size_used == 0x93) ||
		  (spd_data->crc_size_used == 0x13)) ||
		(spd_data->revision       != 0x12) ||
		(spd_data->basic_mem_type != 0x0B))
		return FAIL;

	if ( (board_is("TOC") || board_is("GLD_2") || board_is("FFC_r2") || board_is("FFCC")) && is_Gr2() )
	{
		*DDR_config_record = &TOC_MCConfig;
		*ddr4_memory = false;


		*DDR_PLL_settings = eDDR_PLL_1600MHZ;
		*mem_width     = 32;
		#if 0
		TWNDIE_4_MCConfig.CH0_PMAP0             = 0x05010632;
		TWNDIE_4_MCConfig.CH0_MMAP0             = 0x000F0001;
		TWNDIE_4_MCConfig.CH0_PMAP1             = 0x05010632;
		TWNDIE_4_MCConfig.CH0_MMAP1             = 0x800f0001;
		TWNDIE_4_MCConfig.CH0_PreCharge_Timing  = 0x00b0c60b;
		TWNDIE_4_MCConfig.CH0_ACT_timing        = 0x18270b1c;
		TWNDIE_4_MCConfig.CH0_CAS_RAS_timing    = 0x5b440068;
		*DDR_config_record = &TWNDIE_4_MCConfig;
		#endif

		minPrintf("\nInit %s\n",spd_data->module_part_num);
		return STATUS_OK;
	}

	if ( board_is("GS2_TOC") && is_Ge2() )
	{
		minPrintf("gemstone 2 toc card\n");
		*ddr4_memory = false;
		*DDR_PLL_settings = eDDR_PLL_1333MHZ;
		*mem_width = 16;
		*DDR_config_record = &TOC_MCConfig_Ge2;
		minPrintf("\nInit %s\n",spd_data->module_part_num);
		return STATUS_OK;
	}

#if 0
	else if ( board_is("CUSTOMER_BOARD_XX") )
	{
		Customer_Board_XX_MCConfig.DDR_PLL_setting = eDDR_PLL_1600MHZ;
		Customer_Board_XX_MCConfig.DDR_width_setting = 32;
		*DDR_config_record = &Customer_Board_XX_MCConfig;
		minPrintf("\nInit Customer Board XX\n");
		return STATUS_OK;
	}
#endif

	else if ( board_is("FFC_r1") )
	{
		*ddr4_memory = false;
		*DDR_PLL_settings = eDDR_PLL_800MHZ;
		*mem_width = 16;
		*DDR_config_record = &FFC_r1_MCConfig;
		minPrintf("\nInit FFC_r1\n");
		return STATUS_OK;
	}

	else if ( board_is("GLD_4_TWN") )
	{
		*ddr4_memory = false;
		*DDR_PLL_settings = eDDR_PLL_1600MHZ;
		*mem_width     = 32;
		TWNDIE_4_MCConfig.CH0_MMAP1             = 0x800f0001;
		*DDR_config_record = &TWNDIE_4_MCConfig;
		minPrintf("\nInit GLD_4_TWN\n");
		return STATUS_OK;
	}

	else if ( board_is("XYZ3") || board_is("GPDB") )
	{
		*ddr4_memory = false;
		*DDR_PLL_settings = eDDR_PLL_1600MHZ;
		*mem_width     = 32;
		TWNDIE_4_MCConfig.CH0_PMAP0             = 0x05010632;
		TWNDIE_4_MCConfig.CH0_MMAP0             = 0x000F0001;
		TWNDIE_4_MCConfig.CH0_PMAP1             = 0x05010632;
		TWNDIE_4_MCConfig.CH0_MMAP1             = 0x800f0001;
		TWNDIE_4_MCConfig.CH0_PreCharge_Timing  = 0x00b0c60b;
		TWNDIE_4_MCConfig.CH0_ACT_timing        = 0x18270b1c;
		TWNDIE_4_MCConfig.CH0_CAS_RAS_timing    = 0x5b440068;
		*DDR_config_record = &TWNDIE_4_MCConfig;
		minPrintf("\nInit %s\n",spd_data->module_part_num);
		return STATUS_OK;
	}

	else if ( board_is("GLD_4") )
	{
		*ddr4_memory = false;
		*DDR_PLL_settings = eDDR_PLL_1600MHZ;
		*mem_width = 32;
		*DDR_config_record = &GLD_4_MCConfig;
		minPrintf("\nInit GLD_4\n");
		return STATUS_OK;
	}

	else if ( board_is("GS2_FFC_r1") )
	{
		*ddr4_memory = true;
		*DDR_PLL_settings = eDDR_PLL_1200MHZ;
		*mem_width = 16;
		*DDR_config_record = &Default_MCConfig_DDR4_Ge2;
		minPrintf("\nGS2_FFC_r1\n");
		return STATUS_OK;
	}

	return FAIL;
}



error_type_t read_i2c_SPD_data( board_types_e board_type, void *buffer, int i2c_bus, int i2c_addr)
{
	error_type_t ret_val = FAIL;
	if (STATUS_OK == (ret_val = initialize_I2C(i2c_bus)))
	{
		ret_val = I2C_read(i2c_addr, 0, I2C_ONE_BYTE_MODE, SPD_ROM_SIZE, buffer);
	}
	return ret_val;
}



error_type_t read_SPD_memory_config( board_types_e board_type, DDR_config_t **DDR_config_record, uint32_t *mem_width, pll_freq_t *ddr_pll_settings, bool *ddr4_memory )
{
	error_type_t ret_val = FAIL;
	int i2c_bus = 1;
	int i2c_addr[] = { 0x50, 0x51, 0x53, 0x54 };
	int i = 0;

	do {
		if (STATUS_OK == read_i2c_SPD_data(board_type, spd_buffer, i2c_bus, i2c_addr[i++]))
		{
			ret_val = parse_i2c_SPD_data(spd_buffer, DDR_config_record, mem_width, ddr_pll_settings, ddr4_memory);
		}
	} while ((FAIL == ret_val) && (i < sizeof(i2c_addr)/sizeof(int)));

	return ret_val;
}

/* Used by vim and some versions of vi: set tabstop=4 shiftwidth=4: */
