/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

#ifndef __DDR_UTILS_H__
#define __DDR_UTILS_H__

/*------------------------------------------------------------------------
            Include Files
------------------------------------------------------------------------*/


/*------------------------------------------------------------------------
            Structs
------------------------------------------------------------------------*/
typedef struct cs_sa_s
{
    uint32_t sa[3];                             ///< 1 start address for each supported CS
} cs_sa_t;

typedef struct M2M_Desc_s {
    uint32_t  	Ctrl;
    void     	*Src;
    void      	*Dst;
    uint32_t  	Xlate;
    struct M2M_Desc_s  *Next;
} M2M_Desc_t;

/*------------------------------------------------------------------------
            Prototypes
------------------------------------------------------------------------*/
void xfer_DMA_DATA(volatile uint32_t* startAddress, volatile uint32_t* destination, uint32_t bufferSize);
uint32_t CheckDMAData (uint32_t* addr, uint32_t ed, uint32_t d);
uint32_t DMA_DDR_Memory_Test (uint8_t allNoise, uint32_t loops, uint8_t stpOnFail, uint32_t wdAddr, uint32_t wrOnly, uint32_t rdOnly);
void DumpMcRegs(MC_REGS_t *mc_reg, cs_sa_t *startAddrs);
#endif // ifndef __DDR_UTILS_H__

