/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2011-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/
/*------------------------------------------------------------------------
            Include Files
------------------------------------------------------------------------*/
#include <stdarg.h>
#include <string.h>
#include "regAddrs.h"
#include "MC_regheaders.h"
#include "ddr_utils.h"
#include "m2m_regheaders.h"
#include "cpu_api.h"
#include "minPrintf.h"

/*------------------------------------------------------------------------
        Defines
------------------------------------------------------------------------*/
#define BURSTSIZE 16  // words
#define BURSTSIZEB BURSTSIZE*4
#define UTF_waitForMicroSecs(x) cpu_spin_delay(x)
//#define msg(x,y,...) minPrintf(__VA_ARGS__)
#define msg(x,y,...) 

/*------------------------------------------------------------------------
        Globals
------------------------------------------------------------------------*/
extern uint32_t __start_of_free_DDR__;  //from ld file


/*------------------------------------------------------------------------
        xfer_DMA_DATA
------------------------------------------------------------------------*/
/**
 *
 * \brief use the M2M DMA to read the DDR so that we get a single burst
 *
 * \param uint32_t* startAddress - address of data in DDR
 *        uint32_t* destination - non-DDR emm locaiton used to check read data
 * \return void (no return value)
 *
 *
 */
void xfer_DMA_DATA(volatile uint32_t* startAddress, volatile uint32_t* destination, uint32_t bufferSize)
{
    M2M_Desc_t M2M_Desc;
    uint32_t timeout = 0;

    M2M_Desc.Ctrl   = 0x80000000 | bufferSize;
    M2M_Desc.Src    = (void*)startAddress;
    M2M_Desc.Dst    = (void*)destination;
    M2M_Desc.Xlate  = 0;
    M2M_Desc.Next   = NULL;


    //get pointers to AP CDMA regs
    M2M_REGS_t *M2M_regs = (M2M_REGS_t*) AP_IO_WRAP_M2M0_BASE;

    //start DMA
    M2M_regs->desc_start = (uint32_t)&M2M_Desc;

  //  UTF_startTimer(100,KHZ1,1,2);
#if 1
    while (!(M2M_regs->status & (1<<15)))
    {
        UTF_waitForMicroSecs(10);
        timeout++;
        if ( timeout > 100 )
        {
            minPrintf("DMA timed out\n");
            return;
        }
    }
#endif

    return;
}

/*------------------------------------------------------------------------
        DMA_DDR_Memory_Test
------------------------------------------------------------------------*/
/**
 *
 * \brief use the M2M DMA to test the DDR so that we get a single burst while still in R4
 *
 * \param uint32_t test_addr - address of data in DDR
 *        uint32_t allNoise - if set, changes data pattern from half noise to all noise
 *        uint32_t loops - number of times to run the test
 *        uint32_t stpOnFail - if set, test ends if a failure is found
 * \return void (no return value)
 *
 *
 */
#ifdef R4MEMTEST
uint32_t DMA_DDR_Memory_Test (uint8_t allNoise, uint32_t loops, uint8_t stpOnFail, uint32_t wdAddr, uint32_t wrOnly, uint32_t rdOnly)
{
  uint32_t fail = 0;
  volatile uint32_t* freeDDR;
  uint32_t d[BURSTSIZE];
  uint32_t ed[BURSTSIZE];
  uint32_t pattern = 0xFFFF0000;
  uint32_t pattern1 = 0x0000FFFF;
  uint32_t test_size, num_tests, i, j, y;

  if (allNoise == 1) {
    pattern = 0x00000000;
    pattern1 = 0xFFFFFFFF;
  } else if (allNoise == 2) {
    pattern = 0xFFFFFFFF;
    pattern1 = 0x00000000;
  } else if (allNoise == 3) {
    pattern = 0x00000000;
    pattern1 = 0x00000000;
  }

  for (i=0; i<BURSTSIZE; i++) {
    if (allNoise == 4) {
      ed[i] = 1 << i;
    } else {
    if (i%2 == 0)
      ed[i] = pattern;
    else
      ed[i] = pattern1;
    }
    msg(MSG_DEBUG, RAW_DATA, "ed[%0d] = 0x%08x\r\n", i, ed[i]);
  }

  if (rdOnly == 1)
    test_size = 0x100;
  else
  test_size = 0x10000;
  //num_tests = test_size>>6;    // Using 64 byte bursts
  num_tests = test_size/BURSTSIZEB;    // Using 64 byte bursts
  y = 0;
  freeDDR = &__start_of_free_DDR__;
  freeDDR += wdAddr;
  msg(MSG_STATUS, RAW_DATA, "Inside DMA_DDR_Memory_Test, Start Address = 0x%08x, \r\nsize(words) = 0x%0x, num_tests = 0x%0x, loops = 0x%0x\r\n",
                             freeDDR,test_size,num_tests,loops);

  while ((y < loops) && ((fail == 0)  || !stpOnFail)) {
    i = 0;
    fail = 0;
    freeDDR = &__start_of_free_DDR__;
    freeDDR += wdAddr;
    // Malloc the buffer for testing
    msg(MSG_STATUS, RAW_DATA, "\tfreeDDR = 0x%0x, y = %0d, i = %0d, fail = %0d, stpOnFail = %0d\r\n", freeDDR,y,i,fail,stpOnFail);
    while (((fail == 0)  || !stpOnFail) && (i < num_tests)) {
      // Only write on first iteration
      if ((y == 0) || (wrOnly == 1))
        xfer_DMA_DATA(ed, freeDDR, BURSTSIZEB);

      // Read & check the data
      if (wrOnly == 0) {
      xfer_DMA_DATA(freeDDR, d, BURSTSIZEB);
      j = 0;
      while (j<BURSTSIZE && (fail==0 || !stpOnFail)) {
        fail |= CheckDMAData((uint32_t *)freeDDR, ed[j], d[j]);    // Increments sa each time
        freeDDR += 1;
        j++;
      }
        //if (i%2048 == 0)
        //  msg(MSG_STATUS, RAW_DATA, "Read data via DMA from address 0x%08x, y = %0d, i = %0d, fail = %0d\r\n", freeDDR,y,i,fail);
      }
      i++;
    }

    if ((fail == 0) && (loops != 0xffffffff)) {
      msg(MSG_STATUS, RAW_DATA, "DMA_DDR_Memory_Test Test Passed Loop = %d\r\n", y);
    } else if ((fail == 0) && (y%32 == 0)) {
      if (stpOnFail)
        msg(MSG_STATUS, RAW_DATA, "DMA_DDR_Memory_Test Tests Passed Thru Loop = %d\r\n", y);
      else
        msg(MSG_STATUS, RAW_DATA, "DMA_DDR_Memory_Test Tests Passed Thru Loop = %d\r\n", y);
    } else if ((!stpOnFail) && (y%32 == 0))
      msg(MSG_STATUS, RAW_DATA, "DMA_DDR_Memory_Test Tests Run Thru Loop %d\r\n", y);

    y++;

    //msg(MSG_STATUS, RAW_DATA, "y = %0d, i = %0d, fail = %0d, stpOnFail = %0d\r\n", y,i,fail,stpOnFail);
    // if loops == 0xffffffff, then infinite loops
    if (y == 0xffffffff) {
      y = 0;
      msg(MSG_STATUS, RAW_DATA, "Reseting loop count for infinite run, loop = %d\r\n", y);
    }
  }
  return (fail);
}

/*------------------------------------------------------------------------
        CheckDMAData
------------------------------------------------------------------------*/
/**
 *
 * \brief check actual versus expected data.
 *
 * \param uint32_t addr - address of data in DDR
 *        uint32_t ed - expected data
 *        uint32_t d - actual data
 *        uint32_t stpOnFail - if set, test ends if a failure is found
 * \return uint32_t pass(0)/fail(1) flag
 *
 *
 */
uint32_t CheckDMAData (uint32_t* addr, uint32_t ed, uint32_t d)
{
  uint32_t rc = 0;

  if (ed != d) {
    msg(MSG_ERROR, RAW_DATA, "Pat Fail at Addr 0x%08x: Expected 0x%08x, Actual 0x%08x\r\n", addr, ed, d);
    rc = 1;
  } //else
    //msg(MSG_STATUS, RAW_DATA, "Pat Passed at Addr 0x%08x: Expected 0x%0x, Actual 0x%0x\r\n", addr, ed, d);

  return (rc);
}
#endif
/*------------------------------------------------------------------------
        DumpMcRegs
------------------------------------------------------------------------*/
/**
 *
 * \brief Dump ddr configuration registers
 *
 * \param MC_REGS_t *mc_reg - pointer to memory controller registers
 *        cs_sa_t *startAddrs - starting address structure
 * \return void (no return value)
 *
 *
 */
void DumpMcRegs(MC_REGS_t *mc_reg, cs_sa_t *startAddrs)
{
  msg(MSG_DEBUG, RAW_DATA, "Dumping MC CH0 Regs:\r\n");
  msg(MSG_DEBUG, RAW_DATA, "PMAP0 = 0x%08x\r\n", mc_reg->CH0_PMAP0);
  msg(MSG_DEBUG, RAW_DATA, "DRAM_Config_5_CS0 = 0x%08x\r\n", mc_reg->CH0_DRAM_Config_5_CS0);
  msg(MSG_DEBUG, RAW_DATA, "MMAP0 = 0x%08x\r\n", mc_reg->CH0_MMAP0);
  msg(MSG_DEBUG, RAW_DATA, "PMAP0 = 0x%08x\r\n", mc_reg->CH0_PMAP0);
  msg(MSG_DEBUG, RAW_DATA, "MC_Control_1 = 0x%08x\r\n", mc_reg->CH0_MC_Control_1);
  msg(MSG_DEBUG, RAW_DATA, "MC_Control_2 = 0x%08x\r\n", mc_reg->CH0_MC_Control_2);
  msg(MSG_DEBUG, RAW_DATA, "MC_Control_3 = 0x%08x\r\n", mc_reg->CH0_MC_Control_3);
  msg(MSG_DEBUG, RAW_DATA, "MC_Control_4 = 0x%08x\r\n", mc_reg->CH0_MC_Control_4);
  msg(MSG_DEBUG, RAW_DATA, "PreCharge_Timing = 0x%08x\r\n", mc_reg->CH0_PreCharge_Timing);
  msg(MSG_DEBUG, RAW_DATA, "ACT_timing = 0x%08x\r\n", mc_reg->CH0_ACT_timing);
  msg(MSG_DEBUG, RAW_DATA, "CAS_RAS_timing = 0x%08x\r\n", mc_reg->CH0_CAS_RAS_timing);
  msg(MSG_DEBUG, RAW_DATA, "MRS_timing = 0x%08x\r\n", mc_reg->CH0_MRS_timing);
  msg(MSG_DEBUG, RAW_DATA, "DDR_init_timing_control_0 = 0x%08x\r\n", mc_reg->CH0_DDR_init_timing_control_0);
  msg(MSG_DEBUG, RAW_DATA, "DDR_init_timing_control_1 = 0x%08x\r\n", mc_reg->CH0_DDR_init_timing_control_1);
  msg(MSG_DEBUG, RAW_DATA, "Off_spec_timing = 0x%08x\r\n", mc_reg->CH0_Off_spec_timing);
  msg(MSG_DEBUG, RAW_DATA, "ZQC_Timing_0 = 0x%08x\r\n", mc_reg->CH0_ZQC_Timing_0);
  msg(MSG_DEBUG, RAW_DATA, "ZQC_Timing_1 = 0x%08x\r\n", mc_reg->CH0_ZQC_Timing_1);
  msg(MSG_DEBUG, RAW_DATA, "Refresh_timing = 0x%08x\r\n", mc_reg->CH0_Refresh_timing);
  msg(MSG_DEBUG, RAW_DATA, "SelfRefresh_timing = 0x%08x\r\n", mc_reg->CH0_SelfRefresh_timing);
  msg(MSG_DEBUG, RAW_DATA, "DRAM_Control_1 = 0x%08x\r\n", mc_reg->CH0_DRAM_Control_1);
  msg(MSG_DEBUG, RAW_DATA, "DRAM_Control_2 = 0x%08x\r\n", mc_reg->CH0_DRAM_Control_2);
  msg(MSG_DEBUG, RAW_DATA, "DRAM_Config_1 = 0x%08x\r\n", mc_reg->CH0_DRAM_Config_1);
  msg(MSG_DEBUG, RAW_DATA, "DRAM_Config_2 = 0x%08x\r\n", mc_reg->CH0_DRAM_Config_2);
  msg(MSG_DEBUG, RAW_DATA, "DRAM_Config_3 = 0x%08x\r\n", mc_reg->CH0_DRAM_Config_3);
  msg(MSG_DEBUG, RAW_DATA, "PHY_Control_1 = 0x%08x\r\n", mc_reg->CH0_PHY_Control_1);
  msg(MSG_DEBUG, RAW_DATA, "PHY_Control_2 = 0x%08x\r\n", mc_reg->CH0_PHY_Control_2);
  msg(MSG_DEBUG, RAW_DATA, "PHY_Control_3 = 0x%08x\r\n", mc_reg->CH0_PHY_Control_3);
  msg(MSG_DEBUG, RAW_DATA, "PHY_Control_4 = 0x%08x\r\n", mc_reg->CH0_PHY_Control_4);
  msg(MSG_DEBUG, RAW_DATA, "PHY_Control_5 = 0x%08x\r\n", mc_reg->CH0_PHY_Control_5);
  msg(MSG_DEBUG, RAW_DATA, "PHY_Control_6 = 0x%08x\r\n", mc_reg->CH0_PHY_Control_6);
  msg(MSG_DEBUG, RAW_DATA, "PHY_Control_8 = 0x%08x\r\n", mc_reg->CH0_PHY_Control_8);
  msg(MSG_DEBUG, RAW_DATA, "PHY_Control_9 = 0x%08x\r\n", mc_reg->CH0_PHY_Control_9);
  msg(MSG_DEBUG, RAW_DATA, "PHY_Control_11 = 0x%08x\r\n", mc_reg->CH0_PHY_Control_11);
  msg(MSG_DEBUG, RAW_DATA, "PHY_Control_13 = 0x%08x\r\n", mc_reg->CH0_PHY_Control_13);
  msg(MSG_DEBUG, RAW_DATA, "PHY_Control_14 = 0x%08x\r\n", mc_reg->CH0_PHY_Control_14);
  msg(MSG_DEBUG, RAW_DATA, "PHY_Control_15 = 0x%08x\r\n", mc_reg->CH0_PHY_Control_15);
  msg(MSG_DEBUG, RAW_DATA, "PHY_Control_16 = 0x%08x\r\n", mc_reg->CH0_PHY_Control_16);
  msg(MSG_DEBUG, RAW_DATA, "PHY_Control_17 = 0x%08x\r\n", mc_reg->CH0_PHY_Control_17);
  msg(MSG_DEBUG, RAW_DATA, "PHY_Data_Byte_Control_B0 = 0x%08x\r\n", mc_reg->CH0_PHY_Data_Byte_Control_B0);
  msg(MSG_DEBUG, RAW_DATA, "PHY_Data_Byte_Control_B1 = 0x%08x\r\n", mc_reg->CH0_PHY_Data_Byte_Control_B1);
 // msg(MSG_DEBUG, RAW_DATA, "mc_reg->MC_pwr_ctl = 0x%08x\r\n", mc_reg->MC_pwr_ctl);
  msg(MSG_DEBUG, RAW_DATA, "PHY_WL_DATA_Control_CS0_B0 = 0x%08x\r\n", mc_reg->CH0_PHY_WL_DATA_Control_CS0_B0);
  msg(MSG_DEBUG, RAW_DATA, "PHY_WL_DATA_Control_CS0_B1 = 0x%08x\r\n", mc_reg->CH0_PHY_WL_DATA_Control_CS0_B1);
  msg(MSG_DEBUG, RAW_DATA, "PHY_RL_Control_CS0_B0 = 0x%08x\r\n", mc_reg->CH0_PHY_RL_Control_CS0_B0);
  msg(MSG_DEBUG, RAW_DATA, "PHY_RL_Control_CS0_B1 = 0x%08x\r\n", mc_reg->CH0_PHY_RL_Control_CS0_B1);
  msg(MSG_DEBUG, RAW_DATA, "PHY_DLL_control_B0 = 0x%08x\r\n", mc_reg->CH0_PHY_DLL_control_B0);
  msg(MSG_DEBUG, RAW_DATA, "PHY_DLL_control_B1 = 0x%08x\r\n", mc_reg->CH0_PHY_DLL_control_B1);
  msg(MSG_DEBUG, RAW_DATA, "\r\n");
}

