/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

#ifndef __DDR_CONFIG_H__
#define __DDR_CONFIG_H__

/*------------------------------------------------------------------------
            Include Files
------------------------------------------------------------------------*/

/*------------------------------------------------------------------------
            Structs
------------------------------------------------------------------------*/

typedef struct DDR_config_record_s 
{
    uint32_t CH0_PHY_Control_6;                ///< 0x414 [R/W]: PHY Control Register 6
    uint32_t CH0_PHY_Control_17;                ///< 0x440 [R/W]: PHY Control Register 17
    uint32_t CH0_PMAP0;                         ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0
    uint32_t CH0_DRAM_Config_5_CS0;             ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 
    uint32_t CH0_MMAP0;                         ///< 0x200 [R/W]: Memory Address Map Register Channel 0
    uint32_t CH0_PMAP1;                         ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1
    uint32_t CH0_DRAM_Config_5_CS1;             ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1
    uint32_t CH0_MMAP1;                         ///< 0x204 [R/W]: Memory Address Map Register Channel 1
    uint32_t CH0_PMAP2;                         ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2
    uint32_t CH0_DRAM_Config_5_CS2;             ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2
    uint32_t CH0_MMAP2;                         ///< 0x208 [R/W]: Memory Address Map Register Channel 2
    uint32_t CH0_PreCharge_Timing;              ///< 0x3a4 [R/W]: DRAM Precharge Timing Register
    uint32_t CH0_ACT_timing;                    ///< 0x3a0 [R/W]: DRAM Activate Timing Register
    uint32_t CH0_CAS_RAS_timing;                ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register
    uint32_t CH0_MRS_timing;                    ///< 0x39c [R/W]: DRAM MRS Timing Register
    uint32_t CH0_DDR_init_timing_control_0;     ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0
    uint32_t CH0_DDR_init_timing_control_1;     ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1
    uint32_t CH0_Off_spec_timing;               ///< 0x3ac [R/W]: DRAM Off-spec timing Register
    uint32_t CH0_Refresh_timing;                ///< 0x390 [R/W]: DRAM Refresh Timing Register
    uint32_t CH0_SelfRefresh_timing;            ///< 0x394 [R/W]: DRAM Self-refresh Timing Register
    uint32_t CH0_ZQC_Timing_0;                  ///< 0x388 [R/W]: DRAM ZQC Timing Register 0
    uint32_t CH0_ZQC_Timing_1;                  ///< 0x38C [R/W]: DRAM ZQC Timing Register 1
    uint32_t CH0_DRAM_Control_1;                ///< 0x340 [R/W]: DRAM Control Register 1
    uint32_t CH0_DRAM_Control_2;                ///< 0x344 [R/W]: DRAM Control Register 2
    uint32_t CH0_DRAM_Config_1;                 ///< 0x300 [R/W]: DRAM Configuration Register 1
    uint32_t CH0_DRAM_Config_2;                 ///< 0x304 [R/W]: DRAM Configuration Register 2
    uint32_t CH0_PHY_Control_1;                 ///< 0x400 [R/W]: PHY Control Register 1
    uint32_t CH0_PHY_Control_2;                 ///< 0x404 [R/W]: PHY Control Register 2
    uint32_t CH0_PHY_Control_3;                 ///< 0x408 [R/W]: PHY Control Register 3
    uint32_t CH0_PHY_Control_4;                 ///< 0x40c [R/W]: PHY Control Register 4
    uint32_t CH0_PHY_Control_5;                 ///< 0x410 [R/W]: PHY Control Register 5
    uint32_t CH0_PHY_Control_8;                 ///< 0x41c [R/W]: PHY Control Register 8
    uint32_t CH0_PHY_Control_9a;                ///< 0x420 [R/W]: PHY Control Register 9
    uint32_t CH0_PHY_Control_11;                ///< 0x428 [R/W]: PHY Control Register 11
    uint32_t CH0_PHY_Control_13;                ///< 0x430 [R/W]: PHY Control Register 13
    uint32_t CH0_PHY_Control_14;                ///< 0x434 [R/W]: PHY Control Register 14
    uint32_t CH0_PHY_Control_15;                ///< 0x438 [R/W]: PHY Control Register 15
    uint32_t CH0_PHY_Control_16;                ///< 0x43C [R/W]: PHY Control Register 16
    uint32_t CH0_PHY_Data_Byte_Control_B0;      ///< 0x540 [R/W]: PHY Data Byte Control B0
    uint32_t CH0_PHY_Data_Byte_Control_B1;      ///< 0x540 [R/W]: PHY Data Byte Control B0
    uint32_t CH0_PHY_Data_Byte_Control_B2;      ///< 0x540 [R/W]: PHY Data Byte Control B0
    uint32_t CH0_PHY_Data_Byte_Control_B3;      ///< 0x544 [R/W]: PHY Data Byte Control B1
    uint32_t PHY_pwr_ctl;                       ///< 0x054 [R/W]: PHY Power Control Register
    uint32_t CH0_PHY_DLL_control_B0;            ///< 0x500 [R/W]: PHY DLL Control Register
    uint32_t CH0_PHY_DLL_control_B1;            ///< 0x504 [R/W]: PHY DLL Control Register
    uint32_t CH0_PHY_DLL_control_B2;            ///< 0x504 [R/W]: PHY DLL Control Register
    uint32_t CH0_PHY_DLL_control_B3;            ///< 0x504 [R/W]: PHY DLL Control Register
    uint32_t CH0_PHY_Control_9b;                ///< 0x420 [R/W]: PHY Control Register 9
    uint32_t CH0_PHY_Control_9c;                ///< 0x420 [R/W]: PHY Control Register 9
    uint32_t CH0_PHY_Control_9d;                ///< 0x420 [R/W]: PHY Control Register 9
    uint32_t CH0_DRAM_Config_3a;                ///< 0x308 [R/W]: DRAM Configuration Register 3
    uint32_t USER_COMMAND_0a;                   ///< 0x020 [R/W]: User Initiated Command Register 0
    uint32_t CH0_DRAM_Config_3b;                ///< 0x308 [R/W]: DRAM Configuration Register 3
    uint32_t USER_COMMAND_0b;                   ///< 0x020 [R/W]: User Initiated Command Register 0
    uint32_t USER_COMMAND_0c;                   ///< 0x020 [R/W]: User Initiated Command Register 0
    uint32_t CH0_DRAM_Config_3c;                ///< 0x308 [R/W]: DRAM Configuration Register 3
    uint32_t USER_COMMAND_0d;                   ///< 0x020 [R/W]: User Initiated Command Register 0

    /* RICOH add */
    uint32_t Port_priority;                     ///< 0x84 [R/W]: Port Priority Control Register
} DDR_config_t;

/*------------------------------------------------------------------------
            Prototypes
------------------------------------------------------------------------*/

void set_DDR_configuration(const DDR_config_t *DDR_config_record, cs_sa_t *startAddrs);
#endif // ifndef __DDR_CONFIG_H__
