/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2011-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/
/*------------------------------------------------------------------------
            Include Files
------------------------------------------------------------------------*/
#include <string.h>
#include "MC_regheaders.h"
#include "cpu_api.h"
#include "minPrintf.h"

/*------------------------------------------------------------------------
        Defines
------------------------------------------------------------------------*/

//#define msg(x,y,...) minPrintf(__VA_ARGS__)
#define msg(x,y,...) 
#define UTF_waitForMilliSecs(x) cpu_spin_delay(1000 * x)
/*------------------------------------------------------------------------
        Globals
------------------------------------------------------------------------*/

/*------------------------------------------------------------------------
        phyinit_sequence_sync2
------------------------------------------------------------------------*/
/**
 *
 * \brief Performs internal DDR clock synchronization
 *
 * \param const MC_REGS_t *mc_reg - pointer to memory controller registers
 *        volatile unsigned short ld_phase
 *        volatile unsigned short wrst_sel
 *        volatile unsigned short wckg_dly
 *        volatile unsigned short lwck_en
 * \return void (no return value)
 *
 *
 */
void phyinit_sequence_sync2(MC_REGS_t *mc_reg, volatile unsigned short ld_phase, volatile unsigned short wrst_sel, volatile unsigned short wckg_dly, volatile unsigned short int wck_en)
{
    //volatile unsigned int tmp= read(0xf1000438);
    volatile unsigned int tmp= (mc_reg->CH0_PHY_Control_15 & 0xFFFFFFF0);
                
    // sync2 procedure
    //write(0xf1000414,0x00080000 | ld_phase <<9); // ld phase
    mc_reg->CH0_PHY_Control_6 = (0x00080000 | ld_phase <<9); // ld phase
    msg(MSG_DEBUG, RAW_DATA, "PHY_Control_6 = 0x%0x\r\n", mc_reg->CH0_PHY_Control_6);

    //write(0xf1000438, tmp | wrst_sel); //wrst_sel
    mc_reg->CH0_PHY_Control_15 = (tmp | wrst_sel); //wrst_sel
    msg(MSG_DEBUG, RAW_DATA, "PHY_Control_15 = 0x%0x\r\n", mc_reg->CH0_PHY_Control_15);
                                        
    //write(0xf100043c,0x0 | wckg_dly << 4|wck_en<<0);  //wckg_delay, wck
    mc_reg->CH0_PHY_Control_16 = ((wckg_dly << 4) | (wck_en<<0));  //wckg_delay, wck
    msg(MSG_DEBUG, RAW_DATA, "PHY_Control_16 = 0x%0x\r\n", mc_reg->CH0_PHY_Control_16);

    //write(MC5_BASE + 0x0420 , 0x80000000);
    mc_reg->CH0_PHY_Control_9 = 0x80000000;
    msg(MSG_DEBUG, RAW_DATA, "PHY_Control_9 = 0x%0x\r\n", mc_reg->CH0_PHY_Control_9);
}

/*------------------------------------------------------------------------
        calDDRPHYPads
------------------------------------------------------------------------*/
/**
 *
 * \brief Performs auto cal on DDR pads
 *
 * \param const MC_REGS_t *mc_reg - pointer to memory controller registers
 *        uint32_t *zpr - p portion of drive strength
 *        uint32_t *znr - n portion of drive strength
 * \return void (no return value)
 *
 *
 */
void calDDRPHYPads(MC_REGS_t *mc_reg, uint32_t *zpr, uint32_t *znr)
{
    int i;
    //unsigned char z;
    uint32_t timeout;
    uint32_t tempZPR = 0;
    uint32_t tempZNR = 0;

    msg(MSG_INFO, RAW_DATA, "Entering calDDRPHYPads.\r\n");
    //init drive strengths
    *zpr = 0;
    *znr = 0;
    //set values to 0
    mc_reg->CH0_PHY_Control_2 =
        MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_REPLACE_VAL( \
        MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_REPLACE_VAL( \
        MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_REPLACE_VAL( \
        MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_REPLACE_VAL( \
        MC_CH0_PHY_CONTROL_2_PHY_DQ_ZD_REPLACE_VAL( \
        mc_reg->CH0_PHY_Control_2, 0), 0), 0), 0), 0);
    mc_reg->CH0_PHY_Control_3 =
        MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_REPLACE_VAL( \
        MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_REPLACE_VAL( \
        MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_REPLACE_VAL( \
        MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_REPLACE_VAL( \
        MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZD_REPLACE_VAL( \
        mc_reg->CH0_PHY_Control_3, 0), 0), 0), 0), 0);

    //set pad cal interval
    mc_reg->CH0_PHY_Control_5 =   MC_CH0_PHY_CONTROL_5_PAD_CAL_INTERVAL_REPLACE_VAL(mc_reg->CH0_PHY_Control_5, 3);

    //perform cal 10 times and average results
    for(i=0; i<10; i++)
    {
        do
        {
            timeout = 1000;
            mc_reg->CH0_PHY_Control_5 = MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_REPLACE_VAL( \
                                        mc_reg->CH0_PHY_Control_5, 0x1);
            while ( (!(mc_reg->CH0_PHY_Control_9 & MC_CH0_PHY_CONTROL_9_PHY_CAL_DONE_MASK)) && --timeout );

            if (timeout == 0) 
            {
                msg(MSG_INFO, RAW_DATA, "Calibration timeout.  Retrying...\r\n");
            }

        } while ( (mc_reg->CH0_PHY_Control_9 & MC_CH0_PHY_CONTROL_9_PHY_CAL_ERR_MASK) || (timeout == 0) );

        tempZPR = MC_CH0_PHY_CONTROL_9_PHY_CAL_ZPR_MASK_SHIFT(mc_reg->CH0_PHY_Control_9);
        tempZNR = MC_CH0_PHY_CONTROL_9_PHY_CAL_ZNR_MASK_SHIFT(mc_reg->CH0_PHY_Control_9);
        msg(MSG_INFO, RAW_DATA, "zpr = 0x%04x   znr = 0x%04x\r\n", tempZPR, tempZNR);
        *zpr += tempZPR;
        *znr += tempZNR;
        mc_reg->CH0_PHY_Control_5 = MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_REPLACE_VAL( \
                                    mc_reg->CH0_PHY_Control_5, 0x0);
        UTF_waitForMilliSecs(5);
    }
    *zpr = *zpr/10;
    *znr = *znr/10;

    return;
}

