/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

#ifndef __DDR4_TRAINING_H__
#define __DDR4_TRAINING_H__

/*------------------------------------------------------------------------
            Include Files
------------------------------------------------------------------------*/

/*------------------------------------------------------------------------
            Structs
------------------------------------------------------------------------*/
#define DDR_INIT_NUM_WIN 5
typedef struct vref_twin_s
{
    uint16_t size[DDR_INIT_NUM_WIN];       // window size
    uint16_t firstPass[DDR_INIT_NUM_WIN];  // starting point of corresponding window size
    uint16_t lastPass[DDR_INIT_NUM_WIN];   // ending point of corresponding window size
} vref_twin_t;

/*------------------------------------------------------------------------
            Prototypes
------------------------------------------------------------------------*/

void dram_vref_training(MC_REGS_t *mc_reg, uint16_t mem_width, uint16_t winPos);
void phy_vref_training(MC_REGS_t *mc_reg, uint16_t mem_width, uint16_t winPos);
uint16_t selValue (uint8_t passArray[64], uint8_t numVrefDqSteps, uint16_t winPos);
#endif // ifndef __DDR4_TRAINING_H__
