/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

#ifndef __UTF_DDR_GS2_CONFIG_H__
#define __UTF_DDR_GS2_CONFIG_H__

#define MCConfig_jedec_ddr4_8g_x16_2400u_400_x16 \
{    \
    .CH0_PHY_Control_6=                0x00080000,    /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,   /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020635,    /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
	.CH0_DRAM_Config_5_CS0=            0x00110000,    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,    /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
	.CH0_PreCharge_Timing=             0x01106406,    /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x0c14060e,    /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b640048,    /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x00000028,    /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x000000a0,    /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x00b53881,    /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00070401,    /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x008c00c3,    /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,    /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,    /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,    /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030a932,    /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000000,    /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,    /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb1000b,    /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,    /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300501,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,    /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000031,    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x03800000,    /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,    /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x17050003,    /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000020,    /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,    /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,    /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .PHY_pwr_ctl=                      0x001f0ff1,    /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,    /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,    /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x01001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x01171000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x022f1000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}


#define MCConfig_jedec_ddr4_8g_x16_2400u_533_x16 \
{    \
    .CH0_PHY_Control_6=                0x00080000,    /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,   /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020635,    /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
	.CH0_DRAM_Config_5_CS0=            0x00110000,    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,    /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
	.CH0_PreCharge_Timing=             0x01108408,    /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x101a0813,    /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b640048,    /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x00000028,    /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x000000d6,    /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x00eda069,    /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00070401,    /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00bb00c3,    /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,    /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,    /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,    /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030a932,    /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000000,    /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,    /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb1000b,    /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
	.CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,    /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300501,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,    /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000031,    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x03800000,    /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,    /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x17050003,    /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000020,    /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,    /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,    /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .PHY_pwr_ctl=                      0x001f0ff1,    /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,    /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,    /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x01001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x01171000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x022f1000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}


#define MCConfig_jedec_ddr4_8g_x16_2400u_600_x16 \
{    \
    .CH0_PHY_Control_6=                0x00080000,    /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,   /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020635,    /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
	.CH0_DRAM_Config_5_CS0=            0x00110000,    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,    /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
	.CH0_PreCharge_Timing=             0x01109509,    /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x121d0915,    /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b640058,    /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x00000028,    /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x000000f0,    /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x0105d4c1,    /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00070401,    /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00d200c3,    /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0d8b200,    /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,    /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,    /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030a932,    /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000000,    /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,    /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb1000b,    /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
	.CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,    /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300501,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,    /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000031,    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x03800000,    /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,    /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x17050002,    /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,    /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,    /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,    /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .PHY_pwr_ctl=                      0x001f0ff1,    /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,    /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,    /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x01001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x01171000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x022f1000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}


#define MCConfig_jedec_ddr4_8g_x16_2400u_625_x16 \
{    \
    .CH0_PHY_Control_6=                0x00080000,    /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,   /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020635,    /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
	.CH0_DRAM_Config_5_CS0=            0x00110000,    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,    /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
	.CH0_PreCharge_Timing=             0x0110a509,    /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x131e0916,    /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b640058,    /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x00000028,    /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x000000fa,    /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x0111e849,    /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00070401,    /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00db00c3,    /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0e1b200,    /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,    /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,    /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030a932,    /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000000,    /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,    /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb1000b,    /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,    /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300501,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,    /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000031,    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x03800000,    /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,    /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x17050003,    /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,    /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,    /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,    /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .PHY_pwr_ctl=                      0x001f0ff1,    /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,    /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,    /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x01001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x01171000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x022f1000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}


#define MCConfig_jedec_ddr4_8g_x16_2400u_667_x16 \
{    \
    .CH0_PHY_Control_6=                0x00080000,    /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,   /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020635,    /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
	.CH0_DRAM_Config_5_CS0=            0x00110000,    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,    /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
	.CH0_PreCharge_Timing=             0x0110b60a,    /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x15200a17,    /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x5b640068,    /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x00000028,    /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x0000010b,    /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x01220919,    /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00070401,    /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00ea00c3,    /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0f1b200,    /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,    /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,    /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030c932,    /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000000,    /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,    /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb1000b,    /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,    /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300501,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,    /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000031,    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x03800000,    /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,    /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x17050002,    /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,    /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,    /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,    /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .PHY_pwr_ctl=                      0x001f0ff1,    /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,    /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,    /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x01001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x01171000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x022f1000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}


#define MCConfig_jedec_ddr4_8g_x16_2400u_800_x16 \
{    \
    .CH0_PHY_Control_6=                0x00080000,    /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,   /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020635,    /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
	.CH0_DRAM_Config_5_CS0=            0x00110000,    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,    /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
	.CH0_PreCharge_Timing=             0x0110c60c,    /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x18270c1c,    /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x6b640068,    /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x00000028,    /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00000140,    /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x01567101,    /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00070401,    /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x011800c3,    /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb120b200,    /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,    /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,    /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030c932,    /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000000,    /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,    /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb1000b,    /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,    /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300501,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,    /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000031,    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x03800000,    /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,    /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x17050002,    /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,    /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,    /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,    /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .PHY_pwr_ctl=                      0x001f0ff1,    /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,    /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,    /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x01001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x01171000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x022f1000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt40a256m16_093_625_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,    /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17_=               0x00000407,    /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x06020535,    /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00100000,    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,    /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x02010000,    /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,    /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x40000000,    /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,    /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,    /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x40000000,    /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x0110a509,    /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x131e0916,    /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b540058,    /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x00000028,    /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x0004c4b4,    /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x0111e849,    /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00070401,    /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00bc0f3c,    /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,    /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,    /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,    /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030a93b,    /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000000,    /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,    /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb1000b,    /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    /*.CH0_PHY_Control_3=                0x0330000a,*/     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_3=                0x0bb0000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,    /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    /*.CH0_PHY_Control_5=                0x00300501,*/     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_5=                0x00300507,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,    /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    /*.CH0_PHY_Control_11=               0x00000051,*/    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_11=               0x00000071,    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,    /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,    /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    /*.CH0_PHY_Control_15=               0x17050002,*/    /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_15=               0xa2050002,    /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,    /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,    /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,    /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,    /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,    /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,    /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,    /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,    /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,    /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,    /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x01001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x01171000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    /*.CH0_DRAM_Config_3c=               0x00171000, */   /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .CH0_DRAM_Config_3c=               0x02221500,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

// The original struct below has the following DDR4 timing parameters programmed:
//  CL: 12 (should be 11 or 12)
//  CWL: 9 (should be 11)
//  tRp: 12 (should be 11)
//  tFAW: 24 (should be 28)
//  tRC: 39 (should be 39)
//  tRCD: 12 (should be 11)
//  tRAS: 28 (should be 28)
//  tRRD: 5 (should be 6)
//  tRRDS: 11 (should be 5)
//  tCCD: 5 (should be 5)
//  tCCDS: 4 (should be 4)
//  tWTR: 6 (should be 6)
//  tWTRS: 8 (should be 2)
#define mt40a256m16_093_800_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x06020535,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    /*.CH0_DRAM_Config_5_CS0=            0x00110000,*/    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    /*.CH0_DRAM_Config_5_CS0=            0x10110000,*/    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00100000,    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x02010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x40000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x40000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    /*.CH0_PreCharge_Timing=             0x0110a509,*/    /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_PreCharge_Timing=             0x0110c60c,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    /*.CH0_ACT_timing=                   0x131e0916,*/    /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_ACT_timing=                   0x18270c1c,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    /*.CH0_CAS_RAS_timing=               0x4b540058,*/    /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_CAS_RAS_timing=               0x5b540068,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x00000028,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    /*.CH0_DDR_init_timing_control_0=    0x0004c4b4,*/    /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_0=    0x00061a80,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    /*.CH0_DDR_init_timing_control_1=    0x0111e849,*/    /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_DDR_init_timing_control_1=    0x01567101,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00070401,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    /*.CH0_Refresh_timing=               0x00f009c0,*/    /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    /*.CH0_Refresh_timing=               0x00f01380,  */   /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_Refresh_timing=               0x00f009C0,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    /*.CH0_SelfRefresh_timing=           0xb0c8b200,*/    /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0f8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    /*.CH0_DRAM_Config_1=                0x0030a93b,*/    /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_1=                0x0030c93b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000000,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    /*.CH0_PHY_Control_2=                0x1bb1000b,*/    /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_2=                0x1bb1000b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    /*.CH0_PHY_Control_3=                0x0330000a, */    /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_3=                0x0bb0000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    /*.CH0_PHY_Control_5=                0x00300501,*/     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    /*.CH0_PHY_Control_5=                0x0030051f,*/     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_5=                0x00300507,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    /*.CH0_PHY_Control_11=               0x00000051,*/    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    /*.CH0_PHY_Control_11=               0x00000041,*/    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_11=               0x00000071,    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    /*.CH0_PHY_Control_15=               0x17050002,*/     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    /*.CH0_PHY_Control_15=               0xa2050002,*/    /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_15=               0xaf050002,    /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,    /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,    /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,    /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,    /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,    /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,    /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,    /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,    /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,    /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,    /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x01001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x01171000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    /*.CH0_DRAM_Config_3c=               0x00171000, */   /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    /*.CH0_DRAM_Config_3c=               0x02221500,*/    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .CH0_DRAM_Config_3c=               0x022f1000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt40a256m16_093_1066_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,    /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,    /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x06020535,    /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    /*.CH0_DRAM_Config_5_CS0=            0x00110000,*/    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    /*.CH0_DRAM_Config_5_CS0=            0x10110000,*/    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00100000,    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,    /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x02010000,    /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,    /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x40000000,    /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,    /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,    /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x40000000,    /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    /*.CH0_PreCharge_Timing=             0x0110a509,*/    /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_PreCharge_Timing=             0x0110f80f,    /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    /*.CH0_ACT_timing=                   0x131e0916,*/    /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_ACT_timing=                   0x18320f23,    /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    /*.CH0_CAS_RAS_timing=               0x4b540058,*/    /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_CAS_RAS_timing=               0x7b640098,    /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x00000028,    /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    /*.CH0_DDR_init_timing_control_0=    0x0004c4b4,*/    /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_0=    0x00082208,    /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    /*.CH0_DDR_init_timing_control_1=    0x0111e849,*/    /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_DDR_init_timing_control_1=    0x01cb40d2,    /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00070401,    /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    /*.CH0_Refresh_timing=               0x024b207b,*/    /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_Refresh_timing=               0x024b1380,    /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    /*.CH0_SelfRefresh_timing=           0xb0c8b200,*/    /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb256b300,    /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0400,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00a00200,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,    /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,    /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    /*.CH0_DRAM_Config_1=                0x0030a93b,*/    /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_1=                0x0030fe3b,    /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00040000,    /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,    /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    /*.CH0_PHY_Control_2=                0x1bb1000b,*/    /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_2=                0x1bb1000b,    /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    /*.CH0_PHY_Control_3=                0x0330000a,*/     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_3=                0x0bb0000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,    /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    /*.CH0_PHY_Control_5=                0x00300501,*/     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    /*.CH0_PHY_Control_5=                0x0030051f,*/     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_5=                0x00300507,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,    /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    /*.CH0_PHY_Control_11=               0x00000051,*/    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    /*.CH0_PHY_Control_11=               0x00000041,*/    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_11=               0x00000071,    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,    /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,    /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    /*.CH0_PHY_Control_15=               0x17050002,*/    /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    /*.CH0_PHY_Control_15=               0xa2050002,*/    /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_15=               0xaf050002,    /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x01001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x01171000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    /*.CH0_DRAM_Config_3c=               0x00171000,*/    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    /*.CH0_DRAM_Config_3c=               0x02221500,*/    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .CH0_DRAM_Config_3c=               0x022f1000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt40a512m16_083_800_x16_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x04020635,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    /*.CH0_DRAM_Config_5_CS0=            0x00110000,*/    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    /*.CH0_DRAM_Config_5_CS0=            0x10110000,*/    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00100000,    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    /*.CH0_PreCharge_Timing=             0x0110a509,*/    /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_PreCharge_Timing=             0x0110c60c,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    /*.CH0_ACT_timing=                   0x131e0916,*/    /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_ACT_timing=                   0x18270c1c,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    /*.CH0_CAS_RAS_timing=               0x4b540058,*/    /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_CAS_RAS_timing=               0x5b540068,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x00000028,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    /*.CH0_DDR_init_timing_control_0=    0x0004c4b4,*/    /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_0=    0x00061a80,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    /*.CH0_DDR_init_timing_control_1=    0x0111e849,*/    /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_DDR_init_timing_control_1=    0x01567101,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00070401,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    /*.CH0_Refresh_timing=               0x00f009c0,*/    /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    /*.CH0_Refresh_timing=               0x00f01380,  */   /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_Refresh_timing=               0x00f009C0,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    /*.CH0_SelfRefresh_timing=           0xb0c8b200,*/    /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0f8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    /*.CH0_DRAM_Config_1=                0x0030a93b,*/    /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_1=                0x0030c93a,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000000,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    /*.CH0_PHY_Control_2=                0x1bb1000b,*/    /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_2=                0x1bb1000b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    /*.CH0_PHY_Control_3=                0x0330000a, */    /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_3=                0x0bb0000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    /*.CH0_PHY_Control_5=                0x00300501,*/     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    /*.CH0_PHY_Control_5=                0x0030051f,*/     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_5=                0x00300507,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    /*.CH0_PHY_Control_11=               0x00000051,*/    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    /*.CH0_PHY_Control_11=               0x00000041,*/    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_11=               0x00000071,    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    /*.CH0_PHY_Control_15=               0x17050002,*/     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    /*.CH0_PHY_Control_15=               0xa2050002,*/    /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_15=               0xaf050002,    /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,    /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,    /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,    /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .PHY_pwr_ctl=                      0x00000ff1,    /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,    /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,    /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x01001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x01171000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    /*.CH0_DRAM_Config_3c=               0x00171000, */   /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    /*.CH0_DRAM_Config_3c=               0x02221500,*/    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .CH0_DRAM_Config_3c=               0x022f1000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}


#define mt40a512m16_083_625_x16_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,    /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=                0x00000407,   /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x04020635,    /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00100000,    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,    /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
	.CH0_PreCharge_Timing=             0x0110a509,    /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x131e0916,    /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b540058,    /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x00000028,    /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x0004c4b4,    /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x0111e849,    /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00070401,    /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00bc0f3c,    /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,    /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,    /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,    /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030a932,    /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000000,    /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,    /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb1000b,    /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    /*.CH0_PHY_Control_3=                0x0330000a,*/     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_3=                0x0bb0000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,    /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    /*.CH0_PHY_Control_5=                0x00300501,*/     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_5=                0x00300507,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,    /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    /*.CH0_PHY_Control_11=               0x00000051,*/    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_11=               0x00000071,    /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,    /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,    /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    /*.CH0_PHY_Control_15=               0x17050002,*/    /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_15=               0xa2050002,    /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,    /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,    /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,    /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .PHY_pwr_ctl=                      0x00000ff1,    /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,    /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,    /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,    /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x01001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x01171000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    /*.CH0_DRAM_Config_3c=               0x00171000, */   /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .CH0_DRAM_Config_3c=               0x02221500,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x11400000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}




#define mt41j256m16_93_333_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x02010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x40000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x40000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00505405,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x0c10050b,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b440048,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00028a66,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x009d0429,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x005700c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b0200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030552b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000003,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000020,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41j256m16_93_400_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x02010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x40000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x40000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00606406,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x0e13060e,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b440048,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00030d41,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x00b53881,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x006800c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030652b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000003,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000020,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41j256m16_93_600_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x02010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x40000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x40000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00809508,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x151c0814,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b440058,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x000493e1,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x0105d4c1,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x009c00c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030972b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41j256m16_93_667_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x02010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x40000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x40000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x0090a509,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x1e210918,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x5b440058,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x000516bc,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x010e0918,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00ae00c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0x70b57200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030972b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41j256m16_93_800_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x02010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x40000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x40000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00b0c60b,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x1c250b1b,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x5b440068,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00061a81,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x01567101,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00d000c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0d8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030b82b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}


#define mt41j256m16_93_1066_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x02010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x40000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x40000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00e1080e,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x26320e24,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x7b440088,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x00000104,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00082209,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x01c340d1,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x011600c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb120b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b02ab,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00560156,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030ea2b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k512m8_107_400_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05010632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000f0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x02010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x80000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x80000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00606406,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x0b14060e,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b440048,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00030d41,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x00b53881,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x006800c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030652b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0bb0000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    /*.CH0_PHY_Control_5=                0x00300519, */    /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000003,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000020,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k512m8_107_400_x16_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05010632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x02010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x80000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x80000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00606406,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x0b14060e,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b440048,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00030d41,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x00b53881,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x006800c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030652a,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    /*.CH0_PHY_Control_5=                0x00300519, */    /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000003,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000020,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000700,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000700,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k512m8_107_600_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05010632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000f0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x02010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00110000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x80000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x80000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00909509,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x111e0915,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b440058,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x000493e1,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x0105d4c1,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000521,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x009c00c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030972b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0bb0000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300518,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k512m8_107_600_x16_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05010632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x02010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00110000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x80000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x80000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00909509,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x111e0915,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b440058,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x000493e1,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x0105d4c1,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000521,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x009c00c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030972a,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0bb0000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300518,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k512m8_107_800_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05010632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000f0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x02010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x80000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x80000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00c0c60c,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x16280c1c,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b440068,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00061a81,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x01567101,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000521,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00d000c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0d8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030b82b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    /*.CH0_PHY_Control_1=                0x00004040,*/     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_1=                0x00004050,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0bb0000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    /*.CH0_PHY_Control_5=                0x00300519, */    /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_5=                0x00300518,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}



#define mt41k512m8_107_mt41j512m8_125_333_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05010632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000f0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x05010632,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x800f0001,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x00000100,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00505405,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x0e11050c,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b540048,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00028a66,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x009d0429,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x005700c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030652b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0770000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000003,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000020,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}


#define mt41k512m8_107_mt41j512m8_125_400_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05010632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    /*.CH0_DRAM_Config_5_CS0=            0x00110000, */    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000f0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x05010632,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    /*.CH0_DRAM_Config_5_CS1=            0x00100000, */    /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x800f0001,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x00000100,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00606406,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x1014060e,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b540048,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00030d41,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x00b53881,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x006800c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    /*.CH0_DRAM_Control_1=               0x08040201, */    /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030652b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    /*.CH0_PHY_Control_3=                0x0330000a, */    /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_3=                0x0770000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000003,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000020,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k512m8_107_mt41j512m8_125_600_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05010632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000f0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x05010632,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x800f0001,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x00000100,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00909509,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x121e0915,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b540058,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x000493e1,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x0105d4c1,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x009c00c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030972b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0770000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k512m8_107_mt41j512m8_125_800_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05010632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    /*.CH0_DRAM_Config_5_CS0=            0x00110000, */    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    /*.CH0_DRAM_Config_5_CS0=            0x02510000, */    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    /*.CH0_DRAM_Config_5_CS0=            0x02110000, */    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_DRAM_Config_5_CS0=            0x02410000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000f0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x05010632,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    /*.CH0_DRAM_Config_5_CS1=            0x00100000,*/     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_DRAM_Config_5_CS1=            0x02410000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x800f0001,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x00000100,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00c0c60c,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x18280c1c,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x5b540068,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00061a81,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x01567101,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000521,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00d000c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0d8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    /*.CH0_DRAM_Control_1=               0x08040201,*/     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_1=               0x08041323,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030b82b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004050,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0bb0000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    /*.CH0_PHY_Control_3=                0x0330000a,*/     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300518,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    /*.CH0_PHY_Control_15=               0x00000002,*/     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_15=               0xa2050002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    /*.CH0_PHY_DLL_control_B0=           0x12120000, */    /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    /*.CH0_PHY_DLL_control_B1=           0x12120000, */    /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    /*.CH0_PHY_DLL_control_B2=           0x12120000, */    /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    /*.CH0_PHY_DLL_control_B3=           0x12120000, */    /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x21170000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x21170000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x21170000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x21170000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define CobraDIMM_800_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05010632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    /*.CH0_DRAM_Config_5_CS0=            0x00110000, */    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    /*.CH0_DRAM_Config_5_CS0=            0x02510000, */    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    /*.CH0_DRAM_Config_5_CS0=            0x02110000, */    /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_DRAM_Config_5_CS0=            0x02410000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x05010632,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    /*.CH0_DRAM_Config_5_CS1=            0x00100000,*/     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_DRAM_Config_5_CS1=            0x02410000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x800f0801,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x00000100,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00c0c60c,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x18280c1c,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x5b540068,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00061a81,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x01567101,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000521,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    /*.CH0_Off_spec_timing=              0x00001743,*/     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00d000c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0d8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    /*.CH0_DRAM_Control_1=               0x08040201,*/     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_1=               0x08041323,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030b82b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004050,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0bb0000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    /*.CH0_PHY_Control_3=                0x0330000a,*/     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300518,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define h5tq4g83afr_rd_667_x16_INIT_DATA \
{    \
    .CH0_PHY_Control_6 =               0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17 =              0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0 =                       0x04010632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0 =           0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0 =                       0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PreCharge_Timing =            0x00a0b60a,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing =                  0x13210a17,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing =              0x4b440068,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing =                  0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0 =   0x000516be,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1 =   0x01220919,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing =             0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing =              0x00ae00c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing =          0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_DRAM_Control_1 =              0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2 =              0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1 =               0x0030b822,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2 =               0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1 =               0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2 =               0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3 =               0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4 =               0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5 =               0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8 =               0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a =              0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11 =              0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13 =              0x03800000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14 =              0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15 =              0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16 =              0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0 =    0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1 =    0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .PHY_pwr_ctl =                     0x001f0ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0 =          0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1 =          0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b =              0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c =              0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d =              0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k256m16_125_333_x16_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x04020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000d0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x01010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x20000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x01010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x20000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00505405,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x0e11050c,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b440048,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00028a66,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x009d0429,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x005700c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030552a,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000003,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000020,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000700,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000700,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k256m16_125_400_x16_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x04020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000d0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x01010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x20000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x01010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x20000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00606406,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x1014060e,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b440048,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00030d41,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x00b53881,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x006800c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030652a,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000003,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000020,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000700,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000700,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k256m16_125_533_x16_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x04020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000d0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x01010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x20000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x01010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x20000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00808408,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x161a0813,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b440048,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00041105,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x00eda069,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x008b00c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030762a,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000003,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000020,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000700,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000700,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k256m16_125_600_x16_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x04020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000d0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x01010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x20000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x01010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x20000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00909509,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x181e0915,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x5b440058,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x000493e1,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x0105d4c1,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x009c00c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030972a,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000700,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000700,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k256m16_125_667_x16_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x04020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000d0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x01010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x20000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x01010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x20000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x0090a509,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x1e210918,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x5b440058,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x000516bc,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x010e0918,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00ae00c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0x70b57200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030972a,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000700,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000700,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k256m16_125_800_x16_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */   \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x04020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000d0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x01010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x20000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x01010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x20000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00b0c60b,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x20270b1c,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x6b440068,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00061a81,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x01567101,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00d000c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0d8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030b82a,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000700,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000700,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k256m16_125_mt41k256m16_125_333_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x05020532,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x400e0001,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x80000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00505405,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x0e11050c,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b440048,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00028a66,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x009d0429,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x005700c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030552b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0770000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000003,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000020,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k256m16_125_mt41k256m16_125_400_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x05020532,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x400e0001,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x80000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00606406,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x1014060e,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b440048,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00030d41,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x00b53881,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x006800c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030652b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0770000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000003,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000020,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k256m16_125_mt41k256m16_125_600_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x05020532,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x400e0001,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x80000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00909509,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x181e0915,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x5b440058,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x000493e1,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x0105d4c1,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x009c00c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030972b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0770000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k256m16_125_mt41k256m16_125_800_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x05020532,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x400e0001,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x80000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00b0c60b,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x20270b1c,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x6b440068,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00061a81,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x01567101,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    /*.CH0_Off_spec_timing=              0x00000421,*/     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Off_spec_timing=              0x00001743,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00d000c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0d8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030b82b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0770000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k512m8_107_333_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05010632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0=                        0x000f0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x02010000,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00100000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x80000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0x80000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00505405,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x0911050c,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x4b440048,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00028a66,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x009d0429,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x005700c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030552b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000003,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000020,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}


#define mt41k1G8_125_mt41k1G8_125_800_x32_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000C07,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05010632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
	.CH0_MMAP0=                        0x000f0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PMAP1=                        0x05010632,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00110000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 */ \
    .CH0_MMAP1=                        0x800f0801,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00100000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 */ \
    .CH0_MMAP2=                        0xaf000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 */ \
    .CH0_PreCharge_Timing=             0x00b0c60b,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x18270b1c,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x5b440068,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00061a81,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x01567101,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000744,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00d000c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0d8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,    /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,    /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1=                0x0030b82b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004050,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3=                0x0bb0000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4=                0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,    /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,    /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

// GS2 x16 settings
#define mt41k512m16_125_400_x16_INIT_DATA \
{    \
    .CH0_PHY_Control_6 =               0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17 =              0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0 =                       0x04020632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0 =           0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0 =                       0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PreCharge_Timing =            0x00606406,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing =                  0x1014060e,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing =              0x4b440048,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing =                  0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0 =   0x00030d41,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1 =   0x00b53881,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing =             0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing =              0x008c00c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing =          0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_DRAM_Control_1 =              0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2 =              0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1 =               0x00306522,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2 =               0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1 =               0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2 =               0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3 =               0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4 =               0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5 =               0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8 =               0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a =              0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11 =              0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13 =              0x03800000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14 =              0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15 =              0x00000003,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16 =              0x00000020,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0 =    0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1 =    0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .PHY_pwr_ctl =                     0x001f0ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0 =          0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1 =          0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b =              0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c =              0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d =              0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k512m16_125_533_x16_INIT_DATA \
{    \
    .CH0_PHY_Control_6 =               0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17 =              0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0 =                       0x04020632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0 =           0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0 =                       0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PreCharge_Timing =            0x00808408,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing =                  0x161a0813,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing =              0x4b440048,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing =                  0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0 =   0x00041105,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1 =   0x00eda069,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing =             0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing =              0x00bb00c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing =          0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_DRAM_Control_1 =              0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2 =              0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1 =               0x00307622,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2 =               0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1 =               0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2 =               0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3 =               0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4 =               0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5 =               0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8 =               0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a =              0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11 =              0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13 =              0x03800000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14 =              0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15 =              0x00000003,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16 =              0x00000020,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0 =    0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1 =    0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .PHY_pwr_ctl =                     0x001f0ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0 =          0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1 =          0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b =              0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c =              0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d =              0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k512m16_125_600_x16_INIT_DATA \
{    \
    .CH0_PHY_Control_6 =               0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17 =              0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0 =                       0x04020632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0 =           0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0 =                       0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PreCharge_Timing =            0x00909509,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing =                  0x181e0915,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing =              0x5b440058,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing =                  0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0 =   0x000493e1,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1 =   0x0105d4c1,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing =             0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing =              0x00d200c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing =          0xb0d8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_DRAM_Control_1 =              0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2 =              0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1 =               0x00309722,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2 =               0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1 =               0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2 =               0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3 =               0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4 =               0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5 =               0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8 =               0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a =              0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11 =              0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13 =              0x03800000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14 =              0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15 =              0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16 =              0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0 =    0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1 =    0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .PHY_pwr_ctl =                     0x001f0ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0 =          0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1 =          0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b =              0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c =              0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d =              0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k512m16_125_625_x16_INIT_DATA \
{    \
    .CH0_PHY_Control_6 =               0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17 =              0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0 =                       0x04020632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0 =           0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0 =                       0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PreCharge_Timing =            0x0090a509,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing =                  0x191f0916,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing =              0x5b440058,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing =                  0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0 =   0x0004c4b5,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1 =   0x0111e849,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing =             0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing =              0x00db00c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing =          0xb0e1b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_DRAM_Control_1 =              0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2 =              0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1 =               0x00309722,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2 =               0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1 =               0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2 =               0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3 =               0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4 =               0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5 =               0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8 =               0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a =              0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11 =              0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13 =              0x03800000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14 =              0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15 =              0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16 =              0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0 =    0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1 =    0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .PHY_pwr_ctl =                     0x001f0ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0 =          0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1 =          0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b =              0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c =              0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d =              0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k512m16_125_667_x16_INIT_DATA \
{    \
    .CH0_PHY_Control_6 =               0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17 =              0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0 =                       0x04020632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0 =           0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0 =                       0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PreCharge_Timing =            0x00a0b60a,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing =                  0x1b210a18,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing =              0x6b440068,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing =                  0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0 =   0x000516be,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1 =   0x01220919,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing =             0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing =              0x00ae00c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing =          0xb0c8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_DRAM_Control_1 =              0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2 =              0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1 =               0x0030b822,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2 =               0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1 =               0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2 =               0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3 =               0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4 =               0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5 =               0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8 =               0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a =              0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11 =              0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13 =              0x03800000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14 =              0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15 =              0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16 =              0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0 =    0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1 =    0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .PHY_pwr_ctl =                     0x001f0ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0 =          0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1 =          0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b =              0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c =              0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d =              0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#define mt41k512m16_125_800_x16_INIT_DATA \
{    \
    .CH0_PHY_Control_6 =               0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17 =              0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0 =                       0x04020632,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0 =           0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 */ \
    .CH0_MMAP0 =                       0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 */ \
    .CH0_PreCharge_Timing =            0x00b0c60b,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing =                  0x20270b1c,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing =              0x6b440068,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing =                  0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0 =   0x00061a81,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1 =   0x01567101,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing =             0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing =              0x011800c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing =          0xb120b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_DRAM_Control_1 =              0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 */ \
    .CH0_DRAM_Control_2 =              0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 */ \
    .CH0_DRAM_Config_1 =               0x0030b822,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 */ \
    .CH0_DRAM_Config_2 =               0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1 =               0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2 =               0x1bb2200b,     /* ///< 0x404 [R/W]: PHY Control Register 2 */ \
    .CH0_PHY_Control_3 =               0x0330000a,     /* ///< 0x408 [R/W]: PHY Control Register 3 */ \
    .CH0_PHY_Control_4 =               0x6462ec00,     /* ///< 0x40c [R/W]: PHY Control Register 4 */ \
    .CH0_PHY_Control_5 =               0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8 =               0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a =              0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11 =              0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13 =              0x03800000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14 =              0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15 =              0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16 =              0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0 =    0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1 =    0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .PHY_pwr_ctl =                     0x001f0ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0 =          0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1 =          0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b =              0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c =              0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d =              0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00005000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
}

#endif // ifndef __UTF_DDR_CONFIG_H__

