 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _MC_REGSTRUCTS_H_
#define _MC_REGSTRUCTS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: Mckinley 5 (MC)
//
//====================================================================

typedef struct MC_REGS_s
{
  volatile uint32_t MC_ID;  ///< 0x0 [R]: Memory Controller ID and Revision Register
  volatile uint32_t MC_STATUS;  ///< 0x4 [R/W]: Memory Controller Status Register
  volatile uint32_t DRAM_STATUS;  ///< 0x8 [R]: DRAM Status Register
  volatile uint32_t DRAM_MODE;  ///< 0xc [R]: DRAM Mode Register
  volatile uint32_t MC_WP_STAT;  ///< 0x10 [R/W]: MC Write Path Status
  volatile uint32_t MC_RP_STAT;  ///< 0x14 [R/W]: MC Read Path Status
  volatile uint32_t reserved0[2];
  volatile uint32_t USER_COMMAND_0;  ///< 0x20 [W]: User Initiated Command Register 0
  volatile uint32_t reserved1;
  volatile uint32_t USER_COMMAND_2;  ///< 0x28 [W]: User Initiated Command Register 2
  volatile uint32_t reserved2[5];
  volatile uint32_t SRAM_control;  ///< 0x40 [R/W]: Internal SRAM Control Register
  volatile uint32_t MC_Control_0;  ///< 0x44 [R/W]: MC Control Register 0
  volatile uint32_t Exclusive_Monitor;  ///< 0x48 [R/W]: Exclusive Monitor Control Register
  volatile uint32_t Coherency;  ///< 0x4c [R/W]: Data Coherency Check Control Register
  volatile uint32_t RZ_access_ctl;  ///< 0x50 [R/W]: Restrict Zone Access Control Register
  volatile uint32_t MC_pwr_ctl;  ///< 0x54 [R/W]: MC Power Control Register
  volatile uint32_t WCB_Control;  ///< 0x58 [R/W]: Write Command Buffer (WCB) Control Register
  volatile uint32_t BQ_Control;  ///< 0x5c [R/W]: Bank Queue Control Register
  volatile uint32_t ROB_Control;  ///< 0x60 [R/W]: ROB Control Register
  volatile uint32_t reserved3[7];
  volatile uint32_t Port_Weight;  ///< 0x80 [R/W]: Port RRB Weight Register
  volatile uint32_t Port_priority;  ///< 0x84 [R/W]: Port Priority Control Register
  volatile uint32_t RRB_Starvation_0;  ///< 0x88 [R/W]: RRB Starvation Prevention Register 0
  volatile uint32_t RRB_Starvation_1;  ///< 0x8c [R/W]: RRB Starvation Prevention Register 1
  volatile uint32_t Port_QoS_Visibility;  ///< 0x90 [R/W]: AXI Port QoS Visibility
  volatile uint32_t RW_Access_Ctl;  ///< 0x94 [R/W]: Read write access control
  volatile uint32_t reserved4[10];
  volatile uint32_t RegTable_Control;  ///< 0xc0 [W]: Register Table Control Register
  volatile uint32_t RegTable_Data_0;  ///< 0xc4 [R/W]: Register Table Data Register 0
  volatile uint32_t RegTable_Data_1;  ///< 0xc8 [R/W]: Register Table Data Register 1
  volatile uint32_t reserved5[13];
  volatile uint32_t PC_config0;  ///< 0x100 [R/W]: Performance Counter Configuration Register 0
  volatile uint32_t PC_config1;  ///< 0x104 [R/W]: Performance Counter Configuration Register 1
  volatile uint32_t PC_status;  ///< 0x108 [R/W]: Performance Counter Status Register
  volatile uint32_t PC_Control;  ///< 0x10c [R/W]: Performance Counter Control Register
  volatile uint32_t PC0;  ///< 0x110 [R/W]: Performance Counter Register (Instance 1 of 8)
  volatile uint32_t PC1;  ///< 0x114 [R/W]: Performance Counter Register (Instance 2 of 8)
  volatile uint32_t PC2;  ///< 0x118 [R/W]: Performance Counter Register (Instance 3 of 8)
  volatile uint32_t PC3;  ///< 0x11c [R/W]: Performance Counter Register (Instance 4 of 8)
  volatile uint32_t PC4;  ///< 0x120 [R/W]: Performance Counter Register (Instance 5 of 8)
  volatile uint32_t PC5;  ///< 0x124 [R/W]: Performance Counter Register (Instance 6 of 8)
  volatile uint32_t PC6;  ///< 0x128 [R/W]: Performance Counter Register (Instance 7 of 8)
  volatile uint32_t PC7;  ///< 0x12c [R/W]: Performance Counter Register (Instance 8 of 8)
  volatile uint32_t reserved6[4];
  volatile uint32_t ISR;  ///< 0x140 [R]: Interrupt Status Register
  volatile uint32_t IER;  ///< 0x144 [R/W]: Interrupt Enable Register
  volatile uint32_t reserved7[2];
  volatile uint32_t ADC_ERR_ID;  ///< 0x150 [R]: Address Decode Error Master ID Register
  volatile uint32_t ADC_ERR_ADR_L;  ///< 0x154 [R]: Address Decode Error Lower Address Register
  volatile uint32_t ADC_ERR_ADR_H;  ///< 0x158 [R]: Address Decode Error Higher Address Register
  volatile uint32_t reserved8;
  volatile uint32_t AM_PERIOD;  ///< 0x160 [R/W]: Activity Monitor Check Period Register
  volatile uint32_t AM_TH;  ///< 0x164 [R/W]: Activity Monitor Threshold Register
  volatile uint32_t reserved9[2];
  volatile uint32_t TZ_ERR_ID;  ///< 0x170 [R]: TrustZone Error Master ID Register
  volatile uint32_t TZ_ERR_ADR_L;  ///< 0x174 [R]: TrustZone Error Lower Address Register
  volatile uint32_t TZ_ERR_ADR_H;  ///< 0x178 [R]: TrustZone Error Higher Address Register
  volatile uint32_t reserved10[5];
  volatile uint32_t MC_ADDR_PAR_CRC_ERR;  ///< 0x190 [R]: Parity/CRC error status Register
  volatile uint32_t reserved11[12];
  volatile uint32_t Test_Control_0;  ///< 0x1c4 [W]: Test Mode Register 0
  volatile uint32_t Test_Control_1;  ///< 0x1c8 [R/W]: Test Mode Register 1
  volatile uint32_t reserved12[13];
  volatile uint32_t CH0_MMAP0;  ///< 0x200 [R/W]: Channel 0 MMAP Register CS0
  volatile uint32_t reserved13[3];
  volatile uint32_t CH0_PMAP0;  ///< 0x210 [R/W]: Channel 0 MC Physical Address Map Register CS0
  volatile uint32_t reserved14[43];
  volatile uint32_t CH0_MC_Control_1;  ///< 0x2c0 [R/W]: Channel 0 MC Control Register 1
  volatile uint32_t CH0_MC_Control_2;  ///< 0x2c4 [R/W]: Channel 0 MC Control Register 2
  volatile uint32_t CH0_MC_Control_3;  ///< 0x2c8 [R/W]: Channel 0 MC Control Register 3
  volatile uint32_t CH0_MC_Control_4;  ///< 0x2cc [R/W]: Channel 0 MC Control Register 4
  volatile uint32_t reserved15[12];
  volatile uint32_t CH0_DRAM_Config_1;  ///< 0x300 [R/W]: Channel 0 DRAM Configuration Register 1
  volatile uint32_t CH0_DRAM_Config_2;  ///< 0x304 [R/W]: Channel 0 DRAM Configuration Register 2
  volatile uint32_t CH0_DRAM_Config_3;  ///< 0x308 [R/W]: Channel 0 DRAM Configuration Register 3
  volatile uint32_t reserved16;
  volatile uint32_t CH0_DRAM_Config_5_CS0;  ///< 0x310 [R/W]: Channel 0 DRAM Configuration Register 5 CS0
  volatile uint32_t reserved17[11];
  volatile uint32_t CH0_DRAM_Control_1;  ///< 0x340 [R/W]: Channel 0 DRAM Control Register 1
  volatile uint32_t CH0_DRAM_Control_2;  ///< 0x344 [R/W]: Channel 0 DRAM Control Register 2
  volatile uint32_t reserved18[11];
  volatile uint32_t CH0_MPR_Data0;  ///< 0x374 [R]: Channel 0 Multi-Purpose Register Read Data0 Register
  volatile uint32_t CH0_MPR_Data1;  ///< 0x378 [R]: Channel 0 Multi-Purpose Register Read Data1 Register
  volatile uint32_t reserved19;
  volatile uint32_t CH0_DDR_init_timing_control_0;  ///< 0x380 [R/W]: Channel 0 DDR Initialization Timing Control Register 0
  volatile uint32_t CH0_DDR_init_timing_control_1;  ///< 0x384 [R/W]: Channel 0 DDR Initialization Timing Control Register 1
  volatile uint32_t CH0_ZQC_Timing_0;  ///< 0x388 [R/W]: Channel 0 ZQC Timing Register 0
  volatile uint32_t CH0_ZQC_Timing_1;  ///< 0x38c [R/W]: Channel 0 ZQC Timing Register 1
  volatile uint32_t CH0_Refresh_timing;  ///< 0x390 [R/W]: Channel 0 Refresh Timing Register
  volatile uint32_t CH0_SelfRefresh_timing;  ///< 0x394 [R/W]: Channel 0 Self-refresh Timing Register
  volatile uint32_t CH0_PowerDown_timing;  ///< 0x398 [R/W]: Channel 0 Power-down Timing Register
  volatile uint32_t CH0_MRS_timing;  ///< 0x39c [R/W]: Channel 0 MRS Timing Register
  volatile uint32_t CH0_ACT_timing;  ///< 0x3a0 [R/W]: Channel 0 Activate Timing Register
  volatile uint32_t CH0_PreCharge_Timing;  ///< 0x3a4 [R/W]: Channel 0 Precharge Timing Register
  volatile uint32_t CH0_CAS_RAS_timing;  ///< 0x3a8 [R/W]: Channel 0 CAS/RAS Timing Register
  volatile uint32_t CH0_Off_spec_timing;  ///< 0x3ac [R/W]: Channel 0 Off-spec timing Register
  volatile uint32_t reserved20[2];
  volatile uint32_t CH0_crc_par_timing;  ///< 0x3b8 [R/W]: Channel 0 dram CRC and Parity timing Register
  volatile uint32_t CH0_dram_mpd_timing;  ///< 0x3bc [R/W]: Channel 0 dram maximum power-down timing Register
  volatile uint32_t reserved21[16];
  volatile uint32_t CH0_PHY_Control_1;  ///< 0x400 [R/W]: Channel 0 PHY Control Register 1
  volatile uint32_t CH0_PHY_Control_2;  ///< 0x404 [R/W]: Channel 0 PHY Control Register 2
  volatile uint32_t CH0_PHY_Control_3;  ///< 0x408 [R/W]: Channel 0 PHY Control Register 3
  volatile uint32_t CH0_PHY_Control_4;  ///< 0x40c [R/W]: Channel 0 PHY Control Register 4
  volatile uint32_t CH0_PHY_Control_5;  ///< 0x410 [R/W]: Channel 0 PHY Control Register 5
  volatile uint32_t CH0_PHY_Control_6;  ///< 0x414 [R/W]: Channel 0 PHY Control Register 6
  volatile uint32_t reserved22;
  volatile uint32_t CH0_PHY_Control_8;  ///< 0x41c [R/W]: Channel 0 PHY Control Register 8
  volatile uint32_t CH0_PHY_Control_9;  ///< 0x420 [R/W]: Channel 0 PHY Control Register 9
  volatile uint32_t CH0_PHY_Control_10;  ///< 0x424 [R/W]: Channel 0 PHY Control Register 10
  volatile uint32_t CH0_PHY_Control_11;  ///< 0x428 [R/W]: Channel 0 PHY Control Register 11
  volatile uint32_t CH0_PHY_Control_12;  ///< 0x42c [R/W]: Channel 0 PHY Control Register 12
  volatile uint32_t CH0_PHY_Control_13;  ///< 0x430 [R/W]: Channel 0 PHY Control Register 13
  volatile uint32_t CH0_PHY_Control_14;  ///< 0x434 [R/W]: Channel 0 PHY Control Register 14
  volatile uint32_t CH0_PHY_Control_15;  ///< 0x438 [R/W]: Channel 0 PHY Control Register 15
  volatile uint32_t CH0_PHY_Control_16;  ///< 0x43c [R/W]: Channel 0 PHY Control Register 16
  volatile uint32_t CH0_PHY_Control_17;  ///< 0x440 [R/W]: Channel 0 PHY Control Register 17
  volatile uint32_t reserved23[47];
  volatile uint32_t CH0_PHY_DLL_control_B0;  ///< 0x500 [R/W]: Channel 0 PHY DLL Control Register B0
  volatile uint32_t CH0_PHY_DLL_control_B1;  ///< 0x504 [R/W]: Channel 0 PHY DLL Control Register B1
  volatile uint32_t reserved24[8];
  volatile uint32_t CH0_PHY_DLL_BYTE_SELECT;  ///< 0x528 [R/W]: Channel 0 PHY DLL BYTE Select Register
  volatile uint32_t CH0_PHY_DLL_DLY;  ///< 0x52c [R/W]: Channel 0 PHY DLL Delay Register
  volatile uint32_t reserved25[4];
  volatile uint32_t CH0_PHY_Data_Byte_Control_B0;  ///< 0x540 [R/W]: Channel 0 PHY Data Byte Control Register B0
  volatile uint32_t CH0_PHY_Data_Byte_Control_B1;  ///< 0x544 [R/W]: Channel 0 PHY Data Byte Control Register B1
  volatile uint32_t reserved26[10];
  volatile uint32_t CH0_PHY_WL_RL_Control;  ///< 0x570 [R/W]: Channel 0 PHY WL RL Control Register
  volatile uint32_t reserved27[3];
  volatile uint32_t CH0_PHY_WL_DATA_Control_CS0_B0;  ///< 0x580 [R/W]: Channel 0 PHY WL Control Data Register CS0 B0
  volatile uint32_t CH0_PHY_WL_DATA_Control_CS0_B1;  ///< 0x584 [R/W]: Channel 0 PHY WL Control Data Register CS0 B1
  volatile uint32_t reserved28[34];
  volatile uint32_t CH0_PHY_WL_CLK_Control_CS0;  ///< 0x610 [R/W]: Channel 0 PHY WL Control Clock Register CS0
  volatile uint32_t reserved29[3];
  volatile uint32_t CH0_PHY_WL_AC_Control_0;  ///< 0x620 [R/W]: Channel 0 PHY WL Control AC Register (Instance 1 of 3)
  volatile uint32_t CH0_PHY_WL_AC_Control_1;  ///< 0x624 [R/W]: Channel 0 PHY WL Control AC Register (Instance 2 of 3)
  volatile uint32_t CH0_PHY_WL_AC_Control_2;  ///< 0x628 [R/W]: Channel 0 PHY WL Control AC Register (Instance 3 of 3)
  volatile uint32_t reserved30[5];
  volatile uint32_t CH0_PHY_RL_Control_CS0_B0;  ///< 0x640 [R/W]: Channel 0 PHY RL Control Register CS0 B0
  volatile uint32_t CH0_PHY_RL_Control_CS0_B1;  ///< 0x644 [R/W]: Channel 0 PHY RL Control Register CS0 B1
  volatile uint32_t reserved31[46];
  volatile uint32_t CH0_PHY_CA_Delay0;  ///< 0x700 [R/W]: Channel 0 PHY CA Delay Register 0
  volatile uint32_t CH0_PHY_CA_Delay1;  ///< 0x704 [R/W]: Channel 0 PHY CA Delay Register 1
  volatile uint32_t CH0_PHY_CA_Delay2;  ///< 0x708 [R/W]: Channel 0 PHY CA Delay Register 2
  volatile uint32_t CH0_PHY_CA_Delay3;  ///< 0x70c [R/W]: Channel 0 PHY CA Delay Register 3
  volatile uint32_t reserved32[20];
  volatile uint32_t CH0_PHY_PRBS_Stat_Mask_B0;  ///< 0x760 [R/W]: Channel 0 PHY PRBS Status and Mask Register B0
  volatile uint32_t CH0_PHY_PRBS_Stat_Mask_B1;  ///< 0x764 [R/W]: Channel 0 PHY PRBS Status and Mask Register B1
  volatile uint32_t reserved33[7];
  volatile uint32_t CH0_PHY_PRBS_Stat_Mask_C0;  ///< 0x784 [R/W]: Channel 0 PHY PRBS Status and Mask Register C0
  volatile uint32_t CH0_PHY_PRBS_Stat_Mask_C1;  ///< 0x788 [R/W]: Channel 0 PHY PRBS Status and Mask Register C1
  volatile uint32_t CH0_PHY_PRBS_Stat_Mask_C2;  ///< 0x78c [R/W]: Channel 0 PHY PRBS Status and Mask Register C2
  volatile uint32_t CH0_PHY_PRBS_Stat_Mask_C3;  ///< 0x790 [R/W]: Channel 0 PHY PRBS Status and Mask Register C3
  volatile uint32_t reserved34;
  volatile uint32_t CH0_PHY_PRBS_Subphy_Stat;  ///< 0x798 [R]: Channel 0 PHY PRBS Subphy Status Register
  volatile uint32_t CH0_PHY_PRBS_User_Pattern;  ///< 0x79c [R/W]: Channel 0 PHY PRBS User Pattern Register
  volatile uint32_t CH0_PHY_PRBS_Control0;  ///< 0x7a0 [R/W]: Channel 0 PHY PRBS Control0 Register
  volatile uint32_t CH0_PHY_PRBS_Control1;  ///< 0x7a4 [R/W]: Channel 0 PHY PRBS Control1 Register
  volatile uint32_t reserved35[2];
  volatile uint32_t CH0_mem_fold_ctl;  ///< 0x7b0 [R/W]: Channel 0 memory folding control Register
  volatile uint32_t CH0_mem_fold_bad_addr;  ///< 0x7b4 [R/W]: Channel 0 memory folding corrupt address Register
  volatile uint32_t CH0_mem_fold_rep_addr;  ///< 0x7b8 [R/W]: Channel 0 memory folding replace address Register
  volatile uint32_t CH0_mem_fold_read;  ///< 0x7bc [R/W]: Channel 0 memory folding read Register
  volatile uint32_t reserved36[16];
  volatile uint32_t TZ_Range0_Low;  ///< 0x800 [R/W]: MC Trustzone Range Register 0 Low
  volatile uint32_t TZ_Range0_High;  ///< 0x804 [R/W]: MC Trustzone Range Register 0 High
  volatile uint32_t TZ_Range1_Low;  ///< 0x808 [R/W]: MC Trustzone Range Register 1 Low
  volatile uint32_t TZ_Range1_High;  ///< 0x80c [R/W]: MC Trustzone Range Register 1 High
  volatile uint32_t TZ_Range2_Low;  ///< 0x810 [R/W]: MC Trustzone Range Register 2 Low
  volatile uint32_t TZ_Range2_High;  ///< 0x814 [R/W]: MC Trustzone Range Register 2 High
  volatile uint32_t TZ_Range3_Low;  ///< 0x818 [R/W]: MC Trustzone Range Register 3 Low
  volatile uint32_t TZ_Range3_High;  ///< 0x81c [R/W]: MC Trustzone Range Register 3 High
  volatile uint32_t TZ_Range4_Low;  ///< 0x820 [R/W]: MC Trustzone Range Register 4 Low
  volatile uint32_t TZ_Range4_High;  ///< 0x824 [R/W]: MC Trustzone Range Register 4 High
  volatile uint32_t TZ_Range5_Low;  ///< 0x828 [R/W]: MC Trustzone Range Register 5 Low
  volatile uint32_t TZ_Range5_High;  ///< 0x82c [R/W]: MC Trustzone Range Register 5 High
  volatile uint32_t TZ_Range6_Low;  ///< 0x830 [R/W]: MC Trustzone Range Register 6 Low
  volatile uint32_t TZ_Range6_High;  ///< 0x834 [R/W]: MC Trustzone Range Register 6 High
  volatile uint32_t TZ_Range7_Low;  ///< 0x838 [R/W]: MC Trustzone Range Register 7 Low
  volatile uint32_t TZ_Range7_High;  ///< 0x83c [R/W]: MC Trustzone Range Register 7 High
  volatile uint32_t TZ_Range8_Low;  ///< 0x840 [R/W]: MC Trustzone Range Register 8 Low
  volatile uint32_t TZ_Range8_High;  ///< 0x844 [R/W]: MC Trustzone Range Register 8 High
  volatile uint32_t TZ_Range9_Low;  ///< 0x848 [R/W]: MC Trustzone Range Register 9 Low
  volatile uint32_t TZ_Range9_High;  ///< 0x84c [R/W]: MC Trustzone Range Register 9 High
  volatile uint32_t TZ_Range10_Low;  ///< 0x850 [R/W]: MC Trustzone Range Register 10 Low
  volatile uint32_t TZ_Range10_High;  ///< 0x854 [R/W]: MC Trustzone Range Register 10 High
  volatile uint32_t TZ_Range11_Low;  ///< 0x858 [R/W]: MC Trustzone Range Register 11 Low
  volatile uint32_t TZ_Range11_High;  ///< 0x85c [R/W]: MC Trustzone Range Register 11 High
  volatile uint32_t TZ_Range12_Low;  ///< 0x860 [R/W]: MC Trustzone Range Register 12 Low
  volatile uint32_t TZ_Range12_High;  ///< 0x864 [R/W]: MC Trustzone Range Register 12 High
  volatile uint32_t TZ_Range13_Low;  ///< 0x868 [R/W]: MC Trustzone Range Register 13 Low
  volatile uint32_t TZ_Range13_High;  ///< 0x86c [R/W]: MC Trustzone Range Register 13 High
  volatile uint32_t TZ_Range14_Low;  ///< 0x870 [R/W]: MC Trustzone Range Register 14 Low
  volatile uint32_t TZ_Range14_High;  ///< 0x874 [R/W]: MC Trustzone Range Register 14 High
  volatile uint32_t TZ_Range15_Low;  ///< 0x878 [R/W]: MC Trustzone Range Register 15 Low
  volatile uint32_t TZ_Range15_High;  ///< 0x87c [R/W]: MC Trustzone Range Register 15 High
} MC_REGS_t;

#endif // MC
 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _MC_REGMASKS_H_
#define _MC_REGMASKS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: Mckinley 5 (MC)
//
//====================================================================

//====================================================================
//Register: Memory Controller ID and Revision Register (MC_ID)
//====================================================================

#define  MC_MC_ID_RESERVED1_MASK 0xc0000000
#define  MC_MC_ID_RESERVED1_SHIFT 30
#define  MC_MC_ID_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MC_ID_RESERVED1_MASK) >> MC_MC_ID_RESERVED1_SHIFT)
#define  MC_MC_ID_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ID_RESERVED1_MASK) | (((uint32_t)val) << MC_MC_ID_RESERVED1_SHIFT))

#define  MC_MC_ID_SHADOWMEM_MASK 0x20000000
#define  MC_MC_ID_SHADOWMEM_SHIFT 29
#define  MC_MC_ID_SHADOWMEM_MASK_SHIFT(reg) (((reg) & MC_MC_ID_SHADOWMEM_MASK) >> MC_MC_ID_SHADOWMEM_SHIFT)
#define  MC_MC_ID_SHADOWMEM_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ID_SHADOWMEM_MASK) | (((uint32_t)val) << MC_MC_ID_SHADOWMEM_SHIFT))

#define  MC_MC_ID_DUALCHANNEL_MASK 0x10000000
#define  MC_MC_ID_DUALCHANNEL_SHIFT 28
#define  MC_MC_ID_DUALCHANNEL_MASK_SHIFT(reg) (((reg) & MC_MC_ID_DUALCHANNEL_MASK) >> MC_MC_ID_DUALCHANNEL_SHIFT)
#define  MC_MC_ID_DUALCHANNEL_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ID_DUALCHANNEL_MASK) | (((uint32_t)val) << MC_MC_ID_DUALCHANNEL_SHIFT))

#define  MC_MC_ID_ARCHITECTUREVER_MASK 0xf000000
#define  MC_MC_ID_ARCHITECTUREVER_SHIFT 24
#define  MC_MC_ID_ARCHITECTUREVER_MASK_SHIFT(reg) (((reg) & MC_MC_ID_ARCHITECTUREVER_MASK) >> MC_MC_ID_ARCHITECTUREVER_SHIFT)
#define  MC_MC_ID_ARCHITECTUREVER_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ID_ARCHITECTUREVER_MASK) | (((uint32_t)val) << MC_MC_ID_ARCHITECTUREVER_SHIFT))

#define  MC_MC_ID_REL_YEAR_MASK 0xf00000
#define  MC_MC_ID_REL_YEAR_SHIFT 20
#define  MC_MC_ID_REL_YEAR_MASK_SHIFT(reg) (((reg) & MC_MC_ID_REL_YEAR_MASK) >> MC_MC_ID_REL_YEAR_SHIFT)
#define  MC_MC_ID_REL_YEAR_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ID_REL_YEAR_MASK) | (((uint32_t)val) << MC_MC_ID_REL_YEAR_SHIFT))

#define  MC_MC_ID_REL_MONTH_MASK 0xff000
#define  MC_MC_ID_REL_MONTH_SHIFT 12
#define  MC_MC_ID_REL_MONTH_MASK_SHIFT(reg) (((reg) & MC_MC_ID_REL_MONTH_MASK) >> MC_MC_ID_REL_MONTH_SHIFT)
#define  MC_MC_ID_REL_MONTH_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ID_REL_MONTH_MASK) | (((uint32_t)val) << MC_MC_ID_REL_MONTH_SHIFT))

#define  MC_MC_ID_REL_DATE_MASK 0xff0
#define  MC_MC_ID_REL_DATE_SHIFT 4
#define  MC_MC_ID_REL_DATE_MASK_SHIFT(reg) (((reg) & MC_MC_ID_REL_DATE_MASK) >> MC_MC_ID_REL_DATE_SHIFT)
#define  MC_MC_ID_REL_DATE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ID_REL_DATE_MASK) | (((uint32_t)val) << MC_MC_ID_REL_DATE_SHIFT))

#define  MC_MC_ID_REV_ECO_MASK 0xf
#define  MC_MC_ID_REV_ECO_SHIFT 0
#define  MC_MC_ID_REV_ECO_MASK_SHIFT(reg) (((reg) & MC_MC_ID_REV_ECO_MASK) >> MC_MC_ID_REV_ECO_SHIFT)
#define  MC_MC_ID_REV_ECO_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ID_REV_ECO_MASK) | (((uint32_t)val) << MC_MC_ID_REV_ECO_SHIFT))

//====================================================================
//Register: Memory Controller Status Register (MC_STATUS)
//====================================================================

#define  MC_MC_STATUS_RESERVED1_MASK 0xffff8000
#define  MC_MC_STATUS_RESERVED1_SHIFT 15
#define  MC_MC_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_RESERVED1_MASK) >> MC_MC_STATUS_RESERVED1_SHIFT)
#define  MC_MC_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_RESERVED1_MASK) | (((uint32_t)val) << MC_MC_STATUS_RESERVED1_SHIFT))

#define  MC_MC_STATUS_DPCW_IDLE_0_MASK 0x4000
#define  MC_MC_STATUS_DPCW_IDLE_0_SHIFT 14
#define  MC_MC_STATUS_DPCW_IDLE_0_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_DPCW_IDLE_0_MASK) >> MC_MC_STATUS_DPCW_IDLE_0_SHIFT)
#define  MC_MC_STATUS_DPCW_IDLE_0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_DPCW_IDLE_0_MASK) | (((uint32_t)val) << MC_MC_STATUS_DPCW_IDLE_0_SHIFT))

#define  MC_MC_STATUS_DPCR_IDLE_0_MASK 0x2000
#define  MC_MC_STATUS_DPCR_IDLE_0_SHIFT 13
#define  MC_MC_STATUS_DPCR_IDLE_0_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_DPCR_IDLE_0_MASK) >> MC_MC_STATUS_DPCR_IDLE_0_SHIFT)
#define  MC_MC_STATUS_DPCR_IDLE_0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_DPCR_IDLE_0_MASK) | (((uint32_t)val) << MC_MC_STATUS_DPCR_IDLE_0_SHIFT))

#define  MC_MC_STATUS_TC_IDLE_0_MASK 0x1000
#define  MC_MC_STATUS_TC_IDLE_0_SHIFT 12
#define  MC_MC_STATUS_TC_IDLE_0_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_TC_IDLE_0_MASK) >> MC_MC_STATUS_TC_IDLE_0_SHIFT)
#define  MC_MC_STATUS_TC_IDLE_0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_TC_IDLE_0_MASK) | (((uint32_t)val) << MC_MC_STATUS_TC_IDLE_0_SHIFT))

#define  MC_MC_STATUS_BQ_EMPTY_0_MASK 0x800
#define  MC_MC_STATUS_BQ_EMPTY_0_SHIFT 11
#define  MC_MC_STATUS_BQ_EMPTY_0_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_BQ_EMPTY_0_MASK) >> MC_MC_STATUS_BQ_EMPTY_0_SHIFT)
#define  MC_MC_STATUS_BQ_EMPTY_0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_BQ_EMPTY_0_MASK) | (((uint32_t)val) << MC_MC_STATUS_BQ_EMPTY_0_SHIFT))

#define  MC_MC_STATUS_SMTQ_IDLE_0_MASK 0x400
#define  MC_MC_STATUS_SMTQ_IDLE_0_SHIFT 10
#define  MC_MC_STATUS_SMTQ_IDLE_0_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_SMTQ_IDLE_0_MASK) >> MC_MC_STATUS_SMTQ_IDLE_0_SHIFT)
#define  MC_MC_STATUS_SMTQ_IDLE_0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_SMTQ_IDLE_0_MASK) | (((uint32_t)val) << MC_MC_STATUS_SMTQ_IDLE_0_SHIFT))

#define  MC_MC_STATUS_WAIT_CA_TRAIN_0_MASK 0x200
#define  MC_MC_STATUS_WAIT_CA_TRAIN_0_SHIFT 9
#define  MC_MC_STATUS_WAIT_CA_TRAIN_0_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_WAIT_CA_TRAIN_0_MASK) >> MC_MC_STATUS_WAIT_CA_TRAIN_0_SHIFT)
#define  MC_MC_STATUS_WAIT_CA_TRAIN_0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_WAIT_CA_TRAIN_0_MASK) | (((uint32_t)val) << MC_MC_STATUS_WAIT_CA_TRAIN_0_SHIFT))

#define  MC_MC_STATUS_CH_IDLE_0_MASK 0x100
#define  MC_MC_STATUS_CH_IDLE_0_SHIFT 8
#define  MC_MC_STATUS_CH_IDLE_0_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_CH_IDLE_0_MASK) >> MC_MC_STATUS_CH_IDLE_0_SHIFT)
#define  MC_MC_STATUS_CH_IDLE_0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_CH_IDLE_0_MASK) | (((uint32_t)val) << MC_MC_STATUS_CH_IDLE_0_SHIFT))

#define  MC_MC_STATUS_RESERVED2_MASK 0xf0
#define  MC_MC_STATUS_RESERVED2_SHIFT 4
#define  MC_MC_STATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_RESERVED2_MASK) >> MC_MC_STATUS_RESERVED2_SHIFT)
#define  MC_MC_STATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_RESERVED2_MASK) | (((uint32_t)val) << MC_MC_STATUS_RESERVED2_SHIFT))

#define  MC_MC_STATUS_WCB_EMPTY_MASK 0x8
#define  MC_MC_STATUS_WCB_EMPTY_SHIFT 3
#define  MC_MC_STATUS_WCB_EMPTY_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_WCB_EMPTY_MASK) >> MC_MC_STATUS_WCB_EMPTY_SHIFT)
#define  MC_MC_STATUS_WCB_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_WCB_EMPTY_MASK) | (((uint32_t)val) << MC_MC_STATUS_WCB_EMPTY_SHIFT))

#define  MC_MC_STATUS_ROB_EMPTY_MASK 0x4
#define  MC_MC_STATUS_ROB_EMPTY_SHIFT 2
#define  MC_MC_STATUS_ROB_EMPTY_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_ROB_EMPTY_MASK) >> MC_MC_STATUS_ROB_EMPTY_SHIFT)
#define  MC_MC_STATUS_ROB_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_ROB_EMPTY_MASK) | (((uint32_t)val) << MC_MC_STATUS_ROB_EMPTY_SHIFT))

#define  MC_MC_STATUS_RRB_EMPTY_MASK 0x2
#define  MC_MC_STATUS_RRB_EMPTY_SHIFT 1
#define  MC_MC_STATUS_RRB_EMPTY_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_RRB_EMPTY_MASK) >> MC_MC_STATUS_RRB_EMPTY_SHIFT)
#define  MC_MC_STATUS_RRB_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_RRB_EMPTY_MASK) | (((uint32_t)val) << MC_MC_STATUS_RRB_EMPTY_SHIFT))

#define  MC_MC_STATUS_MC_IDLE_MASK 0x1
#define  MC_MC_STATUS_MC_IDLE_SHIFT 0
#define  MC_MC_STATUS_MC_IDLE_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_MC_IDLE_MASK) >> MC_MC_STATUS_MC_IDLE_SHIFT)
#define  MC_MC_STATUS_MC_IDLE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_MC_IDLE_MASK) | (((uint32_t)val) << MC_MC_STATUS_MC_IDLE_SHIFT))

//====================================================================
//Register: DRAM Status Register (DRAM_STATUS)
//====================================================================

#define  MC_DRAM_STATUS_RESERVED1_MASK 0xfffffff0
#define  MC_DRAM_STATUS_RESERVED1_SHIFT 4
#define  MC_DRAM_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_RESERVED1_MASK) >> MC_DRAM_STATUS_RESERVED1_SHIFT)
#define  MC_DRAM_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_RESERVED1_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_RESERVED1_SHIFT))

#define  MC_DRAM_STATUS_STATE_DPD00_MASK 0x8
#define  MC_DRAM_STATUS_STATE_DPD00_SHIFT 3
#define  MC_DRAM_STATUS_STATE_DPD00_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_DPD00_MASK) >> MC_DRAM_STATUS_STATE_DPD00_SHIFT)
#define  MC_DRAM_STATUS_STATE_DPD00_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_DPD00_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_DPD00_SHIFT))

#define  MC_DRAM_STATUS_STATE_SR00_MASK 0x4
#define  MC_DRAM_STATUS_STATE_SR00_SHIFT 2
#define  MC_DRAM_STATUS_STATE_SR00_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_SR00_MASK) >> MC_DRAM_STATUS_STATE_SR00_SHIFT)
#define  MC_DRAM_STATUS_STATE_SR00_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_SR00_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_SR00_SHIFT))

#define  MC_DRAM_STATUS_STATE_PD00_MASK 0x2
#define  MC_DRAM_STATUS_STATE_PD00_SHIFT 1
#define  MC_DRAM_STATUS_STATE_PD00_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_PD00_MASK) >> MC_DRAM_STATUS_STATE_PD00_SHIFT)
#define  MC_DRAM_STATUS_STATE_PD00_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_PD00_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_PD00_SHIFT))

#define  MC_DRAM_STATUS_INIT_DONE00_MASK 0x1
#define  MC_DRAM_STATUS_INIT_DONE00_SHIFT 0
#define  MC_DRAM_STATUS_INIT_DONE00_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_INIT_DONE00_MASK) >> MC_DRAM_STATUS_INIT_DONE00_SHIFT)
#define  MC_DRAM_STATUS_INIT_DONE00_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_INIT_DONE00_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_INIT_DONE00_SHIFT))

//====================================================================
//Register: DRAM Mode Register (DRAM_MODE)
//====================================================================

#define  MC_DRAM_MODE_RESERVED1_MASK 0xffffff80
#define  MC_DRAM_MODE_RESERVED1_SHIFT 7
#define  MC_DRAM_MODE_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_DRAM_MODE_RESERVED1_MASK) >> MC_DRAM_MODE_RESERVED1_SHIFT)
#define  MC_DRAM_MODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_MODE_RESERVED1_MASK) | (((uint32_t)val) << MC_DRAM_MODE_RESERVED1_SHIFT))

#define  MC_DRAM_MODE_SDRAM_READ_DBI_MODE_CH0_MASK 0x40
#define  MC_DRAM_MODE_SDRAM_READ_DBI_MODE_CH0_SHIFT 6
#define  MC_DRAM_MODE_SDRAM_READ_DBI_MODE_CH0_MASK_SHIFT(reg) (((reg) & MC_DRAM_MODE_SDRAM_READ_DBI_MODE_CH0_MASK) >> MC_DRAM_MODE_SDRAM_READ_DBI_MODE_CH0_SHIFT)
#define  MC_DRAM_MODE_SDRAM_READ_DBI_MODE_CH0_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_MODE_SDRAM_READ_DBI_MODE_CH0_MASK) | (((uint32_t)val) << MC_DRAM_MODE_SDRAM_READ_DBI_MODE_CH0_SHIFT))

#define  MC_DRAM_MODE_RESERVED2_MASK 0x20
#define  MC_DRAM_MODE_RESERVED2_SHIFT 5
#define  MC_DRAM_MODE_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_DRAM_MODE_RESERVED2_MASK) >> MC_DRAM_MODE_RESERVED2_SHIFT)
#define  MC_DRAM_MODE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_MODE_RESERVED2_MASK) | (((uint32_t)val) << MC_DRAM_MODE_RESERVED2_SHIFT))

#define  MC_DRAM_MODE_SDRAM_WRITE_CRC_MODE_CH0_MASK 0x10
#define  MC_DRAM_MODE_SDRAM_WRITE_CRC_MODE_CH0_SHIFT 4
#define  MC_DRAM_MODE_SDRAM_WRITE_CRC_MODE_CH0_MASK_SHIFT(reg) (((reg) & MC_DRAM_MODE_SDRAM_WRITE_CRC_MODE_CH0_MASK) >> MC_DRAM_MODE_SDRAM_WRITE_CRC_MODE_CH0_SHIFT)
#define  MC_DRAM_MODE_SDRAM_WRITE_CRC_MODE_CH0_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_MODE_SDRAM_WRITE_CRC_MODE_CH0_MASK) | (((uint32_t)val) << MC_DRAM_MODE_SDRAM_WRITE_CRC_MODE_CH0_SHIFT))

#define  MC_DRAM_MODE_RESERVED3_MASK 0x8
#define  MC_DRAM_MODE_RESERVED3_SHIFT 3
#define  MC_DRAM_MODE_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_DRAM_MODE_RESERVED3_MASK) >> MC_DRAM_MODE_RESERVED3_SHIFT)
#define  MC_DRAM_MODE_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_MODE_RESERVED3_MASK) | (((uint32_t)val) << MC_DRAM_MODE_RESERVED3_SHIFT))

#define  MC_DRAM_MODE_SDRAM_PAR_MODE_CH0_MASK 0x4
#define  MC_DRAM_MODE_SDRAM_PAR_MODE_CH0_SHIFT 2
#define  MC_DRAM_MODE_SDRAM_PAR_MODE_CH0_MASK_SHIFT(reg) (((reg) & MC_DRAM_MODE_SDRAM_PAR_MODE_CH0_MASK) >> MC_DRAM_MODE_SDRAM_PAR_MODE_CH0_SHIFT)
#define  MC_DRAM_MODE_SDRAM_PAR_MODE_CH0_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_MODE_SDRAM_PAR_MODE_CH0_MASK) | (((uint32_t)val) << MC_DRAM_MODE_SDRAM_PAR_MODE_CH0_SHIFT))

#define  MC_DRAM_MODE_RESERVED4_MASK 0x2
#define  MC_DRAM_MODE_RESERVED4_SHIFT 1
#define  MC_DRAM_MODE_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_DRAM_MODE_RESERVED4_MASK) >> MC_DRAM_MODE_RESERVED4_SHIFT)
#define  MC_DRAM_MODE_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_MODE_RESERVED4_MASK) | (((uint32_t)val) << MC_DRAM_MODE_RESERVED4_SHIFT))

#define  MC_DRAM_MODE_SDRAM_CAL_MODE_CH0_MASK 0x1
#define  MC_DRAM_MODE_SDRAM_CAL_MODE_CH0_SHIFT 0
#define  MC_DRAM_MODE_SDRAM_CAL_MODE_CH0_MASK_SHIFT(reg) (((reg) & MC_DRAM_MODE_SDRAM_CAL_MODE_CH0_MASK) >> MC_DRAM_MODE_SDRAM_CAL_MODE_CH0_SHIFT)
#define  MC_DRAM_MODE_SDRAM_CAL_MODE_CH0_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_MODE_SDRAM_CAL_MODE_CH0_MASK) | (((uint32_t)val) << MC_DRAM_MODE_SDRAM_CAL_MODE_CH0_SHIFT))

//====================================================================
//Register: MC Write Path Status (MC_WP_STAT)
//====================================================================

#define  MC_MC_WP_STAT_RESERVED1_MASK 0xe0000000
#define  MC_MC_WP_STAT_RESERVED1_SHIFT 29
#define  MC_MC_WP_STAT_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_RESERVED1_MASK) >> MC_MC_WP_STAT_RESERVED1_SHIFT)
#define  MC_MC_WP_STAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_RESERVED1_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_RESERVED1_SHIFT))

#define  MC_MC_WP_STAT_WCB_DRAINING_MASK 0x10000000
#define  MC_MC_WP_STAT_WCB_DRAINING_SHIFT 28
#define  MC_MC_WP_STAT_WCB_DRAINING_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_WCB_DRAINING_MASK) >> MC_MC_WP_STAT_WCB_DRAINING_SHIFT)
#define  MC_MC_WP_STAT_WCB_DRAINING_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_WCB_DRAINING_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_WCB_DRAINING_SHIFT))

#define  MC_MC_WP_STAT_WDB_LF_FIFO_EMPTY_MASK 0x8000000
#define  MC_MC_WP_STAT_WDB_LF_FIFO_EMPTY_SHIFT 27
#define  MC_MC_WP_STAT_WDB_LF_FIFO_EMPTY_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_WDB_LF_FIFO_EMPTY_MASK) >> MC_MC_WP_STAT_WDB_LF_FIFO_EMPTY_SHIFT)
#define  MC_MC_WP_STAT_WDB_LF_FIFO_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_WDB_LF_FIFO_EMPTY_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_WDB_LF_FIFO_EMPTY_SHIFT))

#define  MC_MC_WP_STAT_WDB_LF_PORT_MASK 0x7000000
#define  MC_MC_WP_STAT_WDB_LF_PORT_SHIFT 24
#define  MC_MC_WP_STAT_WDB_LF_PORT_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_WDB_LF_PORT_MASK) >> MC_MC_WP_STAT_WDB_LF_PORT_SHIFT)
#define  MC_MC_WP_STAT_WDB_LF_PORT_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_WDB_LF_PORT_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_WDB_LF_PORT_SHIFT))

#define  MC_MC_WP_STAT_RESERVED2_MASK 0xe00000
#define  MC_MC_WP_STAT_RESERVED2_SHIFT 21
#define  MC_MC_WP_STAT_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_RESERVED2_MASK) >> MC_MC_WP_STAT_RESERVED2_SHIFT)
#define  MC_MC_WP_STAT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_RESERVED2_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_RESERVED2_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P4_MASK 0x100000
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P4_SHIFT 20
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P4_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P4_MASK) >> MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P4_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P4_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P4_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P3_MASK 0x80000
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P3_SHIFT 19
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P3_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P3_MASK) >> MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P3_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P3_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P3_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P2_MASK 0x40000
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P2_SHIFT 18
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P2_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P2_MASK) >> MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P2_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P2_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P2_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P1_MASK 0x20000
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P1_SHIFT 17
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P1_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P1_MASK) >> MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P1_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P1_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P1_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P0_MASK 0x10000
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P0_SHIFT 16
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P0_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P0_MASK) >> MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P0_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P0_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P0_SHIFT))

#define  MC_MC_WP_STAT_RESERVED3_MASK 0xe000
#define  MC_MC_WP_STAT_RESERVED3_SHIFT 13
#define  MC_MC_WP_STAT_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_RESERVED3_MASK) >> MC_MC_WP_STAT_RESERVED3_SHIFT)
#define  MC_MC_WP_STAT_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_RESERVED3_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_RESERVED3_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P4_MASK 0x1000
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P4_SHIFT 12
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P4_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P4_MASK) >> MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P4_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P4_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P4_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P3_MASK 0x800
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P3_SHIFT 11
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P3_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P3_MASK) >> MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P3_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P3_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P3_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P2_MASK 0x400
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P2_SHIFT 10
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P2_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P2_MASK) >> MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P2_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P2_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P2_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P1_MASK 0x200
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P1_SHIFT 9
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P1_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P1_MASK) >> MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P1_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P1_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P1_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P0_MASK 0x100
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P0_SHIFT 8
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P0_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P0_MASK) >> MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P0_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P0_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P0_SHIFT))

#define  MC_MC_WP_STAT_RESERVED4_MASK 0xe0
#define  MC_MC_WP_STAT_RESERVED4_SHIFT 5
#define  MC_MC_WP_STAT_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_RESERVED4_MASK) >> MC_MC_WP_STAT_RESERVED4_SHIFT)
#define  MC_MC_WP_STAT_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_RESERVED4_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_RESERVED4_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P4_MASK 0x10
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P4_SHIFT 4
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P4_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P4_MASK) >> MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P4_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P4_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P4_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P3_MASK 0x8
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P3_SHIFT 3
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P3_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P3_MASK) >> MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P3_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P3_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P3_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P2_MASK 0x4
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P2_SHIFT 2
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P2_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P2_MASK) >> MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P2_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P2_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P2_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P1_MASK 0x2
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P1_SHIFT 1
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P1_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P1_MASK) >> MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P1_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P1_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P1_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P0_MASK 0x1
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P0_SHIFT 0
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P0_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P0_MASK) >> MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P0_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P0_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P0_SHIFT))

//====================================================================
//Register: MC Read Path Status (MC_RP_STAT)
//====================================================================

#define  MC_MC_RP_STAT_RESERVED1_MASK 0xe0000000
#define  MC_MC_RP_STAT_RESERVED1_SHIFT 29
#define  MC_MC_RP_STAT_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_RESERVED1_MASK) >> MC_MC_RP_STAT_RESERVED1_SHIFT)
#define  MC_MC_RP_STAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_RESERVED1_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_RESERVED1_SHIFT))

#define  MC_MC_RP_STAT_ROB_NOT_FULL_P4_MASK 0x10000000
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P4_SHIFT 28
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P4_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_ROB_NOT_FULL_P4_MASK) >> MC_MC_RP_STAT_ROB_NOT_FULL_P4_SHIFT)
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_ROB_NOT_FULL_P4_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_ROB_NOT_FULL_P4_SHIFT))

#define  MC_MC_RP_STAT_ROB_NOT_FULL_P3_MASK 0x8000000
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P3_SHIFT 27
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P3_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_ROB_NOT_FULL_P3_MASK) >> MC_MC_RP_STAT_ROB_NOT_FULL_P3_SHIFT)
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_ROB_NOT_FULL_P3_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_ROB_NOT_FULL_P3_SHIFT))

#define  MC_MC_RP_STAT_ROB_NOT_FULL_P2_MASK 0x4000000
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P2_SHIFT 26
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P2_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_ROB_NOT_FULL_P2_MASK) >> MC_MC_RP_STAT_ROB_NOT_FULL_P2_SHIFT)
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_ROB_NOT_FULL_P2_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_ROB_NOT_FULL_P2_SHIFT))

#define  MC_MC_RP_STAT_ROB_NOT_FULL_P1_MASK 0x2000000
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P1_SHIFT 25
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P1_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_ROB_NOT_FULL_P1_MASK) >> MC_MC_RP_STAT_ROB_NOT_FULL_P1_SHIFT)
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_ROB_NOT_FULL_P1_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_ROB_NOT_FULL_P1_SHIFT))

#define  MC_MC_RP_STAT_ROB_NOT_FULL_P0_MASK 0x1000000
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P0_SHIFT 24
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P0_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_ROB_NOT_FULL_P0_MASK) >> MC_MC_RP_STAT_ROB_NOT_FULL_P0_SHIFT)
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_ROB_NOT_FULL_P0_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_ROB_NOT_FULL_P0_SHIFT))

#define  MC_MC_RP_STAT_RESERVED2_MASK 0xe00000
#define  MC_MC_RP_STAT_RESERVED2_SHIFT 21
#define  MC_MC_RP_STAT_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_RESERVED2_MASK) >> MC_MC_RP_STAT_RESERVED2_SHIFT)
#define  MC_MC_RP_STAT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_RESERVED2_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_RESERVED2_SHIFT))

#define  MC_MC_RP_STAT_RRB_HAZARD_P4_MASK 0x100000
#define  MC_MC_RP_STAT_RRB_HAZARD_P4_SHIFT 20
#define  MC_MC_RP_STAT_RRB_HAZARD_P4_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_RRB_HAZARD_P4_MASK) >> MC_MC_RP_STAT_RRB_HAZARD_P4_SHIFT)
#define  MC_MC_RP_STAT_RRB_HAZARD_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_RRB_HAZARD_P4_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_RRB_HAZARD_P4_SHIFT))

#define  MC_MC_RP_STAT_RRB_HAZARD_P3_MASK 0x80000
#define  MC_MC_RP_STAT_RRB_HAZARD_P3_SHIFT 19
#define  MC_MC_RP_STAT_RRB_HAZARD_P3_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_RRB_HAZARD_P3_MASK) >> MC_MC_RP_STAT_RRB_HAZARD_P3_SHIFT)
#define  MC_MC_RP_STAT_RRB_HAZARD_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_RRB_HAZARD_P3_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_RRB_HAZARD_P3_SHIFT))

#define  MC_MC_RP_STAT_RRB_HAZARD_P2_MASK 0x40000
#define  MC_MC_RP_STAT_RRB_HAZARD_P2_SHIFT 18
#define  MC_MC_RP_STAT_RRB_HAZARD_P2_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_RRB_HAZARD_P2_MASK) >> MC_MC_RP_STAT_RRB_HAZARD_P2_SHIFT)
#define  MC_MC_RP_STAT_RRB_HAZARD_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_RRB_HAZARD_P2_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_RRB_HAZARD_P2_SHIFT))

#define  MC_MC_RP_STAT_RRB_HAZARD_P1_MASK 0x20000
#define  MC_MC_RP_STAT_RRB_HAZARD_P1_SHIFT 17
#define  MC_MC_RP_STAT_RRB_HAZARD_P1_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_RRB_HAZARD_P1_MASK) >> MC_MC_RP_STAT_RRB_HAZARD_P1_SHIFT)
#define  MC_MC_RP_STAT_RRB_HAZARD_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_RRB_HAZARD_P1_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_RRB_HAZARD_P1_SHIFT))

#define  MC_MC_RP_STAT_RRB_HAZARD_P0_MASK 0x10000
#define  MC_MC_RP_STAT_RRB_HAZARD_P0_SHIFT 16
#define  MC_MC_RP_STAT_RRB_HAZARD_P0_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_RRB_HAZARD_P0_MASK) >> MC_MC_RP_STAT_RRB_HAZARD_P0_SHIFT)
#define  MC_MC_RP_STAT_RRB_HAZARD_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_RRB_HAZARD_P0_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_RRB_HAZARD_P0_SHIFT))

#define  MC_MC_RP_STAT_RESERVED3_MASK 0xe000
#define  MC_MC_RP_STAT_RESERVED3_SHIFT 13
#define  MC_MC_RP_STAT_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_RESERVED3_MASK) >> MC_MC_RP_STAT_RESERVED3_SHIFT)
#define  MC_MC_RP_STAT_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_RESERVED3_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_RESERVED3_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P4_MASK 0x1000
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P4_SHIFT 12
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P4_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P4_MASK) >> MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P4_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P4_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P4_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P3_MASK 0x800
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P3_SHIFT 11
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P3_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P3_MASK) >> MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P3_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P3_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P3_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P2_MASK 0x400
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P2_SHIFT 10
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P2_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P2_MASK) >> MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P2_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P2_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P2_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P1_MASK 0x200
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P1_SHIFT 9
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P1_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P1_MASK) >> MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P1_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P1_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P1_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P0_MASK 0x100
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P0_SHIFT 8
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P0_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P0_MASK) >> MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P0_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P0_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P0_SHIFT))

#define  MC_MC_RP_STAT_RESERVED4_MASK 0xe0
#define  MC_MC_RP_STAT_RESERVED4_SHIFT 5
#define  MC_MC_RP_STAT_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_RESERVED4_MASK) >> MC_MC_RP_STAT_RESERVED4_SHIFT)
#define  MC_MC_RP_STAT_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_RESERVED4_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_RESERVED4_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P4_MASK 0x10
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P4_SHIFT 4
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P4_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P4_MASK) >> MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P4_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P4_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P4_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P3_MASK 0x8
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P3_SHIFT 3
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P3_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P3_MASK) >> MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P3_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P3_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P3_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P2_MASK 0x4
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P2_SHIFT 2
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P2_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P2_MASK) >> MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P2_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P2_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P2_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P1_MASK 0x2
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P1_SHIFT 1
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P1_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P1_MASK) >> MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P1_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P1_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P1_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P0_MASK 0x1
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P0_SHIFT 0
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P0_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P0_MASK) >> MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P0_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P0_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P0_SHIFT))

//====================================================================
//Register: User Initiated Command Register 0 (USER_COMMAND_0)
/** \brief This is a write-only register.
      Note: All commands, except <<xref=USER_COMMAND_0/wcb_drain_req>>, are used in combination with channel and chip-select.*/
//====================================================================

#define  MC_USER_COMMAND_0_RESERVED1_MASK 0xe0000000
#define  MC_USER_COMMAND_0_RESERVED1_SHIFT 29
#define  MC_USER_COMMAND_0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_RESERVED1_MASK) >> MC_USER_COMMAND_0_RESERVED1_SHIFT)
#define  MC_USER_COMMAND_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_RESERVED1_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_RESERVED1_SHIFT))

#define  MC_USER_COMMAND_0_CH0_MASK 0x10000000
#define  MC_USER_COMMAND_0_CH0_SHIFT 28
#define  MC_USER_COMMAND_0_CH0_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_CH0_MASK) >> MC_USER_COMMAND_0_CH0_SHIFT)
#define  MC_USER_COMMAND_0_CH0_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_CH0_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_CH0_SHIFT))

#define  MC_USER_COMMAND_0_RESERVED2_MASK 0xe000000
#define  MC_USER_COMMAND_0_RESERVED2_SHIFT 25
#define  MC_USER_COMMAND_0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_RESERVED2_MASK) >> MC_USER_COMMAND_0_RESERVED2_SHIFT)
#define  MC_USER_COMMAND_0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_RESERVED2_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_RESERVED2_SHIFT))

#define  MC_USER_COMMAND_0_CS0_MASK 0x1000000
#define  MC_USER_COMMAND_0_CS0_SHIFT 24
#define  MC_USER_COMMAND_0_CS0_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_CS0_MASK) >> MC_USER_COMMAND_0_CS0_SHIFT)
#define  MC_USER_COMMAND_0_CS0_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_CS0_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_CS0_SHIFT))

#define  MC_USER_COMMAND_0_RESERVED3_MASK 0x800000
#define  MC_USER_COMMAND_0_RESERVED3_SHIFT 23
#define  MC_USER_COMMAND_0_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_RESERVED3_MASK) >> MC_USER_COMMAND_0_RESERVED3_SHIFT)
#define  MC_USER_COMMAND_0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_RESERVED3_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_RESERVED3_SHIFT))

#define  MC_USER_COMMAND_0_LMR6_REQ_MASK 0x400000
#define  MC_USER_COMMAND_0_LMR6_REQ_SHIFT 22
#define  MC_USER_COMMAND_0_LMR6_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_LMR6_REQ_MASK) >> MC_USER_COMMAND_0_LMR6_REQ_SHIFT)
#define  MC_USER_COMMAND_0_LMR6_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_LMR6_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_LMR6_REQ_SHIFT))

#define  MC_USER_COMMAND_0_LMR5_REQ_MASK 0x200000
#define  MC_USER_COMMAND_0_LMR5_REQ_SHIFT 21
#define  MC_USER_COMMAND_0_LMR5_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_LMR5_REQ_MASK) >> MC_USER_COMMAND_0_LMR5_REQ_SHIFT)
#define  MC_USER_COMMAND_0_LMR5_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_LMR5_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_LMR5_REQ_SHIFT))

#define  MC_USER_COMMAND_0_LMR4_REQ_MASK 0x100000
#define  MC_USER_COMMAND_0_LMR4_REQ_SHIFT 20
#define  MC_USER_COMMAND_0_LMR4_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_LMR4_REQ_MASK) >> MC_USER_COMMAND_0_LMR4_REQ_SHIFT)
#define  MC_USER_COMMAND_0_LMR4_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_LMR4_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_LMR4_REQ_SHIFT))

#define  MC_USER_COMMAND_0_RESERVED4_MASK 0xfc000
#define  MC_USER_COMMAND_0_RESERVED4_SHIFT 14
#define  MC_USER_COMMAND_0_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_RESERVED4_MASK) >> MC_USER_COMMAND_0_RESERVED4_SHIFT)
#define  MC_USER_COMMAND_0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_RESERVED4_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_RESERVED4_SHIFT))

#define  MC_USER_COMMAND_0_ZQC_SHORT_MASK 0x2000
#define  MC_USER_COMMAND_0_ZQC_SHORT_SHIFT 13
#define  MC_USER_COMMAND_0_ZQC_SHORT_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_ZQC_SHORT_MASK) >> MC_USER_COMMAND_0_ZQC_SHORT_SHIFT)
#define  MC_USER_COMMAND_0_ZQC_SHORT_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_ZQC_SHORT_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_ZQC_SHORT_SHIFT))

#define  MC_USER_COMMAND_0_ZQC_LONG_MASK 0x1000
#define  MC_USER_COMMAND_0_ZQC_LONG_SHIFT 12
#define  MC_USER_COMMAND_0_ZQC_LONG_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_ZQC_LONG_MASK) >> MC_USER_COMMAND_0_ZQC_LONG_SHIFT)
#define  MC_USER_COMMAND_0_ZQC_LONG_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_ZQC_LONG_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_ZQC_LONG_SHIFT))

#define  MC_USER_COMMAND_0_LMR3_REQ_MASK 0x800
#define  MC_USER_COMMAND_0_LMR3_REQ_SHIFT 11
#define  MC_USER_COMMAND_0_LMR3_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_LMR3_REQ_MASK) >> MC_USER_COMMAND_0_LMR3_REQ_SHIFT)
#define  MC_USER_COMMAND_0_LMR3_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_LMR3_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_LMR3_REQ_SHIFT))

#define  MC_USER_COMMAND_0_LMR2_REQ_MASK 0x400
#define  MC_USER_COMMAND_0_LMR2_REQ_SHIFT 10
#define  MC_USER_COMMAND_0_LMR2_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_LMR2_REQ_MASK) >> MC_USER_COMMAND_0_LMR2_REQ_SHIFT)
#define  MC_USER_COMMAND_0_LMR2_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_LMR2_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_LMR2_REQ_SHIFT))

#define  MC_USER_COMMAND_0_LMR1_REQ_MASK 0x200
#define  MC_USER_COMMAND_0_LMR1_REQ_SHIFT 9
#define  MC_USER_COMMAND_0_LMR1_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_LMR1_REQ_MASK) >> MC_USER_COMMAND_0_LMR1_REQ_SHIFT)
#define  MC_USER_COMMAND_0_LMR1_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_LMR1_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_LMR1_REQ_SHIFT))

#define  MC_USER_COMMAND_0_LMR0_REQ_MASK 0x100
#define  MC_USER_COMMAND_0_LMR0_REQ_SHIFT 8
#define  MC_USER_COMMAND_0_LMR0_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_LMR0_REQ_MASK) >> MC_USER_COMMAND_0_LMR0_REQ_SHIFT)
#define  MC_USER_COMMAND_0_LMR0_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_LMR0_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_LMR0_REQ_SHIFT))

#define  MC_USER_COMMAND_0_SR_REQ_MASK 0xc0
#define  MC_USER_COMMAND_0_SR_REQ_SHIFT 6
#define  MC_USER_COMMAND_0_SR_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_SR_REQ_MASK) >> MC_USER_COMMAND_0_SR_REQ_SHIFT)
#define  MC_USER_COMMAND_0_SR_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_SR_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_SR_REQ_SHIFT))

#define  MC_USER_COMMAND_0_PPD_REQ_MASK 0x20
#define  MC_USER_COMMAND_0_PPD_REQ_SHIFT 5
#define  MC_USER_COMMAND_0_PPD_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_PPD_REQ_MASK) >> MC_USER_COMMAND_0_PPD_REQ_SHIFT)
#define  MC_USER_COMMAND_0_PPD_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_PPD_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_PPD_REQ_SHIFT))

#define  MC_USER_COMMAND_0_APD_REQ_MASK 0x10
#define  MC_USER_COMMAND_0_APD_REQ_SHIFT 4
#define  MC_USER_COMMAND_0_APD_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_APD_REQ_MASK) >> MC_USER_COMMAND_0_APD_REQ_SHIFT)
#define  MC_USER_COMMAND_0_APD_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_APD_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_APD_REQ_SHIFT))

#define  MC_USER_COMMAND_0_RESERVED5_MASK 0xc
#define  MC_USER_COMMAND_0_RESERVED5_SHIFT 2
#define  MC_USER_COMMAND_0_RESERVED5_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_RESERVED5_MASK) >> MC_USER_COMMAND_0_RESERVED5_SHIFT)
#define  MC_USER_COMMAND_0_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_RESERVED5_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_RESERVED5_SHIFT))

#define  MC_USER_COMMAND_0_WCB_DRAIN_REQ_MASK 0x2
#define  MC_USER_COMMAND_0_WCB_DRAIN_REQ_SHIFT 1
#define  MC_USER_COMMAND_0_WCB_DRAIN_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_WCB_DRAIN_REQ_MASK) >> MC_USER_COMMAND_0_WCB_DRAIN_REQ_SHIFT)
#define  MC_USER_COMMAND_0_WCB_DRAIN_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_WCB_DRAIN_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_WCB_DRAIN_REQ_SHIFT))

#define  MC_USER_COMMAND_0_SDRAM_INIT_REQ_MASK 0x1
#define  MC_USER_COMMAND_0_SDRAM_INIT_REQ_SHIFT 0
#define  MC_USER_COMMAND_0_SDRAM_INIT_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_SDRAM_INIT_REQ_MASK) >> MC_USER_COMMAND_0_SDRAM_INIT_REQ_SHIFT)
#define  MC_USER_COMMAND_0_SDRAM_INIT_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_SDRAM_INIT_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_SDRAM_INIT_REQ_SHIFT))

//====================================================================
//Register: User Initiated Command Register 2 (USER_COMMAND_2)
/** \brief This is a write-only register used only for DDR4 MPR read.
      Note: Commands are used with channel and chip-select.
      The individual CS bits may be programmed simultaneously except when issuing MRR.*/
//====================================================================

#define  MC_USER_COMMAND_2_RESERVED1_MASK 0xe0000000
#define  MC_USER_COMMAND_2_RESERVED1_SHIFT 29
#define  MC_USER_COMMAND_2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_2_RESERVED1_MASK) >> MC_USER_COMMAND_2_RESERVED1_SHIFT)
#define  MC_USER_COMMAND_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_2_RESERVED1_MASK) | (((uint32_t)val) << MC_USER_COMMAND_2_RESERVED1_SHIFT))

#define  MC_USER_COMMAND_2_CH0_MASK 0x10000000
#define  MC_USER_COMMAND_2_CH0_SHIFT 28
#define  MC_USER_COMMAND_2_CH0_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_2_CH0_MASK) >> MC_USER_COMMAND_2_CH0_SHIFT)
#define  MC_USER_COMMAND_2_CH0_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_2_CH0_MASK) | (((uint32_t)val) << MC_USER_COMMAND_2_CH0_SHIFT))

#define  MC_USER_COMMAND_2_RESERVED2_MASK 0xe000000
#define  MC_USER_COMMAND_2_RESERVED2_SHIFT 25
#define  MC_USER_COMMAND_2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_2_RESERVED2_MASK) >> MC_USER_COMMAND_2_RESERVED2_SHIFT)
#define  MC_USER_COMMAND_2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_2_RESERVED2_MASK) | (((uint32_t)val) << MC_USER_COMMAND_2_RESERVED2_SHIFT))

#define  MC_USER_COMMAND_2_CS0_MASK 0x1000000
#define  MC_USER_COMMAND_2_CS0_SHIFT 24
#define  MC_USER_COMMAND_2_CS0_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_2_CS0_MASK) >> MC_USER_COMMAND_2_CS0_SHIFT)
#define  MC_USER_COMMAND_2_CS0_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_2_CS0_MASK) | (((uint32_t)val) << MC_USER_COMMAND_2_CS0_SHIFT))

#define  MC_USER_COMMAND_2_RESERVED3_MASK 0xffff00
#define  MC_USER_COMMAND_2_RESERVED3_SHIFT 8
#define  MC_USER_COMMAND_2_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_2_RESERVED3_MASK) >> MC_USER_COMMAND_2_RESERVED3_SHIFT)
#define  MC_USER_COMMAND_2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_2_RESERVED3_MASK) | (((uint32_t)val) << MC_USER_COMMAND_2_RESERVED3_SHIFT))

#define  MC_USER_COMMAND_2_DEVICE_SEL_MASK 0xf8
#define  MC_USER_COMMAND_2_DEVICE_SEL_SHIFT 3
#define  MC_USER_COMMAND_2_DEVICE_SEL_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_2_DEVICE_SEL_MASK) >> MC_USER_COMMAND_2_DEVICE_SEL_SHIFT)
#define  MC_USER_COMMAND_2_DEVICE_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_2_DEVICE_SEL_MASK) | (((uint32_t)val) << MC_USER_COMMAND_2_DEVICE_SEL_SHIFT))

#define  MC_USER_COMMAND_2_MPRRD_PAGE3_REQ_MASK 0x4
#define  MC_USER_COMMAND_2_MPRRD_PAGE3_REQ_SHIFT 2
#define  MC_USER_COMMAND_2_MPRRD_PAGE3_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_2_MPRRD_PAGE3_REQ_MASK) >> MC_USER_COMMAND_2_MPRRD_PAGE3_REQ_SHIFT)
#define  MC_USER_COMMAND_2_MPRRD_PAGE3_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_2_MPRRD_PAGE3_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_2_MPRRD_PAGE3_REQ_SHIFT))

#define  MC_USER_COMMAND_2_MPRRD_PAGE2_REQ_MASK 0x2
#define  MC_USER_COMMAND_2_MPRRD_PAGE2_REQ_SHIFT 1
#define  MC_USER_COMMAND_2_MPRRD_PAGE2_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_2_MPRRD_PAGE2_REQ_MASK) >> MC_USER_COMMAND_2_MPRRD_PAGE2_REQ_SHIFT)
#define  MC_USER_COMMAND_2_MPRRD_PAGE2_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_2_MPRRD_PAGE2_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_2_MPRRD_PAGE2_REQ_SHIFT))

#define  MC_USER_COMMAND_2_MPRRD_PAGE1_REQ_MASK 0x1
#define  MC_USER_COMMAND_2_MPRRD_PAGE1_REQ_SHIFT 0
#define  MC_USER_COMMAND_2_MPRRD_PAGE1_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_2_MPRRD_PAGE1_REQ_MASK) >> MC_USER_COMMAND_2_MPRRD_PAGE1_REQ_SHIFT)
#define  MC_USER_COMMAND_2_MPRRD_PAGE1_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_2_MPRRD_PAGE1_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_2_MPRRD_PAGE1_REQ_SHIFT))

//====================================================================
//Register: Internal SRAM Control Register (SRAM_control)
//====================================================================

#define  MC_SRAM_CONTROL_REGTABLE_WTC_MASK 0xf0000000
#define  MC_SRAM_CONTROL_REGTABLE_WTC_SHIFT 28
#define  MC_SRAM_CONTROL_REGTABLE_WTC_MASK_SHIFT(reg) (((reg) & MC_SRAM_CONTROL_REGTABLE_WTC_MASK) >> MC_SRAM_CONTROL_REGTABLE_WTC_SHIFT)
#define  MC_SRAM_CONTROL_REGTABLE_WTC_REPLACE_VAL(reg,val) (((reg) & ~MC_SRAM_CONTROL_REGTABLE_WTC_MASK) | (((uint32_t)val) << MC_SRAM_CONTROL_REGTABLE_WTC_SHIFT))

#define  MC_SRAM_CONTROL_REGTABLE_RTC_MASK 0xf000000
#define  MC_SRAM_CONTROL_REGTABLE_RTC_SHIFT 24
#define  MC_SRAM_CONTROL_REGTABLE_RTC_MASK_SHIFT(reg) (((reg) & MC_SRAM_CONTROL_REGTABLE_RTC_MASK) >> MC_SRAM_CONTROL_REGTABLE_RTC_SHIFT)
#define  MC_SRAM_CONTROL_REGTABLE_RTC_REPLACE_VAL(reg,val) (((reg) & ~MC_SRAM_CONTROL_REGTABLE_RTC_MASK) | (((uint32_t)val) << MC_SRAM_CONTROL_REGTABLE_RTC_SHIFT))

#define  MC_SRAM_CONTROL_WDB_WTC_MASK 0xf00000
#define  MC_SRAM_CONTROL_WDB_WTC_SHIFT 20
#define  MC_SRAM_CONTROL_WDB_WTC_MASK_SHIFT(reg) (((reg) & MC_SRAM_CONTROL_WDB_WTC_MASK) >> MC_SRAM_CONTROL_WDB_WTC_SHIFT)
#define  MC_SRAM_CONTROL_WDB_WTC_REPLACE_VAL(reg,val) (((reg) & ~MC_SRAM_CONTROL_WDB_WTC_MASK) | (((uint32_t)val) << MC_SRAM_CONTROL_WDB_WTC_SHIFT))

#define  MC_SRAM_CONTROL_WDB_RTC_MASK 0xf0000
#define  MC_SRAM_CONTROL_WDB_RTC_SHIFT 16
#define  MC_SRAM_CONTROL_WDB_RTC_MASK_SHIFT(reg) (((reg) & MC_SRAM_CONTROL_WDB_RTC_MASK) >> MC_SRAM_CONTROL_WDB_RTC_SHIFT)
#define  MC_SRAM_CONTROL_WDB_RTC_REPLACE_VAL(reg,val) (((reg) & ~MC_SRAM_CONTROL_WDB_RTC_MASK) | (((uint32_t)val) << MC_SRAM_CONTROL_WDB_RTC_SHIFT))

#define  MC_SRAM_CONTROL_RESERVED1_MASK 0xc000
#define  MC_SRAM_CONTROL_RESERVED1_SHIFT 14
#define  MC_SRAM_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SRAM_CONTROL_RESERVED1_MASK) >> MC_SRAM_CONTROL_RESERVED1_SHIFT)
#define  MC_SRAM_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SRAM_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << MC_SRAM_CONTROL_RESERVED1_SHIFT))

#define  MC_SRAM_CONTROL_SRAM_PDWN_EXIT_WAIT_CYCLE_MASK 0x3f00
#define  MC_SRAM_CONTROL_SRAM_PDWN_EXIT_WAIT_CYCLE_SHIFT 8
#define  MC_SRAM_CONTROL_SRAM_PDWN_EXIT_WAIT_CYCLE_MASK_SHIFT(reg) (((reg) & MC_SRAM_CONTROL_SRAM_PDWN_EXIT_WAIT_CYCLE_MASK) >> MC_SRAM_CONTROL_SRAM_PDWN_EXIT_WAIT_CYCLE_SHIFT)
#define  MC_SRAM_CONTROL_SRAM_PDWN_EXIT_WAIT_CYCLE_REPLACE_VAL(reg,val) (((reg) & ~MC_SRAM_CONTROL_SRAM_PDWN_EXIT_WAIT_CYCLE_MASK) | (((uint32_t)val) << MC_SRAM_CONTROL_SRAM_PDWN_EXIT_WAIT_CYCLE_SHIFT))

#define  MC_SRAM_CONTROL_ROB_WTC_MASK 0xf0
#define  MC_SRAM_CONTROL_ROB_WTC_SHIFT 4
#define  MC_SRAM_CONTROL_ROB_WTC_MASK_SHIFT(reg) (((reg) & MC_SRAM_CONTROL_ROB_WTC_MASK) >> MC_SRAM_CONTROL_ROB_WTC_SHIFT)
#define  MC_SRAM_CONTROL_ROB_WTC_REPLACE_VAL(reg,val) (((reg) & ~MC_SRAM_CONTROL_ROB_WTC_MASK) | (((uint32_t)val) << MC_SRAM_CONTROL_ROB_WTC_SHIFT))

#define  MC_SRAM_CONTROL_ROB_RTC_MASK 0xf
#define  MC_SRAM_CONTROL_ROB_RTC_SHIFT 0
#define  MC_SRAM_CONTROL_ROB_RTC_MASK_SHIFT(reg) (((reg) & MC_SRAM_CONTROL_ROB_RTC_MASK) >> MC_SRAM_CONTROL_ROB_RTC_SHIFT)
#define  MC_SRAM_CONTROL_ROB_RTC_REPLACE_VAL(reg,val) (((reg) & ~MC_SRAM_CONTROL_ROB_RTC_MASK) | (((uint32_t)val) << MC_SRAM_CONTROL_ROB_RTC_SHIFT))

//====================================================================
//Register: MC Control Register 0 (MC_Control_0)
//====================================================================

#define  MC_MC_CONTROL_0_TRUSTZONE_LOCK_MASK 0x80000000
#define  MC_MC_CONTROL_0_TRUSTZONE_LOCK_SHIFT 31
#define  MC_MC_CONTROL_0_TRUSTZONE_LOCK_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_TRUSTZONE_LOCK_MASK) >> MC_MC_CONTROL_0_TRUSTZONE_LOCK_SHIFT)
#define  MC_MC_CONTROL_0_TRUSTZONE_LOCK_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_TRUSTZONE_LOCK_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_TRUSTZONE_LOCK_SHIFT))

#define  MC_MC_CONTROL_0_ADDR_MAP_LOCK_MASK 0x40000000
#define  MC_MC_CONTROL_0_ADDR_MAP_LOCK_SHIFT 30
#define  MC_MC_CONTROL_0_ADDR_MAP_LOCK_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_ADDR_MAP_LOCK_MASK) >> MC_MC_CONTROL_0_ADDR_MAP_LOCK_SHIFT)
#define  MC_MC_CONTROL_0_ADDR_MAP_LOCK_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_ADDR_MAP_LOCK_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_ADDR_MAP_LOCK_SHIFT))

#define  MC_MC_CONTROL_0_RESERVED1_MASK 0x30000000
#define  MC_MC_CONTROL_0_RESERVED1_SHIFT 28
#define  MC_MC_CONTROL_0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_RESERVED1_MASK) >> MC_MC_CONTROL_0_RESERVED1_SHIFT)
#define  MC_MC_CONTROL_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_RESERVED1_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_RESERVED1_SHIFT))

#define  MC_MC_CONTROL_0_CHOP_CHANGE_MASK 0x8000000
#define  MC_MC_CONTROL_0_CHOP_CHANGE_SHIFT 27
#define  MC_MC_CONTROL_0_CHOP_CHANGE_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_CHOP_CHANGE_MASK) >> MC_MC_CONTROL_0_CHOP_CHANGE_SHIFT)
#define  MC_MC_CONTROL_0_CHOP_CHANGE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_CHOP_CHANGE_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_CHOP_CHANGE_SHIFT))

#define  MC_MC_CONTROL_0_AXI_CHOP_MASK 0x7000000
#define  MC_MC_CONTROL_0_AXI_CHOP_SHIFT 24
#define  MC_MC_CONTROL_0_AXI_CHOP_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_AXI_CHOP_MASK) >> MC_MC_CONTROL_0_AXI_CHOP_SHIFT)
#define  MC_MC_CONTROL_0_AXI_CHOP_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_AXI_CHOP_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_AXI_CHOP_SHIFT))

#define  MC_MC_CONTROL_0_RESERVED2_MASK 0xfe0000
#define  MC_MC_CONTROL_0_RESERVED2_SHIFT 17
#define  MC_MC_CONTROL_0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_RESERVED2_MASK) >> MC_MC_CONTROL_0_RESERVED2_SHIFT)
#define  MC_MC_CONTROL_0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_RESERVED2_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_RESERVED2_SHIFT))

#define  MC_MC_CONTROL_0_BLOCK_ALL_DATA_REQ_MASK 0x10000
#define  MC_MC_CONTROL_0_BLOCK_ALL_DATA_REQ_SHIFT 16
#define  MC_MC_CONTROL_0_BLOCK_ALL_DATA_REQ_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_BLOCK_ALL_DATA_REQ_MASK) >> MC_MC_CONTROL_0_BLOCK_ALL_DATA_REQ_SHIFT)
#define  MC_MC_CONTROL_0_BLOCK_ALL_DATA_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_BLOCK_ALL_DATA_REQ_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_BLOCK_ALL_DATA_REQ_SHIFT))

#define  MC_MC_CONTROL_0_RESERVED3_MASK 0xe000
#define  MC_MC_CONTROL_0_RESERVED3_SHIFT 13
#define  MC_MC_CONTROL_0_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_RESERVED3_MASK) >> MC_MC_CONTROL_0_RESERVED3_SHIFT)
#define  MC_MC_CONTROL_0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_RESERVED3_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_RESERVED3_SHIFT))

#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P4_MASK 0x1000
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P4_SHIFT 12
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P4_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P4_MASK) >> MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P4_SHIFT)
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P4_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P4_SHIFT))

#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P3_MASK 0x800
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P3_SHIFT 11
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P3_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P3_MASK) >> MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P3_SHIFT)
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P3_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P3_SHIFT))

#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P2_MASK 0x400
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P2_SHIFT 10
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P2_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P2_MASK) >> MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P2_SHIFT)
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P2_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P2_SHIFT))

#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P1_MASK 0x200
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P1_SHIFT 9
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P1_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P1_MASK) >> MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P1_SHIFT)
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P1_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P1_SHIFT))

#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P0_MASK 0x100
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P0_SHIFT 8
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P0_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P0_MASK) >> MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P0_SHIFT)
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P0_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_P0_SHIFT))

#define  MC_MC_CONTROL_0_RESERVED4_MASK 0x80
#define  MC_MC_CONTROL_0_RESERVED4_SHIFT 7
#define  MC_MC_CONTROL_0_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_RESERVED4_MASK) >> MC_MC_CONTROL_0_RESERVED4_SHIFT)
#define  MC_MC_CONTROL_0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_RESERVED4_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_RESERVED4_SHIFT))

#define  MC_MC_CONTROL_0_ACC_SR_ERR_EN_MASK 0x40
#define  MC_MC_CONTROL_0_ACC_SR_ERR_EN_SHIFT 6
#define  MC_MC_CONTROL_0_ACC_SR_ERR_EN_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_ACC_SR_ERR_EN_MASK) >> MC_MC_CONTROL_0_ACC_SR_ERR_EN_SHIFT)
#define  MC_MC_CONTROL_0_ACC_SR_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_ACC_SR_ERR_EN_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_ACC_SR_ERR_EN_SHIFT))

#define  MC_MC_CONTROL_0_TEST_MODE_MASK 0x20
#define  MC_MC_CONTROL_0_TEST_MODE_SHIFT 5
#define  MC_MC_CONTROL_0_TEST_MODE_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_TEST_MODE_MASK) >> MC_MC_CONTROL_0_TEST_MODE_SHIFT)
#define  MC_MC_CONTROL_0_TEST_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_TEST_MODE_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_TEST_MODE_SHIFT))

#define  MC_MC_CONTROL_0_WRITE_LEVEL_MODE_MASK 0x10
#define  MC_MC_CONTROL_0_WRITE_LEVEL_MODE_SHIFT 4
#define  MC_MC_CONTROL_0_WRITE_LEVEL_MODE_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_WRITE_LEVEL_MODE_MASK) >> MC_MC_CONTROL_0_WRITE_LEVEL_MODE_SHIFT)
#define  MC_MC_CONTROL_0_WRITE_LEVEL_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_WRITE_LEVEL_MODE_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_WRITE_LEVEL_MODE_SHIFT))

#define  MC_MC_CONTROL_0_ECC_TRAINING_MODE_MASK 0x8
#define  MC_MC_CONTROL_0_ECC_TRAINING_MODE_SHIFT 3
#define  MC_MC_CONTROL_0_ECC_TRAINING_MODE_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_ECC_TRAINING_MODE_MASK) >> MC_MC_CONTROL_0_ECC_TRAINING_MODE_SHIFT)
#define  MC_MC_CONTROL_0_ECC_TRAINING_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_ECC_TRAINING_MODE_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_ECC_TRAINING_MODE_SHIFT))

#define  MC_MC_CONTROL_0_RESERVED5_MASK 0x4
#define  MC_MC_CONTROL_0_RESERVED5_SHIFT 2
#define  MC_MC_CONTROL_0_RESERVED5_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_RESERVED5_MASK) >> MC_MC_CONTROL_0_RESERVED5_SHIFT)
#define  MC_MC_CONTROL_0_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_RESERVED5_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_RESERVED5_SHIFT))

#define  MC_MC_CONTROL_0_HALT_SCDLR_MASK 0x2
#define  MC_MC_CONTROL_0_HALT_SCDLR_SHIFT 1
#define  MC_MC_CONTROL_0_HALT_SCDLR_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_HALT_SCDLR_MASK) >> MC_MC_CONTROL_0_HALT_SCDLR_SHIFT)
#define  MC_MC_CONTROL_0_HALT_SCDLR_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_HALT_SCDLR_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_HALT_SCDLR_SHIFT))

#define  MC_MC_CONTROL_0_DFC_MODE_MASK 0x1
#define  MC_MC_CONTROL_0_DFC_MODE_SHIFT 0
#define  MC_MC_CONTROL_0_DFC_MODE_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_DFC_MODE_MASK) >> MC_MC_CONTROL_0_DFC_MODE_SHIFT)
#define  MC_MC_CONTROL_0_DFC_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_DFC_MODE_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_DFC_MODE_SHIFT))

//====================================================================
//Register: Exclusive Monitor Control Register (Exclusive_Monitor)
/** \brief Note: The exclusive monitor data size is controlled by <<xref=MC_Control_0/axi_chop>>.
      The monitored data size is the same as the chopping size.*/
//====================================================================

#define  MC_EXCLUSIVE_MONITOR_RESERVED1_MASK 0xfffe0000
#define  MC_EXCLUSIVE_MONITOR_RESERVED1_SHIFT 17
#define  MC_EXCLUSIVE_MONITOR_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_EXCLUSIVE_MONITOR_RESERVED1_MASK) >> MC_EXCLUSIVE_MONITOR_RESERVED1_SHIFT)
#define  MC_EXCLUSIVE_MONITOR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_EXCLUSIVE_MONITOR_RESERVED1_MASK) | (((uint32_t)val) << MC_EXCLUSIVE_MONITOR_RESERVED1_SHIFT))

#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P4_MASK 0x10000
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P4_SHIFT 16
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P4_MASK_SHIFT(reg) (((reg) & MC_EXCLUSIVE_MONITOR_EXCLU_EN_P4_MASK) >> MC_EXCLUSIVE_MONITOR_EXCLU_EN_P4_SHIFT)
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_EXCLUSIVE_MONITOR_EXCLU_EN_P4_MASK) | (((uint32_t)val) << MC_EXCLUSIVE_MONITOR_EXCLU_EN_P4_SHIFT))

#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P3_MASK 0x8000
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P3_SHIFT 15
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P3_MASK_SHIFT(reg) (((reg) & MC_EXCLUSIVE_MONITOR_EXCLU_EN_P3_MASK) >> MC_EXCLUSIVE_MONITOR_EXCLU_EN_P3_SHIFT)
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_EXCLUSIVE_MONITOR_EXCLU_EN_P3_MASK) | (((uint32_t)val) << MC_EXCLUSIVE_MONITOR_EXCLU_EN_P3_SHIFT))

#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P2_MASK 0x4000
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P2_SHIFT 14
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P2_MASK_SHIFT(reg) (((reg) & MC_EXCLUSIVE_MONITOR_EXCLU_EN_P2_MASK) >> MC_EXCLUSIVE_MONITOR_EXCLU_EN_P2_SHIFT)
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_EXCLUSIVE_MONITOR_EXCLU_EN_P2_MASK) | (((uint32_t)val) << MC_EXCLUSIVE_MONITOR_EXCLU_EN_P2_SHIFT))

#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P1_MASK 0x2000
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P1_SHIFT 13
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P1_MASK_SHIFT(reg) (((reg) & MC_EXCLUSIVE_MONITOR_EXCLU_EN_P1_MASK) >> MC_EXCLUSIVE_MONITOR_EXCLU_EN_P1_SHIFT)
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_EXCLUSIVE_MONITOR_EXCLU_EN_P1_MASK) | (((uint32_t)val) << MC_EXCLUSIVE_MONITOR_EXCLU_EN_P1_SHIFT))

#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P0_MASK 0x1000
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P0_SHIFT 12
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P0_MASK_SHIFT(reg) (((reg) & MC_EXCLUSIVE_MONITOR_EXCLU_EN_P0_MASK) >> MC_EXCLUSIVE_MONITOR_EXCLU_EN_P0_SHIFT)
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_EXCLUSIVE_MONITOR_EXCLU_EN_P0_MASK) | (((uint32_t)val) << MC_EXCLUSIVE_MONITOR_EXCLU_EN_P0_SHIFT))

#define  MC_EXCLUSIVE_MONITOR_RESERVED2_MASK 0xfff
#define  MC_EXCLUSIVE_MONITOR_RESERVED2_SHIFT 0
#define  MC_EXCLUSIVE_MONITOR_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_EXCLUSIVE_MONITOR_RESERVED2_MASK) >> MC_EXCLUSIVE_MONITOR_RESERVED2_SHIFT)
#define  MC_EXCLUSIVE_MONITOR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_EXCLUSIVE_MONITOR_RESERVED2_MASK) | (((uint32_t)val) << MC_EXCLUSIVE_MONITOR_RESERVED2_SHIFT))

//====================================================================
//Register: Data Coherency Check Control Register (Coherency)
//====================================================================

#define  MC_COHERENCY_RESERVED1_MASK 0xffffffe0
#define  MC_COHERENCY_RESERVED1_SHIFT 5
#define  MC_COHERENCY_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_COHERENCY_RESERVED1_MASK) >> MC_COHERENCY_RESERVED1_SHIFT)
#define  MC_COHERENCY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_COHERENCY_RESERVED1_MASK) | (((uint32_t)val) << MC_COHERENCY_RESERVED1_SHIFT))

#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P4_MASK 0x10
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P4_SHIFT 4
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P4_MASK_SHIFT(reg) (((reg) & MC_COHERENCY_COHERENCY_CHECK_DISABLE_P4_MASK) >> MC_COHERENCY_COHERENCY_CHECK_DISABLE_P4_SHIFT)
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_COHERENCY_COHERENCY_CHECK_DISABLE_P4_MASK) | (((uint32_t)val) << MC_COHERENCY_COHERENCY_CHECK_DISABLE_P4_SHIFT))

#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P3_MASK 0x8
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P3_SHIFT 3
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P3_MASK_SHIFT(reg) (((reg) & MC_COHERENCY_COHERENCY_CHECK_DISABLE_P3_MASK) >> MC_COHERENCY_COHERENCY_CHECK_DISABLE_P3_SHIFT)
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_COHERENCY_COHERENCY_CHECK_DISABLE_P3_MASK) | (((uint32_t)val) << MC_COHERENCY_COHERENCY_CHECK_DISABLE_P3_SHIFT))

#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P2_MASK 0x4
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P2_SHIFT 2
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P2_MASK_SHIFT(reg) (((reg) & MC_COHERENCY_COHERENCY_CHECK_DISABLE_P2_MASK) >> MC_COHERENCY_COHERENCY_CHECK_DISABLE_P2_SHIFT)
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_COHERENCY_COHERENCY_CHECK_DISABLE_P2_MASK) | (((uint32_t)val) << MC_COHERENCY_COHERENCY_CHECK_DISABLE_P2_SHIFT))

#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P1_MASK 0x2
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P1_SHIFT 1
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P1_MASK_SHIFT(reg) (((reg) & MC_COHERENCY_COHERENCY_CHECK_DISABLE_P1_MASK) >> MC_COHERENCY_COHERENCY_CHECK_DISABLE_P1_SHIFT)
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_COHERENCY_COHERENCY_CHECK_DISABLE_P1_MASK) | (((uint32_t)val) << MC_COHERENCY_COHERENCY_CHECK_DISABLE_P1_SHIFT))

#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P0_MASK 0x1
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P0_SHIFT 0
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P0_MASK_SHIFT(reg) (((reg) & MC_COHERENCY_COHERENCY_CHECK_DISABLE_P0_MASK) >> MC_COHERENCY_COHERENCY_CHECK_DISABLE_P0_SHIFT)
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_COHERENCY_COHERENCY_CHECK_DISABLE_P0_MASK) | (((uint32_t)val) << MC_COHERENCY_COHERENCY_CHECK_DISABLE_P0_SHIFT))

//====================================================================
//Register: Restrict Zone Access Control Register (RZ_access_ctl)
/** \brief Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_RZ_ACCESS_CTL_RESERVED1_MASK 0xffffffe0
#define  MC_RZ_ACCESS_CTL_RESERVED1_SHIFT 5
#define  MC_RZ_ACCESS_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_RZ_ACCESS_CTL_RESERVED1_MASK) >> MC_RZ_ACCESS_CTL_RESERVED1_SHIFT)
#define  MC_RZ_ACCESS_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_RZ_ACCESS_CTL_RESERVED1_MASK) | (((uint32_t)val) << MC_RZ_ACCESS_CTL_RESERVED1_SHIFT))

#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P4_MASK 0x10
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P4_SHIFT 4
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P4_MASK_SHIFT(reg) (((reg) & MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P4_MASK) >> MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P4_SHIFT)
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P4_MASK) | (((uint32_t)val) << MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P4_SHIFT))

#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P3_MASK 0x8
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P3_SHIFT 3
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P3_MASK_SHIFT(reg) (((reg) & MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P3_MASK) >> MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P3_SHIFT)
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P3_MASK) | (((uint32_t)val) << MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P3_SHIFT))

#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P2_MASK 0x4
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P2_SHIFT 2
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P2_MASK_SHIFT(reg) (((reg) & MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P2_MASK) >> MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P2_SHIFT)
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P2_MASK) | (((uint32_t)val) << MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P2_SHIFT))

#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P1_MASK 0x2
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P1_SHIFT 1
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P1_MASK_SHIFT(reg) (((reg) & MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P1_MASK) >> MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P1_SHIFT)
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P1_MASK) | (((uint32_t)val) << MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P1_SHIFT))

#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P0_MASK 0x1
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P0_SHIFT 0
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P0_MASK_SHIFT(reg) (((reg) & MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P0_MASK) >> MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P0_SHIFT)
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P0_MASK) | (((uint32_t)val) << MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_P0_SHIFT))

//====================================================================
//Register: MC Power Control Register (MC_pwr_ctl)
/** \brief The BQ,DPCR,ROB and SRAM clocks can be gated using local clock gating cells.
      The DDR address/command line can be turned-off when external DDRs are in one of the following power saving states:
      - PowerDown
      - SelfRefresh
      - DeepPowerDown*/
//====================================================================

#define  MC_MC_PWR_CTL_RESERVED1_MASK 0xffe00000
#define  MC_MC_PWR_CTL_RESERVED1_SHIFT 21
#define  MC_MC_PWR_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MC_PWR_CTL_RESERVED1_MASK) >> MC_MC_PWR_CTL_RESERVED1_SHIFT)
#define  MC_MC_PWR_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_PWR_CTL_RESERVED1_MASK) | (((uint32_t)val) << MC_MC_PWR_CTL_RESERVED1_SHIFT))

#define  MC_MC_PWR_CTL_DIS_WDB_SRAM_CK_GATE_MASK 0x100000
#define  MC_MC_PWR_CTL_DIS_WDB_SRAM_CK_GATE_SHIFT 20
#define  MC_MC_PWR_CTL_DIS_WDB_SRAM_CK_GATE_MASK_SHIFT(reg) (((reg) & MC_MC_PWR_CTL_DIS_WDB_SRAM_CK_GATE_MASK) >> MC_MC_PWR_CTL_DIS_WDB_SRAM_CK_GATE_SHIFT)
#define  MC_MC_PWR_CTL_DIS_WDB_SRAM_CK_GATE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_PWR_CTL_DIS_WDB_SRAM_CK_GATE_MASK) | (((uint32_t)val) << MC_MC_PWR_CTL_DIS_WDB_SRAM_CK_GATE_SHIFT))

#define  MC_MC_PWR_CTL_DIS_ROB_SRAM_CK_GATE_MASK 0x80000
#define  MC_MC_PWR_CTL_DIS_ROB_SRAM_CK_GATE_SHIFT 19
#define  MC_MC_PWR_CTL_DIS_ROB_SRAM_CK_GATE_MASK_SHIFT(reg) (((reg) & MC_MC_PWR_CTL_DIS_ROB_SRAM_CK_GATE_MASK) >> MC_MC_PWR_CTL_DIS_ROB_SRAM_CK_GATE_SHIFT)
#define  MC_MC_PWR_CTL_DIS_ROB_SRAM_CK_GATE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_PWR_CTL_DIS_ROB_SRAM_CK_GATE_MASK) | (((uint32_t)val) << MC_MC_PWR_CTL_DIS_ROB_SRAM_CK_GATE_SHIFT))

#define  MC_MC_PWR_CTL_DIS_ROB_CK_GATE_MASK 0x40000
#define  MC_MC_PWR_CTL_DIS_ROB_CK_GATE_SHIFT 18
#define  MC_MC_PWR_CTL_DIS_ROB_CK_GATE_MASK_SHIFT(reg) (((reg) & MC_MC_PWR_CTL_DIS_ROB_CK_GATE_MASK) >> MC_MC_PWR_CTL_DIS_ROB_CK_GATE_SHIFT)
#define  MC_MC_PWR_CTL_DIS_ROB_CK_GATE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_PWR_CTL_DIS_ROB_CK_GATE_MASK) | (((uint32_t)val) << MC_MC_PWR_CTL_DIS_ROB_CK_GATE_SHIFT))

#define  MC_MC_PWR_CTL_DIS_DPCR_CK_GATE_MASK 0x20000
#define  MC_MC_PWR_CTL_DIS_DPCR_CK_GATE_SHIFT 17
#define  MC_MC_PWR_CTL_DIS_DPCR_CK_GATE_MASK_SHIFT(reg) (((reg) & MC_MC_PWR_CTL_DIS_DPCR_CK_GATE_MASK) >> MC_MC_PWR_CTL_DIS_DPCR_CK_GATE_SHIFT)
#define  MC_MC_PWR_CTL_DIS_DPCR_CK_GATE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_PWR_CTL_DIS_DPCR_CK_GATE_MASK) | (((uint32_t)val) << MC_MC_PWR_CTL_DIS_DPCR_CK_GATE_SHIFT))

#define  MC_MC_PWR_CTL_DIS_BQ_CK_GATE_MASK 0x10000
#define  MC_MC_PWR_CTL_DIS_BQ_CK_GATE_SHIFT 16
#define  MC_MC_PWR_CTL_DIS_BQ_CK_GATE_MASK_SHIFT(reg) (((reg) & MC_MC_PWR_CTL_DIS_BQ_CK_GATE_MASK) >> MC_MC_PWR_CTL_DIS_BQ_CK_GATE_SHIFT)
#define  MC_MC_PWR_CTL_DIS_BQ_CK_GATE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_PWR_CTL_DIS_BQ_CK_GATE_MASK) | (((uint32_t)val) << MC_MC_PWR_CTL_DIS_BQ_CK_GATE_SHIFT))

#define  MC_MC_PWR_CTL_RESERVED2_MASK 0xf000
#define  MC_MC_PWR_CTL_RESERVED2_SHIFT 12
#define  MC_MC_PWR_CTL_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_MC_PWR_CTL_RESERVED2_MASK) >> MC_MC_PWR_CTL_RESERVED2_SHIFT)
#define  MC_MC_PWR_CTL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_PWR_CTL_RESERVED2_MASK) | (((uint32_t)val) << MC_MC_PWR_CTL_RESERVED2_SHIFT))

#define  MC_MC_PWR_CTL_AC_ON_DLY_MASK 0xf00
#define  MC_MC_PWR_CTL_AC_ON_DLY_SHIFT 8
#define  MC_MC_PWR_CTL_AC_ON_DLY_MASK_SHIFT(reg) (((reg) & MC_MC_PWR_CTL_AC_ON_DLY_MASK) >> MC_MC_PWR_CTL_AC_ON_DLY_SHIFT)
#define  MC_MC_PWR_CTL_AC_ON_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_PWR_CTL_AC_ON_DLY_MASK) | (((uint32_t)val) << MC_MC_PWR_CTL_AC_ON_DLY_SHIFT))

#define  MC_MC_PWR_CTL_AC_OFF_DLY_MASK 0xf0
#define  MC_MC_PWR_CTL_AC_OFF_DLY_SHIFT 4
#define  MC_MC_PWR_CTL_AC_OFF_DLY_MASK_SHIFT(reg) (((reg) & MC_MC_PWR_CTL_AC_OFF_DLY_MASK) >> MC_MC_PWR_CTL_AC_OFF_DLY_SHIFT)
#define  MC_MC_PWR_CTL_AC_OFF_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_PWR_CTL_AC_OFF_DLY_MASK) | (((uint32_t)val) << MC_MC_PWR_CTL_AC_OFF_DLY_SHIFT))

#define  MC_MC_PWR_CTL_RESERVED3_MASK 0xc
#define  MC_MC_PWR_CTL_RESERVED3_SHIFT 2
#define  MC_MC_PWR_CTL_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_MC_PWR_CTL_RESERVED3_MASK) >> MC_MC_PWR_CTL_RESERVED3_SHIFT)
#define  MC_MC_PWR_CTL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_PWR_CTL_RESERVED3_MASK) | (((uint32_t)val) << MC_MC_PWR_CTL_RESERVED3_SHIFT))

#define  MC_MC_PWR_CTL_PHY_CLK_GATING_EN_MASK 0x2
#define  MC_MC_PWR_CTL_PHY_CLK_GATING_EN_SHIFT 1
#define  MC_MC_PWR_CTL_PHY_CLK_GATING_EN_MASK_SHIFT(reg) (((reg) & MC_MC_PWR_CTL_PHY_CLK_GATING_EN_MASK) >> MC_MC_PWR_CTL_PHY_CLK_GATING_EN_SHIFT)
#define  MC_MC_PWR_CTL_PHY_CLK_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_PWR_CTL_PHY_CLK_GATING_EN_MASK) | (((uint32_t)val) << MC_MC_PWR_CTL_PHY_CLK_GATING_EN_SHIFT))

#define  MC_MC_PWR_CTL_PHY_AUTO_AC_OFF_EN_MASK 0x1
#define  MC_MC_PWR_CTL_PHY_AUTO_AC_OFF_EN_SHIFT 0
#define  MC_MC_PWR_CTL_PHY_AUTO_AC_OFF_EN_MASK_SHIFT(reg) (((reg) & MC_MC_PWR_CTL_PHY_AUTO_AC_OFF_EN_MASK) >> MC_MC_PWR_CTL_PHY_AUTO_AC_OFF_EN_SHIFT)
#define  MC_MC_PWR_CTL_PHY_AUTO_AC_OFF_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_PWR_CTL_PHY_AUTO_AC_OFF_EN_MASK) | (((uint32_t)val) << MC_MC_PWR_CTL_PHY_AUTO_AC_OFF_EN_SHIFT))

//====================================================================
//Register: Write Command Buffer (WCB) Control Register (WCB_Control)
//====================================================================

#define  MC_WCB_CONTROL_RESERVED1_MASK 0xfffffff8
#define  MC_WCB_CONTROL_RESERVED1_SHIFT 3
#define  MC_WCB_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_WCB_CONTROL_RESERVED1_MASK) >> MC_WCB_CONTROL_RESERVED1_SHIFT)
#define  MC_WCB_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_WCB_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << MC_WCB_CONTROL_RESERVED1_SHIFT))

#define  MC_WCB_CONTROL_WCB_DRAIN_LEVEL_MASK 0x6
#define  MC_WCB_CONTROL_WCB_DRAIN_LEVEL_SHIFT 1
#define  MC_WCB_CONTROL_WCB_DRAIN_LEVEL_MASK_SHIFT(reg) (((reg) & MC_WCB_CONTROL_WCB_DRAIN_LEVEL_MASK) >> MC_WCB_CONTROL_WCB_DRAIN_LEVEL_SHIFT)
#define  MC_WCB_CONTROL_WCB_DRAIN_LEVEL_REPLACE_VAL(reg,val) (((reg) & ~MC_WCB_CONTROL_WCB_DRAIN_LEVEL_MASK) | (((uint32_t)val) << MC_WCB_CONTROL_WCB_DRAIN_LEVEL_SHIFT))

#define  MC_WCB_CONTROL_AUTO_WCB_DRAIN_EN_MASK 0x1
#define  MC_WCB_CONTROL_AUTO_WCB_DRAIN_EN_SHIFT 0
#define  MC_WCB_CONTROL_AUTO_WCB_DRAIN_EN_MASK_SHIFT(reg) (((reg) & MC_WCB_CONTROL_AUTO_WCB_DRAIN_EN_MASK) >> MC_WCB_CONTROL_AUTO_WCB_DRAIN_EN_SHIFT)
#define  MC_WCB_CONTROL_AUTO_WCB_DRAIN_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_WCB_CONTROL_AUTO_WCB_DRAIN_EN_MASK) | (((uint32_t)val) << MC_WCB_CONTROL_AUTO_WCB_DRAIN_EN_SHIFT))

//====================================================================
//Register: Bank Queue Control Register (BQ_Control)
//====================================================================

#define  MC_BQ_CONTROL_RESERVED1_MASK 0xfffffffc
#define  MC_BQ_CONTROL_RESERVED1_SHIFT 2
#define  MC_BQ_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_BQ_CONTROL_RESERVED1_MASK) >> MC_BQ_CONTROL_RESERVED1_SHIFT)
#define  MC_BQ_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_BQ_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << MC_BQ_CONTROL_RESERVED1_SHIFT))

#define  MC_BQ_CONTROL_BQ_DEPTH_MASK 0x3
#define  MC_BQ_CONTROL_BQ_DEPTH_SHIFT 0
#define  MC_BQ_CONTROL_BQ_DEPTH_MASK_SHIFT(reg) (((reg) & MC_BQ_CONTROL_BQ_DEPTH_MASK) >> MC_BQ_CONTROL_BQ_DEPTH_SHIFT)
#define  MC_BQ_CONTROL_BQ_DEPTH_REPLACE_VAL(reg,val) (((reg) & ~MC_BQ_CONTROL_BQ_DEPTH_MASK) | (((uint32_t)val) << MC_BQ_CONTROL_BQ_DEPTH_SHIFT))

//====================================================================
//Register: ROB Control Register (ROB_Control)
//====================================================================

#define  MC_ROB_CONTROL_RESERVED1_MASK 0xfffffffc
#define  MC_ROB_CONTROL_RESERVED1_SHIFT 2
#define  MC_ROB_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_ROB_CONTROL_RESERVED1_MASK) >> MC_ROB_CONTROL_RESERVED1_SHIFT)
#define  MC_ROB_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_ROB_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << MC_ROB_CONTROL_RESERVED1_SHIFT))

#define  MC_ROB_CONTROL_ROB_DATA_INTERLEAVING_DIS_MASK 0x2
#define  MC_ROB_CONTROL_ROB_DATA_INTERLEAVING_DIS_SHIFT 1
#define  MC_ROB_CONTROL_ROB_DATA_INTERLEAVING_DIS_MASK_SHIFT(reg) (((reg) & MC_ROB_CONTROL_ROB_DATA_INTERLEAVING_DIS_MASK) >> MC_ROB_CONTROL_ROB_DATA_INTERLEAVING_DIS_SHIFT)
#define  MC_ROB_CONTROL_ROB_DATA_INTERLEAVING_DIS_REPLACE_VAL(reg,val) (((reg) & ~MC_ROB_CONTROL_ROB_DATA_INTERLEAVING_DIS_MASK) | (((uint32_t)val) << MC_ROB_CONTROL_ROB_DATA_INTERLEAVING_DIS_SHIFT))

#define  MC_ROB_CONTROL_ROB_DELAY_READ_EN_MASK 0x1
#define  MC_ROB_CONTROL_ROB_DELAY_READ_EN_SHIFT 0
#define  MC_ROB_CONTROL_ROB_DELAY_READ_EN_MASK_SHIFT(reg) (((reg) & MC_ROB_CONTROL_ROB_DELAY_READ_EN_MASK) >> MC_ROB_CONTROL_ROB_DELAY_READ_EN_SHIFT)
#define  MC_ROB_CONTROL_ROB_DELAY_READ_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_ROB_CONTROL_ROB_DELAY_READ_EN_MASK) | (((uint32_t)val) << MC_ROB_CONTROL_ROB_DELAY_READ_EN_SHIFT))

//====================================================================
//Register: Port RRB Weight Register (Port_Weight)
/** \brief Programming all available ports to have 0 token enables flat round robin scheme (default).
      If a port is programmed to have 0 token, it is still possible to be granted when competing ports have no token.*/
//====================================================================

#define  MC_PORT_WEIGHT_RESERVED1_MASK 0xfff00000
#define  MC_PORT_WEIGHT_RESERVED1_SHIFT 20
#define  MC_PORT_WEIGHT_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PORT_WEIGHT_RESERVED1_MASK) >> MC_PORT_WEIGHT_RESERVED1_SHIFT)
#define  MC_PORT_WEIGHT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_WEIGHT_RESERVED1_MASK) | (((uint32_t)val) << MC_PORT_WEIGHT_RESERVED1_SHIFT))

#define  MC_PORT_WEIGHT_WEIGHT_P4_MASK 0xf0000
#define  MC_PORT_WEIGHT_WEIGHT_P4_SHIFT 16
#define  MC_PORT_WEIGHT_WEIGHT_P4_MASK_SHIFT(reg) (((reg) & MC_PORT_WEIGHT_WEIGHT_P4_MASK) >> MC_PORT_WEIGHT_WEIGHT_P4_SHIFT)
#define  MC_PORT_WEIGHT_WEIGHT_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_WEIGHT_WEIGHT_P4_MASK) | (((uint32_t)val) << MC_PORT_WEIGHT_WEIGHT_P4_SHIFT))

#define  MC_PORT_WEIGHT_WEIGHT_P3_MASK 0xf000
#define  MC_PORT_WEIGHT_WEIGHT_P3_SHIFT 12
#define  MC_PORT_WEIGHT_WEIGHT_P3_MASK_SHIFT(reg) (((reg) & MC_PORT_WEIGHT_WEIGHT_P3_MASK) >> MC_PORT_WEIGHT_WEIGHT_P3_SHIFT)
#define  MC_PORT_WEIGHT_WEIGHT_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_WEIGHT_WEIGHT_P3_MASK) | (((uint32_t)val) << MC_PORT_WEIGHT_WEIGHT_P3_SHIFT))

#define  MC_PORT_WEIGHT_WEIGHT_P2_MASK 0xf00
#define  MC_PORT_WEIGHT_WEIGHT_P2_SHIFT 8
#define  MC_PORT_WEIGHT_WEIGHT_P2_MASK_SHIFT(reg) (((reg) & MC_PORT_WEIGHT_WEIGHT_P2_MASK) >> MC_PORT_WEIGHT_WEIGHT_P2_SHIFT)
#define  MC_PORT_WEIGHT_WEIGHT_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_WEIGHT_WEIGHT_P2_MASK) | (((uint32_t)val) << MC_PORT_WEIGHT_WEIGHT_P2_SHIFT))

#define  MC_PORT_WEIGHT_WEIGHT_P1_MASK 0xf0
#define  MC_PORT_WEIGHT_WEIGHT_P1_SHIFT 4
#define  MC_PORT_WEIGHT_WEIGHT_P1_MASK_SHIFT(reg) (((reg) & MC_PORT_WEIGHT_WEIGHT_P1_MASK) >> MC_PORT_WEIGHT_WEIGHT_P1_SHIFT)
#define  MC_PORT_WEIGHT_WEIGHT_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_WEIGHT_WEIGHT_P1_MASK) | (((uint32_t)val) << MC_PORT_WEIGHT_WEIGHT_P1_SHIFT))

#define  MC_PORT_WEIGHT_WEIGHT_P0_MASK 0xf
#define  MC_PORT_WEIGHT_WEIGHT_P0_SHIFT 0
#define  MC_PORT_WEIGHT_WEIGHT_P0_MASK_SHIFT(reg) (((reg) & MC_PORT_WEIGHT_WEIGHT_P0_MASK) >> MC_PORT_WEIGHT_WEIGHT_P0_SHIFT)
#define  MC_PORT_WEIGHT_WEIGHT_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_WEIGHT_WEIGHT_P0_MASK) | (((uint32_t)val) << MC_PORT_WEIGHT_WEIGHT_P0_SHIFT))

//====================================================================
//Register: Port Priority Control Register (Port_priority)
//====================================================================

#define  MC_PORT_PRIORITY_RESERVED1_MASK 0xe0000000
#define  MC_PORT_PRIORITY_RESERVED1_SHIFT 29
#define  MC_PORT_PRIORITY_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_RESERVED1_MASK) >> MC_PORT_PRIORITY_RESERVED1_SHIFT)
#define  MC_PORT_PRIORITY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_RESERVED1_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_RESERVED1_SHIFT))

#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P4_MASK 0x10000000
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P4_SHIFT 28
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P4_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PORT_PRIORITY_EN_P4_MASK) >> MC_PORT_PRIORITY_PORT_PRIORITY_EN_P4_SHIFT)
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PORT_PRIORITY_EN_P4_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PORT_PRIORITY_EN_P4_SHIFT))

#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P3_MASK 0x8000000
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P3_SHIFT 27
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P3_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PORT_PRIORITY_EN_P3_MASK) >> MC_PORT_PRIORITY_PORT_PRIORITY_EN_P3_SHIFT)
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PORT_PRIORITY_EN_P3_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PORT_PRIORITY_EN_P3_SHIFT))

#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P2_MASK 0x4000000
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P2_SHIFT 26
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P2_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PORT_PRIORITY_EN_P2_MASK) >> MC_PORT_PRIORITY_PORT_PRIORITY_EN_P2_SHIFT)
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PORT_PRIORITY_EN_P2_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PORT_PRIORITY_EN_P2_SHIFT))

#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P1_MASK 0x2000000
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P1_SHIFT 25
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P1_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PORT_PRIORITY_EN_P1_MASK) >> MC_PORT_PRIORITY_PORT_PRIORITY_EN_P1_SHIFT)
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PORT_PRIORITY_EN_P1_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PORT_PRIORITY_EN_P1_SHIFT))

#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P0_MASK 0x1000000
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P0_SHIFT 24
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P0_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PORT_PRIORITY_EN_P0_MASK) >> MC_PORT_PRIORITY_PORT_PRIORITY_EN_P0_SHIFT)
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PORT_PRIORITY_EN_P0_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PORT_PRIORITY_EN_P0_SHIFT))

#define  MC_PORT_PRIORITY_RESERVED2_MASK 0xfffc00
#define  MC_PORT_PRIORITY_RESERVED2_SHIFT 10
#define  MC_PORT_PRIORITY_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_RESERVED2_MASK) >> MC_PORT_PRIORITY_RESERVED2_SHIFT)
#define  MC_PORT_PRIORITY_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_RESERVED2_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_RESERVED2_SHIFT))

#define  MC_PORT_PRIORITY_PRIORITY_P4_MASK 0x300
#define  MC_PORT_PRIORITY_PRIORITY_P4_SHIFT 8
#define  MC_PORT_PRIORITY_PRIORITY_P4_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PRIORITY_P4_MASK) >> MC_PORT_PRIORITY_PRIORITY_P4_SHIFT)
#define  MC_PORT_PRIORITY_PRIORITY_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PRIORITY_P4_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PRIORITY_P4_SHIFT))

#define  MC_PORT_PRIORITY_PRIORITY_P3_MASK 0xc0
#define  MC_PORT_PRIORITY_PRIORITY_P3_SHIFT 6
#define  MC_PORT_PRIORITY_PRIORITY_P3_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PRIORITY_P3_MASK) >> MC_PORT_PRIORITY_PRIORITY_P3_SHIFT)
#define  MC_PORT_PRIORITY_PRIORITY_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PRIORITY_P3_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PRIORITY_P3_SHIFT))

#define  MC_PORT_PRIORITY_PRIORITY_P2_MASK 0x30
#define  MC_PORT_PRIORITY_PRIORITY_P2_SHIFT 4
#define  MC_PORT_PRIORITY_PRIORITY_P2_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PRIORITY_P2_MASK) >> MC_PORT_PRIORITY_PRIORITY_P2_SHIFT)
#define  MC_PORT_PRIORITY_PRIORITY_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PRIORITY_P2_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PRIORITY_P2_SHIFT))

#define  MC_PORT_PRIORITY_PRIORITY_P1_MASK 0xc
#define  MC_PORT_PRIORITY_PRIORITY_P1_SHIFT 2
#define  MC_PORT_PRIORITY_PRIORITY_P1_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PRIORITY_P1_MASK) >> MC_PORT_PRIORITY_PRIORITY_P1_SHIFT)
#define  MC_PORT_PRIORITY_PRIORITY_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PRIORITY_P1_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PRIORITY_P1_SHIFT))

#define  MC_PORT_PRIORITY_PRIORITY_P0_MASK 0x3
#define  MC_PORT_PRIORITY_PRIORITY_P0_SHIFT 0
#define  MC_PORT_PRIORITY_PRIORITY_P0_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PRIORITY_P0_MASK) >> MC_PORT_PRIORITY_PRIORITY_P0_SHIFT)
#define  MC_PORT_PRIORITY_PRIORITY_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PRIORITY_P0_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PRIORITY_P0_SHIFT))

//====================================================================
//Register: RRB Starvation Prevention Register 0 (RRB_Starvation_0)
/** \brief This register is the initial value for RRB port 0 to 3 starvation timer (bits [11:4]). The setting resolution is 16 Memory Controller clock cycles.
      Upgrade the low priority requests in RRB to high priority when the timer expires.
      Set to 0 disables this feature.*/
//====================================================================

#define  MC_RRB_STARVATION_0_RRB_STARV_P3_MASK 0xff000000
#define  MC_RRB_STARVATION_0_RRB_STARV_P3_SHIFT 24
#define  MC_RRB_STARVATION_0_RRB_STARV_P3_MASK_SHIFT(reg) (((reg) & MC_RRB_STARVATION_0_RRB_STARV_P3_MASK) >> MC_RRB_STARVATION_0_RRB_STARV_P3_SHIFT)
#define  MC_RRB_STARVATION_0_RRB_STARV_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_RRB_STARVATION_0_RRB_STARV_P3_MASK) | (((uint32_t)val) << MC_RRB_STARVATION_0_RRB_STARV_P3_SHIFT))

#define  MC_RRB_STARVATION_0_RRB_STARV_P2_MASK 0xff0000
#define  MC_RRB_STARVATION_0_RRB_STARV_P2_SHIFT 16
#define  MC_RRB_STARVATION_0_RRB_STARV_P2_MASK_SHIFT(reg) (((reg) & MC_RRB_STARVATION_0_RRB_STARV_P2_MASK) >> MC_RRB_STARVATION_0_RRB_STARV_P2_SHIFT)
#define  MC_RRB_STARVATION_0_RRB_STARV_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_RRB_STARVATION_0_RRB_STARV_P2_MASK) | (((uint32_t)val) << MC_RRB_STARVATION_0_RRB_STARV_P2_SHIFT))

#define  MC_RRB_STARVATION_0_RRB_STARV_P1_MASK 0xff00
#define  MC_RRB_STARVATION_0_RRB_STARV_P1_SHIFT 8
#define  MC_RRB_STARVATION_0_RRB_STARV_P1_MASK_SHIFT(reg) (((reg) & MC_RRB_STARVATION_0_RRB_STARV_P1_MASK) >> MC_RRB_STARVATION_0_RRB_STARV_P1_SHIFT)
#define  MC_RRB_STARVATION_0_RRB_STARV_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_RRB_STARVATION_0_RRB_STARV_P1_MASK) | (((uint32_t)val) << MC_RRB_STARVATION_0_RRB_STARV_P1_SHIFT))

#define  MC_RRB_STARVATION_0_RRB_STARV_P0_MASK 0xff
#define  MC_RRB_STARVATION_0_RRB_STARV_P0_SHIFT 0
#define  MC_RRB_STARVATION_0_RRB_STARV_P0_MASK_SHIFT(reg) (((reg) & MC_RRB_STARVATION_0_RRB_STARV_P0_MASK) >> MC_RRB_STARVATION_0_RRB_STARV_P0_SHIFT)
#define  MC_RRB_STARVATION_0_RRB_STARV_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_RRB_STARVATION_0_RRB_STARV_P0_MASK) | (((uint32_t)val) << MC_RRB_STARVATION_0_RRB_STARV_P0_SHIFT))

//====================================================================
//Register: RRB Starvation Prevention Register 1 (RRB_Starvation_1)
/** \brief This register is the initial value for RRB port 4 to 4 starvation timer (bits [11:4]). The setting resolution is 16 Memory Controller clock cycles.
       Upgrade the low priority requests in RRB to high priority when the timer expires.
       Set to 0 disables this feature.*/
//====================================================================

#define  MC_RRB_STARVATION_1_RESERVED1_MASK 0xffffff00
#define  MC_RRB_STARVATION_1_RESERVED1_SHIFT 8
#define  MC_RRB_STARVATION_1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_RRB_STARVATION_1_RESERVED1_MASK) >> MC_RRB_STARVATION_1_RESERVED1_SHIFT)
#define  MC_RRB_STARVATION_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_RRB_STARVATION_1_RESERVED1_MASK) | (((uint32_t)val) << MC_RRB_STARVATION_1_RESERVED1_SHIFT))

#define  MC_RRB_STARVATION_1_RRB_STARV_P4_MASK 0xff
#define  MC_RRB_STARVATION_1_RRB_STARV_P4_SHIFT 0
#define  MC_RRB_STARVATION_1_RRB_STARV_P4_MASK_SHIFT(reg) (((reg) & MC_RRB_STARVATION_1_RRB_STARV_P4_MASK) >> MC_RRB_STARVATION_1_RRB_STARV_P4_SHIFT)
#define  MC_RRB_STARVATION_1_RRB_STARV_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_RRB_STARVATION_1_RRB_STARV_P4_MASK) | (((uint32_t)val) << MC_RRB_STARVATION_1_RRB_STARV_P4_SHIFT))

//====================================================================
//Register: AXI Port QoS Visibility (Port_QoS_Visibility)
//====================================================================

#define  MC_PORT_QOS_VISIBILITY_RESERVED1_MASK 0xffffff00
#define  MC_PORT_QOS_VISIBILITY_RESERVED1_SHIFT 8
#define  MC_PORT_QOS_VISIBILITY_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PORT_QOS_VISIBILITY_RESERVED1_MASK) >> MC_PORT_QOS_VISIBILITY_RESERVED1_SHIFT)
#define  MC_PORT_QOS_VISIBILITY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_QOS_VISIBILITY_RESERVED1_MASK) | (((uint32_t)val) << MC_PORT_QOS_VISIBILITY_RESERVED1_SHIFT))

#define  MC_PORT_QOS_VISIBILITY_PORT_QOS_VISIBILITY_EN_MASK 0xff
#define  MC_PORT_QOS_VISIBILITY_PORT_QOS_VISIBILITY_EN_SHIFT 0
#define  MC_PORT_QOS_VISIBILITY_PORT_QOS_VISIBILITY_EN_MASK_SHIFT(reg) (((reg) & MC_PORT_QOS_VISIBILITY_PORT_QOS_VISIBILITY_EN_MASK) >> MC_PORT_QOS_VISIBILITY_PORT_QOS_VISIBILITY_EN_SHIFT)
#define  MC_PORT_QOS_VISIBILITY_PORT_QOS_VISIBILITY_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_QOS_VISIBILITY_PORT_QOS_VISIBILITY_EN_MASK) | (((uint32_t)val) << MC_PORT_QOS_VISIBILITY_PORT_QOS_VISIBILITY_EN_SHIFT))

//====================================================================
//Register: Read write access control (RW_Access_Ctl)
//====================================================================

#define  MC_RW_ACCESS_CTL_RW_ACCESS_CTL_EN_MASK 0x80000000
#define  MC_RW_ACCESS_CTL_RW_ACCESS_CTL_EN_SHIFT 31
#define  MC_RW_ACCESS_CTL_RW_ACCESS_CTL_EN_MASK_SHIFT(reg) (((reg) & MC_RW_ACCESS_CTL_RW_ACCESS_CTL_EN_MASK) >> MC_RW_ACCESS_CTL_RW_ACCESS_CTL_EN_SHIFT)
#define  MC_RW_ACCESS_CTL_RW_ACCESS_CTL_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_RW_ACCESS_CTL_RW_ACCESS_CTL_EN_MASK) | (((uint32_t)val) << MC_RW_ACCESS_CTL_RW_ACCESS_CTL_EN_SHIFT))

#define  MC_RW_ACCESS_CTL_WRITE_ACCESS_CYCLES_MASK 0x7fff0000
#define  MC_RW_ACCESS_CTL_WRITE_ACCESS_CYCLES_SHIFT 16
#define  MC_RW_ACCESS_CTL_WRITE_ACCESS_CYCLES_MASK_SHIFT(reg) (((reg) & MC_RW_ACCESS_CTL_WRITE_ACCESS_CYCLES_MASK) >> MC_RW_ACCESS_CTL_WRITE_ACCESS_CYCLES_SHIFT)
#define  MC_RW_ACCESS_CTL_WRITE_ACCESS_CYCLES_REPLACE_VAL(reg,val) (((reg) & ~MC_RW_ACCESS_CTL_WRITE_ACCESS_CYCLES_MASK) | (((uint32_t)val) << MC_RW_ACCESS_CTL_WRITE_ACCESS_CYCLES_SHIFT))

#define  MC_RW_ACCESS_CTL_RESERVED1_MASK 0x8000
#define  MC_RW_ACCESS_CTL_RESERVED1_SHIFT 15
#define  MC_RW_ACCESS_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_RW_ACCESS_CTL_RESERVED1_MASK) >> MC_RW_ACCESS_CTL_RESERVED1_SHIFT)
#define  MC_RW_ACCESS_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_RW_ACCESS_CTL_RESERVED1_MASK) | (((uint32_t)val) << MC_RW_ACCESS_CTL_RESERVED1_SHIFT))

#define  MC_RW_ACCESS_CTL_READ_ACCESS_CYCLES_MASK 0x7fff
#define  MC_RW_ACCESS_CTL_READ_ACCESS_CYCLES_SHIFT 0
#define  MC_RW_ACCESS_CTL_READ_ACCESS_CYCLES_MASK_SHIFT(reg) (((reg) & MC_RW_ACCESS_CTL_READ_ACCESS_CYCLES_MASK) >> MC_RW_ACCESS_CTL_READ_ACCESS_CYCLES_SHIFT)
#define  MC_RW_ACCESS_CTL_READ_ACCESS_CYCLES_REPLACE_VAL(reg,val) (((reg) & ~MC_RW_ACCESS_CTL_READ_ACCESS_CYCLES_MASK) | (((uint32_t)val) << MC_RW_ACCESS_CTL_READ_ACCESS_CYCLES_SHIFT))

//====================================================================
//Register: Register Table Control Register (RegTable_Control)
/** \brief Writing to this register will trigger the register block to write
      the contents of <<xref=RegTable_Data_0>> and <<xref=RegTable_Data_1>> into register table.*/
//====================================================================

#define  MC_REGTABLE_CONTROL_RESERVED1_MASK 0xfffffc00
#define  MC_REGTABLE_CONTROL_RESERVED1_SHIFT 10
#define  MC_REGTABLE_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_CONTROL_RESERVED1_MASK) >> MC_REGTABLE_CONTROL_RESERVED1_SHIFT)
#define  MC_REGTABLE_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << MC_REGTABLE_CONTROL_RESERVED1_SHIFT))

#define  MC_REGTABLE_CONTROL_REGTABLE_SEL_MASK 0x3e0
#define  MC_REGTABLE_CONTROL_REGTABLE_SEL_SHIFT 5
#define  MC_REGTABLE_CONTROL_REGTABLE_SEL_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_CONTROL_REGTABLE_SEL_MASK) >> MC_REGTABLE_CONTROL_REGTABLE_SEL_SHIFT)
#define  MC_REGTABLE_CONTROL_REGTABLE_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_CONTROL_REGTABLE_SEL_MASK) | (((uint32_t)val) << MC_REGTABLE_CONTROL_REGTABLE_SEL_SHIFT))

#define  MC_REGTABLE_CONTROL_REGTABLE_ADDR_MASK 0x1f
#define  MC_REGTABLE_CONTROL_REGTABLE_ADDR_SHIFT 0
#define  MC_REGTABLE_CONTROL_REGTABLE_ADDR_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_CONTROL_REGTABLE_ADDR_MASK) >> MC_REGTABLE_CONTROL_REGTABLE_ADDR_SHIFT)
#define  MC_REGTABLE_CONTROL_REGTABLE_ADDR_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_CONTROL_REGTABLE_ADDR_MASK) | (((uint32_t)val) << MC_REGTABLE_CONTROL_REGTABLE_ADDR_SHIFT))

//====================================================================
//Register: Register Table Data Register 0 (RegTable_Data_0)
//====================================================================

#define  MC_REGTABLE_DATA_0_REGTABLE_REG_DATA_MASK 0xffffffff
#define  MC_REGTABLE_DATA_0_REGTABLE_REG_DATA_SHIFT 0
#define  MC_REGTABLE_DATA_0_REGTABLE_REG_DATA_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_DATA_0_REGTABLE_REG_DATA_MASK) >> MC_REGTABLE_DATA_0_REGTABLE_REG_DATA_SHIFT)
#define  MC_REGTABLE_DATA_0_REGTABLE_REG_DATA_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_DATA_0_REGTABLE_REG_DATA_MASK) | (((uint32_t)val) << MC_REGTABLE_DATA_0_REGTABLE_REG_DATA_SHIFT))

//====================================================================
//Register: Register Table Data Register 1 (RegTable_Data_1)
//====================================================================

#define  MC_REGTABLE_DATA_1_RESERVED1_MASK 0xfffc0000
#define  MC_REGTABLE_DATA_1_RESERVED1_SHIFT 18
#define  MC_REGTABLE_DATA_1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_DATA_1_RESERVED1_MASK) >> MC_REGTABLE_DATA_1_RESERVED1_SHIFT)
#define  MC_REGTABLE_DATA_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_DATA_1_RESERVED1_MASK) | (((uint32_t)val) << MC_REGTABLE_DATA_1_RESERVED1_SHIFT))

#define  MC_REGTABLE_DATA_1_REGTABLE_EOP_MASK 0x20000
#define  MC_REGTABLE_DATA_1_REGTABLE_EOP_SHIFT 17
#define  MC_REGTABLE_DATA_1_REGTABLE_EOP_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_DATA_1_REGTABLE_EOP_MASK) >> MC_REGTABLE_DATA_1_REGTABLE_EOP_SHIFT)
#define  MC_REGTABLE_DATA_1_REGTABLE_EOP_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_DATA_1_REGTABLE_EOP_MASK) | (((uint32_t)val) << MC_REGTABLE_DATA_1_REGTABLE_EOP_SHIFT))

#define  MC_REGTABLE_DATA_1_REGTABLE_PAUSE_MASK 0x10000
#define  MC_REGTABLE_DATA_1_REGTABLE_PAUSE_SHIFT 16
#define  MC_REGTABLE_DATA_1_REGTABLE_PAUSE_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_DATA_1_REGTABLE_PAUSE_MASK) >> MC_REGTABLE_DATA_1_REGTABLE_PAUSE_SHIFT)
#define  MC_REGTABLE_DATA_1_REGTABLE_PAUSE_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_DATA_1_REGTABLE_PAUSE_MASK) | (((uint32_t)val) << MC_REGTABLE_DATA_1_REGTABLE_PAUSE_SHIFT))

#define  MC_REGTABLE_DATA_1_RESERVED2_MASK 0xf000
#define  MC_REGTABLE_DATA_1_RESERVED2_SHIFT 12
#define  MC_REGTABLE_DATA_1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_DATA_1_RESERVED2_MASK) >> MC_REGTABLE_DATA_1_RESERVED2_SHIFT)
#define  MC_REGTABLE_DATA_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_DATA_1_RESERVED2_MASK) | (((uint32_t)val) << MC_REGTABLE_DATA_1_RESERVED2_SHIFT))

#define  MC_REGTABLE_DATA_1_REGTABLE_REG_OFFSET_MASK 0xfff
#define  MC_REGTABLE_DATA_1_REGTABLE_REG_OFFSET_SHIFT 0
#define  MC_REGTABLE_DATA_1_REGTABLE_REG_OFFSET_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_DATA_1_REGTABLE_REG_OFFSET_MASK) >> MC_REGTABLE_DATA_1_REGTABLE_REG_OFFSET_SHIFT)
#define  MC_REGTABLE_DATA_1_REGTABLE_REG_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_DATA_1_REGTABLE_REG_OFFSET_MASK) | (((uint32_t)val) << MC_REGTABLE_DATA_1_REGTABLE_REG_OFFSET_SHIFT))

//====================================================================
//Register: Performance Counter Configuration Register 0 (PC_config0)
//====================================================================

#define  MC_PC_CONFIG0_PC_REG_EN3_MASK 0x80000000
#define  MC_PC_CONFIG0_PC_REG_EN3_SHIFT 31
#define  MC_PC_CONFIG0_PC_REG_EN3_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_PC_REG_EN3_MASK) >> MC_PC_CONFIG0_PC_REG_EN3_SHIFT)
#define  MC_PC_CONFIG0_PC_REG_EN3_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_PC_REG_EN3_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_PC_REG_EN3_SHIFT))

#define  MC_PC_CONFIG0_RESERVED1_MASK 0x40000000
#define  MC_PC_CONFIG0_RESERVED1_SHIFT 30
#define  MC_PC_CONFIG0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_RESERVED1_MASK) >> MC_PC_CONFIG0_RESERVED1_SHIFT)
#define  MC_PC_CONFIG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_RESERVED1_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_RESERVED1_SHIFT))

#define  MC_PC_CONFIG0_PC_EVENT_SEL3_MASK 0x3f000000
#define  MC_PC_CONFIG0_PC_EVENT_SEL3_SHIFT 24
#define  MC_PC_CONFIG0_PC_EVENT_SEL3_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_PC_EVENT_SEL3_MASK) >> MC_PC_CONFIG0_PC_EVENT_SEL3_SHIFT)
#define  MC_PC_CONFIG0_PC_EVENT_SEL3_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_PC_EVENT_SEL3_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_PC_EVENT_SEL3_SHIFT))

#define  MC_PC_CONFIG0_PC_REG_EN2_MASK 0x800000
#define  MC_PC_CONFIG0_PC_REG_EN2_SHIFT 23
#define  MC_PC_CONFIG0_PC_REG_EN2_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_PC_REG_EN2_MASK) >> MC_PC_CONFIG0_PC_REG_EN2_SHIFT)
#define  MC_PC_CONFIG0_PC_REG_EN2_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_PC_REG_EN2_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_PC_REG_EN2_SHIFT))

#define  MC_PC_CONFIG0_RESERVED2_MASK 0x400000
#define  MC_PC_CONFIG0_RESERVED2_SHIFT 22
#define  MC_PC_CONFIG0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_RESERVED2_MASK) >> MC_PC_CONFIG0_RESERVED2_SHIFT)
#define  MC_PC_CONFIG0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_RESERVED2_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_RESERVED2_SHIFT))

#define  MC_PC_CONFIG0_PC_EVENT_SEL2_MASK 0x3f0000
#define  MC_PC_CONFIG0_PC_EVENT_SEL2_SHIFT 16
#define  MC_PC_CONFIG0_PC_EVENT_SEL2_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_PC_EVENT_SEL2_MASK) >> MC_PC_CONFIG0_PC_EVENT_SEL2_SHIFT)
#define  MC_PC_CONFIG0_PC_EVENT_SEL2_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_PC_EVENT_SEL2_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_PC_EVENT_SEL2_SHIFT))

#define  MC_PC_CONFIG0_PC_REG_EN1_MASK 0x8000
#define  MC_PC_CONFIG0_PC_REG_EN1_SHIFT 15
#define  MC_PC_CONFIG0_PC_REG_EN1_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_PC_REG_EN1_MASK) >> MC_PC_CONFIG0_PC_REG_EN1_SHIFT)
#define  MC_PC_CONFIG0_PC_REG_EN1_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_PC_REG_EN1_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_PC_REG_EN1_SHIFT))

#define  MC_PC_CONFIG0_RESERVED3_MASK 0x4000
#define  MC_PC_CONFIG0_RESERVED3_SHIFT 14
#define  MC_PC_CONFIG0_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_RESERVED3_MASK) >> MC_PC_CONFIG0_RESERVED3_SHIFT)
#define  MC_PC_CONFIG0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_RESERVED3_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_RESERVED3_SHIFT))

#define  MC_PC_CONFIG0_PC_EVENT_SEL1_MASK 0x3f00
#define  MC_PC_CONFIG0_PC_EVENT_SEL1_SHIFT 8
#define  MC_PC_CONFIG0_PC_EVENT_SEL1_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_PC_EVENT_SEL1_MASK) >> MC_PC_CONFIG0_PC_EVENT_SEL1_SHIFT)
#define  MC_PC_CONFIG0_PC_EVENT_SEL1_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_PC_EVENT_SEL1_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_PC_EVENT_SEL1_SHIFT))

#define  MC_PC_CONFIG0_PC_REG_EN0_MASK 0x80
#define  MC_PC_CONFIG0_PC_REG_EN0_SHIFT 7
#define  MC_PC_CONFIG0_PC_REG_EN0_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_PC_REG_EN0_MASK) >> MC_PC_CONFIG0_PC_REG_EN0_SHIFT)
#define  MC_PC_CONFIG0_PC_REG_EN0_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_PC_REG_EN0_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_PC_REG_EN0_SHIFT))

#define  MC_PC_CONFIG0_RESERVED4_MASK 0x40
#define  MC_PC_CONFIG0_RESERVED4_SHIFT 6
#define  MC_PC_CONFIG0_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_RESERVED4_MASK) >> MC_PC_CONFIG0_RESERVED4_SHIFT)
#define  MC_PC_CONFIG0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_RESERVED4_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_RESERVED4_SHIFT))

#define  MC_PC_CONFIG0_PC_EVENT_SEL0_MASK 0x3f
#define  MC_PC_CONFIG0_PC_EVENT_SEL0_SHIFT 0
#define  MC_PC_CONFIG0_PC_EVENT_SEL0_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_PC_EVENT_SEL0_MASK) >> MC_PC_CONFIG0_PC_EVENT_SEL0_SHIFT)
#define  MC_PC_CONFIG0_PC_EVENT_SEL0_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_PC_EVENT_SEL0_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_PC_EVENT_SEL0_SHIFT))

//====================================================================
//Register: Performance Counter Configuration Register 1 (PC_config1)
//====================================================================

#define  MC_PC_CONFIG1_PC_REG_EN7_MASK 0x80000000
#define  MC_PC_CONFIG1_PC_REG_EN7_SHIFT 31
#define  MC_PC_CONFIG1_PC_REG_EN7_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_PC_REG_EN7_MASK) >> MC_PC_CONFIG1_PC_REG_EN7_SHIFT)
#define  MC_PC_CONFIG1_PC_REG_EN7_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_PC_REG_EN7_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_PC_REG_EN7_SHIFT))

#define  MC_PC_CONFIG1_RESERVED1_MASK 0x40000000
#define  MC_PC_CONFIG1_RESERVED1_SHIFT 30
#define  MC_PC_CONFIG1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_RESERVED1_MASK) >> MC_PC_CONFIG1_RESERVED1_SHIFT)
#define  MC_PC_CONFIG1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_RESERVED1_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_RESERVED1_SHIFT))

#define  MC_PC_CONFIG1_PC_EVENT_SEL7_MASK 0x3f000000
#define  MC_PC_CONFIG1_PC_EVENT_SEL7_SHIFT 24
#define  MC_PC_CONFIG1_PC_EVENT_SEL7_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_PC_EVENT_SEL7_MASK) >> MC_PC_CONFIG1_PC_EVENT_SEL7_SHIFT)
#define  MC_PC_CONFIG1_PC_EVENT_SEL7_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_PC_EVENT_SEL7_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_PC_EVENT_SEL7_SHIFT))

#define  MC_PC_CONFIG1_PC_REG_EN6_MASK 0x800000
#define  MC_PC_CONFIG1_PC_REG_EN6_SHIFT 23
#define  MC_PC_CONFIG1_PC_REG_EN6_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_PC_REG_EN6_MASK) >> MC_PC_CONFIG1_PC_REG_EN6_SHIFT)
#define  MC_PC_CONFIG1_PC_REG_EN6_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_PC_REG_EN6_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_PC_REG_EN6_SHIFT))

#define  MC_PC_CONFIG1_RESERVED2_MASK 0x400000
#define  MC_PC_CONFIG1_RESERVED2_SHIFT 22
#define  MC_PC_CONFIG1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_RESERVED2_MASK) >> MC_PC_CONFIG1_RESERVED2_SHIFT)
#define  MC_PC_CONFIG1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_RESERVED2_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_RESERVED2_SHIFT))

#define  MC_PC_CONFIG1_PC_EVENT_SEL6_MASK 0x3f0000
#define  MC_PC_CONFIG1_PC_EVENT_SEL6_SHIFT 16
#define  MC_PC_CONFIG1_PC_EVENT_SEL6_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_PC_EVENT_SEL6_MASK) >> MC_PC_CONFIG1_PC_EVENT_SEL6_SHIFT)
#define  MC_PC_CONFIG1_PC_EVENT_SEL6_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_PC_EVENT_SEL6_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_PC_EVENT_SEL6_SHIFT))

#define  MC_PC_CONFIG1_PC_REG_EN5_MASK 0x8000
#define  MC_PC_CONFIG1_PC_REG_EN5_SHIFT 15
#define  MC_PC_CONFIG1_PC_REG_EN5_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_PC_REG_EN5_MASK) >> MC_PC_CONFIG1_PC_REG_EN5_SHIFT)
#define  MC_PC_CONFIG1_PC_REG_EN5_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_PC_REG_EN5_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_PC_REG_EN5_SHIFT))

#define  MC_PC_CONFIG1_RESERVED3_MASK 0x4000
#define  MC_PC_CONFIG1_RESERVED3_SHIFT 14
#define  MC_PC_CONFIG1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_RESERVED3_MASK) >> MC_PC_CONFIG1_RESERVED3_SHIFT)
#define  MC_PC_CONFIG1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_RESERVED3_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_RESERVED3_SHIFT))

#define  MC_PC_CONFIG1_PC_EVENT_SEL5_MASK 0x3f00
#define  MC_PC_CONFIG1_PC_EVENT_SEL5_SHIFT 8
#define  MC_PC_CONFIG1_PC_EVENT_SEL5_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_PC_EVENT_SEL5_MASK) >> MC_PC_CONFIG1_PC_EVENT_SEL5_SHIFT)
#define  MC_PC_CONFIG1_PC_EVENT_SEL5_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_PC_EVENT_SEL5_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_PC_EVENT_SEL5_SHIFT))

#define  MC_PC_CONFIG1_PC_REG_EN4_MASK 0x80
#define  MC_PC_CONFIG1_PC_REG_EN4_SHIFT 7
#define  MC_PC_CONFIG1_PC_REG_EN4_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_PC_REG_EN4_MASK) >> MC_PC_CONFIG1_PC_REG_EN4_SHIFT)
#define  MC_PC_CONFIG1_PC_REG_EN4_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_PC_REG_EN4_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_PC_REG_EN4_SHIFT))

#define  MC_PC_CONFIG1_RESERVED4_MASK 0x40
#define  MC_PC_CONFIG1_RESERVED4_SHIFT 6
#define  MC_PC_CONFIG1_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_RESERVED4_MASK) >> MC_PC_CONFIG1_RESERVED4_SHIFT)
#define  MC_PC_CONFIG1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_RESERVED4_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_RESERVED4_SHIFT))

#define  MC_PC_CONFIG1_PC_EVENT_SEL4_MASK 0x3f
#define  MC_PC_CONFIG1_PC_EVENT_SEL4_SHIFT 0
#define  MC_PC_CONFIG1_PC_EVENT_SEL4_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_PC_EVENT_SEL4_MASK) >> MC_PC_CONFIG1_PC_EVENT_SEL4_SHIFT)
#define  MC_PC_CONFIG1_PC_EVENT_SEL4_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_PC_EVENT_SEL4_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_PC_EVENT_SEL4_SHIFT))

//====================================================================
//Register: Performance Counter Status Register (PC_status)
//====================================================================

#define  MC_PC_STATUS_RESERVED1_MASK 0xffffff00
#define  MC_PC_STATUS_RESERVED1_SHIFT 8
#define  MC_PC_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PC_STATUS_RESERVED1_MASK) >> MC_PC_STATUS_RESERVED1_SHIFT)
#define  MC_PC_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_STATUS_RESERVED1_MASK) | (((uint32_t)val) << MC_PC_STATUS_RESERVED1_SHIFT))

#define  MC_PC_STATUS_PC_OVERFLOW_MASK 0xff
#define  MC_PC_STATUS_PC_OVERFLOW_SHIFT 0
#define  MC_PC_STATUS_PC_OVERFLOW_MASK_SHIFT(reg) (((reg) & MC_PC_STATUS_PC_OVERFLOW_MASK) >> MC_PC_STATUS_PC_OVERFLOW_SHIFT)
#define  MC_PC_STATUS_PC_OVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_STATUS_PC_OVERFLOW_MASK) | (((uint32_t)val) << MC_PC_STATUS_PC_OVERFLOW_SHIFT))

//====================================================================
//Register: Performance Counter Control Register (PC_Control)
//====================================================================

#define  MC_PC_CONTROL_RESERVED1_MASK 0xfff80000
#define  MC_PC_CONTROL_RESERVED1_SHIFT 19
#define  MC_PC_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PC_CONTROL_RESERVED1_MASK) >> MC_PC_CONTROL_RESERVED1_SHIFT)
#define  MC_PC_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << MC_PC_CONTROL_RESERVED1_SHIFT))

#define  MC_PC_CONTROL_PC_CLK_DIV_MASK 0x70000
#define  MC_PC_CONTROL_PC_CLK_DIV_SHIFT 16
#define  MC_PC_CONTROL_PC_CLK_DIV_MASK_SHIFT(reg) (((reg) & MC_PC_CONTROL_PC_CLK_DIV_MASK) >> MC_PC_CONTROL_PC_CLK_DIV_SHIFT)
#define  MC_PC_CONTROL_PC_CLK_DIV_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONTROL_PC_CLK_DIV_MASK) | (((uint32_t)val) << MC_PC_CONTROL_PC_CLK_DIV_SHIFT))

#define  MC_PC_CONTROL_RESERVED2_MASK 0xffe0
#define  MC_PC_CONTROL_RESERVED2_SHIFT 5
#define  MC_PC_CONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PC_CONTROL_RESERVED2_MASK) >> MC_PC_CONTROL_RESERVED2_SHIFT)
#define  MC_PC_CONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONTROL_RESERVED2_MASK) | (((uint32_t)val) << MC_PC_CONTROL_RESERVED2_SHIFT))

#define  MC_PC_CONTROL_PC_STOP_COND_MASK 0x10
#define  MC_PC_CONTROL_PC_STOP_COND_SHIFT 4
#define  MC_PC_CONTROL_PC_STOP_COND_MASK_SHIFT(reg) (((reg) & MC_PC_CONTROL_PC_STOP_COND_MASK) >> MC_PC_CONTROL_PC_STOP_COND_SHIFT)
#define  MC_PC_CONTROL_PC_STOP_COND_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONTROL_PC_STOP_COND_MASK) | (((uint32_t)val) << MC_PC_CONTROL_PC_STOP_COND_SHIFT))

#define  MC_PC_CONTROL_RESERVED3_MASK 0xe
#define  MC_PC_CONTROL_RESERVED3_SHIFT 1
#define  MC_PC_CONTROL_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_PC_CONTROL_RESERVED3_MASK) >> MC_PC_CONTROL_RESERVED3_SHIFT)
#define  MC_PC_CONTROL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONTROL_RESERVED3_MASK) | (((uint32_t)val) << MC_PC_CONTROL_RESERVED3_SHIFT))

#define  MC_PC_CONTROL_PC_START_COND_MASK 0x1
#define  MC_PC_CONTROL_PC_START_COND_SHIFT 0
#define  MC_PC_CONTROL_PC_START_COND_MASK_SHIFT(reg) (((reg) & MC_PC_CONTROL_PC_START_COND_MASK) >> MC_PC_CONTROL_PC_START_COND_SHIFT)
#define  MC_PC_CONTROL_PC_START_COND_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONTROL_PC_START_COND_MASK) | (((uint32_t)val) << MC_PC_CONTROL_PC_START_COND_SHIFT))

//====================================================================
//Register: Performance Counter Register (Instance 1 of 8) (PC0)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  MC_PC0_PC_COUNTER_MASK 0xffffffff
#define  MC_PC0_PC_COUNTER_SHIFT 0
#define  MC_PC0_PC_COUNTER_MASK_SHIFT(reg) (((reg) & MC_PC0_PC_COUNTER_MASK) >> MC_PC0_PC_COUNTER_SHIFT)
#define  MC_PC0_PC_COUNTER_REPLACE_VAL(reg,val) (((reg) & ~MC_PC0_PC_COUNTER_MASK) | (((uint32_t)val) << MC_PC0_PC_COUNTER_SHIFT))

//====================================================================
//Register: Performance Counter Register (Instance 2 of 8) (PC1)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  MC_PC1_PC_COUNTER_MASK 0xffffffff
#define  MC_PC1_PC_COUNTER_SHIFT 0
#define  MC_PC1_PC_COUNTER_MASK_SHIFT(reg) (((reg) & MC_PC1_PC_COUNTER_MASK) >> MC_PC1_PC_COUNTER_SHIFT)
#define  MC_PC1_PC_COUNTER_REPLACE_VAL(reg,val) (((reg) & ~MC_PC1_PC_COUNTER_MASK) | (((uint32_t)val) << MC_PC1_PC_COUNTER_SHIFT))

//====================================================================
//Register: Performance Counter Register (Instance 3 of 8) (PC2)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  MC_PC2_PC_COUNTER_MASK 0xffffffff
#define  MC_PC2_PC_COUNTER_SHIFT 0
#define  MC_PC2_PC_COUNTER_MASK_SHIFT(reg) (((reg) & MC_PC2_PC_COUNTER_MASK) >> MC_PC2_PC_COUNTER_SHIFT)
#define  MC_PC2_PC_COUNTER_REPLACE_VAL(reg,val) (((reg) & ~MC_PC2_PC_COUNTER_MASK) | (((uint32_t)val) << MC_PC2_PC_COUNTER_SHIFT))

//====================================================================
//Register: Performance Counter Register (Instance 4 of 8) (PC3)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  MC_PC3_PC_COUNTER_MASK 0xffffffff
#define  MC_PC3_PC_COUNTER_SHIFT 0
#define  MC_PC3_PC_COUNTER_MASK_SHIFT(reg) (((reg) & MC_PC3_PC_COUNTER_MASK) >> MC_PC3_PC_COUNTER_SHIFT)
#define  MC_PC3_PC_COUNTER_REPLACE_VAL(reg,val) (((reg) & ~MC_PC3_PC_COUNTER_MASK) | (((uint32_t)val) << MC_PC3_PC_COUNTER_SHIFT))

//====================================================================
//Register: Performance Counter Register (Instance 5 of 8) (PC4)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  MC_PC4_PC_COUNTER_MASK 0xffffffff
#define  MC_PC4_PC_COUNTER_SHIFT 0
#define  MC_PC4_PC_COUNTER_MASK_SHIFT(reg) (((reg) & MC_PC4_PC_COUNTER_MASK) >> MC_PC4_PC_COUNTER_SHIFT)
#define  MC_PC4_PC_COUNTER_REPLACE_VAL(reg,val) (((reg) & ~MC_PC4_PC_COUNTER_MASK) | (((uint32_t)val) << MC_PC4_PC_COUNTER_SHIFT))

//====================================================================
//Register: Performance Counter Register (Instance 6 of 8) (PC5)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  MC_PC5_PC_COUNTER_MASK 0xffffffff
#define  MC_PC5_PC_COUNTER_SHIFT 0
#define  MC_PC5_PC_COUNTER_MASK_SHIFT(reg) (((reg) & MC_PC5_PC_COUNTER_MASK) >> MC_PC5_PC_COUNTER_SHIFT)
#define  MC_PC5_PC_COUNTER_REPLACE_VAL(reg,val) (((reg) & ~MC_PC5_PC_COUNTER_MASK) | (((uint32_t)val) << MC_PC5_PC_COUNTER_SHIFT))

//====================================================================
//Register: Performance Counter Register (Instance 7 of 8) (PC6)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  MC_PC6_PC_COUNTER_MASK 0xffffffff
#define  MC_PC6_PC_COUNTER_SHIFT 0
#define  MC_PC6_PC_COUNTER_MASK_SHIFT(reg) (((reg) & MC_PC6_PC_COUNTER_MASK) >> MC_PC6_PC_COUNTER_SHIFT)
#define  MC_PC6_PC_COUNTER_REPLACE_VAL(reg,val) (((reg) & ~MC_PC6_PC_COUNTER_MASK) | (((uint32_t)val) << MC_PC6_PC_COUNTER_SHIFT))

//====================================================================
//Register: Performance Counter Register (Instance 8 of 8) (PC7)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  MC_PC7_PC_COUNTER_MASK 0xffffffff
#define  MC_PC7_PC_COUNTER_SHIFT 0
#define  MC_PC7_PC_COUNTER_MASK_SHIFT(reg) (((reg) & MC_PC7_PC_COUNTER_MASK) >> MC_PC7_PC_COUNTER_SHIFT)
#define  MC_PC7_PC_COUNTER_REPLACE_VAL(reg,val) (((reg) & ~MC_PC7_PC_COUNTER_MASK) | (((uint32_t)val) << MC_PC7_PC_COUNTER_SHIFT))

//====================================================================
//Register: Interrupt Status Register (ISR)
/** \brief Note: This register is clear-on-read.*/
//====================================================================

#define  MC_ISR_RESERVED1_MASK 0xffffff80
#define  MC_ISR_RESERVED1_SHIFT 7
#define  MC_ISR_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_ISR_RESERVED1_MASK) >> MC_ISR_RESERVED1_SHIFT)
#define  MC_ISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_ISR_RESERVED1_MASK) | (((uint32_t)val) << MC_ISR_RESERVED1_SHIFT))

#define  MC_ISR_RETRY_BUFFER_INT_STATUS_MASK 0x40
#define  MC_ISR_RETRY_BUFFER_INT_STATUS_SHIFT 6
#define  MC_ISR_RETRY_BUFFER_INT_STATUS_MASK_SHIFT(reg) (((reg) & MC_ISR_RETRY_BUFFER_INT_STATUS_MASK) >> MC_ISR_RETRY_BUFFER_INT_STATUS_SHIFT)
#define  MC_ISR_RETRY_BUFFER_INT_STATUS_REPLACE_VAL(reg,val) (((reg) & ~MC_ISR_RETRY_BUFFER_INT_STATUS_MASK) | (((uint32_t)val) << MC_ISR_RETRY_BUFFER_INT_STATUS_SHIFT))

#define  MC_ISR_TZ_INT_MASK 0x20
#define  MC_ISR_TZ_INT_SHIFT 5
#define  MC_ISR_TZ_INT_MASK_SHIFT(reg) (((reg) & MC_ISR_TZ_INT_MASK) >> MC_ISR_TZ_INT_SHIFT)
#define  MC_ISR_TZ_INT_REPLACE_VAL(reg,val) (((reg) & ~MC_ISR_TZ_INT_MASK) | (((uint32_t)val) << MC_ISR_TZ_INT_SHIFT))

#define  MC_ISR_AM_HIGH_INT_MASK 0x10
#define  MC_ISR_AM_HIGH_INT_SHIFT 4
#define  MC_ISR_AM_HIGH_INT_MASK_SHIFT(reg) (((reg) & MC_ISR_AM_HIGH_INT_MASK) >> MC_ISR_AM_HIGH_INT_SHIFT)
#define  MC_ISR_AM_HIGH_INT_REPLACE_VAL(reg,val) (((reg) & ~MC_ISR_AM_HIGH_INT_MASK) | (((uint32_t)val) << MC_ISR_AM_HIGH_INT_SHIFT))

#define  MC_ISR_AM_LOW_INT_MASK 0x8
#define  MC_ISR_AM_LOW_INT_SHIFT 3
#define  MC_ISR_AM_LOW_INT_MASK_SHIFT(reg) (((reg) & MC_ISR_AM_LOW_INT_MASK) >> MC_ISR_AM_LOW_INT_SHIFT)
#define  MC_ISR_AM_LOW_INT_REPLACE_VAL(reg,val) (((reg) & ~MC_ISR_AM_LOW_INT_MASK) | (((uint32_t)val) << MC_ISR_AM_LOW_INT_SHIFT))

#define  MC_ISR_ADC_INT_MASK 0x4
#define  MC_ISR_ADC_INT_SHIFT 2
#define  MC_ISR_ADC_INT_MASK_SHIFT(reg) (((reg) & MC_ISR_ADC_INT_MASK) >> MC_ISR_ADC_INT_SHIFT)
#define  MC_ISR_ADC_INT_REPLACE_VAL(reg,val) (((reg) & ~MC_ISR_ADC_INT_MASK) | (((uint32_t)val) << MC_ISR_ADC_INT_SHIFT))

#define  MC_ISR_RESERVED2_MASK 0x2
#define  MC_ISR_RESERVED2_SHIFT 1
#define  MC_ISR_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_ISR_RESERVED2_MASK) >> MC_ISR_RESERVED2_SHIFT)
#define  MC_ISR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_ISR_RESERVED2_MASK) | (((uint32_t)val) << MC_ISR_RESERVED2_SHIFT))

#define  MC_ISR_PC_INT_MASK 0x1
#define  MC_ISR_PC_INT_SHIFT 0
#define  MC_ISR_PC_INT_MASK_SHIFT(reg) (((reg) & MC_ISR_PC_INT_MASK) >> MC_ISR_PC_INT_SHIFT)
#define  MC_ISR_PC_INT_REPLACE_VAL(reg,val) (((reg) & ~MC_ISR_PC_INT_MASK) | (((uint32_t)val) << MC_ISR_PC_INT_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (IER)
//====================================================================

#define  MC_IER_RESERVED1_MASK 0xffffffc0
#define  MC_IER_RESERVED1_SHIFT 6
#define  MC_IER_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_IER_RESERVED1_MASK) >> MC_IER_RESERVED1_SHIFT)
#define  MC_IER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_IER_RESERVED1_MASK) | (((uint32_t)val) << MC_IER_RESERVED1_SHIFT))

#define  MC_IER_TZ_INT_EN_MASK 0x20
#define  MC_IER_TZ_INT_EN_SHIFT 5
#define  MC_IER_TZ_INT_EN_MASK_SHIFT(reg) (((reg) & MC_IER_TZ_INT_EN_MASK) >> MC_IER_TZ_INT_EN_SHIFT)
#define  MC_IER_TZ_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_IER_TZ_INT_EN_MASK) | (((uint32_t)val) << MC_IER_TZ_INT_EN_SHIFT))

#define  MC_IER_RETRY_BUFFER_INT_EN_MASK 0x10
#define  MC_IER_RETRY_BUFFER_INT_EN_SHIFT 4
#define  MC_IER_RETRY_BUFFER_INT_EN_MASK_SHIFT(reg) (((reg) & MC_IER_RETRY_BUFFER_INT_EN_MASK) >> MC_IER_RETRY_BUFFER_INT_EN_SHIFT)
#define  MC_IER_RETRY_BUFFER_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_IER_RETRY_BUFFER_INT_EN_MASK) | (((uint32_t)val) << MC_IER_RETRY_BUFFER_INT_EN_SHIFT))

#define  MC_IER_AM_INT_EN_MASK 0x8
#define  MC_IER_AM_INT_EN_SHIFT 3
#define  MC_IER_AM_INT_EN_MASK_SHIFT(reg) (((reg) & MC_IER_AM_INT_EN_MASK) >> MC_IER_AM_INT_EN_SHIFT)
#define  MC_IER_AM_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_IER_AM_INT_EN_MASK) | (((uint32_t)val) << MC_IER_AM_INT_EN_SHIFT))

#define  MC_IER_ADC_INT_EN_MASK 0x4
#define  MC_IER_ADC_INT_EN_SHIFT 2
#define  MC_IER_ADC_INT_EN_MASK_SHIFT(reg) (((reg) & MC_IER_ADC_INT_EN_MASK) >> MC_IER_ADC_INT_EN_SHIFT)
#define  MC_IER_ADC_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_IER_ADC_INT_EN_MASK) | (((uint32_t)val) << MC_IER_ADC_INT_EN_SHIFT))

#define  MC_IER_RESERVED2_MASK 0x2
#define  MC_IER_RESERVED2_SHIFT 1
#define  MC_IER_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_IER_RESERVED2_MASK) >> MC_IER_RESERVED2_SHIFT)
#define  MC_IER_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_IER_RESERVED2_MASK) | (((uint32_t)val) << MC_IER_RESERVED2_SHIFT))

#define  MC_IER_PC_INT_EN_MASK 0x1
#define  MC_IER_PC_INT_EN_SHIFT 0
#define  MC_IER_PC_INT_EN_MASK_SHIFT(reg) (((reg) & MC_IER_PC_INT_EN_MASK) >> MC_IER_PC_INT_EN_SHIFT)
#define  MC_IER_PC_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_IER_PC_INT_EN_MASK) | (((uint32_t)val) << MC_IER_PC_INT_EN_SHIFT))

//====================================================================
//Register: Address Decode Error Master ID Register (ADC_ERR_ID)
//====================================================================

#define  MC_ADC_ERR_ID_ERR_TRANS_TYPE_MASK 0x80000000
#define  MC_ADC_ERR_ID_ERR_TRANS_TYPE_SHIFT 31
#define  MC_ADC_ERR_ID_ERR_TRANS_TYPE_MASK_SHIFT(reg) (((reg) & MC_ADC_ERR_ID_ERR_TRANS_TYPE_MASK) >> MC_ADC_ERR_ID_ERR_TRANS_TYPE_SHIFT)
#define  MC_ADC_ERR_ID_ERR_TRANS_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_ADC_ERR_ID_ERR_TRANS_TYPE_MASK) | (((uint32_t)val) << MC_ADC_ERR_ID_ERR_TRANS_TYPE_SHIFT))

#define  MC_ADC_ERR_ID_ERR_MSTR_ID_MASK 0x70000000
#define  MC_ADC_ERR_ID_ERR_MSTR_ID_SHIFT 28
#define  MC_ADC_ERR_ID_ERR_MSTR_ID_MASK_SHIFT(reg) (((reg) & MC_ADC_ERR_ID_ERR_MSTR_ID_MASK) >> MC_ADC_ERR_ID_ERR_MSTR_ID_SHIFT)
#define  MC_ADC_ERR_ID_ERR_MSTR_ID_REPLACE_VAL(reg,val) (((reg) & ~MC_ADC_ERR_ID_ERR_MSTR_ID_MASK) | (((uint32_t)val) << MC_ADC_ERR_ID_ERR_MSTR_ID_SHIFT))

#define  MC_ADC_ERR_ID_ERR_TRANS_ID_MASK 0xfffffff
#define  MC_ADC_ERR_ID_ERR_TRANS_ID_SHIFT 0
#define  MC_ADC_ERR_ID_ERR_TRANS_ID_MASK_SHIFT(reg) (((reg) & MC_ADC_ERR_ID_ERR_TRANS_ID_MASK) >> MC_ADC_ERR_ID_ERR_TRANS_ID_SHIFT)
#define  MC_ADC_ERR_ID_ERR_TRANS_ID_REPLACE_VAL(reg,val) (((reg) & ~MC_ADC_ERR_ID_ERR_TRANS_ID_MASK) | (((uint32_t)val) << MC_ADC_ERR_ID_ERR_TRANS_ID_SHIFT))

//====================================================================
//Register: Address Decode Error Lower Address Register (ADC_ERR_ADR_L)
//====================================================================

#define  MC_ADC_ERR_ADR_L_ERR_ADR_L_MASK 0xffffffff
#define  MC_ADC_ERR_ADR_L_ERR_ADR_L_SHIFT 0
#define  MC_ADC_ERR_ADR_L_ERR_ADR_L_MASK_SHIFT(reg) (((reg) & MC_ADC_ERR_ADR_L_ERR_ADR_L_MASK) >> MC_ADC_ERR_ADR_L_ERR_ADR_L_SHIFT)
#define  MC_ADC_ERR_ADR_L_ERR_ADR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_ADC_ERR_ADR_L_ERR_ADR_L_MASK) | (((uint32_t)val) << MC_ADC_ERR_ADR_L_ERR_ADR_L_SHIFT))

//====================================================================
//Register: Address Decode Error Higher Address Register (ADC_ERR_ADR_H)
//====================================================================

#define  MC_ADC_ERR_ADR_H_RESERVED1_MASK 0xffffff00
#define  MC_ADC_ERR_ADR_H_RESERVED1_SHIFT 8
#define  MC_ADC_ERR_ADR_H_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_ADC_ERR_ADR_H_RESERVED1_MASK) >> MC_ADC_ERR_ADR_H_RESERVED1_SHIFT)
#define  MC_ADC_ERR_ADR_H_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_ADC_ERR_ADR_H_RESERVED1_MASK) | (((uint32_t)val) << MC_ADC_ERR_ADR_H_RESERVED1_SHIFT))

#define  MC_ADC_ERR_ADR_H_ERR_ADR_H_MASK 0xff
#define  MC_ADC_ERR_ADR_H_ERR_ADR_H_SHIFT 0
#define  MC_ADC_ERR_ADR_H_ERR_ADR_H_MASK_SHIFT(reg) (((reg) & MC_ADC_ERR_ADR_H_ERR_ADR_H_MASK) >> MC_ADC_ERR_ADR_H_ERR_ADR_H_SHIFT)
#define  MC_ADC_ERR_ADR_H_ERR_ADR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_ADC_ERR_ADR_H_ERR_ADR_H_MASK) | (((uint32_t)val) << MC_ADC_ERR_ADR_H_ERR_ADR_H_SHIFT))

//====================================================================
//Register: Activity Monitor Check Period Register (AM_PERIOD)
//====================================================================

#define  MC_AM_PERIOD_AM_PERIOD_MASK 0xffffffff
#define  MC_AM_PERIOD_AM_PERIOD_SHIFT 0
#define  MC_AM_PERIOD_AM_PERIOD_MASK_SHIFT(reg) (((reg) & MC_AM_PERIOD_AM_PERIOD_MASK) >> MC_AM_PERIOD_AM_PERIOD_SHIFT)
#define  MC_AM_PERIOD_AM_PERIOD_REPLACE_VAL(reg,val) (((reg) & ~MC_AM_PERIOD_AM_PERIOD_MASK) | (((uint32_t)val) << MC_AM_PERIOD_AM_PERIOD_SHIFT))

//====================================================================
//Register: Activity Monitor Threshold Register (AM_TH)
//====================================================================

#define  MC_AM_TH_RESERVED1_MASK 0xffff8000
#define  MC_AM_TH_RESERVED1_SHIFT 15
#define  MC_AM_TH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_AM_TH_RESERVED1_MASK) >> MC_AM_TH_RESERVED1_SHIFT)
#define  MC_AM_TH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_AM_TH_RESERVED1_MASK) | (((uint32_t)val) << MC_AM_TH_RESERVED1_SHIFT))

#define  MC_AM_TH_AM_TH_HIGH_MASK 0x7f00
#define  MC_AM_TH_AM_TH_HIGH_SHIFT 8
#define  MC_AM_TH_AM_TH_HIGH_MASK_SHIFT(reg) (((reg) & MC_AM_TH_AM_TH_HIGH_MASK) >> MC_AM_TH_AM_TH_HIGH_SHIFT)
#define  MC_AM_TH_AM_TH_HIGH_REPLACE_VAL(reg,val) (((reg) & ~MC_AM_TH_AM_TH_HIGH_MASK) | (((uint32_t)val) << MC_AM_TH_AM_TH_HIGH_SHIFT))

#define  MC_AM_TH_RESERVED2_MASK 0x80
#define  MC_AM_TH_RESERVED2_SHIFT 7
#define  MC_AM_TH_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_AM_TH_RESERVED2_MASK) >> MC_AM_TH_RESERVED2_SHIFT)
#define  MC_AM_TH_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_AM_TH_RESERVED2_MASK) | (((uint32_t)val) << MC_AM_TH_RESERVED2_SHIFT))

#define  MC_AM_TH_AM_TH_LOW_MASK 0x7f
#define  MC_AM_TH_AM_TH_LOW_SHIFT 0
#define  MC_AM_TH_AM_TH_LOW_MASK_SHIFT(reg) (((reg) & MC_AM_TH_AM_TH_LOW_MASK) >> MC_AM_TH_AM_TH_LOW_SHIFT)
#define  MC_AM_TH_AM_TH_LOW_REPLACE_VAL(reg,val) (((reg) & ~MC_AM_TH_AM_TH_LOW_MASK) | (((uint32_t)val) << MC_AM_TH_AM_TH_LOW_SHIFT))

//====================================================================
//Register: TrustZone Error Master ID Register (TZ_ERR_ID)
//====================================================================

#define  MC_TZ_ERR_ID_ERR_TRANS_TYPE_MASK 0x80000000
#define  MC_TZ_ERR_ID_ERR_TRANS_TYPE_SHIFT 31
#define  MC_TZ_ERR_ID_ERR_TRANS_TYPE_MASK_SHIFT(reg) (((reg) & MC_TZ_ERR_ID_ERR_TRANS_TYPE_MASK) >> MC_TZ_ERR_ID_ERR_TRANS_TYPE_SHIFT)
#define  MC_TZ_ERR_ID_ERR_TRANS_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_ERR_ID_ERR_TRANS_TYPE_MASK) | (((uint32_t)val) << MC_TZ_ERR_ID_ERR_TRANS_TYPE_SHIFT))

#define  MC_TZ_ERR_ID_ERR_MSTR_ID_MASK 0x70000000
#define  MC_TZ_ERR_ID_ERR_MSTR_ID_SHIFT 28
#define  MC_TZ_ERR_ID_ERR_MSTR_ID_MASK_SHIFT(reg) (((reg) & MC_TZ_ERR_ID_ERR_MSTR_ID_MASK) >> MC_TZ_ERR_ID_ERR_MSTR_ID_SHIFT)
#define  MC_TZ_ERR_ID_ERR_MSTR_ID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_ERR_ID_ERR_MSTR_ID_MASK) | (((uint32_t)val) << MC_TZ_ERR_ID_ERR_MSTR_ID_SHIFT))

#define  MC_TZ_ERR_ID_ERR_TRANS_ID_MASK 0xfffffff
#define  MC_TZ_ERR_ID_ERR_TRANS_ID_SHIFT 0
#define  MC_TZ_ERR_ID_ERR_TRANS_ID_MASK_SHIFT(reg) (((reg) & MC_TZ_ERR_ID_ERR_TRANS_ID_MASK) >> MC_TZ_ERR_ID_ERR_TRANS_ID_SHIFT)
#define  MC_TZ_ERR_ID_ERR_TRANS_ID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_ERR_ID_ERR_TRANS_ID_MASK) | (((uint32_t)val) << MC_TZ_ERR_ID_ERR_TRANS_ID_SHIFT))

//====================================================================
//Register: TrustZone Error Lower Address Register (TZ_ERR_ADR_L)
//====================================================================

#define  MC_TZ_ERR_ADR_L_ERR_ADR_L_MASK 0xffffffff
#define  MC_TZ_ERR_ADR_L_ERR_ADR_L_SHIFT 0
#define  MC_TZ_ERR_ADR_L_ERR_ADR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_ERR_ADR_L_ERR_ADR_L_MASK) >> MC_TZ_ERR_ADR_L_ERR_ADR_L_SHIFT)
#define  MC_TZ_ERR_ADR_L_ERR_ADR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_ERR_ADR_L_ERR_ADR_L_MASK) | (((uint32_t)val) << MC_TZ_ERR_ADR_L_ERR_ADR_L_SHIFT))

//====================================================================
//Register: TrustZone Error Higher Address Register (TZ_ERR_ADR_H)
//====================================================================

#define  MC_TZ_ERR_ADR_H_RESERVED1_MASK 0xffffff00
#define  MC_TZ_ERR_ADR_H_RESERVED1_SHIFT 8
#define  MC_TZ_ERR_ADR_H_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_ERR_ADR_H_RESERVED1_MASK) >> MC_TZ_ERR_ADR_H_RESERVED1_SHIFT)
#define  MC_TZ_ERR_ADR_H_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_ERR_ADR_H_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_ERR_ADR_H_RESERVED1_SHIFT))

#define  MC_TZ_ERR_ADR_H_ERR_ADR_H_MASK 0xff
#define  MC_TZ_ERR_ADR_H_ERR_ADR_H_SHIFT 0
#define  MC_TZ_ERR_ADR_H_ERR_ADR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_ERR_ADR_H_ERR_ADR_H_MASK) >> MC_TZ_ERR_ADR_H_ERR_ADR_H_SHIFT)
#define  MC_TZ_ERR_ADR_H_ERR_ADR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_ERR_ADR_H_ERR_ADR_H_MASK) | (((uint32_t)val) << MC_TZ_ERR_ADR_H_ERR_ADR_H_SHIFT))

//====================================================================
//Register: Parity/CRC error status Register (MC_ADDR_PAR_CRC_ERR)
/** \brief This register is used by DDR4 only*/
//====================================================================

#define  MC_MC_ADDR_PAR_CRC_ERR_RESERVED1_MASK 0xfffffffc
#define  MC_MC_ADDR_PAR_CRC_ERR_RESERVED1_SHIFT 2
#define  MC_MC_ADDR_PAR_CRC_ERR_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MC_ADDR_PAR_CRC_ERR_RESERVED1_MASK) >> MC_MC_ADDR_PAR_CRC_ERR_RESERVED1_SHIFT)
#define  MC_MC_ADDR_PAR_CRC_ERR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ADDR_PAR_CRC_ERR_RESERVED1_MASK) | (((uint32_t)val) << MC_MC_ADDR_PAR_CRC_ERR_RESERVED1_SHIFT))

#define  MC_MC_ADDR_PAR_CRC_ERR_CRC_ERR_CH0_MASK 0x2
#define  MC_MC_ADDR_PAR_CRC_ERR_CRC_ERR_CH0_SHIFT 1
#define  MC_MC_ADDR_PAR_CRC_ERR_CRC_ERR_CH0_MASK_SHIFT(reg) (((reg) & MC_MC_ADDR_PAR_CRC_ERR_CRC_ERR_CH0_MASK) >> MC_MC_ADDR_PAR_CRC_ERR_CRC_ERR_CH0_SHIFT)
#define  MC_MC_ADDR_PAR_CRC_ERR_CRC_ERR_CH0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ADDR_PAR_CRC_ERR_CRC_ERR_CH0_MASK) | (((uint32_t)val) << MC_MC_ADDR_PAR_CRC_ERR_CRC_ERR_CH0_SHIFT))

#define  MC_MC_ADDR_PAR_CRC_ERR_PAR_ERR_CH0_MASK 0x1
#define  MC_MC_ADDR_PAR_CRC_ERR_PAR_ERR_CH0_SHIFT 0
#define  MC_MC_ADDR_PAR_CRC_ERR_PAR_ERR_CH0_MASK_SHIFT(reg) (((reg) & MC_MC_ADDR_PAR_CRC_ERR_PAR_ERR_CH0_MASK) >> MC_MC_ADDR_PAR_CRC_ERR_PAR_ERR_CH0_SHIFT)
#define  MC_MC_ADDR_PAR_CRC_ERR_PAR_ERR_CH0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ADDR_PAR_CRC_ERR_PAR_ERR_CH0_MASK) | (((uint32_t)val) << MC_MC_ADDR_PAR_CRC_ERR_PAR_ERR_CH0_SHIFT))

//====================================================================
//Register: Test Mode Register 0 (Test_Control_0)
/** \brief In test mode, users can directly control RAS#, CAS#, and WE# by writing to
this register.
Address bus signals are take from <<xref=Test_Control_1>>.*/
//====================================================================

#define  MC_TEST_CONTROL_0_RESERVED1_MASK 0xfffffff8
#define  MC_TEST_CONTROL_0_RESERVED1_SHIFT 3
#define  MC_TEST_CONTROL_0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TEST_CONTROL_0_RESERVED1_MASK) >> MC_TEST_CONTROL_0_RESERVED1_SHIFT)
#define  MC_TEST_CONTROL_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TEST_CONTROL_0_RESERVED1_MASK) | (((uint32_t)val) << MC_TEST_CONTROL_0_RESERVED1_SHIFT))

#define  MC_TEST_CONTROL_0_DDR_COMMAND_MASK 0x7
#define  MC_TEST_CONTROL_0_DDR_COMMAND_SHIFT 0
#define  MC_TEST_CONTROL_0_DDR_COMMAND_MASK_SHIFT(reg) (((reg) & MC_TEST_CONTROL_0_DDR_COMMAND_MASK) >> MC_TEST_CONTROL_0_DDR_COMMAND_SHIFT)
#define  MC_TEST_CONTROL_0_DDR_COMMAND_REPLACE_VAL(reg,val) (((reg) & ~MC_TEST_CONTROL_0_DDR_COMMAND_MASK) | (((uint32_t)val) << MC_TEST_CONTROL_0_DDR_COMMAND_SHIFT))

//====================================================================
//Register: Test Mode Register 1 (Test_Control_1)
//====================================================================

#define  MC_TEST_CONTROL_1_RESERVED1_MASK 0xfe000000
#define  MC_TEST_CONTROL_1_RESERVED1_SHIFT 25
#define  MC_TEST_CONTROL_1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TEST_CONTROL_1_RESERVED1_MASK) >> MC_TEST_CONTROL_1_RESERVED1_SHIFT)
#define  MC_TEST_CONTROL_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TEST_CONTROL_1_RESERVED1_MASK) | (((uint32_t)val) << MC_TEST_CONTROL_1_RESERVED1_SHIFT))

#define  MC_TEST_CONTROL_1_CH0_MASK 0x1000000
#define  MC_TEST_CONTROL_1_CH0_SHIFT 24
#define  MC_TEST_CONTROL_1_CH0_MASK_SHIFT(reg) (((reg) & MC_TEST_CONTROL_1_CH0_MASK) >> MC_TEST_CONTROL_1_CH0_SHIFT)
#define  MC_TEST_CONTROL_1_CH0_REPLACE_VAL(reg,val) (((reg) & ~MC_TEST_CONTROL_1_CH0_MASK) | (((uint32_t)val) << MC_TEST_CONTROL_1_CH0_SHIFT))

#define  MC_TEST_CONTROL_1_RESERVED2_MASK 0xe00000
#define  MC_TEST_CONTROL_1_RESERVED2_SHIFT 21
#define  MC_TEST_CONTROL_1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TEST_CONTROL_1_RESERVED2_MASK) >> MC_TEST_CONTROL_1_RESERVED2_SHIFT)
#define  MC_TEST_CONTROL_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TEST_CONTROL_1_RESERVED2_MASK) | (((uint32_t)val) << MC_TEST_CONTROL_1_RESERVED2_SHIFT))

#define  MC_TEST_CONTROL_1_CS0_MASK 0x100000
#define  MC_TEST_CONTROL_1_CS0_SHIFT 20
#define  MC_TEST_CONTROL_1_CS0_MASK_SHIFT(reg) (((reg) & MC_TEST_CONTROL_1_CS0_MASK) >> MC_TEST_CONTROL_1_CS0_SHIFT)
#define  MC_TEST_CONTROL_1_CS0_REPLACE_VAL(reg,val) (((reg) & ~MC_TEST_CONTROL_1_CS0_MASK) | (((uint32_t)val) << MC_TEST_CONTROL_1_CS0_SHIFT))

#define  MC_TEST_CONTROL_1_DDR_CA_MASK 0xfffff
#define  MC_TEST_CONTROL_1_DDR_CA_SHIFT 0
#define  MC_TEST_CONTROL_1_DDR_CA_MASK_SHIFT(reg) (((reg) & MC_TEST_CONTROL_1_DDR_CA_MASK) >> MC_TEST_CONTROL_1_DDR_CA_SHIFT)
#define  MC_TEST_CONTROL_1_DDR_CA_REPLACE_VAL(reg,val) (((reg) & ~MC_TEST_CONTROL_1_DDR_CA_MASK) | (((uint32_t)val) << MC_TEST_CONTROL_1_DDR_CA_SHIFT))

//====================================================================
//Register: Channel 0 MMAP Register CS0 (CH0_MMAP0)
/** \brief The memory map registers, if enabled, define the address range mapped for each of the chip selects.
   The upper bits are used as the starting address for comparing address hits to each chip select.
   The area length determines the appropriate range of the starting address to compare.
   Note: This register is locked when <<xref=MC_Control_0/addr_map_lock>> is on.*/
//====================================================================

#define  MC_CH0_MMAP0_START_ADDRESS_MASK 0xff800000
#define  MC_CH0_MMAP0_START_ADDRESS_SHIFT 23
#define  MC_CH0_MMAP0_START_ADDRESS_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP0_START_ADDRESS_MASK) >> MC_CH0_MMAP0_START_ADDRESS_SHIFT)
#define  MC_CH0_MMAP0_START_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP0_START_ADDRESS_MASK) | (((uint32_t)val) << MC_CH0_MMAP0_START_ADDRESS_SHIFT))

#define  MC_CH0_MMAP0_RESERVED1_MASK 0x600000
#define  MC_CH0_MMAP0_RESERVED1_SHIFT 21
#define  MC_CH0_MMAP0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP0_RESERVED1_MASK) >> MC_CH0_MMAP0_RESERVED1_SHIFT)
#define  MC_CH0_MMAP0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MMAP0_RESERVED1_SHIFT))

#define  MC_CH0_MMAP0_AREA_LENGTH_MASK 0x1f0000
#define  MC_CH0_MMAP0_AREA_LENGTH_SHIFT 16
#define  MC_CH0_MMAP0_AREA_LENGTH_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP0_AREA_LENGTH_MASK) >> MC_CH0_MMAP0_AREA_LENGTH_SHIFT)
#define  MC_CH0_MMAP0_AREA_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP0_AREA_LENGTH_MASK) | (((uint32_t)val) << MC_CH0_MMAP0_AREA_LENGTH_SHIFT))

#define  MC_CH0_MMAP0_START_ADDRESS_HI_MASK 0xff00
#define  MC_CH0_MMAP0_START_ADDRESS_HI_SHIFT 8
#define  MC_CH0_MMAP0_START_ADDRESS_HI_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP0_START_ADDRESS_HI_MASK) >> MC_CH0_MMAP0_START_ADDRESS_HI_SHIFT)
#define  MC_CH0_MMAP0_START_ADDRESS_HI_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP0_START_ADDRESS_HI_MASK) | (((uint32_t)val) << MC_CH0_MMAP0_START_ADDRESS_HI_SHIFT))

#define  MC_CH0_MMAP0_RESERVED2_MASK 0xfe
#define  MC_CH0_MMAP0_RESERVED2_SHIFT 1
#define  MC_CH0_MMAP0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP0_RESERVED2_MASK) >> MC_CH0_MMAP0_RESERVED2_SHIFT)
#define  MC_CH0_MMAP0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_MMAP0_RESERVED2_SHIFT))

#define  MC_CH0_MMAP0_CS_VALID_MASK 0x1
#define  MC_CH0_MMAP0_CS_VALID_SHIFT 0
#define  MC_CH0_MMAP0_CS_VALID_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP0_CS_VALID_MASK) >> MC_CH0_MMAP0_CS_VALID_SHIFT)
#define  MC_CH0_MMAP0_CS_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP0_CS_VALID_MASK) | (((uint32_t)val) << MC_CH0_MMAP0_CS_VALID_SHIFT))

//====================================================================
//Register: Channel 0 MC Physical Address Map Register CS0 (CH0_PMAP0)
/** \brief Note: This register is locked when <<xref=MC_Control_0/addr_map_lock>> is on.*/
//====================================================================

#define  MC_CH0_PMAP0_RESERVED1_MASK 0xe0000000
#define  MC_CH0_PMAP0_RESERVED1_SHIFT 29
#define  MC_CH0_PMAP0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_RESERVED1_MASK) >> MC_CH0_PMAP0_RESERVED1_SHIFT)
#define  MC_CH0_PMAP0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_RESERVED1_SHIFT))

#define  MC_CH0_PMAP0_BANK_MAPPING_MASK 0x1f000000
#define  MC_CH0_PMAP0_BANK_MAPPING_SHIFT 24
#define  MC_CH0_PMAP0_BANK_MAPPING_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_BANK_MAPPING_MASK) >> MC_CH0_PMAP0_BANK_MAPPING_SHIFT)
#define  MC_CH0_PMAP0_BANK_MAPPING_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_BANK_MAPPING_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_BANK_MAPPING_SHIFT))

#define  MC_CH0_PMAP0_RESERVED2_MASK 0xfc0000
#define  MC_CH0_PMAP0_RESERVED2_SHIFT 18
#define  MC_CH0_PMAP0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_RESERVED2_MASK) >> MC_CH0_PMAP0_RESERVED2_SHIFT)
#define  MC_CH0_PMAP0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_RESERVED2_SHIFT))

#define  MC_CH0_PMAP0_DDR4_DEVICE_TYPE_MASK 0x30000
#define  MC_CH0_PMAP0_DDR4_DEVICE_TYPE_SHIFT 16
#define  MC_CH0_PMAP0_DDR4_DEVICE_TYPE_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_DDR4_DEVICE_TYPE_MASK) >> MC_CH0_PMAP0_DDR4_DEVICE_TYPE_SHIFT)
#define  MC_CH0_PMAP0_DDR4_DEVICE_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_DDR4_DEVICE_TYPE_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_DDR4_DEVICE_TYPE_SHIFT))

#define  MC_CH0_PMAP0_RESERVED3_MASK 0xc000
#define  MC_CH0_PMAP0_RESERVED3_SHIFT 14
#define  MC_CH0_PMAP0_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_RESERVED3_MASK) >> MC_CH0_PMAP0_RESERVED3_SHIFT)
#define  MC_CH0_PMAP0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_RESERVED3_SHIFT))

#define  MC_CH0_PMAP0_STACKCHIP_MASK 0x3000
#define  MC_CH0_PMAP0_STACKCHIP_SHIFT 12
#define  MC_CH0_PMAP0_STACKCHIP_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_STACKCHIP_MASK) >> MC_CH0_PMAP0_STACKCHIP_SHIFT)
#define  MC_CH0_PMAP0_STACKCHIP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_STACKCHIP_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_STACKCHIP_SHIFT))

#define  MC_CH0_PMAP0_NOROW_MASK 0xf00
#define  MC_CH0_PMAP0_NOROW_SHIFT 8
#define  MC_CH0_PMAP0_NOROW_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_NOROW_MASK) >> MC_CH0_PMAP0_NOROW_SHIFT)
#define  MC_CH0_PMAP0_NOROW_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_NOROW_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_NOROW_SHIFT))

#define  MC_CH0_PMAP0_NOCOL_MASK 0xf0
#define  MC_CH0_PMAP0_NOCOL_SHIFT 4
#define  MC_CH0_PMAP0_NOCOL_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_NOCOL_MASK) >> MC_CH0_PMAP0_NOCOL_SHIFT)
#define  MC_CH0_PMAP0_NOCOL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_NOCOL_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_NOCOL_SHIFT))

#define  MC_CH0_PMAP0_NOBANKGROUP_MASK 0xc
#define  MC_CH0_PMAP0_NOBANKGROUP_SHIFT 2
#define  MC_CH0_PMAP0_NOBANKGROUP_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_NOBANKGROUP_MASK) >> MC_CH0_PMAP0_NOBANKGROUP_SHIFT)
#define  MC_CH0_PMAP0_NOBANKGROUP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_NOBANKGROUP_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_NOBANKGROUP_SHIFT))

#define  MC_CH0_PMAP0_NOBANK_MASK 0x3
#define  MC_CH0_PMAP0_NOBANK_SHIFT 0
#define  MC_CH0_PMAP0_NOBANK_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_NOBANK_MASK) >> MC_CH0_PMAP0_NOBANK_SHIFT)
#define  MC_CH0_PMAP0_NOBANK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_NOBANK_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_NOBANK_SHIFT))

//====================================================================
//Register: Channel 0 MC Control Register 1 (CH0_MC_Control_1)
//====================================================================

#define  MC_CH0_MC_CONTROL_1_RESERVED1_MASK 0x80000000
#define  MC_CH0_MC_CONTROL_1_RESERVED1_SHIFT 31
#define  MC_CH0_MC_CONTROL_1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_RESERVED1_MASK) >> MC_CH0_MC_CONTROL_1_RESERVED1_SHIFT)
#define  MC_CH0_MC_CONTROL_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_RESERVED1_SHIFT))

#define  MC_CH0_MC_CONTROL_1_APS_TYPE_MASK 0x70000000
#define  MC_CH0_MC_CONTROL_1_APS_TYPE_SHIFT 28
#define  MC_CH0_MC_CONTROL_1_APS_TYPE_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_APS_TYPE_MASK) >> MC_CH0_MC_CONTROL_1_APS_TYPE_SHIFT)
#define  MC_CH0_MC_CONTROL_1_APS_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_APS_TYPE_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_APS_TYPE_SHIFT))

#define  MC_CH0_MC_CONTROL_1_APS_VALUE_MASK 0xfff0000
#define  MC_CH0_MC_CONTROL_1_APS_VALUE_SHIFT 16
#define  MC_CH0_MC_CONTROL_1_APS_VALUE_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_APS_VALUE_MASK) >> MC_CH0_MC_CONTROL_1_APS_VALUE_SHIFT)
#define  MC_CH0_MC_CONTROL_1_APS_VALUE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_APS_VALUE_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_APS_VALUE_SHIFT))

#define  MC_CH0_MC_CONTROL_1_RESERVED2_MASK 0x8000
#define  MC_CH0_MC_CONTROL_1_RESERVED2_SHIFT 15
#define  MC_CH0_MC_CONTROL_1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_RESERVED2_MASK) >> MC_CH0_MC_CONTROL_1_RESERVED2_SHIFT)
#define  MC_CH0_MC_CONTROL_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_RESERVED2_SHIFT))

#define  MC_CH0_MC_CONTROL_1_ACS_EXIT_DLY_MASK 0x7000
#define  MC_CH0_MC_CONTROL_1_ACS_EXIT_DLY_SHIFT 12
#define  MC_CH0_MC_CONTROL_1_ACS_EXIT_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_ACS_EXIT_DLY_MASK) >> MC_CH0_MC_CONTROL_1_ACS_EXIT_DLY_SHIFT)
#define  MC_CH0_MC_CONTROL_1_ACS_EXIT_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_ACS_EXIT_DLY_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_ACS_EXIT_DLY_SHIFT))

#define  MC_CH0_MC_CONTROL_1_RESERVED3_MASK 0x800
#define  MC_CH0_MC_CONTROL_1_RESERVED3_SHIFT 11
#define  MC_CH0_MC_CONTROL_1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_RESERVED3_MASK) >> MC_CH0_MC_CONTROL_1_RESERVED3_SHIFT)
#define  MC_CH0_MC_CONTROL_1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_RESERVED3_SHIFT))

#define  MC_CH0_MC_CONTROL_1_RETRY_MODE_MASK 0x400
#define  MC_CH0_MC_CONTROL_1_RETRY_MODE_SHIFT 10
#define  MC_CH0_MC_CONTROL_1_RETRY_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_RETRY_MODE_MASK) >> MC_CH0_MC_CONTROL_1_RETRY_MODE_SHIFT)
#define  MC_CH0_MC_CONTROL_1_RETRY_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_RETRY_MODE_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_RETRY_MODE_SHIFT))

#define  MC_CH0_MC_CONTROL_1_SRX_AUTO_ZQCL_DIS_MASK 0x200
#define  MC_CH0_MC_CONTROL_1_SRX_AUTO_ZQCL_DIS_SHIFT 9
#define  MC_CH0_MC_CONTROL_1_SRX_AUTO_ZQCL_DIS_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_SRX_AUTO_ZQCL_DIS_MASK) >> MC_CH0_MC_CONTROL_1_SRX_AUTO_ZQCL_DIS_SHIFT)
#define  MC_CH0_MC_CONTROL_1_SRX_AUTO_ZQCL_DIS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_SRX_AUTO_ZQCL_DIS_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_SRX_AUTO_ZQCL_DIS_SHIFT))

#define  MC_CH0_MC_CONTROL_1_RESERVED4_MASK 0x100
#define  MC_CH0_MC_CONTROL_1_RESERVED4_SHIFT 8
#define  MC_CH0_MC_CONTROL_1_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_RESERVED4_MASK) >> MC_CH0_MC_CONTROL_1_RESERVED4_SHIFT)
#define  MC_CH0_MC_CONTROL_1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_RESERVED4_SHIFT))

#define  MC_CH0_MC_CONTROL_1__2T_MODE_MASK 0x80
#define  MC_CH0_MC_CONTROL_1__2T_MODE_SHIFT 7
#define  MC_CH0_MC_CONTROL_1__2T_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1__2T_MODE_MASK) >> MC_CH0_MC_CONTROL_1__2T_MODE_SHIFT)
#define  MC_CH0_MC_CONTROL_1__2T_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1__2T_MODE_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1__2T_MODE_SHIFT))

#define  MC_CH0_MC_CONTROL_1_RDIMM_MODE_MASK 0x40
#define  MC_CH0_MC_CONTROL_1_RDIMM_MODE_SHIFT 6
#define  MC_CH0_MC_CONTROL_1_RDIMM_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_RDIMM_MODE_MASK) >> MC_CH0_MC_CONTROL_1_RDIMM_MODE_SHIFT)
#define  MC_CH0_MC_CONTROL_1_RDIMM_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_RDIMM_MODE_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_RDIMM_MODE_SHIFT))

#define  MC_CH0_MC_CONTROL_1_RESERVED5_MASK 0x20
#define  MC_CH0_MC_CONTROL_1_RESERVED5_SHIFT 5
#define  MC_CH0_MC_CONTROL_1_RESERVED5_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_RESERVED5_MASK) >> MC_CH0_MC_CONTROL_1_RESERVED5_SHIFT)
#define  MC_CH0_MC_CONTROL_1_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_RESERVED5_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_RESERVED5_SHIFT))

#define  MC_CH0_MC_CONTROL_1_TW2R_DIS_MASK 0x10
#define  MC_CH0_MC_CONTROL_1_TW2R_DIS_SHIFT 4
#define  MC_CH0_MC_CONTROL_1_TW2R_DIS_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_TW2R_DIS_MASK) >> MC_CH0_MC_CONTROL_1_TW2R_DIS_SHIFT)
#define  MC_CH0_MC_CONTROL_1_TW2R_DIS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_TW2R_DIS_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_TW2R_DIS_SHIFT))

#define  MC_CH0_MC_CONTROL_1_PHY_MASK_MASK 0x8
#define  MC_CH0_MC_CONTROL_1_PHY_MASK_SHIFT 3
#define  MC_CH0_MC_CONTROL_1_PHY_MASK_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_PHY_MASK_MASK) >> MC_CH0_MC_CONTROL_1_PHY_MASK_SHIFT)
#define  MC_CH0_MC_CONTROL_1_PHY_MASK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_PHY_MASK_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_PHY_MASK_SHIFT))

#define  MC_CH0_MC_CONTROL_1_FORCE_COLD_BOOT_MASK 0x4
#define  MC_CH0_MC_CONTROL_1_FORCE_COLD_BOOT_SHIFT 2
#define  MC_CH0_MC_CONTROL_1_FORCE_COLD_BOOT_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_FORCE_COLD_BOOT_MASK) >> MC_CH0_MC_CONTROL_1_FORCE_COLD_BOOT_SHIFT)
#define  MC_CH0_MC_CONTROL_1_FORCE_COLD_BOOT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_FORCE_COLD_BOOT_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_FORCE_COLD_BOOT_SHIFT))

#define  MC_CH0_MC_CONTROL_1_RESERVED6_MASK 0x3
#define  MC_CH0_MC_CONTROL_1_RESERVED6_SHIFT 0
#define  MC_CH0_MC_CONTROL_1_RESERVED6_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_RESERVED6_MASK) >> MC_CH0_MC_CONTROL_1_RESERVED6_SHIFT)
#define  MC_CH0_MC_CONTROL_1_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_RESERVED6_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_RESERVED6_SHIFT))

//====================================================================
//Register: Channel 0 MC Control Register 2 (CH0_MC_Control_2)
//====================================================================

#define  MC_CH0_MC_CONTROL_2_RESERVED1_MASK 0x80000000
#define  MC_CH0_MC_CONTROL_2_RESERVED1_SHIFT 31
#define  MC_CH0_MC_CONTROL_2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_2_RESERVED1_MASK) >> MC_CH0_MC_CONTROL_2_RESERVED1_SHIFT)
#define  MC_CH0_MC_CONTROL_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_2_RESERVED1_SHIFT))

#define  MC_CH0_MC_CONTROL_2_BLOCK_LOW_MASK 0x40000000
#define  MC_CH0_MC_CONTROL_2_BLOCK_LOW_SHIFT 30
#define  MC_CH0_MC_CONTROL_2_BLOCK_LOW_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_2_BLOCK_LOW_MASK) >> MC_CH0_MC_CONTROL_2_BLOCK_LOW_SHIFT)
#define  MC_CH0_MC_CONTROL_2_BLOCK_LOW_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_2_BLOCK_LOW_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_2_BLOCK_LOW_SHIFT))

#define  MC_CH0_MC_CONTROL_2_BLOCK_HIGH_MASK 0x20000000
#define  MC_CH0_MC_CONTROL_2_BLOCK_HIGH_SHIFT 29
#define  MC_CH0_MC_CONTROL_2_BLOCK_HIGH_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_2_BLOCK_HIGH_MASK) >> MC_CH0_MC_CONTROL_2_BLOCK_HIGH_SHIFT)
#define  MC_CH0_MC_CONTROL_2_BLOCK_HIGH_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_2_BLOCK_HIGH_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_2_BLOCK_HIGH_SHIFT))

#define  MC_CH0_MC_CONTROL_2_LOW_LATENCY_DIS_MASK 0x10000000
#define  MC_CH0_MC_CONTROL_2_LOW_LATENCY_DIS_SHIFT 28
#define  MC_CH0_MC_CONTROL_2_LOW_LATENCY_DIS_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_2_LOW_LATENCY_DIS_MASK) >> MC_CH0_MC_CONTROL_2_LOW_LATENCY_DIS_SHIFT)
#define  MC_CH0_MC_CONTROL_2_LOW_LATENCY_DIS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_2_LOW_LATENCY_DIS_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_2_LOW_LATENCY_DIS_SHIFT))

#define  MC_CH0_MC_CONTROL_2_RESERVED2_MASK 0xfff0000
#define  MC_CH0_MC_CONTROL_2_RESERVED2_SHIFT 16
#define  MC_CH0_MC_CONTROL_2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_2_RESERVED2_MASK) >> MC_CH0_MC_CONTROL_2_RESERVED2_SHIFT)
#define  MC_CH0_MC_CONTROL_2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_2_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_2_RESERVED2_SHIFT))

#define  MC_CH0_MC_CONTROL_2_BQ_STARV_TIME_MASK 0xffff
#define  MC_CH0_MC_CONTROL_2_BQ_STARV_TIME_SHIFT 0
#define  MC_CH0_MC_CONTROL_2_BQ_STARV_TIME_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_2_BQ_STARV_TIME_MASK) >> MC_CH0_MC_CONTROL_2_BQ_STARV_TIME_SHIFT)
#define  MC_CH0_MC_CONTROL_2_BQ_STARV_TIME_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_2_BQ_STARV_TIME_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_2_BQ_STARV_TIME_SHIFT))

//====================================================================
//Register: Channel 0 MC Control Register 3 (CH0_MC_Control_3)
//====================================================================

#define  MC_CH0_MC_CONTROL_3_RESERVED1_MASK 0xffff0000
#define  MC_CH0_MC_CONTROL_3_RESERVED1_SHIFT 16
#define  MC_CH0_MC_CONTROL_3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_3_RESERVED1_MASK) >> MC_CH0_MC_CONTROL_3_RESERVED1_SHIFT)
#define  MC_CH0_MC_CONTROL_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_3_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_3_RESERVED1_SHIFT))

#define  MC_CH0_MC_CONTROL_3_PHY_OUT_FF_BYPASS_MASK 0xff00
#define  MC_CH0_MC_CONTROL_3_PHY_OUT_FF_BYPASS_SHIFT 8
#define  MC_CH0_MC_CONTROL_3_PHY_OUT_FF_BYPASS_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_3_PHY_OUT_FF_BYPASS_MASK) >> MC_CH0_MC_CONTROL_3_PHY_OUT_FF_BYPASS_SHIFT)
#define  MC_CH0_MC_CONTROL_3_PHY_OUT_FF_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_3_PHY_OUT_FF_BYPASS_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_3_PHY_OUT_FF_BYPASS_SHIFT))

#define  MC_CH0_MC_CONTROL_3_PHY_IN_FF_BYPASS_MASK 0xff
#define  MC_CH0_MC_CONTROL_3_PHY_IN_FF_BYPASS_SHIFT 0
#define  MC_CH0_MC_CONTROL_3_PHY_IN_FF_BYPASS_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_3_PHY_IN_FF_BYPASS_MASK) >> MC_CH0_MC_CONTROL_3_PHY_IN_FF_BYPASS_SHIFT)
#define  MC_CH0_MC_CONTROL_3_PHY_IN_FF_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_3_PHY_IN_FF_BYPASS_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_3_PHY_IN_FF_BYPASS_SHIFT))

//====================================================================
//Register: Channel 0 MC Control Register 4 (CH0_MC_Control_4)
//====================================================================

#define  MC_CH0_MC_CONTROL_4_AUTO_SR_IDLE_TIME_MASK 0xffffffff
#define  MC_CH0_MC_CONTROL_4_AUTO_SR_IDLE_TIME_SHIFT 0
#define  MC_CH0_MC_CONTROL_4_AUTO_SR_IDLE_TIME_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_4_AUTO_SR_IDLE_TIME_MASK) >> MC_CH0_MC_CONTROL_4_AUTO_SR_IDLE_TIME_SHIFT)
#define  MC_CH0_MC_CONTROL_4_AUTO_SR_IDLE_TIME_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_4_AUTO_SR_IDLE_TIME_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_4_AUTO_SR_IDLE_TIME_SHIFT))

//====================================================================
//Register: Channel 0 DRAM Configuration Register 1 (CH0_DRAM_Config_1)
/** \brief Note: All timing settings in this register are calculated in DRAM clock cycles.*/
//====================================================================

#define  MC_CH0_DRAM_CONFIG_1_CAP_LATENCY_MASK 0xf0000000
#define  MC_CH0_DRAM_CONFIG_1_CAP_LATENCY_SHIFT 28
#define  MC_CH0_DRAM_CONFIG_1_CAP_LATENCY_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_CAP_LATENCY_MASK) >> MC_CH0_DRAM_CONFIG_1_CAP_LATENCY_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_CAP_LATENCY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_CAP_LATENCY_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_CAP_LATENCY_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_CA_LATENCY_MASK 0xf000000
#define  MC_CH0_DRAM_CONFIG_1_CA_LATENCY_SHIFT 24
#define  MC_CH0_DRAM_CONFIG_1_CA_LATENCY_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_CA_LATENCY_MASK) >> MC_CH0_DRAM_CONFIG_1_CA_LATENCY_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_CA_LATENCY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_CA_LATENCY_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_CA_LATENCY_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_RESERVED1_MASK 0x800000
#define  MC_CH0_DRAM_CONFIG_1_RESERVED1_SHIFT 23
#define  MC_CH0_DRAM_CONFIG_1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_RESERVED1_MASK) >> MC_CH0_DRAM_CONFIG_1_RESERVED1_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_RESERVED1_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_BURST_LENGTH_MASK 0x700000
#define  MC_CH0_DRAM_CONFIG_1_BURST_LENGTH_SHIFT 20
#define  MC_CH0_DRAM_CONFIG_1_BURST_LENGTH_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_BURST_LENGTH_MASK) >> MC_CH0_DRAM_CONFIG_1_BURST_LENGTH_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_BURST_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_BURST_LENGTH_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_BURST_LENGTH_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_RESERVED2_MASK 0x80000
#define  MC_CH0_DRAM_CONFIG_1_RESERVED2_SHIFT 19
#define  MC_CH0_DRAM_CONFIG_1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_RESERVED2_MASK) >> MC_CH0_DRAM_CONFIG_1_RESERVED2_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_RESERVED2_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_CWL_4_MASK 0x40000
#define  MC_CH0_DRAM_CONFIG_1_CWL_4_SHIFT 18
#define  MC_CH0_DRAM_CONFIG_1_CWL_4_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_CWL_4_MASK) >> MC_CH0_DRAM_CONFIG_1_CWL_4_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_CWL_4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_CWL_4_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_CWL_4_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_RESERVED3_MASK 0x20000
#define  MC_CH0_DRAM_CONFIG_1_RESERVED3_SHIFT 17
#define  MC_CH0_DRAM_CONFIG_1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_RESERVED3_MASK) >> MC_CH0_DRAM_CONFIG_1_RESERVED3_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_RESERVED3_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_CAS_LATENCY_MASK 0x1f000
#define  MC_CH0_DRAM_CONFIG_1_CAS_LATENCY_SHIFT 12
#define  MC_CH0_DRAM_CONFIG_1_CAS_LATENCY_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_CAS_LATENCY_MASK) >> MC_CH0_DRAM_CONFIG_1_CAS_LATENCY_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_CAS_LATENCY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_CAS_LATENCY_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_CAS_LATENCY_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_CWL_MASK 0xf00
#define  MC_CH0_DRAM_CONFIG_1_CWL_SHIFT 8
#define  MC_CH0_DRAM_CONFIG_1_CWL_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_CWL_MASK) >> MC_CH0_DRAM_CONFIG_1_CWL_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_CWL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_CWL_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_CWL_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_SDRAM_TYPE_MASK 0xf0
#define  MC_CH0_DRAM_CONFIG_1_SDRAM_TYPE_SHIFT 4
#define  MC_CH0_DRAM_CONFIG_1_SDRAM_TYPE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_SDRAM_TYPE_MASK) >> MC_CH0_DRAM_CONFIG_1_SDRAM_TYPE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_SDRAM_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_SDRAM_TYPE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_SDRAM_TYPE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_RESERVED4_MASK 0x8
#define  MC_CH0_DRAM_CONFIG_1_RESERVED4_SHIFT 3
#define  MC_CH0_DRAM_CONFIG_1_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_RESERVED4_MASK) >> MC_CH0_DRAM_CONFIG_1_RESERVED4_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_RESERVED4_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_DATA_WIDTH_MASK 0x7
#define  MC_CH0_DRAM_CONFIG_1_DATA_WIDTH_SHIFT 0
#define  MC_CH0_DRAM_CONFIG_1_DATA_WIDTH_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_DATA_WIDTH_MASK) >> MC_CH0_DRAM_CONFIG_1_DATA_WIDTH_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_DATA_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_DATA_WIDTH_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_DATA_WIDTH_SHIFT))

//====================================================================
//Register: Channel 0 DRAM Configuration Register 2 (CH0_DRAM_Config_2)
/** \brief Note: Configuration in this register requires Mode Register update.*/
//====================================================================

#define  MC_CH0_DRAM_CONFIG_2_RESERVED1_MASK 0xfc000000
#define  MC_CH0_DRAM_CONFIG_2_RESERVED1_SHIFT 26
#define  MC_CH0_DRAM_CONFIG_2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_RESERVED1_MASK) >> MC_CH0_DRAM_CONFIG_2_RESERVED1_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_RESERVED1_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_MPR_FORMAT_MASK 0x3000000
#define  MC_CH0_DRAM_CONFIG_2_MPR_FORMAT_SHIFT 24
#define  MC_CH0_DRAM_CONFIG_2_MPR_FORMAT_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_MPR_FORMAT_MASK) >> MC_CH0_DRAM_CONFIG_2_MPR_FORMAT_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_MPR_FORMAT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_MPR_FORMAT_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_MPR_FORMAT_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_RESERVED2_MASK 0x800000
#define  MC_CH0_DRAM_CONFIG_2_RESERVED2_SHIFT 23
#define  MC_CH0_DRAM_CONFIG_2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_RESERVED2_MASK) >> MC_CH0_DRAM_CONFIG_2_RESERVED2_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_RESERVED2_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_FINE_REF_MASK 0x700000
#define  MC_CH0_DRAM_CONFIG_2_FINE_REF_SHIFT 20
#define  MC_CH0_DRAM_CONFIG_2_FINE_REF_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_FINE_REF_MASK) >> MC_CH0_DRAM_CONFIG_2_FINE_REF_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_FINE_REF_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_FINE_REF_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_FINE_REF_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_WL_CRC_DM_MASK 0xc0000
#define  MC_CH0_DRAM_CONFIG_2_WL_CRC_DM_SHIFT 18
#define  MC_CH0_DRAM_CONFIG_2_WL_CRC_DM_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_WL_CRC_DM_MASK) >> MC_CH0_DRAM_CONFIG_2_WL_CRC_DM_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_WL_CRC_DM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_WL_CRC_DM_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_WL_CRC_DM_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_PER_DRAM_ADDR_MASK 0x20000
#define  MC_CH0_DRAM_CONFIG_2_PER_DRAM_ADDR_SHIFT 17
#define  MC_CH0_DRAM_CONFIG_2_PER_DRAM_ADDR_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_PER_DRAM_ADDR_MASK) >> MC_CH0_DRAM_CONFIG_2_PER_DRAM_ADDR_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_PER_DRAM_ADDR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_PER_DRAM_ADDR_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_PER_DRAM_ADDR_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_GEARDOWN_MASK 0x10000
#define  MC_CH0_DRAM_CONFIG_2_GEARDOWN_SHIFT 16
#define  MC_CH0_DRAM_CONFIG_2_GEARDOWN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_GEARDOWN_MASK) >> MC_CH0_DRAM_CONFIG_2_GEARDOWN_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_GEARDOWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_GEARDOWN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_GEARDOWN_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_RESERVED3_MASK 0x8000
#define  MC_CH0_DRAM_CONFIG_2_RESERVED3_SHIFT 15
#define  MC_CH0_DRAM_CONFIG_2_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_RESERVED3_MASK) >> MC_CH0_DRAM_CONFIG_2_RESERVED3_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_RESERVED3_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_MPR_PAGE_SEL_MASK 0x6000
#define  MC_CH0_DRAM_CONFIG_2_MPR_PAGE_SEL_SHIFT 13
#define  MC_CH0_DRAM_CONFIG_2_MPR_PAGE_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_MPR_PAGE_SEL_MASK) >> MC_CH0_DRAM_CONFIG_2_MPR_PAGE_SEL_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_MPR_PAGE_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_MPR_PAGE_SEL_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_MPR_PAGE_SEL_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_MPR_MASK 0x1000
#define  MC_CH0_DRAM_CONFIG_2_MPR_SHIFT 12
#define  MC_CH0_DRAM_CONFIG_2_MPR_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_MPR_MASK) >> MC_CH0_DRAM_CONFIG_2_MPR_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_MPR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_MPR_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_MPR_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_WD_CRC_MASK 0x800
#define  MC_CH0_DRAM_CONFIG_2_WD_CRC_SHIFT 11
#define  MC_CH0_DRAM_CONFIG_2_WD_CRC_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_WD_CRC_MASK) >> MC_CH0_DRAM_CONFIG_2_WD_CRC_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_WD_CRC_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_WD_CRC_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_WD_CRC_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_RESERVED4_MASK 0x400
#define  MC_CH0_DRAM_CONFIG_2_RESERVED4_SHIFT 10
#define  MC_CH0_DRAM_CONFIG_2_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_RESERVED4_MASK) >> MC_CH0_DRAM_CONFIG_2_RESERVED4_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_RESERVED4_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_ASR_MASK 0x300
#define  MC_CH0_DRAM_CONFIG_2_ASR_SHIFT 8
#define  MC_CH0_DRAM_CONFIG_2_ASR_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_ASR_MASK) >> MC_CH0_DRAM_CONFIG_2_ASR_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_ASR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_ASR_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_ASR_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_OUTEN_MASK 0x80
#define  MC_CH0_DRAM_CONFIG_2_OUTEN_SHIFT 7
#define  MC_CH0_DRAM_CONFIG_2_OUTEN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_OUTEN_MASK) >> MC_CH0_DRAM_CONFIG_2_OUTEN_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_OUTEN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_OUTEN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_OUTEN_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_RESERVED5_MASK 0x40
#define  MC_CH0_DRAM_CONFIG_2_RESERVED5_SHIFT 6
#define  MC_CH0_DRAM_CONFIG_2_RESERVED5_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_RESERVED5_MASK) >> MC_CH0_DRAM_CONFIG_2_RESERVED5_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_RESERVED5_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_RESERVED5_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_WRITE_LEVEL_EN_MASK 0x20
#define  MC_CH0_DRAM_CONFIG_2_WRITE_LEVEL_EN_SHIFT 5
#define  MC_CH0_DRAM_CONFIG_2_WRITE_LEVEL_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_WRITE_LEVEL_EN_MASK) >> MC_CH0_DRAM_CONFIG_2_WRITE_LEVEL_EN_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_WRITE_LEVEL_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_WRITE_LEVEL_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_WRITE_LEVEL_EN_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_SDRAM_DLL_DIS_MASK 0x10
#define  MC_CH0_DRAM_CONFIG_2_SDRAM_DLL_DIS_SHIFT 4
#define  MC_CH0_DRAM_CONFIG_2_SDRAM_DLL_DIS_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_SDRAM_DLL_DIS_MASK) >> MC_CH0_DRAM_CONFIG_2_SDRAM_DLL_DIS_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_SDRAM_DLL_DIS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_SDRAM_DLL_DIS_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_SDRAM_DLL_DIS_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_RESERVED6_MASK 0x8
#define  MC_CH0_DRAM_CONFIG_2_RESERVED6_SHIFT 3
#define  MC_CH0_DRAM_CONFIG_2_RESERVED6_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_RESERVED6_MASK) >> MC_CH0_DRAM_CONFIG_2_RESERVED6_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_RESERVED6_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_RESERVED6_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_CAS_BT_MASK 0x4
#define  MC_CH0_DRAM_CONFIG_2_CAS_BT_SHIFT 2
#define  MC_CH0_DRAM_CONFIG_2_CAS_BT_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_CAS_BT_MASK) >> MC_CH0_DRAM_CONFIG_2_CAS_BT_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_CAS_BT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_CAS_BT_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_CAS_BT_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_PD_MODE_MASK 0x2
#define  MC_CH0_DRAM_CONFIG_2_PD_MODE_SHIFT 1
#define  MC_CH0_DRAM_CONFIG_2_PD_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_PD_MODE_MASK) >> MC_CH0_DRAM_CONFIG_2_PD_MODE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_PD_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_PD_MODE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_PD_MODE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_DLL_RESET_MASK 0x1
#define  MC_CH0_DRAM_CONFIG_2_DLL_RESET_SHIFT 0
#define  MC_CH0_DRAM_CONFIG_2_DLL_RESET_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_DLL_RESET_MASK) >> MC_CH0_DRAM_CONFIG_2_DLL_RESET_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_DLL_RESET_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_DLL_RESET_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_DLL_RESET_SHIFT))

//====================================================================
//Register: Channel 0 DRAM Configuration Register 3 (CH0_DRAM_Config_3)
/** \brief This register is used for DDR4 only.
      Note: Configuration in this register requires Mode Register update.*/
//====================================================================

#define  MC_CH0_DRAM_CONFIG_3_RESERVED1_MASK 0xfc000000
#define  MC_CH0_DRAM_CONFIG_3_RESERVED1_SHIFT 26
#define  MC_CH0_DRAM_CONFIG_3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RESERVED1_MASK) >> MC_CH0_DRAM_CONFIG_3_RESERVED1_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RESERVED1_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_RANGE_MASK 0x2000000
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_RANGE_SHIFT 25
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_RANGE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_RANGE_MASK) >> MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_RANGE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_RANGE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_RANGE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_RANGE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_MASK 0x1000000
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_SHIFT 24
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_MASK) >> MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_RESERVED2_MASK 0xc00000
#define  MC_CH0_DRAM_CONFIG_3_RESERVED2_SHIFT 22
#define  MC_CH0_DRAM_CONFIG_3_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RESERVED2_MASK) >> MC_CH0_DRAM_CONFIG_3_RESERVED2_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RESERVED2_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_VALUE_MASK 0x3f0000
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_VALUE_SHIFT 16
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_VALUE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_VALUE_MASK) >> MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_VALUE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_VALUE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_VALUE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_VALUE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_RESERVED3_MASK 0x8000
#define  MC_CH0_DRAM_CONFIG_3_RESERVED3_SHIFT 15
#define  MC_CH0_DRAM_CONFIG_3_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RESERVED3_MASK) >> MC_CH0_DRAM_CONFIG_3_RESERVED3_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RESERVED3_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_READ_DBI_MASK 0x4000
#define  MC_CH0_DRAM_CONFIG_3_READ_DBI_SHIFT 14
#define  MC_CH0_DRAM_CONFIG_3_READ_DBI_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_READ_DBI_MASK) >> MC_CH0_DRAM_CONFIG_3_READ_DBI_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_READ_DBI_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_READ_DBI_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_READ_DBI_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_WRITE_DBI_MASK 0x2000
#define  MC_CH0_DRAM_CONFIG_3_WRITE_DBI_SHIFT 13
#define  MC_CH0_DRAM_CONFIG_3_WRITE_DBI_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_WRITE_DBI_MASK) >> MC_CH0_DRAM_CONFIG_3_WRITE_DBI_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_WRITE_DBI_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_WRITE_DBI_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_WRITE_DBI_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_DM_MASK 0x1000
#define  MC_CH0_DRAM_CONFIG_3_DM_SHIFT 12
#define  MC_CH0_DRAM_CONFIG_3_DM_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_DM_MASK) >> MC_CH0_DRAM_CONFIG_3_DM_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_DM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_DM_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_DM_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_RESERVED4_MASK 0x800
#define  MC_CH0_DRAM_CONFIG_3_RESERVED4_SHIFT 11
#define  MC_CH0_DRAM_CONFIG_3_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RESERVED4_MASK) >> MC_CH0_DRAM_CONFIG_3_RESERVED4_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RESERVED4_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_WR_PRE_MASK 0x400
#define  MC_CH0_DRAM_CONFIG_3_WR_PRE_SHIFT 10
#define  MC_CH0_DRAM_CONFIG_3_WR_PRE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_WR_PRE_MASK) >> MC_CH0_DRAM_CONFIG_3_WR_PRE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_WR_PRE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_WR_PRE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_WR_PRE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_RESERVED5_MASK 0x200
#define  MC_CH0_DRAM_CONFIG_3_RESERVED5_SHIFT 9
#define  MC_CH0_DRAM_CONFIG_3_RESERVED5_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RESERVED5_MASK) >> MC_CH0_DRAM_CONFIG_3_RESERVED5_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RESERVED5_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RESERVED5_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_RD_PRE_MASK 0x100
#define  MC_CH0_DRAM_CONFIG_3_RD_PRE_SHIFT 8
#define  MC_CH0_DRAM_CONFIG_3_RD_PRE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RD_PRE_MASK) >> MC_CH0_DRAM_CONFIG_3_RD_PRE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RD_PRE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RD_PRE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RD_PRE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_RESERVED6_MASK 0xc0
#define  MC_CH0_DRAM_CONFIG_3_RESERVED6_SHIFT 6
#define  MC_CH0_DRAM_CONFIG_3_RESERVED6_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RESERVED6_MASK) >> MC_CH0_DRAM_CONFIG_3_RESERVED6_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RESERVED6_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RESERVED6_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_RD_PRE_TRAINING_MASK 0x20
#define  MC_CH0_DRAM_CONFIG_3_RD_PRE_TRAINING_SHIFT 5
#define  MC_CH0_DRAM_CONFIG_3_RD_PRE_TRAINING_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RD_PRE_TRAINING_MASK) >> MC_CH0_DRAM_CONFIG_3_RD_PRE_TRAINING_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RD_PRE_TRAINING_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RD_PRE_TRAINING_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RD_PRE_TRAINING_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_SR_ABT_MODE_MASK 0x10
#define  MC_CH0_DRAM_CONFIG_3_SR_ABT_MODE_SHIFT 4
#define  MC_CH0_DRAM_CONFIG_3_SR_ABT_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_SR_ABT_MODE_MASK) >> MC_CH0_DRAM_CONFIG_3_SR_ABT_MODE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_SR_ABT_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_SR_ABT_MODE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_SR_ABT_MODE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_INT_VREF_MON_MASK 0x8
#define  MC_CH0_DRAM_CONFIG_3_INT_VREF_MON_SHIFT 3
#define  MC_CH0_DRAM_CONFIG_3_INT_VREF_MON_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_INT_VREF_MON_MASK) >> MC_CH0_DRAM_CONFIG_3_INT_VREF_MON_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_INT_VREF_MON_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_INT_VREF_MON_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_INT_VREF_MON_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_MODE_MASK 0x4
#define  MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_MODE_SHIFT 2
#define  MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_MODE_MASK) >> MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_MODE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_MODE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_MODE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_RESERVED7_MASK 0x2
#define  MC_CH0_DRAM_CONFIG_3_RESERVED7_SHIFT 1
#define  MC_CH0_DRAM_CONFIG_3_RESERVED7_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RESERVED7_MASK) >> MC_CH0_DRAM_CONFIG_3_RESERVED7_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RESERVED7_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RESERVED7_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_RANGE_MASK 0x1
#define  MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_RANGE_SHIFT 0
#define  MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_RANGE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_RANGE_MASK) >> MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_RANGE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_RANGE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_RANGE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_RANGE_SHIFT))

//====================================================================
//Register: Channel 0 DRAM Configuration Register 5 CS0 (CH0_DRAM_Config_5_CS0)
//====================================================================

#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED1_MASK 0x80000000
#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED1_SHIFT 31
#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS0_RESERVED1_MASK) >> MC_CH0_DRAM_CONFIG_5_CS0_RESERVED1_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS0_RESERVED1_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_PARK_MASK 0x70000000
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_PARK_SHIFT 28
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_PARK_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS0_RTT_PARK_MASK) >> MC_CH0_DRAM_CONFIG_5_CS0_RTT_PARK_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_PARK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS0_RTT_PARK_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS0_RTT_PARK_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED2_MASK 0xc000000
#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED2_SHIFT 26
#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS0_RESERVED2_MASK) >> MC_CH0_DRAM_CONFIG_5_CS0_RESERVED2_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS0_RESERVED2_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_WR_MASK 0x3000000
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_WR_SHIFT 24
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_WR_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS0_RTT_WR_MASK) >> MC_CH0_DRAM_CONFIG_5_CS0_RTT_WR_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_WR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS0_RTT_WR_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS0_RTT_WR_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED3_MASK 0x800000
#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED3_SHIFT 23
#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS0_RESERVED3_MASK) >> MC_CH0_DRAM_CONFIG_5_CS0_RESERVED3_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS0_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS0_RESERVED3_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_NOM_MASK 0x700000
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_NOM_SHIFT 20
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_NOM_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS0_RTT_NOM_MASK) >> MC_CH0_DRAM_CONFIG_5_CS0_RTT_NOM_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_NOM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS0_RTT_NOM_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS0_RTT_NOM_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS0_ODS_MASK 0xf0000
#define  MC_CH0_DRAM_CONFIG_5_CS0_ODS_SHIFT 16
#define  MC_CH0_DRAM_CONFIG_5_CS0_ODS_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS0_ODS_MASK) >> MC_CH0_DRAM_CONFIG_5_CS0_ODS_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS0_ODS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS0_ODS_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS0_ODS_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS0_PASR_MASK 0xffff
#define  MC_CH0_DRAM_CONFIG_5_CS0_PASR_SHIFT 0
#define  MC_CH0_DRAM_CONFIG_5_CS0_PASR_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS0_PASR_MASK) >> MC_CH0_DRAM_CONFIG_5_CS0_PASR_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS0_PASR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS0_PASR_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS0_PASR_SHIFT))

//====================================================================
//Register: Channel 0 DRAM Control Register 1 (CH0_DRAM_Control_1)
//====================================================================

#define  MC_CH0_DRAM_CONTROL_1_ODT3_READ_EN_MASK 0xf0000000
#define  MC_CH0_DRAM_CONTROL_1_ODT3_READ_EN_SHIFT 28
#define  MC_CH0_DRAM_CONTROL_1_ODT3_READ_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_1_ODT3_READ_EN_MASK) >> MC_CH0_DRAM_CONTROL_1_ODT3_READ_EN_SHIFT)
#define  MC_CH0_DRAM_CONTROL_1_ODT3_READ_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_1_ODT3_READ_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_1_ODT3_READ_EN_SHIFT))

#define  MC_CH0_DRAM_CONTROL_1_ODT3_WRITE_EN_MASK 0xf000000
#define  MC_CH0_DRAM_CONTROL_1_ODT3_WRITE_EN_SHIFT 24
#define  MC_CH0_DRAM_CONTROL_1_ODT3_WRITE_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_1_ODT3_WRITE_EN_MASK) >> MC_CH0_DRAM_CONTROL_1_ODT3_WRITE_EN_SHIFT)
#define  MC_CH0_DRAM_CONTROL_1_ODT3_WRITE_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_1_ODT3_WRITE_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_1_ODT3_WRITE_EN_SHIFT))

#define  MC_CH0_DRAM_CONTROL_1_ODT2_READ_EN_MASK 0xf00000
#define  MC_CH0_DRAM_CONTROL_1_ODT2_READ_EN_SHIFT 20
#define  MC_CH0_DRAM_CONTROL_1_ODT2_READ_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_1_ODT2_READ_EN_MASK) >> MC_CH0_DRAM_CONTROL_1_ODT2_READ_EN_SHIFT)
#define  MC_CH0_DRAM_CONTROL_1_ODT2_READ_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_1_ODT2_READ_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_1_ODT2_READ_EN_SHIFT))

#define  MC_CH0_DRAM_CONTROL_1_ODT2_WRITE_EN_MASK 0xf0000
#define  MC_CH0_DRAM_CONTROL_1_ODT2_WRITE_EN_SHIFT 16
#define  MC_CH0_DRAM_CONTROL_1_ODT2_WRITE_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_1_ODT2_WRITE_EN_MASK) >> MC_CH0_DRAM_CONTROL_1_ODT2_WRITE_EN_SHIFT)
#define  MC_CH0_DRAM_CONTROL_1_ODT2_WRITE_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_1_ODT2_WRITE_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_1_ODT2_WRITE_EN_SHIFT))

#define  MC_CH0_DRAM_CONTROL_1_ODT1_READ_EN_MASK 0xf000
#define  MC_CH0_DRAM_CONTROL_1_ODT1_READ_EN_SHIFT 12
#define  MC_CH0_DRAM_CONTROL_1_ODT1_READ_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_1_ODT1_READ_EN_MASK) >> MC_CH0_DRAM_CONTROL_1_ODT1_READ_EN_SHIFT)
#define  MC_CH0_DRAM_CONTROL_1_ODT1_READ_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_1_ODT1_READ_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_1_ODT1_READ_EN_SHIFT))

#define  MC_CH0_DRAM_CONTROL_1_ODT1_WRITE_EN_MASK 0xf00
#define  MC_CH0_DRAM_CONTROL_1_ODT1_WRITE_EN_SHIFT 8
#define  MC_CH0_DRAM_CONTROL_1_ODT1_WRITE_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_1_ODT1_WRITE_EN_MASK) >> MC_CH0_DRAM_CONTROL_1_ODT1_WRITE_EN_SHIFT)
#define  MC_CH0_DRAM_CONTROL_1_ODT1_WRITE_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_1_ODT1_WRITE_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_1_ODT1_WRITE_EN_SHIFT))

#define  MC_CH0_DRAM_CONTROL_1_ODT0_READ_EN_MASK 0xf0
#define  MC_CH0_DRAM_CONTROL_1_ODT0_READ_EN_SHIFT 4
#define  MC_CH0_DRAM_CONTROL_1_ODT0_READ_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_1_ODT0_READ_EN_MASK) >> MC_CH0_DRAM_CONTROL_1_ODT0_READ_EN_SHIFT)
#define  MC_CH0_DRAM_CONTROL_1_ODT0_READ_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_1_ODT0_READ_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_1_ODT0_READ_EN_SHIFT))

#define  MC_CH0_DRAM_CONTROL_1_ODT0_WRITE_EN_MASK 0xf
#define  MC_CH0_DRAM_CONTROL_1_ODT0_WRITE_EN_SHIFT 0
#define  MC_CH0_DRAM_CONTROL_1_ODT0_WRITE_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_1_ODT0_WRITE_EN_MASK) >> MC_CH0_DRAM_CONTROL_1_ODT0_WRITE_EN_SHIFT)
#define  MC_CH0_DRAM_CONTROL_1_ODT0_WRITE_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_1_ODT0_WRITE_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_1_ODT0_WRITE_EN_SHIFT))

//====================================================================
//Register: Channel 0 DRAM Control Register 2 (CH0_DRAM_Control_2)
//====================================================================

#define  MC_CH0_DRAM_CONTROL_2_RESERVED1_MASK 0xe0000000
#define  MC_CH0_DRAM_CONTROL_2_RESERVED1_SHIFT 29
#define  MC_CH0_DRAM_CONTROL_2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_2_RESERVED1_MASK) >> MC_CH0_DRAM_CONTROL_2_RESERVED1_SHIFT)
#define  MC_CH0_DRAM_CONTROL_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_2_RESERVED1_SHIFT))

#define  MC_CH0_DRAM_CONTROL_2_ODT0_MASK 0x10000000
#define  MC_CH0_DRAM_CONTROL_2_ODT0_SHIFT 28
#define  MC_CH0_DRAM_CONTROL_2_ODT0_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_2_ODT0_MASK) >> MC_CH0_DRAM_CONTROL_2_ODT0_SHIFT)
#define  MC_CH0_DRAM_CONTROL_2_ODT0_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_2_ODT0_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_2_ODT0_SHIFT))

#define  MC_CH0_DRAM_CONTROL_2_RESERVED2_MASK 0xc000000
#define  MC_CH0_DRAM_CONTROL_2_RESERVED2_SHIFT 26
#define  MC_CH0_DRAM_CONTROL_2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_2_RESERVED2_MASK) >> MC_CH0_DRAM_CONTROL_2_RESERVED2_SHIFT)
#define  MC_CH0_DRAM_CONTROL_2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_2_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_2_RESERVED2_SHIFT))

#define  MC_CH0_DRAM_CONTROL_2_PAD_TERM_SWITCH_MODE_MASK 0x3000000
#define  MC_CH0_DRAM_CONTROL_2_PAD_TERM_SWITCH_MODE_SHIFT 24
#define  MC_CH0_DRAM_CONTROL_2_PAD_TERM_SWITCH_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_2_PAD_TERM_SWITCH_MODE_MASK) >> MC_CH0_DRAM_CONTROL_2_PAD_TERM_SWITCH_MODE_SHIFT)
#define  MC_CH0_DRAM_CONTROL_2_PAD_TERM_SWITCH_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_2_PAD_TERM_SWITCH_MODE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_2_PAD_TERM_SWITCH_MODE_SHIFT))

#define  MC_CH0_DRAM_CONTROL_2_RESERVED3_MASK 0xffff00
#define  MC_CH0_DRAM_CONTROL_2_RESERVED3_SHIFT 8
#define  MC_CH0_DRAM_CONTROL_2_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_2_RESERVED3_MASK) >> MC_CH0_DRAM_CONTROL_2_RESERVED3_SHIFT)
#define  MC_CH0_DRAM_CONTROL_2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_2_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_2_RESERVED3_SHIFT))

#define  MC_CH0_DRAM_CONTROL_2_ODT3_SWITCH_MODE_MASK 0xc0
#define  MC_CH0_DRAM_CONTROL_2_ODT3_SWITCH_MODE_SHIFT 6
#define  MC_CH0_DRAM_CONTROL_2_ODT3_SWITCH_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_2_ODT3_SWITCH_MODE_MASK) >> MC_CH0_DRAM_CONTROL_2_ODT3_SWITCH_MODE_SHIFT)
#define  MC_CH0_DRAM_CONTROL_2_ODT3_SWITCH_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_2_ODT3_SWITCH_MODE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_2_ODT3_SWITCH_MODE_SHIFT))

#define  MC_CH0_DRAM_CONTROL_2_ODT2_SWITCH_MODE_MASK 0x30
#define  MC_CH0_DRAM_CONTROL_2_ODT2_SWITCH_MODE_SHIFT 4
#define  MC_CH0_DRAM_CONTROL_2_ODT2_SWITCH_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_2_ODT2_SWITCH_MODE_MASK) >> MC_CH0_DRAM_CONTROL_2_ODT2_SWITCH_MODE_SHIFT)
#define  MC_CH0_DRAM_CONTROL_2_ODT2_SWITCH_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_2_ODT2_SWITCH_MODE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_2_ODT2_SWITCH_MODE_SHIFT))

#define  MC_CH0_DRAM_CONTROL_2_ODT1_SWITCH_MODE_MASK 0xc
#define  MC_CH0_DRAM_CONTROL_2_ODT1_SWITCH_MODE_SHIFT 2
#define  MC_CH0_DRAM_CONTROL_2_ODT1_SWITCH_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_2_ODT1_SWITCH_MODE_MASK) >> MC_CH0_DRAM_CONTROL_2_ODT1_SWITCH_MODE_SHIFT)
#define  MC_CH0_DRAM_CONTROL_2_ODT1_SWITCH_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_2_ODT1_SWITCH_MODE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_2_ODT1_SWITCH_MODE_SHIFT))

#define  MC_CH0_DRAM_CONTROL_2_ODT0_SWITCH_MODE_MASK 0x3
#define  MC_CH0_DRAM_CONTROL_2_ODT0_SWITCH_MODE_SHIFT 0
#define  MC_CH0_DRAM_CONTROL_2_ODT0_SWITCH_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_2_ODT0_SWITCH_MODE_MASK) >> MC_CH0_DRAM_CONTROL_2_ODT0_SWITCH_MODE_SHIFT)
#define  MC_CH0_DRAM_CONTROL_2_ODT0_SWITCH_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_2_ODT0_SWITCH_MODE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_2_ODT0_SWITCH_MODE_SHIFT))

//====================================================================
//Register: Channel 0 Multi-Purpose Register Read Data0 Register (CH0_MPR_Data0)
/** \brief This register is only used for DDR4.*/
//====================================================================

#define  MC_CH0_MPR_DATA0_MPR_DATA_VALID_MASK 0x80000000
#define  MC_CH0_MPR_DATA0_MPR_DATA_VALID_SHIFT 31
#define  MC_CH0_MPR_DATA0_MPR_DATA_VALID_MASK_SHIFT(reg) (((reg) & MC_CH0_MPR_DATA0_MPR_DATA_VALID_MASK) >> MC_CH0_MPR_DATA0_MPR_DATA_VALID_SHIFT)
#define  MC_CH0_MPR_DATA0_MPR_DATA_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MPR_DATA0_MPR_DATA_VALID_MASK) | (((uint32_t)val) << MC_CH0_MPR_DATA0_MPR_DATA_VALID_SHIFT))

#define  MC_CH0_MPR_DATA0_RESERVED1_MASK 0x7fffff00
#define  MC_CH0_MPR_DATA0_RESERVED1_SHIFT 8
#define  MC_CH0_MPR_DATA0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MPR_DATA0_RESERVED1_MASK) >> MC_CH0_MPR_DATA0_RESERVED1_SHIFT)
#define  MC_CH0_MPR_DATA0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MPR_DATA0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MPR_DATA0_RESERVED1_SHIFT))

#define  MC_CH0_MPR_DATA0_MPR_DATA_MASK 0xff
#define  MC_CH0_MPR_DATA0_MPR_DATA_SHIFT 0
#define  MC_CH0_MPR_DATA0_MPR_DATA_MASK_SHIFT(reg) (((reg) & MC_CH0_MPR_DATA0_MPR_DATA_MASK) >> MC_CH0_MPR_DATA0_MPR_DATA_SHIFT)
#define  MC_CH0_MPR_DATA0_MPR_DATA_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MPR_DATA0_MPR_DATA_MASK) | (((uint32_t)val) << MC_CH0_MPR_DATA0_MPR_DATA_SHIFT))

//====================================================================
//Register: Channel 0 Multi-Purpose Register Read Data1 Register (CH0_MPR_Data1)
/** \brief This register is only used for DDR4.*/
//====================================================================

#define  MC_CH0_MPR_DATA1_MPR_DATA_VALID_MASK 0x80000000
#define  MC_CH0_MPR_DATA1_MPR_DATA_VALID_SHIFT 31
#define  MC_CH0_MPR_DATA1_MPR_DATA_VALID_MASK_SHIFT(reg) (((reg) & MC_CH0_MPR_DATA1_MPR_DATA_VALID_MASK) >> MC_CH0_MPR_DATA1_MPR_DATA_VALID_SHIFT)
#define  MC_CH0_MPR_DATA1_MPR_DATA_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MPR_DATA1_MPR_DATA_VALID_MASK) | (((uint32_t)val) << MC_CH0_MPR_DATA1_MPR_DATA_VALID_SHIFT))

#define  MC_CH0_MPR_DATA1_RESERVED1_MASK 0x7fffff00
#define  MC_CH0_MPR_DATA1_RESERVED1_SHIFT 8
#define  MC_CH0_MPR_DATA1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MPR_DATA1_RESERVED1_MASK) >> MC_CH0_MPR_DATA1_RESERVED1_SHIFT)
#define  MC_CH0_MPR_DATA1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MPR_DATA1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MPR_DATA1_RESERVED1_SHIFT))

#define  MC_CH0_MPR_DATA1_MPR_DATA_MASK 0xff
#define  MC_CH0_MPR_DATA1_MPR_DATA_SHIFT 0
#define  MC_CH0_MPR_DATA1_MPR_DATA_MASK_SHIFT(reg) (((reg) & MC_CH0_MPR_DATA1_MPR_DATA_MASK) >> MC_CH0_MPR_DATA1_MPR_DATA_SHIFT)
#define  MC_CH0_MPR_DATA1_MPR_DATA_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MPR_DATA1_MPR_DATA_MASK) | (((uint32_t)val) << MC_CH0_MPR_DATA1_MPR_DATA_SHIFT))

//====================================================================
//Register: Channel 0 DDR Initialization Timing Control Register 0 (CH0_DDR_init_timing_control_0)
/** \brief Note: All timing settings in this register are calculated in DRAM clock cycles.*/
//====================================================================

#define  MC_CH0_DDR_INIT_TIMING_CONTROL_0_RESERVED1_MASK 0xfff00000
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_0_RESERVED1_SHIFT 20
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DDR_INIT_TIMING_CONTROL_0_RESERVED1_MASK) >> MC_CH0_DDR_INIT_TIMING_CONTROL_0_RESERVED1_SHIFT)
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DDR_INIT_TIMING_CONTROL_0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DDR_INIT_TIMING_CONTROL_0_RESERVED1_SHIFT))

#define  MC_CH0_DDR_INIT_TIMING_CONTROL_0_INIT_COUNT_NOP_MASK 0xfffff
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_0_INIT_COUNT_NOP_SHIFT 0
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_0_INIT_COUNT_NOP_MASK_SHIFT(reg) (((reg) & MC_CH0_DDR_INIT_TIMING_CONTROL_0_INIT_COUNT_NOP_MASK) >> MC_CH0_DDR_INIT_TIMING_CONTROL_0_INIT_COUNT_NOP_SHIFT)
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_0_INIT_COUNT_NOP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DDR_INIT_TIMING_CONTROL_0_INIT_COUNT_NOP_MASK) | (((uint32_t)val) << MC_CH0_DDR_INIT_TIMING_CONTROL_0_INIT_COUNT_NOP_SHIFT))

//====================================================================
//Register: Channel 0 DDR Initialization Timing Control Register 1 (CH0_DDR_init_timing_control_1)
/** \brief Note: All timing settings in this register are calculated in DRAM clock cycles.*/
//====================================================================

#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESET_COUNT_MASK 0xfffc0000
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESET_COUNT_SHIFT 18
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESET_COUNT_MASK_SHIFT(reg) (((reg) & MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESET_COUNT_MASK) >> MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESET_COUNT_SHIFT)
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESET_COUNT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESET_COUNT_MASK) | (((uint32_t)val) << MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESET_COUNT_SHIFT))

#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_INIT_COUNT_MASK 0x3ffff
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_INIT_COUNT_SHIFT 0
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_INIT_COUNT_MASK_SHIFT(reg) (((reg) & MC_CH0_DDR_INIT_TIMING_CONTROL_1_INIT_COUNT_MASK) >> MC_CH0_DDR_INIT_TIMING_CONTROL_1_INIT_COUNT_SHIFT)
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_INIT_COUNT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DDR_INIT_TIMING_CONTROL_1_INIT_COUNT_MASK) | (((uint32_t)val) << MC_CH0_DDR_INIT_TIMING_CONTROL_1_INIT_COUNT_SHIFT))

//====================================================================
//Register: Channel 0 ZQC Timing Register 0 (CH0_ZQC_Timing_0)
/** \brief Note: All timing settings in this register are calculated in DRAM clock cycles.*/
//====================================================================

#define  MC_CH0_ZQC_TIMING_0_RESERVED1_MASK 0xfffff800
#define  MC_CH0_ZQC_TIMING_0_RESERVED1_SHIFT 11
#define  MC_CH0_ZQC_TIMING_0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_ZQC_TIMING_0_RESERVED1_MASK) >> MC_CH0_ZQC_TIMING_0_RESERVED1_SHIFT)
#define  MC_CH0_ZQC_TIMING_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ZQC_TIMING_0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_ZQC_TIMING_0_RESERVED1_SHIFT))

#define  MC_CH0_ZQC_TIMING_0_TZQINIT_MASK 0x7ff
#define  MC_CH0_ZQC_TIMING_0_TZQINIT_SHIFT 0
#define  MC_CH0_ZQC_TIMING_0_TZQINIT_MASK_SHIFT(reg) (((reg) & MC_CH0_ZQC_TIMING_0_TZQINIT_MASK) >> MC_CH0_ZQC_TIMING_0_TZQINIT_SHIFT)
#define  MC_CH0_ZQC_TIMING_0_TZQINIT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ZQC_TIMING_0_TZQINIT_MASK) | (((uint32_t)val) << MC_CH0_ZQC_TIMING_0_TZQINIT_SHIFT))

//====================================================================
//Register: Channel 0 ZQC Timing Register 1 (CH0_ZQC_Timing_1)
/** \brief Note: All timing settings in this register are calculated in DRAM clock cycles.*/
//====================================================================

#define  MC_CH0_ZQC_TIMING_1_RESERVED1_MASK 0xff000000
#define  MC_CH0_ZQC_TIMING_1_RESERVED1_SHIFT 24
#define  MC_CH0_ZQC_TIMING_1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_ZQC_TIMING_1_RESERVED1_MASK) >> MC_CH0_ZQC_TIMING_1_RESERVED1_SHIFT)
#define  MC_CH0_ZQC_TIMING_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ZQC_TIMING_1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_ZQC_TIMING_1_RESERVED1_SHIFT))

#define  MC_CH0_ZQC_TIMING_1_TZQCS_MASK 0xff0000
#define  MC_CH0_ZQC_TIMING_1_TZQCS_SHIFT 16
#define  MC_CH0_ZQC_TIMING_1_TZQCS_MASK_SHIFT(reg) (((reg) & MC_CH0_ZQC_TIMING_1_TZQCS_MASK) >> MC_CH0_ZQC_TIMING_1_TZQCS_SHIFT)
#define  MC_CH0_ZQC_TIMING_1_TZQCS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ZQC_TIMING_1_TZQCS_MASK) | (((uint32_t)val) << MC_CH0_ZQC_TIMING_1_TZQCS_SHIFT))

#define  MC_CH0_ZQC_TIMING_1_RESERVED2_MASK 0xfc00
#define  MC_CH0_ZQC_TIMING_1_RESERVED2_SHIFT 10
#define  MC_CH0_ZQC_TIMING_1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_ZQC_TIMING_1_RESERVED2_MASK) >> MC_CH0_ZQC_TIMING_1_RESERVED2_SHIFT)
#define  MC_CH0_ZQC_TIMING_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ZQC_TIMING_1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_ZQC_TIMING_1_RESERVED2_SHIFT))

#define  MC_CH0_ZQC_TIMING_1_TZQOPER_MASK 0x3ff
#define  MC_CH0_ZQC_TIMING_1_TZQOPER_SHIFT 0
#define  MC_CH0_ZQC_TIMING_1_TZQOPER_MASK_SHIFT(reg) (((reg) & MC_CH0_ZQC_TIMING_1_TZQOPER_MASK) >> MC_CH0_ZQC_TIMING_1_TZQOPER_SHIFT)
#define  MC_CH0_ZQC_TIMING_1_TZQOPER_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ZQC_TIMING_1_TZQOPER_MASK) | (((uint32_t)val) << MC_CH0_ZQC_TIMING_1_TZQOPER_SHIFT))

//====================================================================
//Register: Channel 0 Refresh Timing Register (CH0_Refresh_timing)
//====================================================================

#define  MC_CH0_REFRESH_TIMING_RESERVED1_MASK 0xf8000000
#define  MC_CH0_REFRESH_TIMING_RESERVED1_SHIFT 27
#define  MC_CH0_REFRESH_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_REFRESH_TIMING_RESERVED1_MASK) >> MC_CH0_REFRESH_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_REFRESH_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_REFRESH_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_REFRESH_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_REFRESH_TIMING_TRFC_MASK 0x7ff0000
#define  MC_CH0_REFRESH_TIMING_TRFC_SHIFT 16
#define  MC_CH0_REFRESH_TIMING_TRFC_MASK_SHIFT(reg) (((reg) & MC_CH0_REFRESH_TIMING_TRFC_MASK) >> MC_CH0_REFRESH_TIMING_TRFC_SHIFT)
#define  MC_CH0_REFRESH_TIMING_TRFC_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_REFRESH_TIMING_TRFC_MASK) | (((uint32_t)val) << MC_CH0_REFRESH_TIMING_TRFC_SHIFT))

#define  MC_CH0_REFRESH_TIMING_RESERVED2_MASK 0xc000
#define  MC_CH0_REFRESH_TIMING_RESERVED2_SHIFT 14
#define  MC_CH0_REFRESH_TIMING_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_REFRESH_TIMING_RESERVED2_MASK) >> MC_CH0_REFRESH_TIMING_RESERVED2_SHIFT)
#define  MC_CH0_REFRESH_TIMING_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_REFRESH_TIMING_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_REFRESH_TIMING_RESERVED2_SHIFT))

#define  MC_CH0_REFRESH_TIMING_TREFI_MASK 0x3fff
#define  MC_CH0_REFRESH_TIMING_TREFI_SHIFT 0
#define  MC_CH0_REFRESH_TIMING_TREFI_MASK_SHIFT(reg) (((reg) & MC_CH0_REFRESH_TIMING_TREFI_MASK) >> MC_CH0_REFRESH_TIMING_TREFI_SHIFT)
#define  MC_CH0_REFRESH_TIMING_TREFI_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_REFRESH_TIMING_TREFI_MASK) | (((uint32_t)val) << MC_CH0_REFRESH_TIMING_TREFI_SHIFT))

//====================================================================
//Register: Channel 0 Self-refresh Timing Register (CH0_SelfRefresh_timing)
/** \brief Note: All timing settings in this register are calculated in DRAM clock cycles.*/
//====================================================================

#define  MC_CH0_SELFREFRESH_TIMING_TCKSRE_MASK 0xf0000000
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRE_SHIFT 28
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRE_MASK_SHIFT(reg) (((reg) & MC_CH0_SELFREFRESH_TIMING_TCKSRE_MASK) >> MC_CH0_SELFREFRESH_TIMING_TCKSRE_SHIFT)
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_SELFREFRESH_TIMING_TCKSRE_MASK) | (((uint32_t)val) << MC_CH0_SELFREFRESH_TIMING_TCKSRE_SHIFT))

#define  MC_CH0_SELFREFRESH_TIMING_TCKSRE_H_MASK 0x8000000
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRE_H_SHIFT 27
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRE_H_MASK_SHIFT(reg) (((reg) & MC_CH0_SELFREFRESH_TIMING_TCKSRE_H_MASK) >> MC_CH0_SELFREFRESH_TIMING_TCKSRE_H_SHIFT)
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRE_H_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_SELFREFRESH_TIMING_TCKSRE_H_MASK) | (((uint32_t)val) << MC_CH0_SELFREFRESH_TIMING_TCKSRE_H_SHIFT))

#define  MC_CH0_SELFREFRESH_TIMING_TXSNR_MASK 0x7ff0000
#define  MC_CH0_SELFREFRESH_TIMING_TXSNR_SHIFT 16
#define  MC_CH0_SELFREFRESH_TIMING_TXSNR_MASK_SHIFT(reg) (((reg) & MC_CH0_SELFREFRESH_TIMING_TXSNR_MASK) >> MC_CH0_SELFREFRESH_TIMING_TXSNR_SHIFT)
#define  MC_CH0_SELFREFRESH_TIMING_TXSNR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_SELFREFRESH_TIMING_TXSNR_MASK) | (((uint32_t)val) << MC_CH0_SELFREFRESH_TIMING_TXSNR_SHIFT))

#define  MC_CH0_SELFREFRESH_TIMING_TCKSRX_MASK 0xf000
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRX_SHIFT 12
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRX_MASK_SHIFT(reg) (((reg) & MC_CH0_SELFREFRESH_TIMING_TCKSRX_MASK) >> MC_CH0_SELFREFRESH_TIMING_TCKSRX_SHIFT)
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRX_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_SELFREFRESH_TIMING_TCKSRX_MASK) | (((uint32_t)val) << MC_CH0_SELFREFRESH_TIMING_TCKSRX_SHIFT))

#define  MC_CH0_SELFREFRESH_TIMING_TCKSRX_H_MASK 0x800
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRX_H_SHIFT 11
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRX_H_MASK_SHIFT(reg) (((reg) & MC_CH0_SELFREFRESH_TIMING_TCKSRX_H_MASK) >> MC_CH0_SELFREFRESH_TIMING_TCKSRX_H_SHIFT)
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRX_H_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_SELFREFRESH_TIMING_TCKSRX_H_MASK) | (((uint32_t)val) << MC_CH0_SELFREFRESH_TIMING_TCKSRX_H_SHIFT))

#define  MC_CH0_SELFREFRESH_TIMING_RESERVED1_MASK 0x400
#define  MC_CH0_SELFREFRESH_TIMING_RESERVED1_SHIFT 10
#define  MC_CH0_SELFREFRESH_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_SELFREFRESH_TIMING_RESERVED1_MASK) >> MC_CH0_SELFREFRESH_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_SELFREFRESH_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_SELFREFRESH_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_SELFREFRESH_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_SELFREFRESH_TIMING_TXSRD_MASK 0x3ff
#define  MC_CH0_SELFREFRESH_TIMING_TXSRD_SHIFT 0
#define  MC_CH0_SELFREFRESH_TIMING_TXSRD_MASK_SHIFT(reg) (((reg) & MC_CH0_SELFREFRESH_TIMING_TXSRD_MASK) >> MC_CH0_SELFREFRESH_TIMING_TXSRD_SHIFT)
#define  MC_CH0_SELFREFRESH_TIMING_TXSRD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_SELFREFRESH_TIMING_TXSRD_MASK) | (((uint32_t)val) << MC_CH0_SELFREFRESH_TIMING_TXSRD_SHIFT))

//====================================================================
//Register: Channel 0 Power-down Timing Register (CH0_PowerDown_timing)
/** \brief Note: All timing settings in this register are calculated in DRAM clock cycles.*/
//====================================================================

#define  MC_CH0_POWERDOWN_TIMING_RESERVED1_MASK 0x80000000
#define  MC_CH0_POWERDOWN_TIMING_RESERVED1_SHIFT 31
#define  MC_CH0_POWERDOWN_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_RESERVED1_MASK) >> MC_CH0_POWERDOWN_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_TPDEN_MASK 0x70000000
#define  MC_CH0_POWERDOWN_TIMING_TPDEN_SHIFT 28
#define  MC_CH0_POWERDOWN_TIMING_TPDEN_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_TPDEN_MASK) >> MC_CH0_POWERDOWN_TIMING_TPDEN_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_TPDEN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_TPDEN_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_TPDEN_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_RESERVED2_MASK 0x8000000
#define  MC_CH0_POWERDOWN_TIMING_RESERVED2_SHIFT 27
#define  MC_CH0_POWERDOWN_TIMING_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_RESERVED2_MASK) >> MC_CH0_POWERDOWN_TIMING_RESERVED2_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_RESERVED2_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_TCPDED_MASK 0x7000000
#define  MC_CH0_POWERDOWN_TIMING_TCPDED_SHIFT 24
#define  MC_CH0_POWERDOWN_TIMING_TCPDED_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_TCPDED_MASK) >> MC_CH0_POWERDOWN_TIMING_TCPDED_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_TCPDED_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_TCPDED_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_TCPDED_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_RESERVED3_MASK 0xe00000
#define  MC_CH0_POWERDOWN_TIMING_RESERVED3_SHIFT 21
#define  MC_CH0_POWERDOWN_TIMING_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_RESERVED3_MASK) >> MC_CH0_POWERDOWN_TIMING_RESERVED3_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_RESERVED3_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_TCKESR_MASK 0x1f0000
#define  MC_CH0_POWERDOWN_TIMING_TCKESR_SHIFT 16
#define  MC_CH0_POWERDOWN_TIMING_TCKESR_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_TCKESR_MASK) >> MC_CH0_POWERDOWN_TIMING_TCKESR_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_TCKESR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_TCKESR_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_TCKESR_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_RESERVED4_MASK 0xf000
#define  MC_CH0_POWERDOWN_TIMING_RESERVED4_SHIFT 12
#define  MC_CH0_POWERDOWN_TIMING_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_RESERVED4_MASK) >> MC_CH0_POWERDOWN_TIMING_RESERVED4_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_RESERVED4_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_TXP_MASK 0xf00
#define  MC_CH0_POWERDOWN_TIMING_TXP_SHIFT 8
#define  MC_CH0_POWERDOWN_TIMING_TXP_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_TXP_MASK) >> MC_CH0_POWERDOWN_TIMING_TXP_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_TXP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_TXP_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_TXP_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_RESERVED5_MASK 0xe0
#define  MC_CH0_POWERDOWN_TIMING_RESERVED5_SHIFT 5
#define  MC_CH0_POWERDOWN_TIMING_RESERVED5_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_RESERVED5_MASK) >> MC_CH0_POWERDOWN_TIMING_RESERVED5_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_RESERVED5_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_RESERVED5_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_TXARDS_MASK 0x1f
#define  MC_CH0_POWERDOWN_TIMING_TXARDS_SHIFT 0
#define  MC_CH0_POWERDOWN_TIMING_TXARDS_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_TXARDS_MASK) >> MC_CH0_POWERDOWN_TIMING_TXARDS_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_TXARDS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_TXARDS_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_TXARDS_SHIFT))

//====================================================================
//Register: Channel 0 MRS Timing Register (CH0_MRS_timing)
/** \brief Note: All timing settings in this register are calculated in DRAM clock cycles.*/
//====================================================================

#define  MC_CH0_MRS_TIMING_RESERVED1_MASK 0xfffffe00
#define  MC_CH0_MRS_TIMING_RESERVED1_SHIFT 9
#define  MC_CH0_MRS_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MRS_TIMING_RESERVED1_MASK) >> MC_CH0_MRS_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_MRS_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MRS_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MRS_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_MRS_TIMING_TMOD_MASK 0x1f0
#define  MC_CH0_MRS_TIMING_TMOD_SHIFT 4
#define  MC_CH0_MRS_TIMING_TMOD_MASK_SHIFT(reg) (((reg) & MC_CH0_MRS_TIMING_TMOD_MASK) >> MC_CH0_MRS_TIMING_TMOD_SHIFT)
#define  MC_CH0_MRS_TIMING_TMOD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MRS_TIMING_TMOD_MASK) | (((uint32_t)val) << MC_CH0_MRS_TIMING_TMOD_SHIFT))

#define  MC_CH0_MRS_TIMING_TMRD_MASK 0xf
#define  MC_CH0_MRS_TIMING_TMRD_SHIFT 0
#define  MC_CH0_MRS_TIMING_TMRD_MASK_SHIFT(reg) (((reg) & MC_CH0_MRS_TIMING_TMRD_MASK) >> MC_CH0_MRS_TIMING_TMRD_SHIFT)
#define  MC_CH0_MRS_TIMING_TMRD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MRS_TIMING_TMRD_MASK) | (((uint32_t)val) << MC_CH0_MRS_TIMING_TMRD_SHIFT))

//====================================================================
//Register: Channel 0 Activate Timing Register (CH0_ACT_timing)
/** \brief Note: All timing settings in this register are calculated in DRAM clock cycles.*/
//====================================================================

#define  MC_CH0_ACT_TIMING_RESERVED1_MASK 0xc0000000
#define  MC_CH0_ACT_TIMING_RESERVED1_SHIFT 30
#define  MC_CH0_ACT_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_ACT_TIMING_RESERVED1_MASK) >> MC_CH0_ACT_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_ACT_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ACT_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_ACT_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_ACT_TIMING_TFAW_MASK 0x3f000000
#define  MC_CH0_ACT_TIMING_TFAW_SHIFT 24
#define  MC_CH0_ACT_TIMING_TFAW_MASK_SHIFT(reg) (((reg) & MC_CH0_ACT_TIMING_TFAW_MASK) >> MC_CH0_ACT_TIMING_TFAW_SHIFT)
#define  MC_CH0_ACT_TIMING_TFAW_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ACT_TIMING_TFAW_MASK) | (((uint32_t)val) << MC_CH0_ACT_TIMING_TFAW_SHIFT))

#define  MC_CH0_ACT_TIMING_RESERVED2_MASK 0x800000
#define  MC_CH0_ACT_TIMING_RESERVED2_SHIFT 23
#define  MC_CH0_ACT_TIMING_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_ACT_TIMING_RESERVED2_MASK) >> MC_CH0_ACT_TIMING_RESERVED2_SHIFT)
#define  MC_CH0_ACT_TIMING_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ACT_TIMING_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_ACT_TIMING_RESERVED2_SHIFT))

#define  MC_CH0_ACT_TIMING_TRC_MASK 0x7f0000
#define  MC_CH0_ACT_TIMING_TRC_SHIFT 16
#define  MC_CH0_ACT_TIMING_TRC_MASK_SHIFT(reg) (((reg) & MC_CH0_ACT_TIMING_TRC_MASK) >> MC_CH0_ACT_TIMING_TRC_SHIFT)
#define  MC_CH0_ACT_TIMING_TRC_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ACT_TIMING_TRC_MASK) | (((uint32_t)val) << MC_CH0_ACT_TIMING_TRC_SHIFT))

#define  MC_CH0_ACT_TIMING_RESERVED3_MASK 0xe000
#define  MC_CH0_ACT_TIMING_RESERVED3_SHIFT 13
#define  MC_CH0_ACT_TIMING_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_ACT_TIMING_RESERVED3_MASK) >> MC_CH0_ACT_TIMING_RESERVED3_SHIFT)
#define  MC_CH0_ACT_TIMING_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ACT_TIMING_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_ACT_TIMING_RESERVED3_SHIFT))

#define  MC_CH0_ACT_TIMING_TRCD_MASK 0x1f00
#define  MC_CH0_ACT_TIMING_TRCD_SHIFT 8
#define  MC_CH0_ACT_TIMING_TRCD_MASK_SHIFT(reg) (((reg) & MC_CH0_ACT_TIMING_TRCD_MASK) >> MC_CH0_ACT_TIMING_TRCD_SHIFT)
#define  MC_CH0_ACT_TIMING_TRCD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ACT_TIMING_TRCD_MASK) | (((uint32_t)val) << MC_CH0_ACT_TIMING_TRCD_SHIFT))

#define  MC_CH0_ACT_TIMING_RESERVED4_MASK 0xc0
#define  MC_CH0_ACT_TIMING_RESERVED4_SHIFT 6
#define  MC_CH0_ACT_TIMING_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_ACT_TIMING_RESERVED4_MASK) >> MC_CH0_ACT_TIMING_RESERVED4_SHIFT)
#define  MC_CH0_ACT_TIMING_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ACT_TIMING_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_ACT_TIMING_RESERVED4_SHIFT))

#define  MC_CH0_ACT_TIMING_TRAS_MASK 0x3f
#define  MC_CH0_ACT_TIMING_TRAS_SHIFT 0
#define  MC_CH0_ACT_TIMING_TRAS_MASK_SHIFT(reg) (((reg) & MC_CH0_ACT_TIMING_TRAS_MASK) >> MC_CH0_ACT_TIMING_TRAS_SHIFT)
#define  MC_CH0_ACT_TIMING_TRAS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ACT_TIMING_TRAS_MASK) | (((uint32_t)val) << MC_CH0_ACT_TIMING_TRAS_SHIFT))

//====================================================================
//Register: Channel 0 Precharge Timing Register (CH0_PreCharge_Timing)
/** \brief Note: All timing settings in this register are calculated in DRAM clock cycles.*/
//====================================================================

#define  MC_CH0_PRECHARGE_TIMING_RESERVED1_MASK 0xfe000000
#define  MC_CH0_PRECHARGE_TIMING_RESERVED1_SHIFT 25
#define  MC_CH0_PRECHARGE_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PRECHARGE_TIMING_RESERVED1_MASK) >> MC_CH0_PRECHARGE_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_PRECHARGE_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PRECHARGE_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PRECHARGE_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_PRECHARGE_TIMING_TRPA_MASK 0x1f00000
#define  MC_CH0_PRECHARGE_TIMING_TRPA_SHIFT 20
#define  MC_CH0_PRECHARGE_TIMING_TRPA_MASK_SHIFT(reg) (((reg) & MC_CH0_PRECHARGE_TIMING_TRPA_MASK) >> MC_CH0_PRECHARGE_TIMING_TRPA_SHIFT)
#define  MC_CH0_PRECHARGE_TIMING_TRPA_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PRECHARGE_TIMING_TRPA_MASK) | (((uint32_t)val) << MC_CH0_PRECHARGE_TIMING_TRPA_SHIFT))

#define  MC_CH0_PRECHARGE_TIMING_RESERVED2_MASK 0xe0000
#define  MC_CH0_PRECHARGE_TIMING_RESERVED2_SHIFT 17
#define  MC_CH0_PRECHARGE_TIMING_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PRECHARGE_TIMING_RESERVED2_MASK) >> MC_CH0_PRECHARGE_TIMING_RESERVED2_SHIFT)
#define  MC_CH0_PRECHARGE_TIMING_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PRECHARGE_TIMING_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PRECHARGE_TIMING_RESERVED2_SHIFT))

#define  MC_CH0_PRECHARGE_TIMING_TWR_MASK 0x1f000
#define  MC_CH0_PRECHARGE_TIMING_TWR_SHIFT 12
#define  MC_CH0_PRECHARGE_TIMING_TWR_MASK_SHIFT(reg) (((reg) & MC_CH0_PRECHARGE_TIMING_TWR_MASK) >> MC_CH0_PRECHARGE_TIMING_TWR_SHIFT)
#define  MC_CH0_PRECHARGE_TIMING_TWR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PRECHARGE_TIMING_TWR_MASK) | (((uint32_t)val) << MC_CH0_PRECHARGE_TIMING_TWR_SHIFT))

#define  MC_CH0_PRECHARGE_TIMING_TRTP_MASK 0xf00
#define  MC_CH0_PRECHARGE_TIMING_TRTP_SHIFT 8
#define  MC_CH0_PRECHARGE_TIMING_TRTP_MASK_SHIFT(reg) (((reg) & MC_CH0_PRECHARGE_TIMING_TRTP_MASK) >> MC_CH0_PRECHARGE_TIMING_TRTP_SHIFT)
#define  MC_CH0_PRECHARGE_TIMING_TRTP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PRECHARGE_TIMING_TRTP_MASK) | (((uint32_t)val) << MC_CH0_PRECHARGE_TIMING_TRTP_SHIFT))

#define  MC_CH0_PRECHARGE_TIMING_RESERVED3_MASK 0xe0
#define  MC_CH0_PRECHARGE_TIMING_RESERVED3_SHIFT 5
#define  MC_CH0_PRECHARGE_TIMING_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PRECHARGE_TIMING_RESERVED3_MASK) >> MC_CH0_PRECHARGE_TIMING_RESERVED3_SHIFT)
#define  MC_CH0_PRECHARGE_TIMING_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PRECHARGE_TIMING_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PRECHARGE_TIMING_RESERVED3_SHIFT))

#define  MC_CH0_PRECHARGE_TIMING_TRP_MASK 0x1f
#define  MC_CH0_PRECHARGE_TIMING_TRP_SHIFT 0
#define  MC_CH0_PRECHARGE_TIMING_TRP_MASK_SHIFT(reg) (((reg) & MC_CH0_PRECHARGE_TIMING_TRP_MASK) >> MC_CH0_PRECHARGE_TIMING_TRP_SHIFT)
#define  MC_CH0_PRECHARGE_TIMING_TRP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PRECHARGE_TIMING_TRP_MASK) | (((uint32_t)val) << MC_CH0_PRECHARGE_TIMING_TRP_SHIFT))

//====================================================================
//Register: Channel 0 CAS/RAS Timing Register (CH0_CAS_RAS_timing)
/** \brief Note: All timing settings in this register are calculated in DRAM clock cycles.*/
//====================================================================

#define  MC_CH0_CAS_RAS_TIMING_TRRD_MASK 0xf0000000
#define  MC_CH0_CAS_RAS_TIMING_TRRD_SHIFT 28
#define  MC_CH0_CAS_RAS_TIMING_TRRD_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_TRRD_MASK) >> MC_CH0_CAS_RAS_TIMING_TRRD_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_TRRD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_TRRD_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_TRRD_SHIFT))

#define  MC_CH0_CAS_RAS_TIMING_TRRD_S_MASK 0xf000000
#define  MC_CH0_CAS_RAS_TIMING_TRRD_S_SHIFT 24
#define  MC_CH0_CAS_RAS_TIMING_TRRD_S_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_TRRD_S_MASK) >> MC_CH0_CAS_RAS_TIMING_TRRD_S_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_TRRD_S_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_TRRD_S_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_TRRD_S_SHIFT))

#define  MC_CH0_CAS_RAS_TIMING_RESERVED1_MASK 0x800000
#define  MC_CH0_CAS_RAS_TIMING_RESERVED1_SHIFT 23
#define  MC_CH0_CAS_RAS_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_RESERVED1_MASK) >> MC_CH0_CAS_RAS_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_CAS_RAS_TIMING_TCCD_MASK 0x700000
#define  MC_CH0_CAS_RAS_TIMING_TCCD_SHIFT 20
#define  MC_CH0_CAS_RAS_TIMING_TCCD_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_TCCD_MASK) >> MC_CH0_CAS_RAS_TIMING_TCCD_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_TCCD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_TCCD_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_TCCD_SHIFT))

#define  MC_CH0_CAS_RAS_TIMING_RESERVED2_MASK 0x80000
#define  MC_CH0_CAS_RAS_TIMING_RESERVED2_SHIFT 19
#define  MC_CH0_CAS_RAS_TIMING_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_RESERVED2_MASK) >> MC_CH0_CAS_RAS_TIMING_RESERVED2_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_RESERVED2_SHIFT))

#define  MC_CH0_CAS_RAS_TIMING_TCCD_S_MASK 0x70000
#define  MC_CH0_CAS_RAS_TIMING_TCCD_S_SHIFT 16
#define  MC_CH0_CAS_RAS_TIMING_TCCD_S_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_TCCD_S_MASK) >> MC_CH0_CAS_RAS_TIMING_TCCD_S_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_TCCD_S_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_TCCD_S_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_TCCD_S_SHIFT))

#define  MC_CH0_CAS_RAS_TIMING_RESERVED3_MASK 0xff00
#define  MC_CH0_CAS_RAS_TIMING_RESERVED3_SHIFT 8
#define  MC_CH0_CAS_RAS_TIMING_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_RESERVED3_MASK) >> MC_CH0_CAS_RAS_TIMING_RESERVED3_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_RESERVED3_SHIFT))

#define  MC_CH0_CAS_RAS_TIMING_TWTR_MASK 0xf0
#define  MC_CH0_CAS_RAS_TIMING_TWTR_SHIFT 4
#define  MC_CH0_CAS_RAS_TIMING_TWTR_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_TWTR_MASK) >> MC_CH0_CAS_RAS_TIMING_TWTR_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_TWTR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_TWTR_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_TWTR_SHIFT))

#define  MC_CH0_CAS_RAS_TIMING_TWTR_S_MASK 0xf
#define  MC_CH0_CAS_RAS_TIMING_TWTR_S_SHIFT 0
#define  MC_CH0_CAS_RAS_TIMING_TWTR_S_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_TWTR_S_MASK) >> MC_CH0_CAS_RAS_TIMING_TWTR_S_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_TWTR_S_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_TWTR_S_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_TWTR_S_SHIFT))

//====================================================================
//Register: Channel 0 Off-spec timing Register (CH0_Off_spec_timing)
//====================================================================

#define  MC_CH0_OFF_SPEC_TIMING_RESERVED1_MASK 0xfff00000
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED1_SHIFT 20
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_RESERVED1_MASK) >> MC_CH0_OFF_SPEC_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_OFF_SPEC_TIMING_READ_GAP_EXTEND_MASK 0xf0000
#define  MC_CH0_OFF_SPEC_TIMING_READ_GAP_EXTEND_SHIFT 16
#define  MC_CH0_OFF_SPEC_TIMING_READ_GAP_EXTEND_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_READ_GAP_EXTEND_MASK) >> MC_CH0_OFF_SPEC_TIMING_READ_GAP_EXTEND_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_READ_GAP_EXTEND_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_READ_GAP_EXTEND_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_READ_GAP_EXTEND_SHIFT))

#define  MC_CH0_OFF_SPEC_TIMING_RESERVED2_MASK 0xc000
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED2_SHIFT 14
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_RESERVED2_MASK) >> MC_CH0_OFF_SPEC_TIMING_RESERVED2_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_RESERVED2_SHIFT))

#define  MC_CH0_OFF_SPEC_TIMING_TWL_EARLY_MASK 0x3000
#define  MC_CH0_OFF_SPEC_TIMING_TWL_EARLY_SHIFT 12
#define  MC_CH0_OFF_SPEC_TIMING_TWL_EARLY_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_TWL_EARLY_MASK) >> MC_CH0_OFF_SPEC_TIMING_TWL_EARLY_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_TWL_EARLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_TWL_EARLY_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_TWL_EARLY_SHIFT))

#define  MC_CH0_OFF_SPEC_TIMING_RESERVED3_MASK 0x800
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED3_SHIFT 11
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_RESERVED3_MASK) >> MC_CH0_OFF_SPEC_TIMING_RESERVED3_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_RESERVED3_SHIFT))

#define  MC_CH0_OFF_SPEC_TIMING_TRWD_EXT_DLY_MASK 0x700
#define  MC_CH0_OFF_SPEC_TIMING_TRWD_EXT_DLY_SHIFT 8
#define  MC_CH0_OFF_SPEC_TIMING_TRWD_EXT_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_TRWD_EXT_DLY_MASK) >> MC_CH0_OFF_SPEC_TIMING_TRWD_EXT_DLY_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_TRWD_EXT_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_TRWD_EXT_DLY_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_TRWD_EXT_DLY_SHIFT))

#define  MC_CH0_OFF_SPEC_TIMING_RESERVED4_MASK 0x80
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED4_SHIFT 7
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_RESERVED4_MASK) >> MC_CH0_OFF_SPEC_TIMING_RESERVED4_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_RESERVED4_SHIFT))

#define  MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_WR_EXT_DLY_MASK 0x70
#define  MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_WR_EXT_DLY_SHIFT 4
#define  MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_WR_EXT_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_WR_EXT_DLY_MASK) >> MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_WR_EXT_DLY_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_WR_EXT_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_WR_EXT_DLY_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_WR_EXT_DLY_SHIFT))

#define  MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_EXT_DLY_MASK 0xf
#define  MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_EXT_DLY_SHIFT 0
#define  MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_EXT_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_EXT_DLY_MASK) >> MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_EXT_DLY_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_EXT_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_EXT_DLY_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_EXT_DLY_SHIFT))

//====================================================================
//Register: Channel 0 dram CRC and Parity timing Register (CH0_crc_par_timing)
//====================================================================

#define  MC_CH0_CRC_PAR_TIMING_RESERVED1_MASK 0xffe00000
#define  MC_CH0_CRC_PAR_TIMING_RESERVED1_SHIFT 21
#define  MC_CH0_CRC_PAR_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_CRC_PAR_TIMING_RESERVED1_MASK) >> MC_CH0_CRC_PAR_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_CRC_PAR_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CRC_PAR_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_CRC_PAR_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_CRC_PAR_TIMING_TCRC_ALERT_MASK 0x1f0000
#define  MC_CH0_CRC_PAR_TIMING_TCRC_ALERT_SHIFT 16
#define  MC_CH0_CRC_PAR_TIMING_TCRC_ALERT_MASK_SHIFT(reg) (((reg) & MC_CH0_CRC_PAR_TIMING_TCRC_ALERT_MASK) >> MC_CH0_CRC_PAR_TIMING_TCRC_ALERT_SHIFT)
#define  MC_CH0_CRC_PAR_TIMING_TCRC_ALERT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CRC_PAR_TIMING_TCRC_ALERT_MASK) | (((uint32_t)val) << MC_CH0_CRC_PAR_TIMING_TCRC_ALERT_SHIFT))

#define  MC_CH0_CRC_PAR_TIMING_TPAR_ALERT_PW_MASK 0xfe00
#define  MC_CH0_CRC_PAR_TIMING_TPAR_ALERT_PW_SHIFT 9
#define  MC_CH0_CRC_PAR_TIMING_TPAR_ALERT_PW_MASK_SHIFT(reg) (((reg) & MC_CH0_CRC_PAR_TIMING_TPAR_ALERT_PW_MASK) >> MC_CH0_CRC_PAR_TIMING_TPAR_ALERT_PW_SHIFT)
#define  MC_CH0_CRC_PAR_TIMING_TPAR_ALERT_PW_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CRC_PAR_TIMING_TPAR_ALERT_PW_MASK) | (((uint32_t)val) << MC_CH0_CRC_PAR_TIMING_TPAR_ALERT_PW_SHIFT))

#define  MC_CH0_CRC_PAR_TIMING_TPAR_ALERT_ON_MASK 0x1f0
#define  MC_CH0_CRC_PAR_TIMING_TPAR_ALERT_ON_SHIFT 4
#define  MC_CH0_CRC_PAR_TIMING_TPAR_ALERT_ON_MASK_SHIFT(reg) (((reg) & MC_CH0_CRC_PAR_TIMING_TPAR_ALERT_ON_MASK) >> MC_CH0_CRC_PAR_TIMING_TPAR_ALERT_ON_SHIFT)
#define  MC_CH0_CRC_PAR_TIMING_TPAR_ALERT_ON_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CRC_PAR_TIMING_TPAR_ALERT_ON_MASK) | (((uint32_t)val) << MC_CH0_CRC_PAR_TIMING_TPAR_ALERT_ON_SHIFT))

#define  MC_CH0_CRC_PAR_TIMING_TPAR_UNKNOWN_MASK 0xf
#define  MC_CH0_CRC_PAR_TIMING_TPAR_UNKNOWN_SHIFT 0
#define  MC_CH0_CRC_PAR_TIMING_TPAR_UNKNOWN_MASK_SHIFT(reg) (((reg) & MC_CH0_CRC_PAR_TIMING_TPAR_UNKNOWN_MASK) >> MC_CH0_CRC_PAR_TIMING_TPAR_UNKNOWN_SHIFT)
#define  MC_CH0_CRC_PAR_TIMING_TPAR_UNKNOWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CRC_PAR_TIMING_TPAR_UNKNOWN_MASK) | (((uint32_t)val) << MC_CH0_CRC_PAR_TIMING_TPAR_UNKNOWN_SHIFT))

//====================================================================
//Register: Channel 0 dram maximum power-down timing Register (CH0_dram_mpd_timing)
//====================================================================

#define  MC_CH0_DRAM_MPD_TIMING_RESERVED1_MASK 0xfffe0000
#define  MC_CH0_DRAM_MPD_TIMING_RESERVED1_SHIFT 17
#define  MC_CH0_DRAM_MPD_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_MPD_TIMING_RESERVED1_MASK) >> MC_CH0_DRAM_MPD_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_DRAM_MPD_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_MPD_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DRAM_MPD_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_DRAM_MPD_TIMING_TMPX_S_MASK 0x1c000
#define  MC_CH0_DRAM_MPD_TIMING_TMPX_S_SHIFT 14
#define  MC_CH0_DRAM_MPD_TIMING_TMPX_S_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_MPD_TIMING_TMPX_S_MASK) >> MC_CH0_DRAM_MPD_TIMING_TMPX_S_SHIFT)
#define  MC_CH0_DRAM_MPD_TIMING_TMPX_S_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_MPD_TIMING_TMPX_S_MASK) | (((uint32_t)val) << MC_CH0_DRAM_MPD_TIMING_TMPX_S_SHIFT))

#define  MC_CH0_DRAM_MPD_TIMING_TMPX_LH_MASK 0x3c00
#define  MC_CH0_DRAM_MPD_TIMING_TMPX_LH_SHIFT 10
#define  MC_CH0_DRAM_MPD_TIMING_TMPX_LH_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_MPD_TIMING_TMPX_LH_MASK) >> MC_CH0_DRAM_MPD_TIMING_TMPX_LH_SHIFT)
#define  MC_CH0_DRAM_MPD_TIMING_TMPX_LH_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_MPD_TIMING_TMPX_LH_MASK) | (((uint32_t)val) << MC_CH0_DRAM_MPD_TIMING_TMPX_LH_SHIFT))

#define  MC_CH0_DRAM_MPD_TIMING_TXMP_MASK 0x3ff
#define  MC_CH0_DRAM_MPD_TIMING_TXMP_SHIFT 0
#define  MC_CH0_DRAM_MPD_TIMING_TXMP_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_MPD_TIMING_TXMP_MASK) >> MC_CH0_DRAM_MPD_TIMING_TXMP_SHIFT)
#define  MC_CH0_DRAM_MPD_TIMING_TXMP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_MPD_TIMING_TXMP_MASK) | (((uint32_t)val) << MC_CH0_DRAM_MPD_TIMING_TXMP_SHIFT))

//====================================================================
//Register: Channel 0 PHY Control Register 1 (CH0_PHY_Control_1)
/** \brief This register is used to configure parameters related to the DQS.*/
//====================================================================

#define  MC_CH0_PHY_CONTROL_1_RESERVED1_MASK 0xfff80000
#define  MC_CH0_PHY_CONTROL_1_RESERVED1_SHIFT 19
#define  MC_CH0_PHY_CONTROL_1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EXPAND_MASK 0x60000
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EXPAND_SHIFT 17
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EXPAND_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EXPAND_MASK) >> MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EXPAND_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EXPAND_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EXPAND_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EXPAND_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_RESERVED2_MASK 0x10000
#define  MC_CH0_PHY_CONTROL_1_RESERVED2_SHIFT 16
#define  MC_CH0_PHY_CONTROL_1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_1_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EARLY_MASK 0x8000
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EARLY_SHIFT 15
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EARLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EARLY_MASK) >> MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EARLY_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EARLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EARLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EARLY_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EN_MASK 0x4000
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EN_SHIFT 14
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EN_MASK) >> MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EN_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_RESERVED3_MASK 0x2000
#define  MC_CH0_PHY_CONTROL_1_RESERVED3_SHIFT 13
#define  MC_CH0_PHY_CONTROL_1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_RESERVED3_MASK) >> MC_CH0_PHY_CONTROL_1_RESERVED3_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_RESERVED3_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_DQ_EN_EXTEND_MASK 0x1000
#define  MC_CH0_PHY_CONTROL_1_DQ_EN_EXTEND_SHIFT 12
#define  MC_CH0_PHY_CONTROL_1_DQ_EN_EXTEND_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_DQ_EN_EXTEND_MASK) >> MC_CH0_PHY_CONTROL_1_DQ_EN_EXTEND_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_DQ_EN_EXTEND_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_DQ_EN_EXTEND_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_DQ_EN_EXTEND_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_RESERVED4_MASK 0x800
#define  MC_CH0_PHY_CONTROL_1_RESERVED4_SHIFT 11
#define  MC_CH0_PHY_CONTROL_1_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_RESERVED4_MASK) >> MC_CH0_PHY_CONTROL_1_RESERVED4_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_RESERVED4_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_RD_EXT_DLY_MASK 0x700
#define  MC_CH0_PHY_CONTROL_1_RD_EXT_DLY_SHIFT 8
#define  MC_CH0_PHY_CONTROL_1_RD_EXT_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_RD_EXT_DLY_MASK) >> MC_CH0_PHY_CONTROL_1_RD_EXT_DLY_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_RD_EXT_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_RD_EXT_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_RD_EXT_DLY_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RPTR_DLY_VAL_MASK 0xf0
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RPTR_DLY_VAL_SHIFT 4
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RPTR_DLY_VAL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RPTR_DLY_VAL_MASK) >> MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RPTR_DLY_VAL_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RPTR_DLY_VAL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RPTR_DLY_VAL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RPTR_DLY_VAL_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_DQ_EXT_DLY_MASK 0xf
#define  MC_CH0_PHY_CONTROL_1_DQ_EXT_DLY_SHIFT 0
#define  MC_CH0_PHY_CONTROL_1_DQ_EXT_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_DQ_EXT_DLY_MASK) >> MC_CH0_PHY_CONTROL_1_DQ_EXT_DLY_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_DQ_EXT_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_DQ_EXT_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_DQ_EXT_DLY_SHIFT))

//====================================================================
//Register: Channel 0 PHY Control Register 2 (CH0_PHY_Control_2)
//====================================================================

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_MASK 0x80000000
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_SHIFT 31
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_MASK 0x40000000
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_SHIFT 30
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_QS_VREF_SEL_MASK 0x30000000
#define  MC_CH0_PHY_CONTROL_2_PHY_QS_VREF_SEL_SHIFT 28
#define  MC_CH0_PHY_CONTROL_2_PHY_QS_VREF_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_QS_VREF_SEL_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_QS_VREF_SEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_QS_VREF_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_QS_VREF_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_QS_VREF_SEL_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPDRV_MASK 0xf000000
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPDRV_SHIFT 24
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPDRV_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPDRV_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPDRV_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPDRV_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPDRV_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPDRV_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNDRV_MASK 0xf00000
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNDRV_SHIFT 20
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNDRV_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNDRV_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNDRV_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNDRV_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNDRV_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNDRV_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPTRM_MASK 0xf0000
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPTRM_SHIFT 16
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPTRM_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPTRM_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPTRM_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPTRM_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPTRM_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNTRM_MASK 0xf000
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNTRM_SHIFT 12
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNTRM_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNTRM_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNTRM_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNTRM_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNTRM_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MASK 0xf00
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_SHIFT 8
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MASK 0xf0
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_SHIFT 4
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_VREF_SEL_MASK 0xc
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_VREF_SEL_SHIFT 2
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_VREF_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_VREF_SEL_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_VREF_SEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_VREF_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_VREF_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_VREF_SEL_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZD_MASK 0x2
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZD_SHIFT 1
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZD_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZD_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZD_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_MODE_MASK 0x1
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_MODE_SHIFT 0
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_MODE_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_MODE_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_MODE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_MODE_SHIFT))

//====================================================================
//Register: Channel 0 PHY Control Register 3 (CH0_PHY_Control_3)
/** \brief Note: ADCM (Address/Command) does not use the receiver.*/
//====================================================================

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_MASK 0x80000000
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_SHIFT 31
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_MASK 0x40000000
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_SHIFT 30
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_RCVTYPE_MASK 0x30000000
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_RCVTYPE_SHIFT 28
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_RCVTYPE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_RCVTYPE_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_RCVTYPE_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_RCVTYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_RCVTYPE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_RCVTYPE_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPDRV_MASK 0xf000000
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPDRV_SHIFT 24
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPDRV_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPDRV_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPDRV_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPDRV_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPDRV_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPDRV_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNDRV_MASK 0xf00000
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNDRV_SHIFT 20
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNDRV_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNDRV_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNDRV_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNDRV_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNDRV_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNDRV_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPTRM_MASK 0xf0000
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPTRM_SHIFT 16
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPTRM_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPTRM_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPTRM_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPTRM_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPTRM_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNTRM_MASK 0xf000
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNTRM_SHIFT 12
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNTRM_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNTRM_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNTRM_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNTRM_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNTRM_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MASK 0xf00
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_SHIFT 8
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MASK 0xf0
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_SHIFT 4
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_VREF_SEL_MASK 0xc
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_VREF_SEL_SHIFT 2
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_VREF_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_VREF_SEL_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_VREF_SEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_VREF_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_VREF_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_VREF_SEL_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZD_MASK 0x2
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZD_SHIFT 1
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZD_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZD_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZD_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_MODE_MASK 0x1
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_MODE_SHIFT 0
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_MODE_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_MODE_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_MODE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_MODE_SHIFT))

//====================================================================
//Register: Channel 0 PHY Control Register 4 (CH0_PHY_Control_4)
//====================================================================

#define  MC_CH0_PHY_CONTROL_4_PHY_QS_RCVTYPE_MASK 0xc0000000
#define  MC_CH0_PHY_CONTROL_4_PHY_QS_RCVTYPE_SHIFT 30
#define  MC_CH0_PHY_CONTROL_4_PHY_QS_RCVTYPE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_QS_RCVTYPE_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_QS_RCVTYPE_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_QS_RCVTYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_QS_RCVTYPE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_QS_RCVTYPE_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEP_MASK 0x38000000
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEP_SHIFT 27
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEP_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEP_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEP_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEP_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEP_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEN_MASK 0x7000000
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEN_SHIFT 24
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEN_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEN_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEN_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVTYPE_MASK 0xc00000
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVTYPE_SHIFT 22
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVTYPE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVTYPE_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVTYPE_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVTYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVTYPE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVTYPE_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZD_MASK 0x200000
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZD_SHIFT 21
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_CK_ZD_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_CK_ZD_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_CK_ZD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_CK_ZD_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_USE_REGISTER_TEST_MASK 0x100000
#define  MC_CH0_PHY_CONTROL_4_PHY_USE_REGISTER_TEST_SHIFT 20
#define  MC_CH0_PHY_CONTROL_4_PHY_USE_REGISTER_TEST_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_USE_REGISTER_TEST_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_USE_REGISTER_TEST_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_USE_REGISTER_TEST_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_USE_REGISTER_TEST_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_USE_REGISTER_TEST_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCV_DIS_LATE_MASK 0x80000
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCV_DIS_LATE_SHIFT 19
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCV_DIS_LATE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_DQ_RCV_DIS_LATE_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_DQ_RCV_DIS_LATE_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCV_DIS_LATE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_DQ_RCV_DIS_LATE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_DQ_RCV_DIS_LATE_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_RESERVED1_MASK 0x40000
#define  MC_CH0_PHY_CONTROL_4_RESERVED1_SHIFT 18
#define  MC_CH0_PHY_CONTROL_4_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_4_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNDRV_MASK 0x3c000
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNDRV_SHIFT 14
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNDRV_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_CK_ZNDRV_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_CK_ZNDRV_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNDRV_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_CK_ZNDRV_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_CK_ZNDRV_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPDRV_MASK 0x3c00
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPDRV_SHIFT 10
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPDRV_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_CK_ZPDRV_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_CK_ZPDRV_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPDRV_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_CK_ZPDRV_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_CK_ZPDRV_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MSB_MASK 0x200
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MSB_SHIFT 9
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MSB_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MSB_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MSB_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MSB_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MSB_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MSB_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MSB_MASK 0x100
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MSB_SHIFT 8
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MSB_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MSB_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MSB_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MSB_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MSB_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MSB_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MASK 0xf0
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_SHIFT 4
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MASK 0xf
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_SHIFT 0
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_SHIFT))

//====================================================================
//Register: Channel 0 PHY Control Register 5 (CH0_PHY_Control_5)
//====================================================================

#define  MC_CH0_PHY_CONTROL_5_RESERVED1_MASK 0xffc00000
#define  MC_CH0_PHY_CONTROL_5_RESERVED1_SHIFT 22
#define  MC_CH0_PHY_CONTROL_5_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_5_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_INTERVAL_MASK 0x300000
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_INTERVAL_SHIFT 20
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_INTERVAL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_PAD_CAL_INTERVAL_MASK) >> MC_CH0_PHY_CONTROL_5_PAD_CAL_INTERVAL_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_PAD_CAL_INTERVAL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_PAD_CAL_INTERVAL_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SEL_MASK 0xe0000
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SEL_SHIFT 17
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SEL_MASK) >> MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SEL_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_MASK 0x10000
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SHIFT 16
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_MASK) >> MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_MASK 0x8000
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_SHIFT 15
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_MASK) >> MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_RESERVED2_MASK 0x7800
#define  MC_CH0_PHY_CONTROL_5_RESERVED2_SHIFT 11
#define  MC_CH0_PHY_CONTROL_5_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_5_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_WRITE_DQSB_ONE_MASK 0x400
#define  MC_CH0_PHY_CONTROL_5_WRITE_DQSB_ONE_SHIFT 10
#define  MC_CH0_PHY_CONTROL_5_WRITE_DQSB_ONE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_WRITE_DQSB_ONE_MASK) >> MC_CH0_PHY_CONTROL_5_WRITE_DQSB_ONE_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_WRITE_DQSB_ONE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_WRITE_DQSB_ONE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_WRITE_DQSB_ONE_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_RESERVED3_MASK 0x200
#define  MC_CH0_PHY_CONTROL_5_RESERVED3_SHIFT 9
#define  MC_CH0_PHY_CONTROL_5_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_RESERVED3_MASK) >> MC_CH0_PHY_CONTROL_5_RESERVED3_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_RESERVED3_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_WRITE_DQSB_EN_MASK 0x100
#define  MC_CH0_PHY_CONTROL_5_WRITE_DQSB_EN_SHIFT 8
#define  MC_CH0_PHY_CONTROL_5_WRITE_DQSB_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_WRITE_DQSB_EN_MASK) >> MC_CH0_PHY_CONTROL_5_WRITE_DQSB_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_WRITE_DQSB_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_WRITE_DQSB_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_WRITE_DQSB_EN_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_PD_MASK 0x80
#define  MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_PD_SHIFT 7
#define  MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_PD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_PD_MASK) >> MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_PD_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_PD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_PD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_PD_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_OE_MASK 0x40
#define  MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_OE_SHIFT 6
#define  MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_OE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_OE_MASK) >> MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_OE_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_OE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_OE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_OE_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_RESERVED4_MASK 0x20
#define  MC_CH0_PHY_CONTROL_5_RESERVED4_SHIFT 5
#define  MC_CH0_PHY_CONTROL_5_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_RESERVED4_MASK) >> MC_CH0_PHY_CONTROL_5_RESERVED4_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_RESERVED4_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_MC_QSN_PD_MASK 0x10
#define  MC_CH0_PHY_CONTROL_5_MC_QSN_PD_SHIFT 4
#define  MC_CH0_PHY_CONTROL_5_MC_QSN_PD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_MC_QSN_PD_MASK) >> MC_CH0_PHY_CONTROL_5_MC_QSN_PD_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_MC_QSN_PD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_MC_QSN_PD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_MC_QSN_PD_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_MC_QSP_PD_MASK 0x8
#define  MC_CH0_PHY_CONTROL_5_MC_QSP_PD_SHIFT 3
#define  MC_CH0_PHY_CONTROL_5_MC_QSP_PD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_MC_QSP_PD_MASK) >> MC_CH0_PHY_CONTROL_5_MC_QSP_PD_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_MC_QSP_PD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_MC_QSP_PD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_MC_QSP_PD_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_MC_DQ_PD_MASK 0x4
#define  MC_CH0_PHY_CONTROL_5_MC_DQ_PD_SHIFT 2
#define  MC_CH0_PHY_CONTROL_5_MC_DQ_PD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_MC_DQ_PD_MASK) >> MC_CH0_PHY_CONTROL_5_MC_DQ_PD_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_MC_DQ_PD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_MC_DQ_PD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_MC_DQ_PD_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_MC_CK_PD_MASK 0x2
#define  MC_CH0_PHY_CONTROL_5_MC_CK_PD_SHIFT 1
#define  MC_CH0_PHY_CONTROL_5_MC_CK_PD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_MC_CK_PD_MASK) >> MC_CH0_PHY_CONTROL_5_MC_CK_PD_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_MC_CK_PD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_MC_CK_PD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_MC_CK_PD_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_MC_AC_PD_MASK 0x1
#define  MC_CH0_PHY_CONTROL_5_MC_AC_PD_SHIFT 0
#define  MC_CH0_PHY_CONTROL_5_MC_AC_PD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_MC_AC_PD_MASK) >> MC_CH0_PHY_CONTROL_5_MC_AC_PD_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_MC_AC_PD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_MC_AC_PD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_MC_AC_PD_SHIFT))

//====================================================================
//Register: Channel 0 PHY Control Register 6 (CH0_PHY_Control_6)
//====================================================================

#define  MC_CH0_PHY_CONTROL_6_RESERVED1_MASK 0xfff00000
#define  MC_CH0_PHY_CONTROL_6_RESERVED1_SHIFT 20
#define  MC_CH0_PHY_CONTROL_6_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_6_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_6_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_6_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_6_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_EN_SEL_MASK 0x80000
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_EN_SEL_SHIFT 19
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_EN_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_EN_SEL_MASK) >> MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_EN_SEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_EN_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_EN_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_EN_SEL_SHIFT))

#define  MC_CH0_PHY_CONTROL_6_RESERVED2_MASK 0x7fc00
#define  MC_CH0_PHY_CONTROL_6_RESERVED2_SHIFT 10
#define  MC_CH0_PHY_CONTROL_6_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_6_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_6_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_6_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_6_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_6_MC_PHY_WFIFO_LD_PHASE_MASK 0x200
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_WFIFO_LD_PHASE_SHIFT 9
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_WFIFO_LD_PHASE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_6_MC_PHY_WFIFO_LD_PHASE_MASK) >> MC_CH0_PHY_CONTROL_6_MC_PHY_WFIFO_LD_PHASE_SHIFT)
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_WFIFO_LD_PHASE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_6_MC_PHY_WFIFO_LD_PHASE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_6_MC_PHY_WFIFO_LD_PHASE_SHIFT))

#define  MC_CH0_PHY_CONTROL_6_RESERVED3_MASK 0x1f0
#define  MC_CH0_PHY_CONTROL_6_RESERVED3_SHIFT 4
#define  MC_CH0_PHY_CONTROL_6_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_6_RESERVED3_MASK) >> MC_CH0_PHY_CONTROL_6_RESERVED3_SHIFT)
#define  MC_CH0_PHY_CONTROL_6_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_6_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_6_RESERVED3_SHIFT))

#define  MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_MODE_MASK 0x8
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_MODE_SHIFT 3
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_MODE_MASK) >> MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_MODE_SHIFT)
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_MODE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_MODE_SHIFT))

#define  MC_CH0_PHY_CONTROL_6_RESERVED4_MASK 0x7
#define  MC_CH0_PHY_CONTROL_6_RESERVED4_SHIFT 0
#define  MC_CH0_PHY_CONTROL_6_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_6_RESERVED4_MASK) >> MC_CH0_PHY_CONTROL_6_RESERVED4_SHIFT)
#define  MC_CH0_PHY_CONTROL_6_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_6_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_6_RESERVED4_SHIFT))

//====================================================================
//Register: Channel 0 PHY Control Register 8 (CH0_PHY_Control_8)
//====================================================================

#define  MC_CH0_PHY_CONTROL_8_DLL_RESET_TIMER_MASK 0xff000000
#define  MC_CH0_PHY_CONTROL_8_DLL_RESET_TIMER_SHIFT 24
#define  MC_CH0_PHY_CONTROL_8_DLL_RESET_TIMER_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_DLL_RESET_TIMER_MASK) >> MC_CH0_PHY_CONTROL_8_DLL_RESET_TIMER_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_DLL_RESET_TIMER_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_DLL_RESET_TIMER_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_DLL_RESET_TIMER_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_RESERVED1_MASK 0xe00000
#define  MC_CH0_PHY_CONTROL_8_RESERVED1_SHIFT 21
#define  MC_CH0_PHY_CONTROL_8_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_8_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_DLL_UPDATE_TIMER_MASK 0x1f0000
#define  MC_CH0_PHY_CONTROL_8_DLL_UPDATE_TIMER_SHIFT 16
#define  MC_CH0_PHY_CONTROL_8_DLL_UPDATE_TIMER_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_DLL_UPDATE_TIMER_MASK) >> MC_CH0_PHY_CONTROL_8_DLL_UPDATE_TIMER_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_DLL_UPDATE_TIMER_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_DLL_UPDATE_TIMER_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_DLL_UPDATE_TIMER_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_INTERVAL_MASK 0xff00
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_INTERVAL_SHIFT 8
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_INTERVAL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_INTERVAL_MASK) >> MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_INTERVAL_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_INTERVAL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_INTERVAL_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_RESERVED2_MASK 0xe0
#define  MC_CH0_PHY_CONTROL_8_RESERVED2_SHIFT 5
#define  MC_CH0_PHY_CONTROL_8_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_8_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_DLL_FAST_LOCK_MASK 0x10
#define  MC_CH0_PHY_CONTROL_8_DLL_FAST_LOCK_SHIFT 4
#define  MC_CH0_PHY_CONTROL_8_DLL_FAST_LOCK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_DLL_FAST_LOCK_MASK) >> MC_CH0_PHY_CONTROL_8_DLL_FAST_LOCK_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_DLL_FAST_LOCK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_DLL_FAST_LOCK_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_DLL_FAST_LOCK_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_MANUAL_UPDATE_MASK 0x8
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_MANUAL_UPDATE_SHIFT 3
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_MANUAL_UPDATE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_DLL_AUTO_MANUAL_UPDATE_MASK) >> MC_CH0_PHY_CONTROL_8_DLL_AUTO_MANUAL_UPDATE_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_MANUAL_UPDATE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_DLL_AUTO_MANUAL_UPDATE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_DLL_AUTO_MANUAL_UPDATE_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_EN_MASK 0x4
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_EN_SHIFT 2
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_EN_MASK) >> MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_EN_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_RESERVED3_MASK 0x2
#define  MC_CH0_PHY_CONTROL_8_RESERVED3_SHIFT 1
#define  MC_CH0_PHY_CONTROL_8_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_RESERVED3_MASK) >> MC_CH0_PHY_CONTROL_8_RESERVED3_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_RESERVED3_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_DLL_UPDATE_BY_REF_EN_MASK 0x1
#define  MC_CH0_PHY_CONTROL_8_DLL_UPDATE_BY_REF_EN_SHIFT 0
#define  MC_CH0_PHY_CONTROL_8_DLL_UPDATE_BY_REF_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_DLL_UPDATE_BY_REF_EN_MASK) >> MC_CH0_PHY_CONTROL_8_DLL_UPDATE_BY_REF_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_DLL_UPDATE_BY_REF_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_DLL_UPDATE_BY_REF_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_DLL_UPDATE_BY_REF_EN_SHIFT))

//====================================================================
//Register: Channel 0 PHY Control Register 9 (CH0_PHY_Control_9)
/** \brief Refer to the DDLL_DDR document.*/
//====================================================================

#define  MC_CH0_PHY_CONTROL_9_PHY_SYNC_EN_MASK 0x80000000
#define  MC_CH0_PHY_CONTROL_9_PHY_SYNC_EN_SHIFT 31
#define  MC_CH0_PHY_CONTROL_9_PHY_SYNC_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_PHY_SYNC_EN_MASK) >> MC_CH0_PHY_CONTROL_9_PHY_SYNC_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_PHY_SYNC_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_PHY_SYNC_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_PHY_SYNC_EN_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_DLL_UPDATE_EN_PULSE_MASK 0x40000000
#define  MC_CH0_PHY_CONTROL_9_DLL_UPDATE_EN_PULSE_SHIFT 30
#define  MC_CH0_PHY_CONTROL_9_DLL_UPDATE_EN_PULSE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_DLL_UPDATE_EN_PULSE_MASK) >> MC_CH0_PHY_CONTROL_9_DLL_UPDATE_EN_PULSE_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_DLL_UPDATE_EN_PULSE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_DLL_UPDATE_EN_PULSE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_DLL_UPDATE_EN_PULSE_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_PHY_DLL_RST_MASK 0x20000000
#define  MC_CH0_PHY_CONTROL_9_PHY_DLL_RST_SHIFT 29
#define  MC_CH0_PHY_CONTROL_9_PHY_DLL_RST_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_PHY_DLL_RST_MASK) >> MC_CH0_PHY_CONTROL_9_PHY_DLL_RST_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_PHY_DLL_RST_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_PHY_DLL_RST_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_PHY_DLL_RST_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_PHY_PLL_RST_MASK 0x10000000
#define  MC_CH0_PHY_CONTROL_9_PHY_PLL_RST_SHIFT 28
#define  MC_CH0_PHY_CONTROL_9_PHY_PLL_RST_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_PHY_PLL_RST_MASK) >> MC_CH0_PHY_CONTROL_9_PHY_PLL_RST_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_PHY_PLL_RST_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_PHY_PLL_RST_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_PHY_PLL_RST_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_RESERVED1_MASK 0xe000000
#define  MC_CH0_PHY_CONTROL_9_RESERVED1_SHIFT 25
#define  MC_CH0_PHY_CONTROL_9_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_9_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ZPR_MASK 0x1f00000
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ZPR_SHIFT 20
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ZPR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_PHY_CAL_ZPR_MASK) >> MC_CH0_PHY_CONTROL_9_PHY_CAL_ZPR_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ZPR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_PHY_CAL_ZPR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_PHY_CAL_ZPR_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ZNR_MASK 0xf8000
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ZNR_SHIFT 15
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ZNR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_PHY_CAL_ZNR_MASK) >> MC_CH0_PHY_CONTROL_9_PHY_CAL_ZNR_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ZNR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_PHY_CAL_ZNR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_PHY_CAL_ZNR_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_RESERVED2_MASK 0x7ff0
#define  MC_CH0_PHY_CONTROL_9_RESERVED2_SHIFT 4
#define  MC_CH0_PHY_CONTROL_9_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_9_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ERR_MASK 0x8
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ERR_SHIFT 3
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ERR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_PHY_CAL_ERR_MASK) >> MC_CH0_PHY_CONTROL_9_PHY_CAL_ERR_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ERR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_PHY_CAL_ERR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_PHY_CAL_ERR_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_DONE_MASK 0x4
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_DONE_SHIFT 2
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_DONE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_PHY_CAL_DONE_MASK) >> MC_CH0_PHY_CONTROL_9_PHY_CAL_DONE_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_DONE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_PHY_CAL_DONE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_PHY_CAL_DONE_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_RESERVED3_MASK 0x3
#define  MC_CH0_PHY_CONTROL_9_RESERVED3_SHIFT 0
#define  MC_CH0_PHY_CONTROL_9_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_RESERVED3_MASK) >> MC_CH0_PHY_CONTROL_9_RESERVED3_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_RESERVED3_SHIFT))

//====================================================================
//Register: Channel 0 PHY Control Register 10 (CH0_PHY_Control_10)
/** \brief Refer to the DDLL_DDR document.*/
//====================================================================

#define  MC_CH0_PHY_CONTROL_10_PHY_WL_DQS_PULSE_MASK 0x80000000
#define  MC_CH0_PHY_CONTROL_10_PHY_WL_DQS_PULSE_SHIFT 31
#define  MC_CH0_PHY_CONTROL_10_PHY_WL_DQS_PULSE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_10_PHY_WL_DQS_PULSE_MASK) >> MC_CH0_PHY_CONTROL_10_PHY_WL_DQS_PULSE_SHIFT)
#define  MC_CH0_PHY_CONTROL_10_PHY_WL_DQS_PULSE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_10_PHY_WL_DQS_PULSE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_10_PHY_WL_DQS_PULSE_SHIFT))

#define  MC_CH0_PHY_CONTROL_10_RESERVED1_MASK 0x7ffffe00
#define  MC_CH0_PHY_CONTROL_10_RESERVED1_SHIFT 9
#define  MC_CH0_PHY_CONTROL_10_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_10_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_10_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_10_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_10_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_10_PHY_WL_DQ_OUT_MASK 0x1ff
#define  MC_CH0_PHY_CONTROL_10_PHY_WL_DQ_OUT_SHIFT 0
#define  MC_CH0_PHY_CONTROL_10_PHY_WL_DQ_OUT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_10_PHY_WL_DQ_OUT_MASK) >> MC_CH0_PHY_CONTROL_10_PHY_WL_DQ_OUT_SHIFT)
#define  MC_CH0_PHY_CONTROL_10_PHY_WL_DQ_OUT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_10_PHY_WL_DQ_OUT_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_10_PHY_WL_DQ_OUT_SHIFT))

//====================================================================
//Register: Channel 0 PHY Control Register 11 (CH0_PHY_Control_11)
//====================================================================

#define  MC_CH0_PHY_CONTROL_11_RESERVED1_MASK 0xffffff80
#define  MC_CH0_PHY_CONTROL_11_RESERVED1_SHIFT 7
#define  MC_CH0_PHY_CONTROL_11_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_11_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_11_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_11_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_11_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_CYCLE_MASK 0x70
#define  MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_CYCLE_SHIFT 4
#define  MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_CYCLE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_CYCLE_MASK) >> MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_CYCLE_SHIFT)
#define  MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_CYCLE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_CYCLE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_CYCLE_SHIFT))

#define  MC_CH0_PHY_CONTROL_11_RESERVED2_MASK 0xe
#define  MC_CH0_PHY_CONTROL_11_RESERVED2_SHIFT 1
#define  MC_CH0_PHY_CONTROL_11_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_11_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_11_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_11_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_11_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_EN_MASK 0x1
#define  MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_EN_SHIFT 0
#define  MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_EN_MASK) >> MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_EN_SHIFT))

//====================================================================
//Register: Channel 0 PHY Control Register 12 (CH0_PHY_Control_12)
//====================================================================

#define  MC_CH0_PHY_CONTROL_12_RESERVE_CK_MASK 0xff000000
#define  MC_CH0_PHY_CONTROL_12_RESERVE_CK_SHIFT 24
#define  MC_CH0_PHY_CONTROL_12_RESERVE_CK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_12_RESERVE_CK_MASK) >> MC_CH0_PHY_CONTROL_12_RESERVE_CK_SHIFT)
#define  MC_CH0_PHY_CONTROL_12_RESERVE_CK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_12_RESERVE_CK_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_12_RESERVE_CK_SHIFT))

#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC2_MASK 0xff0000
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC2_SHIFT 16
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_12_RESERVE_AC2_MASK) >> MC_CH0_PHY_CONTROL_12_RESERVE_AC2_SHIFT)
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_12_RESERVE_AC2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_12_RESERVE_AC2_SHIFT))

#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC1_MASK 0xff00
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC1_SHIFT 8
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_12_RESERVE_AC1_MASK) >> MC_CH0_PHY_CONTROL_12_RESERVE_AC1_SHIFT)
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_12_RESERVE_AC1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_12_RESERVE_AC1_SHIFT))

#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC0_MASK 0xff
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC0_SHIFT 0
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC0_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_12_RESERVE_AC0_MASK) >> MC_CH0_PHY_CONTROL_12_RESERVE_AC0_SHIFT)
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC0_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_12_RESERVE_AC0_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_12_RESERVE_AC0_SHIFT))

//====================================================================
//Register: Channel 0 PHY Control Register 13 (CH0_PHY_Control_13)
//====================================================================

#define  MC_CH0_PHY_CONTROL_13_RESERVED1_MASK 0xfc000000
#define  MC_CH0_PHY_CONTROL_13_RESERVED1_SHIFT 26
#define  MC_CH0_PHY_CONTROL_13_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_13_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_13_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_13_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_13_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_13_PHY_SA_PWRDWN_MASK 0x3800000
#define  MC_CH0_PHY_CONTROL_13_PHY_SA_PWRDWN_SHIFT 23
#define  MC_CH0_PHY_CONTROL_13_PHY_SA_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_13_PHY_SA_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_13_PHY_SA_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_13_PHY_SA_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_13_PHY_SA_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_13_PHY_SA_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_13_PHY_BA_PWRDWN_MASK 0x700000
#define  MC_CH0_PHY_CONTROL_13_PHY_BA_PWRDWN_SHIFT 20
#define  MC_CH0_PHY_CONTROL_13_PHY_BA_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_13_PHY_BA_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_13_PHY_BA_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_13_PHY_BA_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_13_PHY_BA_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_13_PHY_BA_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_13_RESERVED2_MASK 0xc0000
#define  MC_CH0_PHY_CONTROL_13_RESERVED2_SHIFT 18
#define  MC_CH0_PHY_CONTROL_13_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_13_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_13_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_13_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_13_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_13_PHY_AD_PWRDWN_MASK 0x3ffff
#define  MC_CH0_PHY_CONTROL_13_PHY_AD_PWRDWN_SHIFT 0
#define  MC_CH0_PHY_CONTROL_13_PHY_AD_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_13_PHY_AD_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_13_PHY_AD_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_13_PHY_AD_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_13_PHY_AD_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_13_PHY_AD_PWRDWN_SHIFT))

//====================================================================
//Register: Channel 0 PHY Control Register 14 (CH0_PHY_Control_14)
//====================================================================

#define  MC_CH0_PHY_CONTROL_14_RESERVED1_MASK 0xffc00000
#define  MC_CH0_PHY_CONTROL_14_RESERVED1_SHIFT 22
#define  MC_CH0_PHY_CONTROL_14_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_14_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_ALERTN_PWRDWN_MASK 0x200000
#define  MC_CH0_PHY_CONTROL_14_PHY_ALERTN_PWRDWN_SHIFT 21
#define  MC_CH0_PHY_CONTROL_14_PHY_ALERTN_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_ALERTN_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_ALERTN_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_ALERTN_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_ALERTN_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_ALERTN_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_PAR_PWRDWN_MASK 0x100000
#define  MC_CH0_PHY_CONTROL_14_PHY_PAR_PWRDWN_SHIFT 20
#define  MC_CH0_PHY_CONTROL_14_PHY_PAR_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_PAR_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_PAR_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_PAR_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_PAR_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_PAR_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_RESETN_PWRDWN_MASK 0x80000
#define  MC_CH0_PHY_CONTROL_14_PHY_RESETN_PWRDWN_SHIFT 19
#define  MC_CH0_PHY_CONTROL_14_PHY_RESETN_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_RESETN_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_RESETN_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_RESETN_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_RESETN_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_RESETN_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_WEN_PWRDWN_MASK 0x40000
#define  MC_CH0_PHY_CONTROL_14_PHY_WEN_PWRDWN_SHIFT 18
#define  MC_CH0_PHY_CONTROL_14_PHY_WEN_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_WEN_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_WEN_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_WEN_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_WEN_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_WEN_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_CASN_PWRDWN_MASK 0x20000
#define  MC_CH0_PHY_CONTROL_14_PHY_CASN_PWRDWN_SHIFT 17
#define  MC_CH0_PHY_CONTROL_14_PHY_CASN_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_CASN_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_CASN_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_CASN_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_CASN_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_CASN_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_RASN_PWRDWN_MASK 0x10000
#define  MC_CH0_PHY_CONTROL_14_PHY_RASN_PWRDWN_SHIFT 16
#define  MC_CH0_PHY_CONTROL_14_PHY_RASN_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_RASN_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_RASN_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_RASN_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_RASN_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_RASN_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_ODT_PWRDWN_MASK 0xf000
#define  MC_CH0_PHY_CONTROL_14_PHY_ODT_PWRDWN_SHIFT 12
#define  MC_CH0_PHY_CONTROL_14_PHY_ODT_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_ODT_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_ODT_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_ODT_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_ODT_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_ODT_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_CKE_PWRDWN_MASK 0xf00
#define  MC_CH0_PHY_CONTROL_14_PHY_CKE_PWRDWN_SHIFT 8
#define  MC_CH0_PHY_CONTROL_14_PHY_CKE_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_CKE_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_CKE_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_CKE_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_CKE_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_CKE_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_CSN_PWRDWN_MASK 0xf0
#define  MC_CH0_PHY_CONTROL_14_PHY_CSN_PWRDWN_SHIFT 4
#define  MC_CH0_PHY_CONTROL_14_PHY_CSN_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_CSN_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_CSN_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_CSN_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_CSN_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_CSN_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_CK_PWRDWN_MASK 0xf
#define  MC_CH0_PHY_CONTROL_14_PHY_CK_PWRDWN_SHIFT 0
#define  MC_CH0_PHY_CONTROL_14_PHY_CK_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_CK_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_CK_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_CK_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_CK_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_CK_PWRDWN_SHIFT))

//====================================================================
//Register: Channel 0 PHY Control Register 15 (CH0_PHY_Control_15)
//====================================================================

#define  MC_CH0_PHY_CONTROL_15_PHY_VREF_RNGE_MASK 0x80000000
#define  MC_CH0_PHY_CONTROL_15_PHY_VREF_RNGE_SHIFT 31
#define  MC_CH0_PHY_CONTROL_15_PHY_VREF_RNGE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_VREF_RNGE_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_VREF_RNGE_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_VREF_RNGE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_VREF_RNGE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_VREF_RNGE_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_RESERVED1_MASK 0x40000000
#define  MC_CH0_PHY_CONTROL_15_RESERVED1_SHIFT 30
#define  MC_CH0_PHY_CONTROL_15_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_15_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_VREF_CTRL_MASK 0x3f000000
#define  MC_CH0_PHY_CONTROL_15_PHY_VREF_CTRL_SHIFT 24
#define  MC_CH0_PHY_CONTROL_15_PHY_VREF_CTRL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_VREF_CTRL_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_VREF_CTRL_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_VREF_CTRL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_VREF_CTRL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_VREF_CTRL_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_RESERVED2_MASK 0xc00000
#define  MC_CH0_PHY_CONTROL_15_RESERVED2_SHIFT 22
#define  MC_CH0_PHY_CONTROL_15_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_15_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_TSTPT_SEL_MASK 0x300000
#define  MC_CH0_PHY_CONTROL_15_PHY_TSTPT_SEL_SHIFT 20
#define  MC_CH0_PHY_CONTROL_15_PHY_TSTPT_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_TSTPT_SEL_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_TSTPT_SEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_TSTPT_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_TSTPT_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_TSTPT_SEL_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_RESERVED3_MASK 0x80000
#define  MC_CH0_PHY_CONTROL_15_RESERVED3_SHIFT 19
#define  MC_CH0_PHY_CONTROL_15_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_RESERVED3_MASK) >> MC_CH0_PHY_CONTROL_15_RESERVED3_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_RESERVED3_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_REFBUF_TRI_MASK 0x40000
#define  MC_CH0_PHY_CONTROL_15_PHY_REFBUF_TRI_SHIFT 18
#define  MC_CH0_PHY_CONTROL_15_PHY_REFBUF_TRI_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_REFBUF_TRI_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_REFBUF_TRI_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_REFBUF_TRI_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_REFBUF_TRI_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_REFBUF_TRI_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_REFBUF_BYP_MASK 0x20000
#define  MC_CH0_PHY_CONTROL_15_PHY_REFBUF_BYP_SHIFT 17
#define  MC_CH0_PHY_CONTROL_15_PHY_REFBUF_BYP_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_REFBUF_BYP_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_REFBUF_BYP_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_REFBUF_BYP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_REFBUF_BYP_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_REFBUF_BYP_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_PU_MASK 0x10000
#define  MC_CH0_PHY_CONTROL_15_PHY_PU_SHIFT 16
#define  MC_CH0_PHY_CONTROL_15_PHY_PU_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_PU_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_PU_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_PU_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_PU_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_PU_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_RESERVED4_MASK 0xf000
#define  MC_CH0_PHY_CONTROL_15_RESERVED4_SHIFT 12
#define  MC_CH0_PHY_CONTROL_15_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_RESERVED4_MASK) >> MC_CH0_PHY_CONTROL_15_RESERVED4_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_RESERVED4_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_CP_REF_SEL_MASK 0xf00
#define  MC_CH0_PHY_CONTROL_15_PHY_CP_REF_SEL_SHIFT 8
#define  MC_CH0_PHY_CONTROL_15_PHY_CP_REF_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_CP_REF_SEL_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_CP_REF_SEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_CP_REF_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_CP_REF_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_CP_REF_SEL_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_CP_TEST_EN_MASK 0x80
#define  MC_CH0_PHY_CONTROL_15_PHY_CP_TEST_EN_SHIFT 7
#define  MC_CH0_PHY_CONTROL_15_PHY_CP_TEST_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_CP_TEST_EN_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_CP_TEST_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_CP_TEST_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_CP_TEST_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_CP_TEST_EN_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_VREFINT_EN_MASK 0x40
#define  MC_CH0_PHY_CONTROL_15_PHY_VREFINT_EN_SHIFT 6
#define  MC_CH0_PHY_CONTROL_15_PHY_VREFINT_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_VREFINT_EN_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_VREFINT_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_VREFINT_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_VREFINT_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_VREFINT_EN_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_REG_SLP_MASK 0x20
#define  MC_CH0_PHY_CONTROL_15_PHY_REG_SLP_SHIFT 5
#define  MC_CH0_PHY_CONTROL_15_PHY_REG_SLP_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_REG_SLP_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_REG_SLP_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_REG_SLP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_REG_SLP_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_REG_SLP_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_REG_PD_MASK 0x10
#define  MC_CH0_PHY_CONTROL_15_PHY_REG_PD_SHIFT 4
#define  MC_CH0_PHY_CONTROL_15_PHY_REG_PD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_REG_PD_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_REG_PD_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_REG_PD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_REG_PD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_REG_PD_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_RESERVED5_MASK 0xc
#define  MC_CH0_PHY_CONTROL_15_RESERVED5_SHIFT 2
#define  MC_CH0_PHY_CONTROL_15_RESERVED5_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_RESERVED5_MASK) >> MC_CH0_PHY_CONTROL_15_RESERVED5_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_RESERVED5_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_RESERVED5_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_WRST_SEL_MASK 0x3
#define  MC_CH0_PHY_CONTROL_15_PHY_WRST_SEL_SHIFT 0
#define  MC_CH0_PHY_CONTROL_15_PHY_WRST_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_WRST_SEL_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_WRST_SEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_WRST_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_WRST_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_WRST_SEL_SHIFT))

//====================================================================
//Register: Channel 0 PHY Control Register 16 (CH0_PHY_Control_16)
//====================================================================

#define  MC_CH0_PHY_CONTROL_16_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_CONTROL_16_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_CONTROL_16_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_16_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_16_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_16_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_16_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_16_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_16_PHY_DMSYNC_RESERVED_MASK 0xf00
#define  MC_CH0_PHY_CONTROL_16_PHY_DMSYNC_RESERVED_SHIFT 8
#define  MC_CH0_PHY_CONTROL_16_PHY_DMSYNC_RESERVED_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_16_PHY_DMSYNC_RESERVED_MASK) >> MC_CH0_PHY_CONTROL_16_PHY_DMSYNC_RESERVED_SHIFT)
#define  MC_CH0_PHY_CONTROL_16_PHY_DMSYNC_RESERVED_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_16_PHY_DMSYNC_RESERVED_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_16_PHY_DMSYNC_RESERVED_SHIFT))

#define  MC_CH0_PHY_CONTROL_16_PHY_WCKG_DLY_MASK 0xf0
#define  MC_CH0_PHY_CONTROL_16_PHY_WCKG_DLY_SHIFT 4
#define  MC_CH0_PHY_CONTROL_16_PHY_WCKG_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_16_PHY_WCKG_DLY_MASK) >> MC_CH0_PHY_CONTROL_16_PHY_WCKG_DLY_SHIFT)
#define  MC_CH0_PHY_CONTROL_16_PHY_WCKG_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_16_PHY_WCKG_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_16_PHY_WCKG_DLY_SHIFT))

#define  MC_CH0_PHY_CONTROL_16_RESERVED2_MASK 0xe
#define  MC_CH0_PHY_CONTROL_16_RESERVED2_SHIFT 1
#define  MC_CH0_PHY_CONTROL_16_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_16_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_16_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_16_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_16_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_16_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_16_PHY_WCK_EN_MASK 0x1
#define  MC_CH0_PHY_CONTROL_16_PHY_WCK_EN_SHIFT 0
#define  MC_CH0_PHY_CONTROL_16_PHY_WCK_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_16_PHY_WCK_EN_MASK) >> MC_CH0_PHY_CONTROL_16_PHY_WCK_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_16_PHY_WCK_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_16_PHY_WCK_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_16_PHY_WCK_EN_SHIFT))

//====================================================================
//Register: Channel 0 PHY Control Register 17 (CH0_PHY_Control_17)
//====================================================================

#define  MC_CH0_PHY_CONTROL_17_RESERVED1_MASK 0xc0000000
#define  MC_CH0_PHY_CONTROL_17_RESERVED1_SHIFT 30
#define  MC_CH0_PHY_CONTROL_17_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_17_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN7_MASK 0x20000000
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN7_SHIFT 29
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN7_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN7_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN7_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN7_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN7_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN7_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN6_MASK 0x10000000
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN6_SHIFT 28
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN6_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN6_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN6_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN6_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN6_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN6_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN5_MASK 0x8000000
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN5_SHIFT 27
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN5_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN5_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN5_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN5_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN5_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN5_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_RECEN_MASK 0x4000000
#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_RECEN_SHIFT 26
#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_RECEN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_PHY_ALERTN_RECEN_MASK) >> MC_CH0_PHY_CONTROL_17_PHY_ALERTN_RECEN_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_RECEN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_PHY_ALERTN_RECEN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_PHY_ALERTN_RECEN_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_PD_MASK 0x2000000
#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_PD_SHIFT 25
#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_PD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_PHY_ALERTN_PD_MASK) >> MC_CH0_PHY_CONTROL_17_PHY_ALERTN_PD_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_PD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_PHY_ALERTN_PD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_PHY_ALERTN_PD_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_PU_MASK 0x1000000
#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_PU_SHIFT 24
#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_PU_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_PHY_ALERTN_PU_MASK) >> MC_CH0_PHY_CONTROL_17_PHY_ALERTN_PU_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_PU_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_PHY_ALERTN_PU_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_PHY_ALERTN_PU_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_ZNTRM_MASK 0xf00000
#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_ZNTRM_SHIFT 20
#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_ZNTRM_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_PHY_ALERTN_ZNTRM_MASK) >> MC_CH0_PHY_CONTROL_17_PHY_ALERTN_ZNTRM_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_ZNTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_PHY_ALERTN_ZNTRM_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_PHY_ALERTN_ZNTRM_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_ZPTRM_MASK 0xf0000
#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_ZPTRM_SHIFT 16
#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_ZPTRM_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_PHY_ALERTN_ZPTRM_MASK) >> MC_CH0_PHY_CONTROL_17_PHY_ALERTN_ZPTRM_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_PHY_ALERTN_ZPTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_PHY_ALERTN_ZPTRM_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_PHY_ALERTN_ZPTRM_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN4_MASK 0x8000
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN4_SHIFT 15
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN4_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN4_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN4_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN4_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN3_MASK 0x4000
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN3_SHIFT 14
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN3_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN3_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN3_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN3_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN2_MASK 0x2000
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN2_SHIFT 13
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN2_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN2_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN2_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN1_MASK 0x1000
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN1_SHIFT 12
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN1_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN1_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN1_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_BYPASS_MASK 0x800
#define  MC_CH0_PHY_CONTROL_17_VREG_BYPASS_SHIFT 11
#define  MC_CH0_PHY_CONTROL_17_VREG_BYPASS_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_BYPASS_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_BYPASS_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_BYPASS_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_BYPASS_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_PU_MASK 0x400
#define  MC_CH0_PHY_CONTROL_17_VREG_PU_SHIFT 10
#define  MC_CH0_PHY_CONTROL_17_VREG_PU_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_PU_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_PU_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_PU_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_PU_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_PU_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_LP_MASK 0x200
#define  MC_CH0_PHY_CONTROL_17_VREG_LP_SHIFT 9
#define  MC_CH0_PHY_CONTROL_17_VREG_LP_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_LP_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_LP_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_LP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_LP_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_LP_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN0_MASK 0x100
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN0_SHIFT 8
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN0_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN0_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN0_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN0_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN0_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN0_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_RESERVED2_MASK 0x80
#define  MC_CH0_PHY_CONTROL_17_RESERVED2_SHIFT 7
#define  MC_CH0_PHY_CONTROL_17_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_17_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_TESTMON_MASK 0x70
#define  MC_CH0_PHY_CONTROL_17_VREG_TESTMON_SHIFT 4
#define  MC_CH0_PHY_CONTROL_17_VREG_TESTMON_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_TESTMON_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_TESTMON_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_TESTMON_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_TESTMON_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_TESTMON_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_RESERVED3_MASK 0x8
#define  MC_CH0_PHY_CONTROL_17_RESERVED3_SHIFT 3
#define  MC_CH0_PHY_CONTROL_17_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_RESERVED3_MASK) >> MC_CH0_PHY_CONTROL_17_RESERVED3_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_RESERVED3_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_VSEL_MASK 0x7
#define  MC_CH0_PHY_CONTROL_17_VREG_VSEL_SHIFT 0
#define  MC_CH0_PHY_CONTROL_17_VREG_VSEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_VSEL_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_VSEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_VSEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_VSEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_VSEL_SHIFT))

//====================================================================
//Register: Channel 0 PHY DLL Control Register B0 (CH0_PHY_DLL_control_B0)
//====================================================================

#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED1_MASK 0xc0000000
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED1_SHIFT 30
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_RESERVED1_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL1_MASK 0x3f000000
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL1_SHIFT 24
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL1_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL1_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL1_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED2_MASK 0xc00000
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED2_SHIFT 22
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_RESERVED2_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_RESERVED2_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_RESERVED2_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL_MASK 0x3f0000
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL_SHIFT 16
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED3_MASK 0xc000
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED3_SHIFT 14
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_RESERVED3_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_RESERVED3_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_RESERVED3_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_DELAY_TEST_MASK 0x3ff0
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_DELAY_TEST_SHIFT 4
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_DELAY_TEST_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_DLL_DELAY_TEST_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_DLL_DELAY_TEST_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_DELAY_TEST_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_DLL_DELAY_TEST_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_DLL_DELAY_TEST_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_GAIN2X_MASK 0x8
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_GAIN2X_SHIFT 3
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_GAIN2X_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_DLL_GAIN2X_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_DLL_GAIN2X_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_GAIN2X_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_DLL_GAIN2X_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_DLL_GAIN2X_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED4_MASK 0x4
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED4_SHIFT 2
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_RESERVED4_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_RESERVED4_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_RESERVED4_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_TEST_EN_MASK 0x2
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_TEST_EN_SHIFT 1
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_TEST_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_DLL_TEST_EN_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_DLL_TEST_EN_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_TEST_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_DLL_TEST_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_DLL_TEST_EN_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_BYPASS_EN_MASK 0x1
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_BYPASS_EN_SHIFT 0
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_BYPASS_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_DLL_BYPASS_EN_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_DLL_BYPASS_EN_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_BYPASS_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_DLL_BYPASS_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_DLL_BYPASS_EN_SHIFT))

//====================================================================
//Register: Channel 0 PHY DLL Control Register B1 (CH0_PHY_DLL_control_B1)
//====================================================================

#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED1_MASK 0xc0000000
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED1_SHIFT 30
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_RESERVED1_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL1_MASK 0x3f000000
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL1_SHIFT 24
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL1_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL1_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL1_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED2_MASK 0xc00000
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED2_SHIFT 22
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_RESERVED2_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_RESERVED2_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_RESERVED2_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL_MASK 0x3f0000
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL_SHIFT 16
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED3_MASK 0xc000
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED3_SHIFT 14
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_RESERVED3_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_RESERVED3_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_RESERVED3_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_DELAY_TEST_MASK 0x3ff0
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_DELAY_TEST_SHIFT 4
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_DELAY_TEST_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_DLL_DELAY_TEST_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_DLL_DELAY_TEST_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_DELAY_TEST_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_DLL_DELAY_TEST_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_DLL_DELAY_TEST_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_GAIN2X_MASK 0x8
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_GAIN2X_SHIFT 3
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_GAIN2X_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_DLL_GAIN2X_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_DLL_GAIN2X_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_GAIN2X_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_DLL_GAIN2X_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_DLL_GAIN2X_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED4_MASK 0x4
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED4_SHIFT 2
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_RESERVED4_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_RESERVED4_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_RESERVED4_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_TEST_EN_MASK 0x2
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_TEST_EN_SHIFT 1
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_TEST_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_DLL_TEST_EN_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_DLL_TEST_EN_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_TEST_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_DLL_TEST_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_DLL_TEST_EN_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_BYPASS_EN_MASK 0x1
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_BYPASS_EN_SHIFT 0
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_BYPASS_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_DLL_BYPASS_EN_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_DLL_BYPASS_EN_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_BYPASS_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_DLL_BYPASS_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_DLL_BYPASS_EN_SHIFT))

//====================================================================
//Register: Channel 0 PHY DLL BYTE Select Register (CH0_PHY_DLL_BYTE_SELECT)
//====================================================================

#define  MC_CH0_PHY_DLL_BYTE_SELECT_RESERVED1_MASK 0xfffffff0
#define  MC_CH0_PHY_DLL_BYTE_SELECT_RESERVED1_SHIFT 4
#define  MC_CH0_PHY_DLL_BYTE_SELECT_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_BYTE_SELECT_RESERVED1_MASK) >> MC_CH0_PHY_DLL_BYTE_SELECT_RESERVED1_SHIFT)
#define  MC_CH0_PHY_DLL_BYTE_SELECT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_BYTE_SELECT_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_BYTE_SELECT_RESERVED1_SHIFT))

#define  MC_CH0_PHY_DLL_BYTE_SELECT_DLL_BYTE_SEL_MASK 0xf
#define  MC_CH0_PHY_DLL_BYTE_SELECT_DLL_BYTE_SEL_SHIFT 0
#define  MC_CH0_PHY_DLL_BYTE_SELECT_DLL_BYTE_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_BYTE_SELECT_DLL_BYTE_SEL_MASK) >> MC_CH0_PHY_DLL_BYTE_SELECT_DLL_BYTE_SEL_SHIFT)
#define  MC_CH0_PHY_DLL_BYTE_SELECT_DLL_BYTE_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_BYTE_SELECT_DLL_BYTE_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_BYTE_SELECT_DLL_BYTE_SEL_SHIFT))

//====================================================================
//Register: Channel 0 PHY DLL Delay Register (CH0_PHY_DLL_DLY)
//====================================================================

#define  MC_CH0_PHY_DLL_DLY_RESERVED1_MASK 0xfc000000
#define  MC_CH0_PHY_DLL_DLY_RESERVED1_SHIFT 26
#define  MC_CH0_PHY_DLL_DLY_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_DLY_RESERVED1_MASK) >> MC_CH0_PHY_DLL_DLY_RESERVED1_SHIFT)
#define  MC_CH0_PHY_DLL_DLY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_DLY_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_DLY_RESERVED1_SHIFT))

#define  MC_CH0_PHY_DLL_DLY_DLL_SLAVE_DELAY_OUT_MASK 0x3ff0000
#define  MC_CH0_PHY_DLL_DLY_DLL_SLAVE_DELAY_OUT_SHIFT 16
#define  MC_CH0_PHY_DLL_DLY_DLL_SLAVE_DELAY_OUT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_DLY_DLL_SLAVE_DELAY_OUT_MASK) >> MC_CH0_PHY_DLL_DLY_DLL_SLAVE_DELAY_OUT_SHIFT)
#define  MC_CH0_PHY_DLL_DLY_DLL_SLAVE_DELAY_OUT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_DLY_DLL_SLAVE_DELAY_OUT_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_DLY_DLL_SLAVE_DELAY_OUT_SHIFT))

#define  MC_CH0_PHY_DLL_DLY_RESERVED2_MASK 0xfc00
#define  MC_CH0_PHY_DLL_DLY_RESERVED2_SHIFT 10
#define  MC_CH0_PHY_DLL_DLY_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_DLY_RESERVED2_MASK) >> MC_CH0_PHY_DLL_DLY_RESERVED2_SHIFT)
#define  MC_CH0_PHY_DLL_DLY_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_DLY_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_DLY_RESERVED2_SHIFT))

#define  MC_CH0_PHY_DLL_DLY_DLL_MASTER_DELAY_OUT_MASK 0x3ff
#define  MC_CH0_PHY_DLL_DLY_DLL_MASTER_DELAY_OUT_SHIFT 0
#define  MC_CH0_PHY_DLL_DLY_DLL_MASTER_DELAY_OUT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_DLY_DLL_MASTER_DELAY_OUT_MASK) >> MC_CH0_PHY_DLL_DLY_DLL_MASTER_DELAY_OUT_SHIFT)
#define  MC_CH0_PHY_DLL_DLY_DLL_MASTER_DELAY_OUT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_DLY_DLL_MASTER_DELAY_OUT_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_DLY_DLL_MASTER_DELAY_OUT_SHIFT))

//====================================================================
//Register: Channel 0 PHY Data Byte Control Register B0 (CH0_PHY_Data_Byte_Control_B0)
//====================================================================

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_RESERVED1_MASK 0xffffc000
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_RESERVED1_SHIFT 14
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B0_RESERVED1_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_DISTRM_MASK 0x2000
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_DISTRM_SHIFT 13
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_DISTRM_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_DISTRM_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_DISTRM_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_DISTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_DISTRM_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_DISTRM_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_DISTRM_MASK 0x1000
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_DISTRM_SHIFT 12
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_DISTRM_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_DISTRM_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_DISTRM_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_DISTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_DISTRM_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_DISTRM_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_DISTRM_MASK 0x800
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_DISTRM_SHIFT 11
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_DISTRM_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_DISTRM_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_DISTRM_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_DISTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_DISTRM_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_DISTRM_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_PWRDWN_MASK 0x400
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_PWRDWN_SHIFT 10
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_PWRDWN_MASK 0x200
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_PWRDWN_SHIFT 9
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_PWRDWN_MASK 0x100
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_PWRDWN_SHIFT 8
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_RESERVE_MASK 0xff
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_RESERVE_SHIFT 0
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_RESERVE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_RESERVE_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_RESERVE_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_RESERVE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_RESERVE_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_RESERVE_SHIFT))

//====================================================================
//Register: Channel 0 PHY Data Byte Control Register B1 (CH0_PHY_Data_Byte_Control_B1)
//====================================================================

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_RESERVED1_MASK 0xffffc000
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_RESERVED1_SHIFT 14
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B1_RESERVED1_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_DISTRM_MASK 0x2000
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_DISTRM_SHIFT 13
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_DISTRM_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_DISTRM_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_DISTRM_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_DISTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_DISTRM_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_DISTRM_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_DISTRM_MASK 0x1000
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_DISTRM_SHIFT 12
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_DISTRM_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_DISTRM_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_DISTRM_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_DISTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_DISTRM_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_DISTRM_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_DISTRM_MASK 0x800
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_DISTRM_SHIFT 11
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_DISTRM_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_DISTRM_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_DISTRM_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_DISTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_DISTRM_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_DISTRM_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_PWRDWN_MASK 0x400
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_PWRDWN_SHIFT 10
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_PWRDWN_MASK 0x200
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_PWRDWN_SHIFT 9
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_PWRDWN_MASK 0x100
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_PWRDWN_SHIFT 8
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_RESERVE_MASK 0xff
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_RESERVE_SHIFT 0
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_RESERVE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_RESERVE_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_RESERVE_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_RESERVE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_RESERVE_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_RESERVE_SHIFT))

//====================================================================
//Register: Channel 0 PHY WL RL Control Register (CH0_PHY_WL_RL_Control)
//====================================================================

#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_RFIFO_SPLIT_EN_MASK 0x80000000
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_RFIFO_SPLIT_EN_SHIFT 31
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_RFIFO_SPLIT_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_RL_CONTROL_PHY_RFIFO_SPLIT_EN_MASK) >> MC_CH0_PHY_WL_RL_CONTROL_PHY_RFIFO_SPLIT_EN_SHIFT)
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_RFIFO_SPLIT_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_RL_CONTROL_PHY_RFIFO_SPLIT_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_RL_CONTROL_PHY_RFIFO_SPLIT_EN_SHIFT))

#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_DQS_TERM_ON_MASK 0x40000000
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_DQS_TERM_ON_SHIFT 30
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_DQS_TERM_ON_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_RL_CONTROL_PHY_DQS_TERM_ON_MASK) >> MC_CH0_PHY_WL_RL_CONTROL_PHY_DQS_TERM_ON_SHIFT)
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_DQS_TERM_ON_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_RL_CONTROL_PHY_DQS_TERM_ON_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_RL_CONTROL_PHY_DQS_TERM_ON_SHIFT))

#define  MC_CH0_PHY_WL_RL_CONTROL_RDQS_POSTAMBLE_HIGH_MASK 0x20000000
#define  MC_CH0_PHY_WL_RL_CONTROL_RDQS_POSTAMBLE_HIGH_SHIFT 29
#define  MC_CH0_PHY_WL_RL_CONTROL_RDQS_POSTAMBLE_HIGH_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_RL_CONTROL_RDQS_POSTAMBLE_HIGH_MASK) >> MC_CH0_PHY_WL_RL_CONTROL_RDQS_POSTAMBLE_HIGH_SHIFT)
#define  MC_CH0_PHY_WL_RL_CONTROL_RDQS_POSTAMBLE_HIGH_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_RL_CONTROL_RDQS_POSTAMBLE_HIGH_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_RL_CONTROL_RDQS_POSTAMBLE_HIGH_SHIFT))

#define  MC_CH0_PHY_WL_RL_CONTROL_RDQS_PREAMBLE_HIGH_MASK 0x10000000
#define  MC_CH0_PHY_WL_RL_CONTROL_RDQS_PREAMBLE_HIGH_SHIFT 28
#define  MC_CH0_PHY_WL_RL_CONTROL_RDQS_PREAMBLE_HIGH_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_RL_CONTROL_RDQS_PREAMBLE_HIGH_MASK) >> MC_CH0_PHY_WL_RL_CONTROL_RDQS_PREAMBLE_HIGH_SHIFT)
#define  MC_CH0_PHY_WL_RL_CONTROL_RDQS_PREAMBLE_HIGH_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_RL_CONTROL_RDQS_PREAMBLE_HIGH_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_RL_CONTROL_RDQS_PREAMBLE_HIGH_SHIFT))

#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED1_MASK 0xffff000
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_RL_CONTROL_RESERVED1_MASK) >> MC_CH0_PHY_WL_RL_CONTROL_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_RL_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_RL_CONTROL_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_CS_SEL_MASK 0xf00
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_CS_SEL_SHIFT 8
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_CS_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_CS_SEL_MASK) >> MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_CS_SEL_SHIFT)
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_CS_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_CS_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_CS_SEL_SHIFT))

#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED2_MASK 0xe0
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED2_SHIFT 5
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_RL_CONTROL_RESERVED2_MASK) >> MC_CH0_PHY_WL_RL_CONTROL_RESERVED2_SHIFT)
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_RL_CONTROL_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_RL_CONTROL_RESERVED2_SHIFT))

#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_DQS_RECEN_DIS_MASK 0x10
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_DQS_RECEN_DIS_SHIFT 4
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_DQS_RECEN_DIS_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_DQS_RECEN_DIS_MASK) >> MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_DQS_RECEN_DIS_SHIFT)
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_DQS_RECEN_DIS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_DQS_RECEN_DIS_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_DQS_RECEN_DIS_SHIFT))

#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED3_MASK 0xc
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED3_SHIFT 2
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_RL_CONTROL_RESERVED3_MASK) >> MC_CH0_PHY_WL_RL_CONTROL_RESERVED3_SHIFT)
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_RL_CONTROL_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_RL_CONTROL_RESERVED3_SHIFT))

#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_RL_ENABLE_MASK 0x3
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_RL_ENABLE_SHIFT 0
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_RL_ENABLE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_RL_CONTROL_PHY_RL_ENABLE_MASK) >> MC_CH0_PHY_WL_RL_CONTROL_PHY_RL_ENABLE_SHIFT)
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_RL_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_RL_CONTROL_PHY_RL_ENABLE_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_RL_CONTROL_PHY_RL_ENABLE_SHIFT))

//====================================================================
//Register: Channel 0 PHY WL Control Data Register CS0 B0 (CH0_PHY_WL_DATA_Control_CS0_B0)
/** \brief This register is used for write-leveling support.*/
//====================================================================

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED1_MASK 0x80000000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED1_SHIFT 31
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED1_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QSC_DLY_MASK 0x7f000000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QSC_DLY_SHIFT 24
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QSC_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QSC_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QSC_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QSC_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QSC_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QSC_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED2_MASK 0x800000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED2_SHIFT 23
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED2_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED2_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED2_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQC_DLY_MASK 0x7f0000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQC_DLY_SHIFT 16
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQC_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQC_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQC_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQC_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQC_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQC_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED3_MASK 0x8000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED3_SHIFT 15
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED3_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED3_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED3_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QS_DLY_MASK 0x7f00
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QS_DLY_SHIFT 8
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QS_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QS_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QS_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QS_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QS_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QS_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED4_MASK 0x80
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED4_SHIFT 7
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED4_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED4_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED4_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQ_DLY_MASK 0x7f
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQ_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQ_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQ_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQ_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQ_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQ_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQ_DLY_SHIFT))

//====================================================================
//Register: Channel 0 PHY WL Control Data Register CS0 B1 (CH0_PHY_WL_DATA_Control_CS0_B1)
/** \brief This register is used for write-leveling support.*/
//====================================================================

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED1_MASK 0x80000000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED1_SHIFT 31
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED1_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QSC_DLY_MASK 0x7f000000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QSC_DLY_SHIFT 24
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QSC_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QSC_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QSC_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QSC_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QSC_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QSC_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED2_MASK 0x800000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED2_SHIFT 23
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED2_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED2_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED2_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQC_DLY_MASK 0x7f0000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQC_DLY_SHIFT 16
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQC_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQC_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQC_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQC_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQC_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQC_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED3_MASK 0x8000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED3_SHIFT 15
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED3_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED3_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED3_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QS_DLY_MASK 0x7f00
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QS_DLY_SHIFT 8
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QS_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QS_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QS_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QS_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QS_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QS_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED4_MASK 0x80
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED4_SHIFT 7
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED4_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED4_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED4_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQ_DLY_MASK 0x7f
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQ_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQ_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQ_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQ_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQ_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQ_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQ_DLY_SHIFT))

//====================================================================
//Register: Channel 0 PHY WL Control Clock Register CS0 (CH0_PHY_WL_CLK_Control_CS0)
/** \brief This register is used for write-leveling support.*/
//====================================================================

#define  MC_CH0_PHY_WL_CLK_CONTROL_CS0_RESERVED1_MASK 0xffffffe0
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS0_RESERVED1_SHIFT 5
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_CLK_CONTROL_CS0_RESERVED1_MASK) >> MC_CH0_PHY_WL_CLK_CONTROL_CS0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_CLK_CONTROL_CS0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_CLK_CONTROL_CS0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_CLK_CONTROL_CS0_PHY_WL_WCK_CK_DLY_MASK 0x1f
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS0_PHY_WL_WCK_CK_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS0_PHY_WL_WCK_CK_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_CLK_CONTROL_CS0_PHY_WL_WCK_CK_DLY_MASK) >> MC_CH0_PHY_WL_CLK_CONTROL_CS0_PHY_WL_WCK_CK_DLY_SHIFT)
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS0_PHY_WL_WCK_CK_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_CLK_CONTROL_CS0_PHY_WL_WCK_CK_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_CLK_CONTROL_CS0_PHY_WL_WCK_CK_DLY_SHIFT))

//====================================================================
//Register: Channel 0 PHY WL Control AC Register (Instance 1 of 3) (CH0_PHY_WL_AC_Control_0)
/** \brief This register is used for write-leveling support. (Instance 1 of 3)*/
//====================================================================

#define  MC_CH0_PHY_WL_AC_CONTROL_0_RESERVED1_MASK 0xffffffe0
#define  MC_CH0_PHY_WL_AC_CONTROL_0_RESERVED1_SHIFT 5
#define  MC_CH0_PHY_WL_AC_CONTROL_0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_AC_CONTROL_0_RESERVED1_MASK) >> MC_CH0_PHY_WL_AC_CONTROL_0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_AC_CONTROL_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_AC_CONTROL_0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_AC_CONTROL_0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_AC_CONTROL_0_PHY_WL_WCK_AC_DLY_MASK 0x1f
#define  MC_CH0_PHY_WL_AC_CONTROL_0_PHY_WL_WCK_AC_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_AC_CONTROL_0_PHY_WL_WCK_AC_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_AC_CONTROL_0_PHY_WL_WCK_AC_DLY_MASK) >> MC_CH0_PHY_WL_AC_CONTROL_0_PHY_WL_WCK_AC_DLY_SHIFT)
#define  MC_CH0_PHY_WL_AC_CONTROL_0_PHY_WL_WCK_AC_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_AC_CONTROL_0_PHY_WL_WCK_AC_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_AC_CONTROL_0_PHY_WL_WCK_AC_DLY_SHIFT))

//====================================================================
//Register: Channel 0 PHY WL Control AC Register (Instance 2 of 3) (CH0_PHY_WL_AC_Control_1)
/** \brief This register is used for write-leveling support. (Instance 2 of 3)*/
//====================================================================

#define  MC_CH0_PHY_WL_AC_CONTROL_1_RESERVED1_MASK 0xffffffe0
#define  MC_CH0_PHY_WL_AC_CONTROL_1_RESERVED1_SHIFT 5
#define  MC_CH0_PHY_WL_AC_CONTROL_1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_AC_CONTROL_1_RESERVED1_MASK) >> MC_CH0_PHY_WL_AC_CONTROL_1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_AC_CONTROL_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_AC_CONTROL_1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_AC_CONTROL_1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_AC_CONTROL_1_PHY_WL_WCK_AC_DLY_MASK 0x1f
#define  MC_CH0_PHY_WL_AC_CONTROL_1_PHY_WL_WCK_AC_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_AC_CONTROL_1_PHY_WL_WCK_AC_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_AC_CONTROL_1_PHY_WL_WCK_AC_DLY_MASK) >> MC_CH0_PHY_WL_AC_CONTROL_1_PHY_WL_WCK_AC_DLY_SHIFT)
#define  MC_CH0_PHY_WL_AC_CONTROL_1_PHY_WL_WCK_AC_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_AC_CONTROL_1_PHY_WL_WCK_AC_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_AC_CONTROL_1_PHY_WL_WCK_AC_DLY_SHIFT))

//====================================================================
//Register: Channel 0 PHY WL Control AC Register (Instance 3 of 3) (CH0_PHY_WL_AC_Control_2)
/** \brief This register is used for write-leveling support. (Instance 3 of 3)*/
//====================================================================

#define  MC_CH0_PHY_WL_AC_CONTROL_2_RESERVED1_MASK 0xffffffe0
#define  MC_CH0_PHY_WL_AC_CONTROL_2_RESERVED1_SHIFT 5
#define  MC_CH0_PHY_WL_AC_CONTROL_2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_AC_CONTROL_2_RESERVED1_MASK) >> MC_CH0_PHY_WL_AC_CONTROL_2_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_AC_CONTROL_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_AC_CONTROL_2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_AC_CONTROL_2_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_AC_CONTROL_2_PHY_WL_WCK_AC_DLY_MASK 0x1f
#define  MC_CH0_PHY_WL_AC_CONTROL_2_PHY_WL_WCK_AC_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_AC_CONTROL_2_PHY_WL_WCK_AC_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_AC_CONTROL_2_PHY_WL_WCK_AC_DLY_MASK) >> MC_CH0_PHY_WL_AC_CONTROL_2_PHY_WL_WCK_AC_DLY_SHIFT)
#define  MC_CH0_PHY_WL_AC_CONTROL_2_PHY_WL_WCK_AC_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_AC_CONTROL_2_PHY_WL_WCK_AC_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_AC_CONTROL_2_PHY_WL_WCK_AC_DLY_SHIFT))

//====================================================================
//Register: Channel 0 PHY RL Control Register CS0 B0 (CH0_PHY_RL_Control_CS0_B0)
/** \brief This register controls read leveling, which is used to calibrate the window used for gating DQS.*/
//====================================================================

#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B0_RESERVED1_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_CYCLE_DLY_MASK 0xf00
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_CYCLE_DLY_SHIFT 8
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_CYCLE_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_CYCLE_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_CYCLE_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_CYCLE_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_CYCLE_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_CYCLE_DLY_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_TAP_DLY_MASK 0xff
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_TAP_DLY_SHIFT 0
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_TAP_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_TAP_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_TAP_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_TAP_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_TAP_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_TAP_DLY_SHIFT))

//====================================================================
//Register: Channel 0 PHY RL Control Register CS0 B1 (CH0_PHY_RL_Control_CS0_B1)
/** \brief This register controls read leveling, which is used to calibrate the window used for gating DQS.*/
//====================================================================

#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B1_RESERVED1_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_CYCLE_DLY_MASK 0xf00
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_CYCLE_DLY_SHIFT 8
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_CYCLE_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_CYCLE_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_CYCLE_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_CYCLE_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_CYCLE_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_CYCLE_DLY_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_TAP_DLY_MASK 0xff
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_TAP_DLY_SHIFT 0
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_TAP_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_TAP_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_TAP_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_TAP_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_TAP_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_TAP_DLY_SHIFT))

//====================================================================
//Register: Channel 0 PHY CA Delay Register 0 (CH0_PHY_CA_Delay0)
/** \brief This register stores the CA delay for CA0, CA1, CA2 and CA3.*/
//====================================================================

#define  MC_CH0_PHY_CA_DELAY0_CA3_WCK_DELAY_MASK 0xf0000000
#define  MC_CH0_PHY_CA_DELAY0_CA3_WCK_DELAY_SHIFT 28
#define  MC_CH0_PHY_CA_DELAY0_CA3_WCK_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY0_CA3_WCK_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY0_CA3_WCK_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY0_CA3_WCK_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY0_CA3_WCK_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY0_CA3_WCK_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY0_CA3_DELAY_MASK 0xf000000
#define  MC_CH0_PHY_CA_DELAY0_CA3_DELAY_SHIFT 24
#define  MC_CH0_PHY_CA_DELAY0_CA3_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY0_CA3_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY0_CA3_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY0_CA3_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY0_CA3_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY0_CA3_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY0_CA2_WCK_DELAY_MASK 0xf00000
#define  MC_CH0_PHY_CA_DELAY0_CA2_WCK_DELAY_SHIFT 20
#define  MC_CH0_PHY_CA_DELAY0_CA2_WCK_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY0_CA2_WCK_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY0_CA2_WCK_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY0_CA2_WCK_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY0_CA2_WCK_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY0_CA2_WCK_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY0_CA2_DELAY_MASK 0xf0000
#define  MC_CH0_PHY_CA_DELAY0_CA2_DELAY_SHIFT 16
#define  MC_CH0_PHY_CA_DELAY0_CA2_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY0_CA2_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY0_CA2_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY0_CA2_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY0_CA2_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY0_CA2_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY0_CA1_WCK_DELAY_MASK 0xf000
#define  MC_CH0_PHY_CA_DELAY0_CA1_WCK_DELAY_SHIFT 12
#define  MC_CH0_PHY_CA_DELAY0_CA1_WCK_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY0_CA1_WCK_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY0_CA1_WCK_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY0_CA1_WCK_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY0_CA1_WCK_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY0_CA1_WCK_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY0_CA1_DELAY_MASK 0xf00
#define  MC_CH0_PHY_CA_DELAY0_CA1_DELAY_SHIFT 8
#define  MC_CH0_PHY_CA_DELAY0_CA1_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY0_CA1_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY0_CA1_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY0_CA1_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY0_CA1_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY0_CA1_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY0_CA0_WCK_DELAY_MASK 0xf0
#define  MC_CH0_PHY_CA_DELAY0_CA0_WCK_DELAY_SHIFT 4
#define  MC_CH0_PHY_CA_DELAY0_CA0_WCK_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY0_CA0_WCK_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY0_CA0_WCK_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY0_CA0_WCK_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY0_CA0_WCK_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY0_CA0_WCK_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY0_CA0_DELAY_MASK 0xf
#define  MC_CH0_PHY_CA_DELAY0_CA0_DELAY_SHIFT 0
#define  MC_CH0_PHY_CA_DELAY0_CA0_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY0_CA0_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY0_CA0_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY0_CA0_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY0_CA0_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY0_CA0_DELAY_SHIFT))

//====================================================================
//Register: Channel 0 PHY CA Delay Register 1 (CH0_PHY_CA_Delay1)
/** \brief This register stores the CA delay for CA5, CA6, CA7 and CA8.*/
//====================================================================

#define  MC_CH0_PHY_CA_DELAY1_CA8_WCK_DELAY_MASK 0xf0000000
#define  MC_CH0_PHY_CA_DELAY1_CA8_WCK_DELAY_SHIFT 28
#define  MC_CH0_PHY_CA_DELAY1_CA8_WCK_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY1_CA8_WCK_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY1_CA8_WCK_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY1_CA8_WCK_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY1_CA8_WCK_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY1_CA8_WCK_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY1_CA8_DELAY_MASK 0xf000000
#define  MC_CH0_PHY_CA_DELAY1_CA8_DELAY_SHIFT 24
#define  MC_CH0_PHY_CA_DELAY1_CA8_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY1_CA8_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY1_CA8_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY1_CA8_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY1_CA8_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY1_CA8_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY1_CA7_WCK_DELAY_MASK 0xf00000
#define  MC_CH0_PHY_CA_DELAY1_CA7_WCK_DELAY_SHIFT 20
#define  MC_CH0_PHY_CA_DELAY1_CA7_WCK_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY1_CA7_WCK_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY1_CA7_WCK_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY1_CA7_WCK_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY1_CA7_WCK_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY1_CA7_WCK_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY1_CA7_DELAY_MASK 0xf0000
#define  MC_CH0_PHY_CA_DELAY1_CA7_DELAY_SHIFT 16
#define  MC_CH0_PHY_CA_DELAY1_CA7_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY1_CA7_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY1_CA7_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY1_CA7_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY1_CA7_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY1_CA7_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY1_CA6_WCK_DELAY_MASK 0xf000
#define  MC_CH0_PHY_CA_DELAY1_CA6_WCK_DELAY_SHIFT 12
#define  MC_CH0_PHY_CA_DELAY1_CA6_WCK_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY1_CA6_WCK_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY1_CA6_WCK_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY1_CA6_WCK_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY1_CA6_WCK_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY1_CA6_WCK_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY1_CA6_DELAY_MASK 0xf00
#define  MC_CH0_PHY_CA_DELAY1_CA6_DELAY_SHIFT 8
#define  MC_CH0_PHY_CA_DELAY1_CA6_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY1_CA6_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY1_CA6_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY1_CA6_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY1_CA6_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY1_CA6_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY1_CA5_WCK_WCK_DELAY_MASK 0xf0
#define  MC_CH0_PHY_CA_DELAY1_CA5_WCK_WCK_DELAY_SHIFT 4
#define  MC_CH0_PHY_CA_DELAY1_CA5_WCK_WCK_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY1_CA5_WCK_WCK_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY1_CA5_WCK_WCK_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY1_CA5_WCK_WCK_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY1_CA5_WCK_WCK_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY1_CA5_WCK_WCK_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY1_CA5_DELAY_MASK 0xf
#define  MC_CH0_PHY_CA_DELAY1_CA5_DELAY_SHIFT 0
#define  MC_CH0_PHY_CA_DELAY1_CA5_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY1_CA5_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY1_CA5_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY1_CA5_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY1_CA5_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY1_CA5_DELAY_SHIFT))

//====================================================================
//Register: Channel 0 PHY CA Delay Register 2 (CH0_PHY_CA_Delay2)
/** \brief This register stores the CA delay for CA4 and CA9.*/
//====================================================================

#define  MC_CH0_PHY_CA_DELAY2_CKP_WCK_DELAY_MASK 0xf0000000
#define  MC_CH0_PHY_CA_DELAY2_CKP_WCK_DELAY_SHIFT 28
#define  MC_CH0_PHY_CA_DELAY2_CKP_WCK_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY2_CKP_WCK_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY2_CKP_WCK_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY2_CKP_WCK_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY2_CKP_WCK_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY2_CKP_WCK_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY2_CKP_DELAY_MASK 0xf000000
#define  MC_CH0_PHY_CA_DELAY2_CKP_DELAY_SHIFT 24
#define  MC_CH0_PHY_CA_DELAY2_CKP_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY2_CKP_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY2_CKP_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY2_CKP_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY2_CKP_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY2_CKP_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY2_CKN_WCK_DELAY_MASK 0xf00000
#define  MC_CH0_PHY_CA_DELAY2_CKN_WCK_DELAY_SHIFT 20
#define  MC_CH0_PHY_CA_DELAY2_CKN_WCK_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY2_CKN_WCK_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY2_CKN_WCK_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY2_CKN_WCK_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY2_CKN_WCK_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY2_CKN_WCK_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY2_CKN_DELAY_MASK 0xf0000
#define  MC_CH0_PHY_CA_DELAY2_CKN_DELAY_SHIFT 16
#define  MC_CH0_PHY_CA_DELAY2_CKN_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY2_CKN_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY2_CKN_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY2_CKN_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY2_CKN_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY2_CKN_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY2_CA9_WCK_DELAY_MASK 0xf000
#define  MC_CH0_PHY_CA_DELAY2_CA9_WCK_DELAY_SHIFT 12
#define  MC_CH0_PHY_CA_DELAY2_CA9_WCK_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY2_CA9_WCK_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY2_CA9_WCK_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY2_CA9_WCK_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY2_CA9_WCK_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY2_CA9_WCK_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY2_CA9_DELAY_MASK 0xf00
#define  MC_CH0_PHY_CA_DELAY2_CA9_DELAY_SHIFT 8
#define  MC_CH0_PHY_CA_DELAY2_CA9_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY2_CA9_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY2_CA9_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY2_CA9_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY2_CA9_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY2_CA9_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY2_CA4_WCK_DELAY_MASK 0xf0
#define  MC_CH0_PHY_CA_DELAY2_CA4_WCK_DELAY_SHIFT 4
#define  MC_CH0_PHY_CA_DELAY2_CA4_WCK_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY2_CA4_WCK_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY2_CA4_WCK_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY2_CA4_WCK_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY2_CA4_WCK_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY2_CA4_WCK_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY2_CA4_DELAY_MASK 0xf
#define  MC_CH0_PHY_CA_DELAY2_CA4_DELAY_SHIFT 0
#define  MC_CH0_PHY_CA_DELAY2_CA4_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY2_CA4_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY2_CA4_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY2_CA4_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY2_CA4_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY2_CA4_DELAY_SHIFT))

//====================================================================
//Register: Channel 0 PHY CA Delay Register 3 (CH0_PHY_CA_Delay3)
/** \brief This register stores the CA delay for CKE, CSN, ODT and Other PAD.*/
//====================================================================

#define  MC_CH0_PHY_CA_DELAY3_OTHER_PAD_WCK_DELAY_MASK 0xf0000000
#define  MC_CH0_PHY_CA_DELAY3_OTHER_PAD_WCK_DELAY_SHIFT 28
#define  MC_CH0_PHY_CA_DELAY3_OTHER_PAD_WCK_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY3_OTHER_PAD_WCK_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY3_OTHER_PAD_WCK_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY3_OTHER_PAD_WCK_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY3_OTHER_PAD_WCK_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY3_OTHER_PAD_WCK_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY3_OTHER_PAD_DELAY_MASK 0xf000000
#define  MC_CH0_PHY_CA_DELAY3_OTHER_PAD_DELAY_SHIFT 24
#define  MC_CH0_PHY_CA_DELAY3_OTHER_PAD_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY3_OTHER_PAD_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY3_OTHER_PAD_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY3_OTHER_PAD_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY3_OTHER_PAD_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY3_OTHER_PAD_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY3_ODT_WCK_DELAY_MASK 0xf00000
#define  MC_CH0_PHY_CA_DELAY3_ODT_WCK_DELAY_SHIFT 20
#define  MC_CH0_PHY_CA_DELAY3_ODT_WCK_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY3_ODT_WCK_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY3_ODT_WCK_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY3_ODT_WCK_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY3_ODT_WCK_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY3_ODT_WCK_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY3_ODT_DELAY_MASK 0xf0000
#define  MC_CH0_PHY_CA_DELAY3_ODT_DELAY_SHIFT 16
#define  MC_CH0_PHY_CA_DELAY3_ODT_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY3_ODT_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY3_ODT_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY3_ODT_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY3_ODT_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY3_ODT_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY3_CSN_WCK_DELAY_MASK 0xf000
#define  MC_CH0_PHY_CA_DELAY3_CSN_WCK_DELAY_SHIFT 12
#define  MC_CH0_PHY_CA_DELAY3_CSN_WCK_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY3_CSN_WCK_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY3_CSN_WCK_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY3_CSN_WCK_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY3_CSN_WCK_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY3_CSN_WCK_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY3_CSN_DELAY_MASK 0xf00
#define  MC_CH0_PHY_CA_DELAY3_CSN_DELAY_SHIFT 8
#define  MC_CH0_PHY_CA_DELAY3_CSN_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY3_CSN_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY3_CSN_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY3_CSN_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY3_CSN_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY3_CSN_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY3_CKE_WCK_DELAY_MASK 0xf0
#define  MC_CH0_PHY_CA_DELAY3_CKE_WCK_DELAY_SHIFT 4
#define  MC_CH0_PHY_CA_DELAY3_CKE_WCK_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY3_CKE_WCK_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY3_CKE_WCK_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY3_CKE_WCK_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY3_CKE_WCK_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY3_CKE_WCK_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY3_CKE_DELAY_MASK 0xf
#define  MC_CH0_PHY_CA_DELAY3_CKE_DELAY_SHIFT 0
#define  MC_CH0_PHY_CA_DELAY3_CKE_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY3_CKE_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY3_CKE_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY3_CKE_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY3_CKE_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY3_CKE_DELAY_SHIFT))

//====================================================================
//Register: Channel 0 PHY PRBS Status and Mask Register B0 (CH0_PHY_PRBS_Stat_Mask_B0)
/** \brief This register controls PRBS test bit mask for each Subphy, and records the error status for the related bits.*/
//====================================================================

#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_RESERVED1_MASK 0xfe000000
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_RESERVED1_SHIFT 25
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_B0_RESERVED1_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_B0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_B0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_B0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_ERROR_STAT_MASK 0x1ff0000
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_ERROR_STAT_SHIFT 16
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_ERROR_STAT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_ERROR_STAT_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_ERROR_STAT_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_ERROR_STAT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_ERROR_STAT_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_ERROR_STAT_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_RESERVED2_MASK 0xfe00
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_RESERVED2_SHIFT 9
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_B0_RESERVED2_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_B0_RESERVED2_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_B0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_B0_RESERVED2_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_MASK_MASK 0x1ff
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_MASK_SHIFT 0
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_MASK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_MASK_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_MASK_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_MASK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_MASK_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_MASK_SHIFT))

//====================================================================
//Register: Channel 0 PHY PRBS Status and Mask Register B1 (CH0_PHY_PRBS_Stat_Mask_B1)
/** \brief This register controls PRBS test bit mask for each Subphy, and records the error status for the related bits.*/
//====================================================================

#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_RESERVED1_MASK 0xfe000000
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_RESERVED1_SHIFT 25
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_B1_RESERVED1_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_B1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_B1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_B1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_ERROR_STAT_MASK 0x1ff0000
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_ERROR_STAT_SHIFT 16
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_ERROR_STAT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_ERROR_STAT_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_ERROR_STAT_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_ERROR_STAT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_ERROR_STAT_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_ERROR_STAT_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_RESERVED2_MASK 0xfe00
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_RESERVED2_SHIFT 9
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_B1_RESERVED2_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_B1_RESERVED2_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_B1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_B1_RESERVED2_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_MASK_MASK 0x1ff
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_MASK_SHIFT 0
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_MASK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_MASK_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_MASK_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_MASK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_MASK_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_MASK_SHIFT))

//====================================================================
//Register: Channel 0 PHY PRBS Status and Mask Register C0 (CH0_PHY_PRBS_Stat_Mask_C0)
/** \brief This register controls PRBS test bit mask for each Subphy, and records the error status for the related bits.*/
//====================================================================

#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_RESERVED1_MASK 0xfc000000
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_RESERVED1_SHIFT 26
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C0_RESERVED1_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_ERROR_STAT_MASK 0x3ff0000
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_ERROR_STAT_SHIFT 16
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_ERROR_STAT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_ERROR_STAT_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_ERROR_STAT_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_ERROR_STAT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_ERROR_STAT_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_ERROR_STAT_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_RESERVED2_MASK 0xfc00
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_RESERVED2_SHIFT 10
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C0_RESERVED2_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C0_RESERVED2_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C0_RESERVED2_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_MASK_MASK 0x3ff
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_MASK_SHIFT 0
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_MASK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_MASK_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_MASK_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_MASK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_MASK_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_MASK_SHIFT))

//====================================================================
//Register: Channel 0 PHY PRBS Status and Mask Register C1 (CH0_PHY_PRBS_Stat_Mask_C1)
/** \brief This register controls PRBS test bit mask for each Subphy, and records the error status for the related bits.*/
//====================================================================

#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_RESERVED1_MASK 0xfc000000
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_RESERVED1_SHIFT 26
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C1_RESERVED1_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_ERROR_STAT_MASK 0x3ff0000
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_ERROR_STAT_SHIFT 16
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_ERROR_STAT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_ERROR_STAT_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_ERROR_STAT_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_ERROR_STAT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_ERROR_STAT_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_ERROR_STAT_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_RESERVED2_MASK 0xfc00
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_RESERVED2_SHIFT 10
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C1_RESERVED2_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C1_RESERVED2_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C1_RESERVED2_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_MASK_MASK 0x3ff
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_MASK_SHIFT 0
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_MASK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_MASK_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_MASK_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_MASK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_MASK_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_MASK_SHIFT))

//====================================================================
//Register: Channel 0 PHY PRBS Status and Mask Register C2 (CH0_PHY_PRBS_Stat_Mask_C2)
/** \brief This register controls PRBS test bit mask for each Subphy, and records the error status for the related bits.*/
//====================================================================

#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_RESERVED1_MASK 0xfc000000
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_RESERVED1_SHIFT 26
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C2_RESERVED1_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C2_RESERVED1_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C2_RESERVED1_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_ERROR_STAT_MASK 0x3ff0000
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_ERROR_STAT_SHIFT 16
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_ERROR_STAT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_ERROR_STAT_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_ERROR_STAT_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_ERROR_STAT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_ERROR_STAT_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_ERROR_STAT_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_RESERVED2_MASK 0xfc00
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_RESERVED2_SHIFT 10
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C2_RESERVED2_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C2_RESERVED2_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C2_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C2_RESERVED2_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_MASK_MASK 0x3ff
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_MASK_SHIFT 0
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_MASK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_MASK_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_MASK_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_MASK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_MASK_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_MASK_SHIFT))

//====================================================================
//Register: Channel 0 PHY PRBS Status and Mask Register C3 (CH0_PHY_PRBS_Stat_Mask_C3)
/** \brief This register controls PRBS test bit mask for each Subphy, and records the error status for the related bits.*/
//====================================================================

#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_RESERVED1_MASK 0xfc000000
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_RESERVED1_SHIFT 26
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C3_RESERVED1_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C3_RESERVED1_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C3_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C3_RESERVED1_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_ERROR_STAT_MASK 0x3ff0000
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_ERROR_STAT_SHIFT 16
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_ERROR_STAT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_ERROR_STAT_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_ERROR_STAT_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_ERROR_STAT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_ERROR_STAT_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_ERROR_STAT_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_RESERVED2_MASK 0xfc00
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_RESERVED2_SHIFT 10
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C3_RESERVED2_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C3_RESERVED2_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C3_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C3_RESERVED2_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_MASK_MASK 0x3ff
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_MASK_SHIFT 0
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_MASK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_MASK_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_MASK_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_MASK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_MASK_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_MASK_SHIFT))

//====================================================================
//Register: Channel 0 PHY PRBS Subphy Status Register (CH0_PHY_PRBS_Subphy_Stat)
/** \brief This register records each Subphy's PRBS test result.*/
//====================================================================

#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED1_MASK 0xc0000000
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED1_SHIFT 30
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED1_MASK) >> MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED1_SHIFT)
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED1_SHIFT))

#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_NEG_ERROR_MASK 0x3e000000
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_NEG_ERROR_SHIFT 25
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_NEG_ERROR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_NEG_ERROR_MASK) >> MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_NEG_ERROR_SHIFT)
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_NEG_ERROR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_NEG_ERROR_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_NEG_ERROR_SHIFT))

#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_NEG_ERROR_MASK 0x1ff0000
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_NEG_ERROR_SHIFT 16
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_NEG_ERROR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_NEG_ERROR_MASK) >> MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_NEG_ERROR_SHIFT)
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_NEG_ERROR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_NEG_ERROR_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_NEG_ERROR_SHIFT))

#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED2_MASK 0xc000
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED2_SHIFT 14
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED2_MASK) >> MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED2_SHIFT)
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED2_SHIFT))

#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_POS_ERROR_MASK 0x3e00
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_POS_ERROR_SHIFT 9
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_POS_ERROR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_POS_ERROR_MASK) >> MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_POS_ERROR_SHIFT)
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_POS_ERROR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_POS_ERROR_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_POS_ERROR_SHIFT))

#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_POS_ERROR_MASK 0x1ff
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_POS_ERROR_SHIFT 0
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_POS_ERROR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_POS_ERROR_MASK) >> MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_POS_ERROR_SHIFT)
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_POS_ERROR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_POS_ERROR_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_POS_ERROR_SHIFT))

//====================================================================
//Register: Channel 0 PHY PRBS User Pattern Register (CH0_PHY_PRBS_User_Pattern)
/** \brief This register controls PRBS user defined test pattern.*/
//====================================================================

#define  MC_CH0_PHY_PRBS_USER_PATTERN_PRBS_USER_PATTERN_MASK 0xffffffff
#define  MC_CH0_PHY_PRBS_USER_PATTERN_PRBS_USER_PATTERN_SHIFT 0
#define  MC_CH0_PHY_PRBS_USER_PATTERN_PRBS_USER_PATTERN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_USER_PATTERN_PRBS_USER_PATTERN_MASK) >> MC_CH0_PHY_PRBS_USER_PATTERN_PRBS_USER_PATTERN_SHIFT)
#define  MC_CH0_PHY_PRBS_USER_PATTERN_PRBS_USER_PATTERN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_USER_PATTERN_PRBS_USER_PATTERN_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_USER_PATTERN_PRBS_USER_PATTERN_SHIFT))

//====================================================================
//Register: Channel 0 PHY PRBS Control0 Register (CH0_PHY_PRBS_Control0)
/** \brief This register controls PRBS work style.*/
//====================================================================

#define  MC_CH0_PHY_PRBS_CONTROL0_RESERVED1_MASK 0xfc000000
#define  MC_CH0_PHY_PRBS_CONTROL0_RESERVED1_SHIFT 26
#define  MC_CH0_PHY_PRBS_CONTROL0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_RESERVED1_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_ADCM_DDRMODE_MASK 0x2000000
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_ADCM_DDRMODE_SHIFT 25
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_ADCM_DDRMODE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_PRBS_ADCM_DDRMODE_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_PRBS_ADCM_DDRMODE_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_ADCM_DDRMODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_PRBS_ADCM_DDRMODE_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_PRBS_ADCM_DDRMODE_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_ADCM_SDR_MASK 0x1000000
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_ADCM_SDR_SHIFT 24
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_ADCM_SDR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_PRBS_ADCM_SDR_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_PRBS_ADCM_SDR_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_ADCM_SDR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_PRBS_ADCM_SDR_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_PRBS_ADCM_SDR_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_RFIFO_RDPTR_DLY_MASK 0xf00000
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_RFIFO_RDPTR_DLY_SHIFT 20
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_RFIFO_RDPTR_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_PRBS_RFIFO_RDPTR_DLY_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_PRBS_RFIFO_RDPTR_DLY_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_RFIFO_RDPTR_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_PRBS_RFIFO_RDPTR_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_PRBS_RFIFO_RDPTR_DLY_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_INV_MASK_SEL_MASK 0x80000
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_INV_MASK_SEL_SHIFT 19
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_INV_MASK_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_PRBS_INV_MASK_SEL_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_PRBS_INV_MASK_SEL_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_INV_MASK_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_PRBS_INV_MASK_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_PRBS_INV_MASK_SEL_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_CK_DEBUG_MODE_MASK 0x40000
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_CK_DEBUG_MODE_SHIFT 18
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_CK_DEBUG_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_PRBS_CK_DEBUG_MODE_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_PRBS_CK_DEBUG_MODE_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_CK_DEBUG_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_PRBS_CK_DEBUG_MODE_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_PRBS_CK_DEBUG_MODE_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_USER_MODE_MASK 0x20000
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_USER_MODE_SHIFT 17
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_USER_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_PRBS_USER_MODE_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_PRBS_USER_MODE_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_USER_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_PRBS_USER_MODE_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_PRBS_USER_MODE_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_START_MASK 0x10000
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_START_SHIFT 16
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_START_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_PRBS_START_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_PRBS_START_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_START_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_PRBS_START_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_PRBS_START_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL0_RESERVED2_MASK 0xc000
#define  MC_CH0_PHY_PRBS_CONTROL0_RESERVED2_SHIFT 14
#define  MC_CH0_PHY_PRBS_CONTROL0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_RESERVED2_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_RESERVED2_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_RESERVED2_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_CKP_DEBUG_VALUE_MASK 0x3e00
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_CKP_DEBUG_VALUE_SHIFT 9
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_CKP_DEBUG_VALUE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_PRBS_CKP_DEBUG_VALUE_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_PRBS_CKP_DEBUG_VALUE_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_CKP_DEBUG_VALUE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_PRBS_CKP_DEBUG_VALUE_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_PRBS_CKP_DEBUG_VALUE_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_QSP_DEBUG_VALUE_MASK 0x1ff
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_QSP_DEBUG_VALUE_SHIFT 0
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_QSP_DEBUG_VALUE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_PRBS_QSP_DEBUG_VALUE_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_PRBS_QSP_DEBUG_VALUE_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_QSP_DEBUG_VALUE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_PRBS_QSP_DEBUG_VALUE_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_PRBS_QSP_DEBUG_VALUE_SHIFT))

//====================================================================
//Register: Channel 0 PHY PRBS Control1 Register (CH0_PHY_PRBS_Control1)
/** \brief This register controls PRBS work style.*/
//====================================================================

#define  MC_CH0_PHY_PRBS_CONTROL1_RESERVED1_MASK 0xc0000000
#define  MC_CH0_PHY_PRBS_CONTROL1_RESERVED1_SHIFT 30
#define  MC_CH0_PHY_PRBS_CONTROL1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL1_RESERVED1_MASK) >> MC_CH0_PHY_PRBS_CONTROL1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD4_DLY_MASK 0x3e000000
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD4_DLY_SHIFT 25
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD4_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD4_DLY_MASK) >> MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD4_DLY_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD4_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD4_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD4_DLY_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD3_DLY_MASK 0x1f00000
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD3_DLY_SHIFT 20
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD3_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD3_DLY_MASK) >> MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD3_DLY_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD3_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD3_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD3_DLY_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD2_DLY_MASK 0xf8000
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD2_DLY_SHIFT 15
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD2_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD2_DLY_MASK) >> MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD2_DLY_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD2_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD2_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD2_DLY_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD1_DLY_MASK 0x7c00
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD1_DLY_SHIFT 10
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD1_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD1_DLY_MASK) >> MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD1_DLY_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD1_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD1_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD1_DLY_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD0_DLY_MASK 0x3e0
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD0_DLY_SHIFT 5
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD0_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD0_DLY_MASK) >> MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD0_DLY_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD0_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD0_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD0_DLY_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_DATA_DLY_MASK 0x1f
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_DATA_DLY_SHIFT 0
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_DATA_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL1_PRBS_DATA_DLY_MASK) >> MC_CH0_PHY_PRBS_CONTROL1_PRBS_DATA_DLY_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_DATA_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL1_PRBS_DATA_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL1_PRBS_DATA_DLY_SHIFT))

//====================================================================
//Register: Channel 0 memory folding control Register (CH0_mem_fold_ctl)
/** \brief This is a control register for memory folding logic.*/
//====================================================================

#define  MC_CH0_MEM_FOLD_CTL_RESERVED1_MASK 0xffffffe0
#define  MC_CH0_MEM_FOLD_CTL_RESERVED1_SHIFT 5
#define  MC_CH0_MEM_FOLD_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_CTL_RESERVED1_MASK) >> MC_CH0_MEM_FOLD_CTL_RESERVED1_SHIFT)
#define  MC_CH0_MEM_FOLD_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_CTL_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_CTL_RESERVED1_SHIFT))

#define  MC_CH0_MEM_FOLD_CTL_MEM_FOLD_HALF_SEL_CS0_MASK 0x10
#define  MC_CH0_MEM_FOLD_CTL_MEM_FOLD_HALF_SEL_CS0_SHIFT 4
#define  MC_CH0_MEM_FOLD_CTL_MEM_FOLD_HALF_SEL_CS0_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_CTL_MEM_FOLD_HALF_SEL_CS0_MASK) >> MC_CH0_MEM_FOLD_CTL_MEM_FOLD_HALF_SEL_CS0_SHIFT)
#define  MC_CH0_MEM_FOLD_CTL_MEM_FOLD_HALF_SEL_CS0_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_CTL_MEM_FOLD_HALF_SEL_CS0_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_CTL_MEM_FOLD_HALF_SEL_CS0_SHIFT))

#define  MC_CH0_MEM_FOLD_CTL_RESERVED2_MASK 0xe
#define  MC_CH0_MEM_FOLD_CTL_RESERVED2_SHIFT 1
#define  MC_CH0_MEM_FOLD_CTL_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_CTL_RESERVED2_MASK) >> MC_CH0_MEM_FOLD_CTL_RESERVED2_SHIFT)
#define  MC_CH0_MEM_FOLD_CTL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_CTL_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_CTL_RESERVED2_SHIFT))

#define  MC_CH0_MEM_FOLD_CTL_MEM_FOLD_EN_CS0_MASK 0x1
#define  MC_CH0_MEM_FOLD_CTL_MEM_FOLD_EN_CS0_SHIFT 0
#define  MC_CH0_MEM_FOLD_CTL_MEM_FOLD_EN_CS0_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_CTL_MEM_FOLD_EN_CS0_MASK) >> MC_CH0_MEM_FOLD_CTL_MEM_FOLD_EN_CS0_SHIFT)
#define  MC_CH0_MEM_FOLD_CTL_MEM_FOLD_EN_CS0_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_CTL_MEM_FOLD_EN_CS0_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_CTL_MEM_FOLD_EN_CS0_SHIFT))

//====================================================================
//Register: Channel 0 memory folding corrupt address Register (CH0_mem_fold_bad_addr)
/** \brief This register is used to programme CS and Row address with CS(in binary) and tag.
   These addresses can be read out from this regsiter by writing CS(in binary) and tag into <<xref=mem_fold_read>>.*/
//====================================================================

#define  MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ADDR_CS_MASK 0xc0000000
#define  MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ADDR_CS_SHIFT 30
#define  MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ADDR_CS_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ADDR_CS_MASK) >> MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ADDR_CS_SHIFT)
#define  MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ADDR_CS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ADDR_CS_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ADDR_CS_SHIFT))

#define  MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ADDR_TAG_MASK 0x3f000000
#define  MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ADDR_TAG_SHIFT 24
#define  MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ADDR_TAG_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ADDR_TAG_MASK) >> MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ADDR_TAG_SHIFT)
#define  MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ADDR_TAG_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ADDR_TAG_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ADDR_TAG_SHIFT))

#define  MC_CH0_MEM_FOLD_BAD_ADDR_RESERVED1_MASK 0xe00000
#define  MC_CH0_MEM_FOLD_BAD_ADDR_RESERVED1_SHIFT 21
#define  MC_CH0_MEM_FOLD_BAD_ADDR_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_BAD_ADDR_RESERVED1_MASK) >> MC_CH0_MEM_FOLD_BAD_ADDR_RESERVED1_SHIFT)
#define  MC_CH0_MEM_FOLD_BAD_ADDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_BAD_ADDR_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_BAD_ADDR_RESERVED1_SHIFT))

#define  MC_CH0_MEM_FOLD_BAD_ADDR_CS0_MASK 0x100000
#define  MC_CH0_MEM_FOLD_BAD_ADDR_CS0_SHIFT 20
#define  MC_CH0_MEM_FOLD_BAD_ADDR_CS0_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_BAD_ADDR_CS0_MASK) >> MC_CH0_MEM_FOLD_BAD_ADDR_CS0_SHIFT)
#define  MC_CH0_MEM_FOLD_BAD_ADDR_CS0_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_BAD_ADDR_CS0_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_BAD_ADDR_CS0_SHIFT))

#define  MC_CH0_MEM_FOLD_BAD_ADDR_RESERVED2_MASK 0xc0000
#define  MC_CH0_MEM_FOLD_BAD_ADDR_RESERVED2_SHIFT 18
#define  MC_CH0_MEM_FOLD_BAD_ADDR_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_BAD_ADDR_RESERVED2_MASK) >> MC_CH0_MEM_FOLD_BAD_ADDR_RESERVED2_SHIFT)
#define  MC_CH0_MEM_FOLD_BAD_ADDR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_BAD_ADDR_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_BAD_ADDR_RESERVED2_SHIFT))

#define  MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ROW_ADDR_MASK 0x3ffff
#define  MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ROW_ADDR_SHIFT 0
#define  MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ROW_ADDR_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ROW_ADDR_MASK) >> MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ROW_ADDR_SHIFT)
#define  MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ROW_ADDR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ROW_ADDR_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_BAD_ADDR_BAD_ROW_ADDR_SHIFT))

//====================================================================
//Register: Channel 0 memory folding replace address Register (CH0_mem_fold_rep_addr)
/** \brief This register is used to programme CS and Row address with CS(in binary) and tag.
   These addresses can be read out from this regsiter by writing CS(in binary) and tag into <<xref=mem_fold_read>>.*/
//====================================================================

#define  MC_CH0_MEM_FOLD_REP_ADDR_REP_ADDR_CS_MASK 0xc0000000
#define  MC_CH0_MEM_FOLD_REP_ADDR_REP_ADDR_CS_SHIFT 30
#define  MC_CH0_MEM_FOLD_REP_ADDR_REP_ADDR_CS_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_REP_ADDR_REP_ADDR_CS_MASK) >> MC_CH0_MEM_FOLD_REP_ADDR_REP_ADDR_CS_SHIFT)
#define  MC_CH0_MEM_FOLD_REP_ADDR_REP_ADDR_CS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_REP_ADDR_REP_ADDR_CS_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_REP_ADDR_REP_ADDR_CS_SHIFT))

#define  MC_CH0_MEM_FOLD_REP_ADDR_REP_ADDR_TAG_MASK 0x3f000000
#define  MC_CH0_MEM_FOLD_REP_ADDR_REP_ADDR_TAG_SHIFT 24
#define  MC_CH0_MEM_FOLD_REP_ADDR_REP_ADDR_TAG_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_REP_ADDR_REP_ADDR_TAG_MASK) >> MC_CH0_MEM_FOLD_REP_ADDR_REP_ADDR_TAG_SHIFT)
#define  MC_CH0_MEM_FOLD_REP_ADDR_REP_ADDR_TAG_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_REP_ADDR_REP_ADDR_TAG_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_REP_ADDR_REP_ADDR_TAG_SHIFT))

#define  MC_CH0_MEM_FOLD_REP_ADDR_RESERVED1_MASK 0xe00000
#define  MC_CH0_MEM_FOLD_REP_ADDR_RESERVED1_SHIFT 21
#define  MC_CH0_MEM_FOLD_REP_ADDR_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_REP_ADDR_RESERVED1_MASK) >> MC_CH0_MEM_FOLD_REP_ADDR_RESERVED1_SHIFT)
#define  MC_CH0_MEM_FOLD_REP_ADDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_REP_ADDR_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_REP_ADDR_RESERVED1_SHIFT))

#define  MC_CH0_MEM_FOLD_REP_ADDR_CS0_MASK 0x100000
#define  MC_CH0_MEM_FOLD_REP_ADDR_CS0_SHIFT 20
#define  MC_CH0_MEM_FOLD_REP_ADDR_CS0_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_REP_ADDR_CS0_MASK) >> MC_CH0_MEM_FOLD_REP_ADDR_CS0_SHIFT)
#define  MC_CH0_MEM_FOLD_REP_ADDR_CS0_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_REP_ADDR_CS0_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_REP_ADDR_CS0_SHIFT))

#define  MC_CH0_MEM_FOLD_REP_ADDR_RESERVED2_MASK 0xc0000
#define  MC_CH0_MEM_FOLD_REP_ADDR_RESERVED2_SHIFT 18
#define  MC_CH0_MEM_FOLD_REP_ADDR_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_REP_ADDR_RESERVED2_MASK) >> MC_CH0_MEM_FOLD_REP_ADDR_RESERVED2_SHIFT)
#define  MC_CH0_MEM_FOLD_REP_ADDR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_REP_ADDR_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_REP_ADDR_RESERVED2_SHIFT))

#define  MC_CH0_MEM_FOLD_REP_ADDR_REP_ROW_ADDR_MASK 0x3ffff
#define  MC_CH0_MEM_FOLD_REP_ADDR_REP_ROW_ADDR_SHIFT 0
#define  MC_CH0_MEM_FOLD_REP_ADDR_REP_ROW_ADDR_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_REP_ADDR_REP_ROW_ADDR_MASK) >> MC_CH0_MEM_FOLD_REP_ADDR_REP_ROW_ADDR_SHIFT)
#define  MC_CH0_MEM_FOLD_REP_ADDR_REP_ROW_ADDR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_REP_ADDR_REP_ROW_ADDR_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_REP_ADDR_REP_ROW_ADDR_SHIFT))

//====================================================================
//Register: Channel 0 memory folding read Register (CH0_mem_fold_read)
/** \brief This register is used to read out programmed CS and Row address.
   Write CS(in binary) and tag in this register and then read out from <<xref=mem_fold_bad_addr>> or <<xref=mem_fold_rep_addr>>.*/
//====================================================================

#define  MC_CH0_MEM_FOLD_READ_RESERVED1_MASK 0xffffff00
#define  MC_CH0_MEM_FOLD_READ_RESERVED1_SHIFT 8
#define  MC_CH0_MEM_FOLD_READ_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_READ_RESERVED1_MASK) >> MC_CH0_MEM_FOLD_READ_RESERVED1_SHIFT)
#define  MC_CH0_MEM_FOLD_READ_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_READ_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_READ_RESERVED1_SHIFT))

#define  MC_CH0_MEM_FOLD_READ_RD_ADDR_CS_MASK 0xc0
#define  MC_CH0_MEM_FOLD_READ_RD_ADDR_CS_SHIFT 6
#define  MC_CH0_MEM_FOLD_READ_RD_ADDR_CS_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_READ_RD_ADDR_CS_MASK) >> MC_CH0_MEM_FOLD_READ_RD_ADDR_CS_SHIFT)
#define  MC_CH0_MEM_FOLD_READ_RD_ADDR_CS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_READ_RD_ADDR_CS_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_READ_RD_ADDR_CS_SHIFT))

#define  MC_CH0_MEM_FOLD_READ_RD_ADDR_TAG_MASK 0x3f
#define  MC_CH0_MEM_FOLD_READ_RD_ADDR_TAG_SHIFT 0
#define  MC_CH0_MEM_FOLD_READ_RD_ADDR_TAG_MASK_SHIFT(reg) (((reg) & MC_CH0_MEM_FOLD_READ_RD_ADDR_TAG_MASK) >> MC_CH0_MEM_FOLD_READ_RD_ADDR_TAG_SHIFT)
#define  MC_CH0_MEM_FOLD_READ_RD_ADDR_TAG_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MEM_FOLD_READ_RD_ADDR_TAG_MASK) | (((uint32_t)val) << MC_CH0_MEM_FOLD_READ_RD_ADDR_TAG_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 0 Low (TZ_Range0_Low)
/** \brief Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE0_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE0_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE0_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE0_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE0_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE0_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE0_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE0_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_RESERVED1_MASK) >> MC_TZ_RANGE0_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE0_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE0_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE0_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE0_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE0_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE0_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE0_LOW_RESERVED2_MASK 0x80
#define  MC_TZ_RANGE0_LOW_RESERVED2_SHIFT 7
#define  MC_TZ_RANGE0_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_RESERVED2_MASK) >> MC_TZ_RANGE0_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE0_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE0_LOW_RZ_ENB_UR_MASK 0x40
#define  MC_TZ_RANGE0_LOW_RZ_ENB_UR_SHIFT 6
#define  MC_TZ_RANGE0_LOW_RZ_ENB_UR_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_RZ_ENB_UR_MASK) >> MC_TZ_RANGE0_LOW_RZ_ENB_UR_SHIFT)
#define  MC_TZ_RANGE0_LOW_RZ_ENB_UR_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_RZ_ENB_UR_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_RZ_ENB_UR_SHIFT))

#define  MC_TZ_RANGE0_LOW_TZ_PERM_UR_MASK 0x30
#define  MC_TZ_RANGE0_LOW_TZ_PERM_UR_SHIFT 4
#define  MC_TZ_RANGE0_LOW_TZ_PERM_UR_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_TZ_PERM_UR_MASK) >> MC_TZ_RANGE0_LOW_TZ_PERM_UR_SHIFT)
#define  MC_TZ_RANGE0_LOW_TZ_PERM_UR_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_TZ_PERM_UR_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_TZ_PERM_UR_SHIFT))

#define  MC_TZ_RANGE0_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE0_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE0_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE0_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE0_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE0_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE0_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE0_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE0_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE0_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE0_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE0_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE0_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE0_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE0_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 0 High (TZ_Range0_High)
/** \brief Note: This register is for LPAE only.
      Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE0_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE0_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE0_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE0_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE0_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE0_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE0_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE0_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE0_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE0_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 1 Low (TZ_Range1_Low)
/** \brief Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE1_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE1_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE1_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE1_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE1_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE1_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE1_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE1_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_LOW_RESERVED1_MASK) >> MC_TZ_RANGE1_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE1_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE1_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE1_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE1_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE1_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE1_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE1_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE1_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE1_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_LOW_RESERVED2_MASK) >> MC_TZ_RANGE1_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE1_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE1_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE1_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE1_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE1_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE1_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE1_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE1_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE1_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE1_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE1_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE1_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE1_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE1_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE1_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE1_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 1 High (TZ_Range1_High)
/** \brief Note: This register is for LPAE only.
      Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE1_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE1_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE1_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE1_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE1_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE1_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE1_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE1_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE1_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE1_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 2 Low (TZ_Range2_Low)
/** \brief Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE2_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE2_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE2_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE2_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE2_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE2_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE2_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE2_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_LOW_RESERVED1_MASK) >> MC_TZ_RANGE2_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE2_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE2_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE2_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE2_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE2_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE2_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE2_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE2_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE2_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_LOW_RESERVED2_MASK) >> MC_TZ_RANGE2_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE2_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE2_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE2_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE2_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE2_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE2_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE2_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE2_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE2_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE2_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE2_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE2_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE2_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE2_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE2_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE2_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 2 High (TZ_Range2_High)
/** \brief Note: This register is for LPAE only.
      Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE2_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE2_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE2_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE2_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE2_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE2_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE2_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE2_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE2_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE2_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 3 Low (TZ_Range3_Low)
/** \brief Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE3_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE3_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE3_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE3_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE3_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE3_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE3_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE3_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_LOW_RESERVED1_MASK) >> MC_TZ_RANGE3_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE3_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE3_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE3_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE3_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE3_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE3_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE3_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE3_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE3_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_LOW_RESERVED2_MASK) >> MC_TZ_RANGE3_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE3_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE3_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE3_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE3_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE3_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE3_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE3_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE3_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE3_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE3_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE3_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE3_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE3_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE3_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE3_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE3_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 3 High (TZ_Range3_High)
/** \brief Note: This register is for LPAE only.
      Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE3_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE3_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE3_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE3_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE3_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE3_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE3_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE3_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE3_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE3_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 4 Low (TZ_Range4_Low)
/** \brief Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE4_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE4_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE4_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE4_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE4_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE4_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE4_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE4_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_LOW_RESERVED1_MASK) >> MC_TZ_RANGE4_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE4_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE4_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE4_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE4_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE4_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE4_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE4_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE4_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE4_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_LOW_RESERVED2_MASK) >> MC_TZ_RANGE4_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE4_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE4_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE4_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE4_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE4_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE4_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE4_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE4_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE4_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE4_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE4_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE4_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE4_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE4_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE4_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE4_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 4 High (TZ_Range4_High)
/** \brief Note: This register is for LPAE only.
      Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE4_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE4_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE4_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE4_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE4_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE4_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE4_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE4_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE4_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE4_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 5 Low (TZ_Range5_Low)
/** \brief Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE5_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE5_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE5_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE5_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE5_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE5_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE5_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE5_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_LOW_RESERVED1_MASK) >> MC_TZ_RANGE5_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE5_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE5_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE5_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE5_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE5_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE5_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE5_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE5_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE5_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_LOW_RESERVED2_MASK) >> MC_TZ_RANGE5_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE5_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE5_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE5_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE5_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE5_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE5_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE5_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE5_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE5_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE5_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE5_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE5_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE5_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE5_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE5_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE5_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 5 High (TZ_Range5_High)
/** \brief Note: This register is for LPAE only.
      Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE5_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE5_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE5_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE5_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE5_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE5_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE5_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE5_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE5_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE5_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 6 Low (TZ_Range6_Low)
/** \brief Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE6_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE6_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE6_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE6_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE6_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE6_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE6_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE6_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_LOW_RESERVED1_MASK) >> MC_TZ_RANGE6_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE6_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE6_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE6_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE6_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE6_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE6_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE6_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE6_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE6_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_LOW_RESERVED2_MASK) >> MC_TZ_RANGE6_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE6_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE6_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE6_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE6_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE6_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE6_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE6_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE6_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE6_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE6_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE6_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE6_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE6_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE6_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE6_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE6_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 6 High (TZ_Range6_High)
/** \brief Note: This register is for LPAE only.
      Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE6_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE6_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE6_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE6_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE6_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE6_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE6_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE6_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE6_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE6_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 7 Low (TZ_Range7_Low)
/** \brief Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE7_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE7_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE7_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE7_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE7_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE7_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE7_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE7_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_LOW_RESERVED1_MASK) >> MC_TZ_RANGE7_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE7_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE7_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE7_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE7_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE7_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE7_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE7_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE7_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE7_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_LOW_RESERVED2_MASK) >> MC_TZ_RANGE7_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE7_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE7_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE7_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE7_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE7_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE7_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE7_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE7_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE7_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE7_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE7_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE7_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE7_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE7_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE7_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE7_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 7 High (TZ_Range7_High)
/** \brief Note: This register is for LPAE only.
      Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE7_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE7_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE7_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE7_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE7_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE7_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE7_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE7_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE7_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE7_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 8 Low (TZ_Range8_Low)
/** \brief Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE8_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE8_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE8_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE8_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE8_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE8_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE8_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE8_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_LOW_RESERVED1_MASK) >> MC_TZ_RANGE8_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE8_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE8_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE8_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE8_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE8_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE8_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE8_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE8_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE8_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_LOW_RESERVED2_MASK) >> MC_TZ_RANGE8_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE8_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE8_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE8_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE8_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE8_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE8_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE8_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE8_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE8_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE8_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE8_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE8_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE8_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE8_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE8_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE8_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 8 High (TZ_Range8_High)
/** \brief Note: This register is for LPAE only.
      Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE8_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE8_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE8_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE8_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE8_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE8_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE8_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE8_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE8_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE8_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 9 Low (TZ_Range9_Low)
/** \brief Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE9_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE9_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE9_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE9_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE9_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE9_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE9_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE9_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_LOW_RESERVED1_MASK) >> MC_TZ_RANGE9_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE9_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE9_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE9_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE9_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE9_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE9_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE9_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE9_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE9_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_LOW_RESERVED2_MASK) >> MC_TZ_RANGE9_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE9_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE9_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE9_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE9_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE9_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE9_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE9_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE9_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE9_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE9_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE9_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE9_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE9_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE9_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE9_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE9_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 9 High (TZ_Range9_High)
/** \brief Note: This register is for LPAE only.
      Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE9_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE9_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE9_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE9_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE9_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE9_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE9_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE9_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE9_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE9_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 10 Low (TZ_Range10_Low)
/** \brief Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE10_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE10_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE10_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE10_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE10_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE10_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE10_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE10_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_LOW_RESERVED1_MASK) >> MC_TZ_RANGE10_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE10_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE10_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE10_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE10_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE10_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE10_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE10_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE10_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE10_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_LOW_RESERVED2_MASK) >> MC_TZ_RANGE10_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE10_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE10_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE10_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE10_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE10_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE10_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE10_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE10_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE10_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE10_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE10_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE10_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE10_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE10_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE10_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE10_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 10 High (TZ_Range10_High)
/** \brief Note: This register is for LPAE only.
      Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE10_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE10_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE10_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE10_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE10_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE10_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE10_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE10_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE10_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE10_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 11 Low (TZ_Range11_Low)
/** \brief Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE11_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE11_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE11_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE11_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE11_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE11_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE11_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE11_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_LOW_RESERVED1_MASK) >> MC_TZ_RANGE11_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE11_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE11_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE11_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE11_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE11_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE11_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE11_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE11_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE11_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_LOW_RESERVED2_MASK) >> MC_TZ_RANGE11_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE11_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE11_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE11_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE11_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE11_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE11_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE11_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE11_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE11_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE11_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE11_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE11_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE11_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE11_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE11_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE11_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 11 High (TZ_Range11_High)
/** \brief Note: This register is for LPAE only.
      Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE11_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE11_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE11_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE11_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE11_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE11_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE11_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE11_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE11_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE11_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 12 Low (TZ_Range12_Low)
/** \brief Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE12_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE12_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE12_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE12_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE12_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE12_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE12_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE12_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_LOW_RESERVED1_MASK) >> MC_TZ_RANGE12_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE12_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE12_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE12_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE12_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE12_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE12_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE12_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE12_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE12_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_LOW_RESERVED2_MASK) >> MC_TZ_RANGE12_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE12_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE12_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE12_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE12_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE12_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE12_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE12_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE12_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE12_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE12_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE12_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE12_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE12_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE12_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE12_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE12_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 12 High (TZ_Range12_High)
/** \brief Note: This register is for LPAE only.
      Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE12_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE12_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE12_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE12_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE12_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE12_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE12_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE12_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE12_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE12_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 13 Low (TZ_Range13_Low)
/** \brief Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE13_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE13_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE13_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE13_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE13_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE13_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE13_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE13_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_LOW_RESERVED1_MASK) >> MC_TZ_RANGE13_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE13_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE13_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE13_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE13_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE13_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE13_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE13_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE13_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE13_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_LOW_RESERVED2_MASK) >> MC_TZ_RANGE13_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE13_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE13_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE13_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE13_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE13_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE13_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE13_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE13_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE13_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE13_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE13_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE13_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE13_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE13_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE13_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE13_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 13 High (TZ_Range13_High)
/** \brief Note: This register is for LPAE only.
      Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE13_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE13_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE13_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE13_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE13_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE13_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE13_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE13_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE13_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE13_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 14 Low (TZ_Range14_Low)
/** \brief Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE14_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE14_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE14_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE14_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE14_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE14_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE14_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE14_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_LOW_RESERVED1_MASK) >> MC_TZ_RANGE14_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE14_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE14_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE14_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE14_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE14_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE14_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE14_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE14_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE14_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_LOW_RESERVED2_MASK) >> MC_TZ_RANGE14_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE14_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE14_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE14_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE14_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE14_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE14_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE14_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE14_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE14_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE14_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE14_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE14_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE14_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE14_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE14_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE14_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 14 High (TZ_Range14_High)
/** \brief Note: This register is for LPAE only.
      Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE14_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE14_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE14_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE14_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE14_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE14_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE14_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE14_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE14_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE14_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 15 Low (TZ_Range15_Low)
/** \brief Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE15_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE15_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE15_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE15_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE15_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE15_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE15_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE15_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_LOW_RESERVED1_MASK) >> MC_TZ_RANGE15_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE15_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE15_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE15_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE15_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE15_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE15_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE15_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE15_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE15_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_LOW_RESERVED2_MASK) >> MC_TZ_RANGE15_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE15_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE15_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE15_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE15_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE15_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE15_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE15_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE15_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE15_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE15_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE15_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE15_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE15_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE15_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE15_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE15_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Register 15 High (TZ_Range15_High)
/** \brief Note: This register is for LPAE only.
      Note: This register is locked when <<xref=MC_Control_0/trustzone_lock>> is on.
      Note: This register is accessible only in secure mode.
      Note: If restrict zone is configured, in "MC Trustzone Range Register", even when trustzone is disabled, restrict zone access control is still active.*/
//====================================================================

#define  MC_TZ_RANGE15_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE15_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE15_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE15_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE15_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE15_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE15_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE15_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE15_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE15_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_HIGH_TZ_START_ADDR_H_SHIFT))

#endif // MC
