/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2011-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/
/*------------------------------------------------------------------------
            Include Files
------------------------------------------------------------------------*/
#include <string.h>
#include "regAddrs.h"
#include "MC_regheaders.h"
#include "../ddr_utils.h"
#include "ciu_regheaders.h"
#include "ddr_config_gr2.h"
#include "ddr_phy_config_gr2.h"
#include "ID_utils.h"
#include "UTF_DDR_Config.h"

/*------------------------------------------------------------------------
        Defines
------------------------------------------------------------------------*/

//#define msg(x,y,...) minPrintf(__VA_ARGS__)
#define msg(x,y,...) 
/*------------------------------------------------------------------------
        Globals
------------------------------------------------------------------------*/
extern bool ddr4_memory;

const DDR_config_t Default_MCConfig = mt41j256m16_93_800_x32_INIT_DATA;
const DDR_config_t TOC_MCConfig        = mt41j256m16_93_800_x32_INIT_DATA;
const DDR_config_t FFC_r1_MCConfig     = mt41k256m16_125_400_x16_INIT_DATA;
const DDR_config_t GLD_4_MCConfig      = mt41k512m8_107_800_x32_INIT_DATA;
const DDR_config_t TWNDIE_4_MCConfig   = mt41k1G8_125_mt41k1G8_125_800_x32_INIT_DATA;
/*------------------------------------------------------------------------
        set_DDR_configuration
------------------------------------------------------------------------*/
/**
 *
 * \brief Initializes the memory controller
 *
 * \param const DDR_config_t *DDR_config_record - pointer to the config values
 *      to be used to program the MC
 * \return void (no return value)
 *
 *
 */

void set_DDR_configuration_gr2(const DDR_config_t *DDR_config_record, cs_sa_t *startAddrs)
{
    MC_REGS_t *mem_ctrl_regs = (MC_REGS_t*) AP_MC_BASE;
    CIU_REGS_t *ciu_regs = (CIU_REGS_t*) AP_CIU_BASE;
    uint32_t zpr = 0;
    uint32_t znr = 0;
 
#ifdef C0ASIC
    ciu_regs->MC_PRIORITY3 |= CIU_MC_PRIORITY3_QS_GATE_CLR_MASK;
#endif


    msg(MSG_INFO, RAW_DATA, "Initiating Sync2\r\n" );
    phyinit_sequence_sync2_gr2(mem_ctrl_regs, 0, 3, 2, 0);

    msg(MSG_INFO, RAW_DATA, "Calibrating DDR PHY pads\r\n");
    
    calDDRPHYPads_gr2(mem_ctrl_regs, &zpr, &znr);
    msg(MSG_INFO, RAW_DATA, "zpr 0x%08x  znr  0x%08x\r\n", zpr, znr );
 
    ciu_regs->DDR_CONTROL |= CIU_DDR_CONTROL_MC_WATCHDOG_SOFT_RESET_MASK;

    //mem_ctrl_regs->CH0_PHY_Control_6                  = DDR_config_record->CH0_PHY_Control_6;
    mem_ctrl_regs->CH0_DRAM_Config_3                  = 0x00005000;/* flush setting to dram for enabling DBI */
    mem_ctrl_regs->CH0_PHY_Control_17                 = DDR_config_record->CH0_PHY_Control_17;
    mem_ctrl_regs->CH0_PMAP0                          = DDR_config_record->CH0_PMAP0;
    mem_ctrl_regs->CH0_DRAM_Config_5_CS0              = DDR_config_record->CH0_DRAM_Config_5_CS0;
    mem_ctrl_regs->CH0_MMAP0                          = DDR_config_record->CH0_MMAP0;
    mem_ctrl_regs->CH0_PMAP1                          = DDR_config_record->CH0_PMAP1;
    mem_ctrl_regs->CH0_DRAM_Config_5_CS1              = DDR_config_record->CH0_DRAM_Config_5_CS1;
    mem_ctrl_regs->CH0_MMAP1                          = DDR_config_record->CH0_MMAP1;
    mem_ctrl_regs->CH0_PMAP2                          = DDR_config_record->CH0_PMAP2;
    mem_ctrl_regs->CH0_DRAM_Config_5_CS2              = DDR_config_record->CH0_DRAM_Config_5_CS2;
    mem_ctrl_regs->CH0_MMAP2                          = DDR_config_record->CH0_MMAP2;
    mem_ctrl_regs->CH0_PreCharge_Timing               = DDR_config_record->CH0_PreCharge_Timing;
    mem_ctrl_regs->CH0_ACT_timing                     = DDR_config_record->CH0_ACT_timing;
    mem_ctrl_regs->CH0_CAS_RAS_timing                 = DDR_config_record->CH0_CAS_RAS_timing;
    mem_ctrl_regs->CH0_MRS_timing                     = DDR_config_record->CH0_MRS_timing;
    mem_ctrl_regs->CH0_DDR_init_timing_control_0      = DDR_config_record->CH0_DDR_init_timing_control_0;
    mem_ctrl_regs->CH0_DDR_init_timing_control_1      = DDR_config_record->CH0_DDR_init_timing_control_1;
    mem_ctrl_regs->CH0_Off_spec_timing                = DDR_config_record->CH0_Off_spec_timing;
    mem_ctrl_regs->CH0_Refresh_timing                 = DDR_config_record->CH0_Refresh_timing;
    mem_ctrl_regs->CH0_SelfRefresh_timing             = DDR_config_record->CH0_SelfRefresh_timing;
    mem_ctrl_regs->CH0_ZQC_Timing_0                   = DDR_config_record->CH0_ZQC_Timing_0;
    mem_ctrl_regs->CH0_ZQC_Timing_1                   = DDR_config_record->CH0_ZQC_Timing_1;
    mem_ctrl_regs->CH0_DRAM_Control_1                 = DDR_config_record->CH0_DRAM_Control_1;
    mem_ctrl_regs->CH0_DRAM_Control_2                 = DDR_config_record->CH0_DRAM_Control_2;
    mem_ctrl_regs->CH0_DRAM_Config_1                  = DDR_config_record->CH0_DRAM_Config_1;
    mem_ctrl_regs->CH0_DRAM_Config_2                  = DDR_config_record->CH0_DRAM_Config_2;
    mem_ctrl_regs->CH0_PHY_Control_1                  = DDR_config_record->CH0_PHY_Control_1;
    mem_ctrl_regs->CH0_PHY_Control_2 =
        MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_REPLACE_VAL( \
        MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_REPLACE_VAL( \
        MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_REPLACE_VAL( \
        MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_REPLACE_VAL( \
        DDR_config_record->CH0_PHY_Control_2, zpr&0xf), znr&0xf), (zpr>>4)&0x1), (znr>>4)&0x1);
    mem_ctrl_regs->CH0_PHY_Control_3 =
        MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_REPLACE_VAL( \
        MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_REPLACE_VAL( \
        MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_REPLACE_VAL( \
        MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_REPLACE_VAL( \
        DDR_config_record->CH0_PHY_Control_3, zpr&0xf), znr&0xf), (zpr>>4)&0x1), (znr>>4)&0x1);
 

    mem_ctrl_regs->CH0_PHY_Control_4                  = DDR_config_record->CH0_PHY_Control_4;
    mem_ctrl_regs->CH0_PHY_Control_5                  = DDR_config_record->CH0_PHY_Control_5;
    mem_ctrl_regs->CH0_PHY_Control_8                  = DDR_config_record->CH0_PHY_Control_8;
    mem_ctrl_regs->CH0_PHY_Control_9                  = DDR_config_record->CH0_PHY_Control_9a;
    mem_ctrl_regs->CH0_PHY_Control_11                 = DDR_config_record->CH0_PHY_Control_11;
    mem_ctrl_regs->CH0_PHY_Control_13                 = DDR_config_record->CH0_PHY_Control_13;
    mem_ctrl_regs->CH0_PHY_Control_14                 = DDR_config_record->CH0_PHY_Control_14;
    mem_ctrl_regs->CH0_PHY_Control_15                 = ((DDR_config_record->CH0_PHY_Control_15 & 0xFFFFFFFC) | (mem_ctrl_regs->CH0_PHY_Control_15));
    //mem_ctrl_regs->CH0_PHY_Control_16                 = DDR_config_record->CH0_PHY_Control_16;
    mem_ctrl_regs->CH0_PHY_Data_Byte_Control_B0       = DDR_config_record->CH0_PHY_Data_Byte_Control_B0;
    mem_ctrl_regs->CH0_PHY_Data_Byte_Control_B1       = DDR_config_record->CH0_PHY_Data_Byte_Control_B1;
    mem_ctrl_regs->CH0_PHY_Data_Byte_Control_B2       = DDR_config_record->CH0_PHY_Data_Byte_Control_B2;
    mem_ctrl_regs->CH0_PHY_Data_Byte_Control_B3       = DDR_config_record->CH0_PHY_Data_Byte_Control_B3;
    mem_ctrl_regs->PHY_pwr_ctl                        = DDR_config_record->PHY_pwr_ctl;
    mem_ctrl_regs->CH0_PHY_DLL_control_B0             = DDR_config_record->CH0_PHY_DLL_control_B0;
    mem_ctrl_regs->CH0_PHY_DLL_control_B1             = DDR_config_record->CH0_PHY_DLL_control_B1;
    mem_ctrl_regs->CH0_PHY_DLL_control_B2             = DDR_config_record->CH0_PHY_DLL_control_B2;
    mem_ctrl_regs->CH0_PHY_DLL_control_B3             = DDR_config_record->CH0_PHY_DLL_control_B3;
 

    mem_ctrl_regs->CH0_PHY_Control_9                  = DDR_config_record->CH0_PHY_Control_9b;
 

    mem_ctrl_regs->CH0_PHY_Control_9                  = DDR_config_record->CH0_PHY_Control_9c;
 

    mem_ctrl_regs->CH0_PHY_Control_9                  = DDR_config_record->CH0_PHY_Control_9d;
 

	if (is_ddr4()) {
		 // Enable ReadDBI, DM bits,
	    mem_ctrl_regs->CH0_DRAM_Config_3                  |= MC_CH0_DRAM_CONFIG_3_DM_MASK | MC_CH0_DRAM_CONFIG_3_READ_DBI_MASK;
	}
    msg(MSG_INFO, RAW_DATA, "Begin DRAM Init\r\n");
 

    mem_ctrl_regs->USER_COMMAND_0                     = MC_USER_COMMAND_0_CH_REPLACE_VAL(\
                                                        MC_USER_COMMAND_0_SDRAM_INIT_REQ_MASK, MC_USER_COMMAND_0_SDRAM_INIT_REQ_MASK);
 
    while ( (mem_ctrl_regs->DRAM_STATUS&MC_DRAM_STATUS_INIT_DONE00_MASK) !=
            MC_DRAM_STATUS_INIT_DONE00_MASK ); // Wait for Init to Finish
    msg(MSG_INFO, RAW_DATA, "End DRAM Init\r\n");

    mem_ctrl_regs->CH0_DRAM_Config_3                  = DDR_config_record->CH0_DRAM_Config_3a;
    mem_ctrl_regs->USER_COMMAND_0                     = DDR_config_record->USER_COMMAND_0a;
    mem_ctrl_regs->CH0_DRAM_Config_3                  = DDR_config_record->CH0_DRAM_Config_3b;
    mem_ctrl_regs->USER_COMMAND_0                     = DDR_config_record->USER_COMMAND_0b;
    mem_ctrl_regs->USER_COMMAND_0                     = DDR_config_record->USER_COMMAND_0c;
    mem_ctrl_regs->CH0_DRAM_Config_3                  = DDR_config_record->CH0_DRAM_Config_3c;
    mem_ctrl_regs->USER_COMMAND_0                     = DDR_config_record->USER_COMMAND_0d;
 
    msg(MSG_INFO, RAW_DATA, "CH0_PHY_Control_2 0x%08x  CH0_PHY_Control_3  0x%08x\r\n", mem_ctrl_regs->CH0_PHY_Control_2, mem_ctrl_regs->CH0_PHY_Control_3 );
    msg(MSG_INFO, RAW_DATA, "CH0_PHY_Control_15 0x%08x\r\n", mem_ctrl_regs->CH0_PHY_Control_15 );
    if (ddr4_memory) {
        msg(MSG_INFO, RAW_DATA, "CH0_DRAM_Config_3 0x%08x\r\n", mem_ctrl_regs->CH0_DRAM_Config_3);
    }
 
    if ((DDR_config_record->CH0_MMAP0 & 0x1) == 1)  // CS0 valid.
    {
        startAddrs->sa[0] = (DDR_config_record->CH0_MMAP0 & 0xff000000);
        msg(MSG_INFO, RAW_DATA, "   CS0 valid, start address = 0x%08x\r\n",startAddrs->sa[0] );
    }
    else
    {
        startAddrs->sa[0] = 0xDEADBEEF;
    }
 
    if ((DDR_config_record->CH0_MMAP1 & 0x1) == 1)  // CS1 valid.
    {
        startAddrs->sa[1] = (DDR_config_record->CH0_MMAP1 & 0xff000000);
        msg(MSG_INFO, RAW_DATA, "   CS1 valid, start address = 0x%08x\r\n",startAddrs->sa[1] );
    }
    else
    {
        startAddrs->sa[1] = 0xDEADBEEF;
    }
 
    if ((DDR_config_record->CH0_MMAP2 & 0x1) == 1)  // CS2 valid.
    {
        startAddrs->sa[2] = (DDR_config_record->CH0_MMAP2 & 0xff000000);
        msg(MSG_INFO, RAW_DATA, "   CS2 valid, start address = 0x%08x\r\n",startAddrs->sa[2] );
    }
    else
    {
        startAddrs->sa[2] = 0xDEADBEEF;
    }
 
    /* RICOH add */
    mem_ctrl_regs->Port_priority = DDR_config_record->Port_priority;

    return;
}
