/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/

#ifndef __CUSTOMER_DDR_CONFIG_H__
#define __CUSTOMER_DDR_CONFIG_H__

#define Customer_400_x32_1024_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 [RICOH changed] */ \
    .CH0_MMAP0=                        0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 [RICOH changed] */ \
    .CH0_PMAP1=                        0x05020532,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00000000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 [RICOH changed] */ \
    .CH0_MMAP1=                        0x00000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 [RICOH changed] */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00000000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 [RICOH changed] */ \
    .CH0_MMAP2=                        0x00000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 [RICOH changed] */ \
    .CH0_PreCharge_Timing=             0x00b0c60b,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x20270b1c,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x6b440068,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00061a81,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x01567101,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00d000c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0d8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,     /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,     /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 [RICOH changed] */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 [RICOH changed] */ \
    .CH0_DRAM_Config_1=                0x0030a52b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 [RICOH changed] */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0xd778844b,     /* ///< 0x404 [R/W]: PHY Control Register 2 [RICOH changed] */ \
    .CH0_PHY_Control_3=                0xc770044a,     /* ///< 0x408 [R/W]: PHY Control Register 3 [RICOH changed] */ \
    .CH0_PHY_Control_4=                0x6461dc00,     /* ///< 0x40c [R/W]: PHY Control Register 4 [RICOH changed] */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .Port_priority =                   0xff000000,     /* ///< 0x84  [R/W]: Port Priority Control Register */ \
}

#define Customer_400_x32_512_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 [RICOH changed] */ \
    .CH0_MMAP0=                        0x000d0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 [RICOH changed] */ \
    .CH0_PMAP1=                        0x05020532,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00000000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 [RICOH changed] */ \
    .CH0_MMAP1=                        0x00000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 [RICOH changed] */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00000000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 [RICOH changed] */ \
    .CH0_MMAP2=                        0x00000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 [RICOH changed] */ \
    .CH0_PreCharge_Timing=             0x00b0c60b,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x20270b1c,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x6b440068,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00061a81,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x01567101,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00d000c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0d8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,     /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,     /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 [RICOH changed] */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 [RICOH changed] */ \
    .CH0_DRAM_Config_1=                0x0030a52b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 [RICOH changed] */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0xd778844b,     /* ///< 0x404 [R/W]: PHY Control Register 2 [RICOH changed] */ \
    .CH0_PHY_Control_3=                0xc770044a,     /* ///< 0x408 [R/W]: PHY Control Register 3 [RICOH changed] */ \
    .CH0_PHY_Control_4=                0x6461dc00,     /* ///< 0x40c [R/W]: PHY Control Register 4 [RICOH changed] */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .Port_priority =                   0xff000030,     /* ///< 0x84  [R/W]: Port Priority Control Register */ \
}

#define Customer_400_x32_2048_INIT_DATA \
{    \
    .CH0_PHY_Control_6=                0x00080000,     /* ///< 0x414 [R/W]: PHY Control Register 6 */ \
    .CH0_PHY_Control_17=               0x00000407,     /* ///< 0x440 [R/W]: PHY Control Register 17 */ \
    .CH0_PMAP0=                        0x05020532,     /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 */ \
    .CH0_DRAM_Config_5_CS0=            0x00110000,     /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0 [RICOH changed] */ \
    .CH0_MMAP0=                        0x000e0001,     /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 [RICOH changed] */ \
    .CH0_PMAP1=                        0x05020532,     /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1 */ \
    .CH0_DRAM_Config_5_CS1=            0x00000000,     /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1 [RICOH changed] */ \
    .CH0_MMAP1=                        0x00000000,     /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 [RICOH changed] */ \
    .CH0_PMAP2=                        0x02010000,     /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2 */ \
    .CH0_DRAM_Config_5_CS2=            0x00000000,     /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2 [RICOH changed] */ \
    .CH0_MMAP2=                        0x00000000,     /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 [RICOH changed] */ \
    .CH0_PreCharge_Timing=             0x00b0c60b,     /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register */ \
    .CH0_ACT_timing=                   0x20270b1c,     /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register */ \
    .CH0_CAS_RAS_timing=               0x6b440068,     /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register */ \
    .CH0_MRS_timing=                   0x000000c4,     /* ///< 0x39c [R/W]: DRAM MRS Timing Register */ \
    .CH0_DDR_init_timing_control_0=    0x00061a81,     /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0 */ \
    .CH0_DDR_init_timing_control_1=    0x01567101,     /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1 */ \
    .CH0_Off_spec_timing=              0x00000421,     /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register */ \
    .CH0_Refresh_timing=               0x00d000c3,     /* ///< 0x390 [R/W]: DRAM Refresh Timing Register */ \
    .CH0_SelfRefresh_timing=           0xb0d8b200,     /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register */ \
    .CH0_ZQC_Timing_0=                 0x001b0200,     /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0 */ \
    .CH0_ZQC_Timing_1=                 0x00400100,     /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1 */ \
    .CH0_DRAM_Control_1=               0x08040201,     /* ///< 0x340 [R/W]: DRAM Control Register 1 [RICOH changed] */ \
    .CH0_DRAM_Control_2=               0x020000aa,     /* ///< 0x344 [R/W]: DRAM Control Register 2 [RICOH changed] */ \
    .CH0_DRAM_Config_1=                0x0030b52b,     /* ///< 0x300 [R/W]: DRAM Configuration Register 1 [RICOH changed] */ \
    .CH0_DRAM_Config_2=                0x00000002,     /* ///< 0x304 [R/W]: DRAM Configuration Register 2 */ \
    .CH0_PHY_Control_1=                0x00004040,     /* ///< 0x400 [R/W]: PHY Control Register 1 */ \
    .CH0_PHY_Control_2=                0x17788009,     /* ///< 0x404 [R/W]: PHY Control Register 2 [RICOH changed] */ \
    .CH0_PHY_Control_3=                0x07700000,     /* ///< 0x408 [R/W]: PHY Control Register 3 [RICOH changed] */ \
    .CH0_PHY_Control_4=                0x6441dc00,     /* ///< 0x40c [R/W]: PHY Control Register 4 [RICOH changed] */ \
    .CH0_PHY_Control_5=                0x00300519,     /* ///< 0x410 [R/W]: PHY Control Register 5 */ \
    .CH0_PHY_Control_8=                0x08110010,     /* ///< 0x41c [R/W]: PHY Control Register 8 */ \
    .CH0_PHY_Control_9a=               0x00000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_11=               0x00000000,     /* ///< 0x428 [R/W]: PHY Control Register 11 */ \
    .CH0_PHY_Control_13=               0x00000000,     /* ///< 0x430 [R/W]: PHY Control Register 13 */ \
    .CH0_PHY_Control_14=               0x00000000,     /* ///< 0x434 [R/W]: PHY Control Register 14 */ \
    .CH0_PHY_Control_15=               0x00000002,     /* ///< 0x438 [R/W]: PHY Control Register 15 */ \
    .CH0_PHY_Control_16=               0x00000010,     /* ///< 0x43C [R/W]: PHY Control Register 16 */ \
    .CH0_PHY_Data_Byte_Control_B0=     0x00000000,     /* ///< 0x540 [R/W]: PHY Data Byte Control B0 */ \
    .CH0_PHY_Data_Byte_Control_B1=     0x00000000,     /* ///< 0x544 [R/W]: PHY Data Byte Control B1 */ \
    .CH0_PHY_Data_Byte_Control_B2=     0x00000000,     /* ///< 0x548 [R/W]: PHY Data Byte Control B2 */ \
    .CH0_PHY_Data_Byte_Control_B3=     0x00000000,     /* ///< 0x54C [R/W]: PHY Data Byte Control B3 */ \
    .PHY_pwr_ctl=                      0x00000ff1,     /* ///< 0x054 [R/W]: PHY Power Control Register */ \
    .CH0_PHY_DLL_control_B0=           0x12120000,     /* ///< 0x500 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B1=           0x12120000,     /* ///< 0x504 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B2=           0x12120000,     /* ///< 0x508 [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_DLL_control_B3=           0x12120000,     /* ///< 0x50C [R/W]: PHY DLL Control Register */ \
    .CH0_PHY_Control_9b=               0x80000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9c=               0x20000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_PHY_Control_9d=               0x40000000,     /* ///< 0x420 [R/W]: PHY Control Register 9 */ \
    .CH0_DRAM_Config_3a=               0x00001000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0a   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3b=               0x00001000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0b   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .USER_COMMAND_0c   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .CH0_DRAM_Config_3c=               0x00001000,     /* ///< 0x308 [R/W]: DRAM Configuration Register 3 */ \
    .USER_COMMAND_0d   =               0x00000000,     /* ///< 0x20 [R/W]: User Initiated Command Register 0 */ \
    .Port_priority =                   0xff000000,     /* ///< 0x84  [R/W]: Port Priority Control Register */ \
}

/* DDR4-1600 */
#define Customer_mt40a512m16jy_083e_800_32_INIT_DATA \
{    \
    .CH0_PHY_Control_6             = 0x00080000, /* ///< 0x414 [R/W]: PHY Control Register 6                                            */ \
    .CH0_PHY_Control_17            = 0x00000407, /* ///< 0x440 [R/W]: PHY Control Register 17                                           */ \
    .CH0_PMAP0                     = 0x06020635, /* ///< 0x210 [R/W]: Memory Controller Physical Address Map Register 0 [RICOH Changed] */ \
    .CH0_DRAM_Config_5_CS0         = 0x00600000, /* ///< 0x310 [R/W]: DRAM Configuration Register 5 CS0                                 */ \
    .CH0_MMAP0                     = 0x000f0001, /* ///< 0x200 [R/W]: Memory Address Map Register Channel 0 [RICOH Changed]             */ \
    .CH0_PMAP1                     = 0x00000000, /* ///< 0x214 [R/W]: Memory Controller Physical Address Map Register 1                 */ \
    .CH0_DRAM_Config_5_CS1         = 0x00000000, /* ///< 0x314 [R/W]: DRAM Configuration Register 5 CS1                                 */ \
    .CH0_MMAP1                     = 0x00000000, /* ///< 0x204 [R/W]: Memory Address Map Register Channel 1 [RICOH Changed]             */ \
    .CH0_PMAP2                     = 0x00000000, /* ///< 0x218 [R/W]: Memory Controller Physical Address Map Register 2                 */ \
    .CH0_DRAM_Config_5_CS2         = 0x00000000, /* ///< 0x318 [R/W]: DRAM Configuration Register 5 CS2                                 */ \
    .CH0_MMAP2                     = 0x00000000, /* ///< 0x208 [R/W]: Memory Address Map Register Channel 2 [RICOH Changed]             */ \
    .CH0_PreCharge_Timing          = 0x0110c60c, /* ///< 0x3a4 [R/W]: DRAM Precharge Timing Register [RICOH Changed]                    */ \
    .CH0_ACT_timing                = 0x1c2c0c1c, /* ///< 0x3a0 [R/W]: DRAM Activate Timing Register                                     */ \
    .CH0_CAS_RAS_timing            = 0x65540062, /* ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register                                      */ \
    .CH0_MRS_timing                = 0x00000188, /* ///< 0x39c [R/W]: DRAM MRS Timing Register                                          */ \
    .CH0_DDR_init_timing_control_0 = 0x00065bc0, /* ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0                     */ \
    .CH0_DDR_init_timing_control_1 = 0x01567101, /* ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1                     */ \
    .CH0_Off_spec_timing           = 0x00070701, /* ///< 0x3ac [R/W]: DRAM Off-spec timing Register [RICOH Changed]                     */ \
    .CH0_Refresh_timing            = 0x015000c3, /* ///< 0x390 [R/W]: DRAM Refresh Timing Register [RICOH Changed]                      */ \
    .CH0_SelfRefresh_timing        = 0xb158b200, /* ///< 0x394 [R/W]: DRAM Self-refresh Timing Register                                 */ \
    .CH0_ZQC_Timing_0              = 0x001b0400, /* ///< 0x388 [R/W]: DRAM ZQC Timing Register 0                                        */ \
    .CH0_ZQC_Timing_1              = 0x00800200, /* ///< 0x38C [R/W]: DRAM ZQC Timing Register 1                                        */ \
    .CH0_DRAM_Control_1            = 0x00000001, /* ///< 0x340 [R/W]: DRAM Control Register 1                                           */ \
    .CH0_DRAM_Control_2            = 0x02000002, /* ///< 0x344 [R/W]: DRAM Control Register 2                                           */ \
    .CH0_DRAM_Config_1             = 0x0530eb3b, /* ///< 0x300 [R/W]: DRAM Configuration Register 1 [RICOH Changed]                     */ \
    .CH0_DRAM_Config_2             = 0x00000000, /* ///< 0x304 [R/W]: DRAM Configuration Register 2                                     */ \
    .CH0_PHY_Control_1             = 0x00004040, /* ///< 0x400 [R/W]: PHY Control Register 1                                            */ \
    .CH0_PHY_Control_2             = 0x1551000b, /* ///< 0x404 [R/W]: PHY Control Register 2 [RICOH Changed]                            */ \
    .CH0_PHY_Control_3             = 0x0770000a, /* ///< 0x408 [R/W]: PHY Control Register 3 [RICOH Changed]                            */ \
    .CH0_PHY_Control_4             = 0x6461dc00, /* ///< 0x40c [R/W]: PHY Control Register 4 [RICOH Changed]                            */ \
    .CH0_PHY_Control_5             = 0x00300507, /* ///< 0x410 [R/W]: PHY Control Register 5                                            */ \
    .CH0_PHY_Control_8             = 0x08110010, /* ///< 0x41c [R/W]: PHY Control Register 8                                            */ \
    .CH0_PHY_Control_9a            = 0x00000000, /* ///< 0x420 [R/W]: PHY Control Register 9                                            */ \
    .CH0_PHY_Control_11            = 0x00000071, /* ///< 0x428 [R/W]: PHY Control Register 11                                           */ \
    .CH0_PHY_Control_13            = 0x00000000, /* ///< 0x430 [R/W]: PHY Control Register 13                                           */ \
    .CH0_PHY_Control_14            = 0x00000000, /* ///< 0x434 [R/W]: PHY Control Register 14                                           */ \
    .CH0_PHY_Control_15            = 0xaf050002, /* ///< 0x438 [R/W]: PHY Control Register 15                                           */ \
    .CH0_PHY_Control_16            = 0x00000010, /* ///< 0x43C [R/W]: PHY Control Register 16                                           */ \
    .CH0_PHY_Data_Byte_Control_B0  = 0x00000000, /* ///< 0x540 [R/W]: PHY Data Byte Control B0                                          */ \
    .CH0_PHY_Data_Byte_Control_B1  = 0x00000000, /* ///< 0x544 [R/W]: PHY Data Byte Control B1                                          */ \
    .CH0_PHY_Data_Byte_Control_B2  = 0x00000000, /* ///< 0x548 [R/W]: PHY Data Byte Control B2                                          */ \
    .CH0_PHY_Data_Byte_Control_B3  = 0x00000000, /* ///< 0x54C [R/W]: PHY Data Byte Control B3                                          */ \
    .PHY_pwr_ctl                   = 0x00000ff1, /* ///< 0x054 [R/W]: PHY Power Control Register                                        */ \
    .CH0_PHY_DLL_control_B0        = 0x12120000, /* ///< 0x500 [R/W]: PHY DLL Control Register                                          */ \
    .CH0_PHY_DLL_control_B1        = 0x12120000, /* ///< 0x504 [R/W]: PHY DLL Control Register                                          */ \
    .CH0_PHY_DLL_control_B2        = 0x12120000, /* ///< 0x508 [R/W]: PHY DLL Control Register                                          */ \
    .CH0_PHY_DLL_control_B3        = 0x12120000, /* ///< 0x50C [R/W]: PHY DLL Control Register                                          */ \
    .CH0_PHY_Control_9b            = 0x80000000, /* ///< 0x420 [R/W]: PHY Control Register 9                                            */ \
    .CH0_PHY_Control_9c            = 0x20000000, /* ///< 0x420 [R/W]: PHY Control Register 9                                            */ \
    .CH0_PHY_Control_9d            = 0x40000000, /* ///< 0x420 [R/W]: PHY Control Register 9                                            */ \
    .CH0_DRAM_Config_3a            = 0x01005000, /* ///< 0x308 [R/W]: DRAM Configuration Register 3                                     */ \
    .USER_COMMAND_0a               = 0x11400000, /* ///< 0x20  [R/W]: User Initiated Command Register 0                                 */ \
    .CH0_DRAM_Config_3b            = 0x01175000, /* ///< 0x308 [R/W]: DRAM Configuration Register 3                                     */ \
    .USER_COMMAND_0b               = 0x11400000, /* ///< 0x20  [R/W]: User Initiated Command Register 0                                 */ \
    .USER_COMMAND_0c               = 0x11400000, /* ///< 0x20  [R/W]: User Initiated Command Register 0                                 */ \
    .CH0_DRAM_Config_3c            = 0x022f5000, /* ///< 0x308 [R/W]: DRAM Configuration Register 3                                     */ \
    .USER_COMMAND_0d               = 0x11400000, /* ///< 0x20  [R/W]: User Initiated Command Register 0                                 */ \
    .Port_priority                 = 0xff000030, /* ///< 0x84  [R/W]: Port Priority Control Register                                    */ \
}

#endif // ifndef __CUSTOMER_DDR_CONFIG_H__
