/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

#ifndef __VALIDATE_CODE_H__
#define __VALIDATE_CODE_H__

#include <stdint.h>

#define TIMH_BASE_ADDR_FIELD    (0xD100003C)
#define TIM_3_5_00			    (0x30500)	    // Support for Encrypted Boot
#define SWAP32(x) ((((x) & 0xff)<<24) | (((x) & 0xff00) << 8) | (((x) & 0xff0000)>>8) | (((x)>>24) & 0xff))

// Key Lengths
#define WordLengthOf_PKCS1024			  	32
#define WordLengthOf_PKCS2048				64
#define WordLengthOf_ECDSA256				8
#define WordLengthOf_ECDSA521				17
#define WordLengthOf_SHA1		 			5
#define WordLengthOf_SHA256		 			8
#define WordLengthOf_SHA512		 			16

#define ByteLengthOf_SHA1		 			20
#define ByteLengthOf_SHA256		 			32
#define ByteLengthOf_SHA512		 			64

#define HashSizeMismatchError               (-10)
#define InvalidSecureBootMethodError        (-11)
#define InvalidImageHash                    (-12)
#define SecurityFunctionNotSupported        (-13)

typedef struct
{
 uint32_t ImageID;						// Indicate which Image
 uint32_t NextImageID;					// Indicate next image in the chain
 uint32_t FlashEntryAddr;				// Block numbers for NAND
 uint32_t LoadAddr;
 uint32_t ImageSize;
 uint32_t ImageSizeToHash;
 HASHALGORITHMID_T HashAlgorithmID;	    // See Hash_Algorithm_ID_e
 uint32_t Hash[16];						// Reserve 512 bits for the hash
 uint32_t PartitionNumber;
 ENCRYPTALGORITHMID_T EncAlgorithmID;	// See ENCRYPTALGORITHMID_T
 uint32_t EncryptStartOffset;
 uint32_t EncryptSize;
} Image_Info_t, *pImageInfo_t;	// 0x60 bytes


#endif //ifndef __VALIDATE_CODE_H__
