/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2007-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the G
General Public License Version 2, and any use shall comply with the term
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOS
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details a
this warranty disclaimer.
*/
 
#include "asmCmptLayer.h"
#include "regAddrs.h"

/* 
startMPU comes in running on ROM cache address 0xf700XXXX
Now does a PC trick to be running from 0xff00YYYY where YYYY is ROM_ENABLE_MPU
Now we can enable the MPU since the section we are EXE from is not changing (non cached = 0xFF00xxxx)
But the LR still holds the proper 0xf700ZZZZ where ZZZZ is the return address
*/

//#ifdef BUILDROM
.section .mpu.text, "ax"

.balign 16

        EXPORT ROM_ENABLE_MPU
LABEL(ROM_ENABLE_MPU)
        mov	r0, #0;
        mrc    p15, 0, r0, c1, c0, 0 ;
        orr    r0, r0, #0x1 ;
        DSB ;
        mcr    p15, 0, r0, c1, c0, 0 ;
        ISB ;
        BX     LR;

.section .text, "ax"

.balign 16

        EXPORT startMPU
LABEL(startMPU)
         ldr   r0,=ROM_ENABLE_MPU
         orr   pc, r0, #0x08000000

;#*******************************************************************
;# MPUDisable
;#Purpose -  Disable the ARM MPU
;#*******************************************************************
        EXPORT MPUDisable
LABEL(MPUDisable)
        mDisableMPU
        BX LR         ;#Return to Caller

;#*******************************************************************
;# MPUEnable
;#Purpose -  Enable the ARM MPU
;#*******************************************************************
        EXPORT MPUEnable
LABEL(MPUEnable)
//        mEnableMPU
        BX LR         ;#Return to Caller

   END
//#endif
;#/* Used by vim and some versions of vi: set tabstop=4 shiftwidth=4: */
