/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the G
General Public License Version 2, and any use shall comply with the term
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOS
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details a
this warranty disclaimer.
*/

#include "asmCmptLayer.h"
#include "regAddrs.h"

.section .text
   .arm

   .macro GLOBAL label
   .global \label
   .type \label, %function
   .endm

;#*******************************************************************
;# EnableICache - Enable the instruction cache  
;#*******************************************************************  
    GLOBAL __EnableICache    
                             
__EnableICache:
    mEnableICache
    BX LR        

;#********************************************************************
;# DisableICache - Disable the instruction cache  
;#********************************************************************        
    GLOBAL __DisableICache   
__DisableICache:                       
    mDisableICache
    BX LR        

;#*******************************************************************
;# EnableDCache - Enable the Data cache      
;#******************************************************************* 
    GLOBAL __EnableDCache      
__EnableDCache:
    mEnableDCache
    BX LR        



;#******************************************************************** 
;# DisableDCache
;# Purpose - Disable the Data Cache
;#******************************************************************** 
    GLOBAL __DisableDCache       
__DisableDCache:
    mDisableDCache
    BX LR        

;#******************************************************************** 
;# cpu_dcache_writeback_all
;# Purpose - Clean the Data Cache - 
;#    ***!!!WITHOUT using any local memory that could be over written.
;# 4 ways of 64 sets
;#******************************************************************** 
    GLOBAL cpu_dcache_writeback_all       
cpu_dcache_writeback_all:           ;# trashes r0,1
    mov     r1, #0                  ;# set counter
2000:   
    mov     r0, r1, LSL #5          ;# way[31:30] set[s=4:5] reserved[4:0]
    mcr     p15,0,r0,c7,c10,2       ;# clean set r1 /way 00
    orr     r0, r0, #0x40000000
    mcr     p15,0,r0,c7,c10,2       ;# clean set r1 /way 01
    orr     r0, r0, #0x80000000
    mcr     p15,0,r0,c7,c10,2       ;# clean set r1 /way 11
    bic     r0, r0, #0x40000000
    mcr     p15,0,r0,c7,c10,2       ;# clean set r1 /way 10
    DSB
    DMB
    add     r1, #1                  ;#increment set
    cmp     r1, #64                 ;# have all sets have been cleaned?
    bne     2000b          
    mov     r0, #0                  ;# another DSB DMB
    MCR p15, 0, r0, c7, c10, 4 ;# Data Synchronization Barrier operation
    MCR p15, 0, r0, c7, c10, 5 ;# Data Memory Barrier Operation.         
    BX LR        

.end
