/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2008-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/
/**
 *
 * \file 88sv581x-v7.h 
 *
 * \brief This file contains some CPU internal register specific settings
 *
 */

#ifndef INC_88SV581X_V7_H
#define INC_88SV581X_V7_H

// CPSR Mode Definitions
#define CPSR_MODE_MASK 0x1F
#define USR_MODE 0x10
#define FIQ_MODE 0x11
#define IRQ_MODE 0x12
#define SVC_MODE 0x13
#define ABT_MODE 0x17
#define UND_MODE 0x1B
#define SYS_MODE 0x1F

// Interrupt state defines
#define IRQ_DISABLE_MASK 0x80
#define IRQ_ENABLED 0
#define IRQ_DISABLED 1

extern void __EnableDCache(void);
extern void __EnableICache(void);
extern void __DisableDCache(void);
extern void __DisableICache(void);

#endif
