/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

#include <stdint.h>

#define DRO_EFUSE_THRESHOLD         14418
#define DRO_EFUSE_REVB_THRESHOLD    15500
#define DRO_LIVE_THRESHOLD    (DRO_EFUSE_THRESHOLD-2000)

// Need to offset this since calibration is being done at a non-zero
//  value (AVS register settings).  Asking for 1120 mV actually gives us
//  a core setting of 1160 mV -- slightly better than the 1.152 mV recommended.
#define DRO_CORE_ADJUSTMENT   AVS_VOLTS_1120MV

#define AVS_CORE_NOMINAL      AVS_VOLTS_1050MV

typedef struct dro_readings_s {

   uint16_t curDRO;
   uint16_t minDRO;
   uint16_t maxDRO;
   uint16_t efuseDRO;

} DRO_READINGS_t;

void readDRO(DRO_READINGS_t *dro);
