/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

#include "regAddrs.h"
#include "MPMU_regheaders.h"
#include "UH_AVS.h"
#include "cpu_api.h"
#include "dro.h"

#define waitForMilliSecs(n)		cpu_spin_delay(n*1000)

void readDRO(DRO_READINGS_t *dro)
{
    uint32_t minMaxDRO = 0;

    enable_AVS();

    waitForMilliSecs(200);

    dro->curDRO = (uint16_t)(readCurrentDRO());
    minMaxDRO = readMinMaxDRO();

    disable_AVS();

    dro->maxDRO   = (uint16_t)((minMaxDRO >> 16) & 0xFFFF);
    dro->minDRO   = (uint16_t)(minMaxDRO & 0xFFFF);
    dro->efuseDRO = (uint16_t)(readEfuseDRO());

    return;
}
