/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/

//#define DEBUG

#include <stdint.h>
#include <assert.h>
#include "regAddrs.h"
#include "apb_top_regheaders.h"
#include "UH_AVS.h"
#include "error_types.h"
#include "minPrintf.h"
#include "dro.h"
#include "ID_utils.h"

#define ELEVATED_VLTG_PARTS     (3)

error_type_t initialize_AVS(void)
{
	volatile        APB_CONFIG_REGS_t *APB_config_reg = (void*) AP_AP_APB_APB_CONFIG_BASE;
	uint32_t        Bank5_Reg2 = 0;
	uint32_t        AVSvoltageFlags = 0;
	uint32_t        retval = -1;
	uint32_t        AVSeFuseEscape = 0;
	bool            AVSeFusesProgrammed = false;
	DRO_READINGS_t  dro_vals;

	if (is_FPGA())
		return STATUS_OK;

	if (!is_RevA())
		APB_config_reg = (APB_CONFIG_REGS_t*) ((uintptr_t)APB_config_reg - 0xC);

	minPrintf("\n");

	initAVS();

	Bank5_Reg2 = APB_config_reg->Fuse_Bank5_R2;
	AVSeFuseEscape = ((APB_config_reg->Fuse_Bank13_R2 >> 6) && 1);
	AVSvoltageFlags = (Bank5_Reg2 >> 30) & 3;
	msg(MSG_INFO, RAW_DATA, "\r\nBank5 Register2 = 0x%08x,   VoltBin = 0x%01x, efuseEscape = %d \r\n", Bank5_Reg2, AVSvoltageFlags, AVSeFuseEscape );

	if(EFUSE_BURNED != AVSeFuseEscape)
	{
		AVSeFusesProgrammed = set_AVS_To_Efuse_Values();
		retval = AVSeFusesProgrammed;
	}

	if ((EFUSE_BURNED == AVSeFuseEscape) || (false == AVSeFusesProgrammed))
	{
		// Set parts eFused for over-voltage with corevoltage 5% higher than nominal.
		if(ELEVATED_VLTG_PARTS == AVSvoltageFlags)
		{
			minPrintf("Setting Core to 1.15V\n" );
			retval = set_AVS_Voltage(DRO_CORE_ADJUSTMENT);

		}else
		{   // Check if eFuse DRO vals are set
			readDRO(&dro_vals);

			minPrintf("\nDRO Values:\n");
			minPrintf("     Cur  : 0x%04x / %5d d\n",dro_vals.curDRO,dro_vals.curDRO);
			minPrintf("     Min  : 0x%04x / %5d d\n",dro_vals.minDRO,dro_vals.minDRO);
			minPrintf("     Max  : 0x%04x / %5d d\n",dro_vals.maxDRO,dro_vals.maxDRO);
			minPrintf("     eFuse: 0x%04x / %5d d\n",dro_vals.efuseDRO,dro_vals.efuseDRO);

			if (dro_vals.efuseDRO == 0)  // eFuse DRO vals  aren't programmed...
			{
				if (is_Ge2())
				{
					minPrintf("UnFused part! Bumping up core voltage to 1.05V\n");
					retval = set_AVS_Voltage(AVS_CORE_NOMINAL);
				} else
				{
					// Ouch... No eFuse guidance, just Boost the voltage.
					minPrintf("UnFused part! Bumping up core voltage to 1.15V\n");
					retval = set_AVS_Voltage(DRO_CORE_ADJUSTMENT);
				}
			} else  // eFuse *is* programmed...
			{
				uint32_t eFuse_Threshold = (is_RevB() || is_RevB1()) ? DRO_EFUSE_REVB_THRESHOLD : DRO_EFUSE_THRESHOLD;

				if (dro_vals.efuseDRO <= eFuse_Threshold)
				{
					// This part is considered to be slow; bump up the core voltage
					minPrintf("--> Bumping up core voltage based on eFuse setting...%d <= %d\n",
							dro_vals.efuseDRO, eFuse_Threshold);
					retval = set_AVS_Voltage(DRO_CORE_ADJUSTMENT);
				} else
				{
					minPrintf("Setting Core to nominal (1.05V)\n" );
					retval = set_AVS_Voltage(AVS_CORE_NOMINAL);
				}
			}
		}
	}
	return (0 != retval);
}

/* Used by vim and some versions of vi: set tabstop=4 shiftwidth=4: */
